/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class LineCapTab
extends GraphicsTab {
    Button colorButton;
    GraphicsBackground foreground;
    Menu menu;

    public LineCapTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Lines");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("LineCap");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("LineCapDescription");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.foreground = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.foreground = (GraphicsBackground)this.menu.getItem(2).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.foreground.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        Device device = gc.getDevice();
        gc.setLineWidth(1);
        gc.setLineStyle(3);
        gc.setForeground(device.getSystemColor(2));
        gc.drawLine(3 * width / 16, height / 6, 3 * width / 16, 5 * height / 6);
        gc.drawLine(13 * width / 16, height / 6, 13 * width / 16, 5 * height / 6);
        gc.setLineStyle(1);
        Font font = new Font(device, LineCapTab.getPlatformFont(), 20, 0);
        gc.setFont(font);
        String text = GraphicsExample.getResourceString("Flat");
        Point size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 3 * height / 12, true);
        text = GraphicsExample.getResourceString("Square");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 5 * height / 12, true);
        text = GraphicsExample.getResourceString("Round");
        size = gc.stringExtent(text);
        gc.drawString(text, (width - size.x) / 2, 7 * height / 12, true);
        font.dispose();
        Pattern pattern = null;
        if (this.foreground.getBgColor1() != null) {
            gc.setForeground(this.foreground.getBgColor1());
        } else if (this.foreground.getBgImage() != null) {
            pattern = new Pattern(device, this.foreground.getBgImage());
            gc.setForegroundPattern(pattern);
        }
        gc.setLineWidth(20);
        gc.setLineCap(1);
        gc.drawLine(3 * width / 16, 2 * height / 6, 13 * width / 16, 2 * height / 6);
        gc.setLineCap(3);
        gc.drawLine(3 * width / 16, 3 * height / 6, 13 * width / 16, 3 * height / 6);
        gc.setLineCap(2);
        gc.drawLine(3 * width / 16, 4 * height / 6, 13 * width / 16, 4 * height / 6);
        if (pattern != null) {
            pattern.dispose();
        }
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        return "Verdana";
    }
}

