/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class MazeTab
extends AnimatedGraphicsTab {
    int nextIndex;
    int nextIndex2;
    int nextIndex3;
    int xcoord;
    int ycoord;
    int xcoord2;
    int ycoord2;
    int xcoord3;
    int ycoord3;
    List<Integer> nextCoord = new ArrayList<Integer>();
    List<Integer> nextCoord2;
    List<Integer> nextCoord3;
    boolean isDone;
    boolean isDone2;
    boolean isDone3;
    Image image;

    public MazeTab(GraphicsExample example) {
        super(example);
        this.nextCoord.addAll(this.moveDown(20, -50, 20, 110, 10));
        this.nextCoord.addAll(this.moveRight(30, 110, 130, 110, 10));
        this.nextCoord.addAll(this.moveUp(135, 100, 135, 15, 10));
        this.nextCoord.addAll(this.moveRight(140, 15, 210, 15, 10));
        this.nextCoord.addAll(this.moveDown(210, 25, 210, 75, 10));
        this.nextCoord.addAll(this.moveRight(220, 75, 320, 75, 10));
        this.nextCoord.addAll(this.moveUp(320, 65, 320, 55, 10));
        this.nextCoord.addAll(this.moveRight(330, 50, 475, 50, 10));
        this.nextCoord.addAll(this.moveDown(475, 60, 475, 225, 10));
        this.nextCoord.addAll(this.moveLeft(465, 225, 200, 225, 10));
        this.nextCoord.addAll(this.moveUp(200, 215, 200, 180, 10));
        this.nextCoord.addAll(this.moveLeft(190, 180, 120, 180, 10));
        this.nextCoord.addAll(this.moveDown(120, 190, 120, 320, 10));
        this.nextCoord.addAll(this.moveRight(130, 320, 475, 320, 10));
        this.nextCoord.addAll(this.moveDown(475, 330, 475, 435, 10));
        this.nextCoord.addAll(this.moveLeft(465, 435, 20, 435, 10));
        this.nextCoord.addAll(this.moveDown(20, 445, 20, 495, 10));
        this.nextIndex = 0;
        this.xcoord = this.nextCoord.get(this.nextIndex);
        this.ycoord = this.nextCoord.get(this.nextIndex + 1);
        this.nextCoord2 = new ArrayList<Integer>();
        this.nextCoord2.addAll(this.moveDown(20, -25, 20, 110, 10));
        this.nextCoord2.addAll(this.moveRight(30, 110, 130, 110, 10));
        this.nextCoord2.addAll(this.moveUp(135, 100, 135, 15, 10));
        this.nextCoord2.addAll(this.moveRight(140, 15, 520, 15, 10));
        this.nextCoord2.addAll(this.moveDown(525, 15, 525, 480, 10));
        this.nextCoord2.addAll(this.moveLeft(515, 480, 70, 480, 10));
        this.nextIndex2 = 0;
        this.xcoord2 = this.nextCoord2.get(this.nextIndex2);
        this.ycoord2 = this.nextCoord2.get(this.nextIndex2 + 1);
        this.nextCoord3 = new ArrayList<Integer>();
        this.nextCoord3.addAll(this.moveDown(20, 0, 20, 110, 10));
        this.nextCoord3.addAll(this.moveRight(30, 110, 130, 110, 10));
        this.nextCoord3.addAll(this.moveUp(135, 100, 135, 15, 10));
        this.nextCoord3.addAll(this.moveRight(140, 15, 210, 15, 10));
        this.nextCoord3.addAll(this.moveDown(210, 25, 210, 75, 10));
        this.nextCoord3.addAll(this.moveRight(220, 75, 320, 75, 10));
        this.nextCoord3.addAll(this.moveUp(320, 65, 320, 55, 10));
        this.nextCoord3.addAll(this.moveRight(330, 50, 475, 50, 10));
        this.nextCoord3.addAll(this.moveDown(475, 60, 475, 225, 10));
        this.nextCoord3.addAll(this.moveLeft(465, 225, 425, 225, 10));
        this.nextCoord3.addAll(this.moveUp(420, 225, 420, 150, 10));
        this.nextCoord3.addAll(this.moveLeft(420, 145, 70, 145, 10));
        this.nextCoord3.addAll(this.moveDown(70, 150, 70, 320, 10));
        this.nextIndex3 = 0;
        this.xcoord3 = this.nextCoord3.get(this.nextIndex3);
        this.ycoord3 = this.nextCoord3.get(this.nextIndex3 + 1);
        this.isDone3 = false;
        this.isDone2 = false;
        this.isDone = false;
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Misc");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Maze");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("MazeDescription");
    }

    @Override
    public int getInitialAnimationTime() {
        return 50;
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        super.createControlPanel(parent);
        this.playItem.addListener(13, event -> {
            if (this.isDone) {
                this.nextIndex3 = 0;
                this.nextIndex2 = 0;
                this.nextIndex = 0;
                this.isDone3 = false;
                this.isDone2 = false;
                this.isDone = false;
            }
        });
    }

    @Override
    public void next(int width, int height) {
        if (this.nextIndex + 2 < this.nextCoord.size()) {
            this.nextIndex = (this.nextIndex + 2) % this.nextCoord.size();
            this.xcoord = this.nextCoord.get(this.nextIndex);
            this.ycoord = this.nextCoord.get(this.nextIndex + 1);
        } else {
            this.setAnimation(false);
            this.isDone = true;
        }
        if (this.nextIndex2 + 2 < this.nextCoord2.size()) {
            this.nextIndex2 = (this.nextIndex2 + 2) % this.nextCoord2.size();
            this.xcoord2 = this.nextCoord2.get(this.nextIndex2);
            this.ycoord2 = this.nextCoord2.get(this.nextIndex2 + 1);
        } else {
            this.isDone2 = true;
        }
        if (this.nextIndex3 + 2 < this.nextCoord3.size()) {
            this.nextIndex3 = (this.nextIndex3 + 2) % this.nextCoord3.size();
            this.xcoord3 = this.nextCoord3.get(this.nextIndex3);
            this.ycoord3 = this.nextCoord3.get(this.nextIndex3 + 1);
        } else {
            this.isDone3 = true;
        }
    }

    @Override
    public void paint(GC gc, int width, int height) {
        Image helpImg;
        Device device = gc.getDevice();
        if (this.image == null) {
            this.image = this.example.loadImage(device, "maze.bmp");
        }
        Rectangle bounds = this.image.getBounds();
        int x = (width - bounds.width) / 2;
        int y = (height - bounds.height) / 2;
        gc.drawImage(this.image, x, y);
        gc.setBackground(device.getSystemColor(3));
        gc.fillOval(x + this.xcoord, y + this.ycoord, 16, 16);
        gc.drawOval(x + this.xcoord, y + this.ycoord, 15, 15);
        gc.setBackground(device.getSystemColor(9));
        gc.fillOval(x + this.xcoord2, y + this.ycoord2, 16, 16);
        gc.drawOval(x + this.xcoord2, y + this.ycoord2, 15, 15);
        gc.setBackground(device.getSystemColor(5));
        gc.fillOval(x + this.xcoord3, y + this.ycoord3, 16, 16);
        gc.drawOval(x + this.xcoord3, y + this.ycoord3, 15, 15);
        if (this.isDone2) {
            helpImg = this.example.loadImage(device, "help.gif");
            gc.drawImage(helpImg, x + this.xcoord2 + 16, y + this.ycoord2 - 16);
            helpImg.dispose();
        }
        if (this.isDone3) {
            helpImg = this.example.loadImage(device, "help.gif");
            gc.drawImage(helpImg, x + this.xcoord3 + 16, y + this.ycoord3 - 16);
            helpImg.dispose();
        }
    }

    private List<Integer> moveLeft(int x1, int y1, int x2, int y2, int stepsize) {
        ArrayList<Integer> coords = new ArrayList<Integer>();
        coords.add(x1);
        coords.add(y1);
        while (x1 - stepsize > x2) {
            coords.add(x1 -= stepsize);
            coords.add(y1);
        }
        coords.add(x2);
        coords.add(y2);
        return coords;
    }

    private List<Integer> moveRight(int x1, int y1, int x2, int y2, int stepsize) {
        ArrayList<Integer> coords = new ArrayList<Integer>();
        coords.add(x1);
        coords.add(y1);
        while (x1 + stepsize < x2) {
            coords.add(x1 += stepsize);
            coords.add(y1);
        }
        coords.add(x2);
        coords.add(y2);
        return coords;
    }

    private List<Integer> moveUp(int x1, int y1, int x2, int y2, int stepsize) {
        ArrayList<Integer> coords = new ArrayList<Integer>();
        coords.add(x1);
        coords.add(y1);
        while (y1 - stepsize > y2) {
            coords.add(x1);
            coords.add(y1 -= stepsize);
        }
        coords.add(x2);
        coords.add(y2);
        return coords;
    }

    private List<Integer> moveDown(int x1, int y1, int x2, int y2, int stepsize) {
        ArrayList<Integer> coords = new ArrayList<Integer>();
        coords.add(x1);
        coords.add(y1);
        while (y1 + stepsize < y2) {
            coords.add(x1);
            coords.add(y1 += stepsize);
        }
        coords.add(x2);
        coords.add(y2);
        return coords;
    }
}

