/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.javaviewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.javaviewer.JavaLineStyler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class JavaViewer {
    Shell shell;
    StyledText text;
    JavaLineStyler lineStyler = new JavaLineStyler();
    FileDialog fileDialog;
    static ResourceBundle resources = ResourceBundle.getBundle("examples_javaviewer");

    Menu createFileMenu() {
        Menu bar = this.shell.getMenuBar();
        Menu menu = new Menu(bar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(resources.getString("Open_menuitem"));
        item.setAccelerator(SWT.MOD1 + 79);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.openFile()));
        item = new MenuItem(menu, 8);
        item.setText(resources.getString("Exit_menuitem"));
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.menuFileExit()));
        return menu;
    }

    void createMenuBar() {
        Menu bar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(bar);
        MenuItem fileItem = new MenuItem(bar, 64);
        fileItem.setText(resources.getString("File_menuitem"));
        fileItem.setMenu(this.createFileMenu());
    }

    void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setText(resources.getString("Window_title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
        this.shell.addShellListener(ShellListener.shellClosedAdapter(e -> {
            this.lineStyler.disposeColors();
            this.text.removeLineStyleListener((LineStyleListener)this.lineStyler);
        }));
    }

    void createStyledText() {
        this.text = new StyledText((Composite)this.shell, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.addLineStyleListener((LineStyleListener)this.lineStyler);
        this.text.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(15);
        this.text.setBackground(bg);
    }

    void displayError(String msg) {
        MessageBox box = new MessageBox(this.shell, 1);
        box.setMessage(msg);
        box.open();
    }

    public static void main(String[] args) {
        Display display = new Display();
        JavaViewer example = new JavaViewer();
        Shell shell = example.open(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        this.createShell(display);
        this.createMenuBar();
        this.createStyledText();
        this.shell.setSize(500, 400);
        this.shell.open();
        return this.shell;
    }

    void openFile() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.shell, 4096);
        }
        this.fileDialog.setFilterExtensions(new String[]{"*.java", "*.*"});
        String name = this.fileDialog.open();
        this.open(name);
    }

    void open(String name) {
        String textString;
        if (name == null || name.length() == 0) {
            return;
        }
        File file = new File(name);
        if (!file.exists()) {
            String message = MessageFormat.format(resources.getString("Err_file_no_exist"), file.getName());
            this.displayError(message);
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(file.getPath());
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
                    int n;
                    char[] readBuffer = new char[2048];
                    StringBuilder buffer = new StringBuilder((int)file.length());
                    while ((n = in.read(readBuffer)) > 0) {
                        buffer.append(readBuffer, 0, n);
                    }
                    textString = buffer.toString();
                    stream.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                String message = MessageFormat.format(resources.getString("Err_file_io"), file.getName());
                this.displayError(message);
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String message = MessageFormat.format(resources.getString("Err_not_found"), file.getName());
            this.displayError(message);
            return;
        }
        Display display = this.text.getDisplay();
        display.asyncExec(() -> this.text.setText(textString));
        this.lineStyler.parseBlockComments(textString);
    }

    void menuFileExit() {
        this.shell.close();
    }
}

