/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class FormLayoutTab
extends Tab {
    Spinner marginWidth;
    Spinner marginHeight;
    Spinner marginLeft;
    Spinner marginRight;
    Spinner marginTop;
    Spinner marginBottom;
    Spinner spacing;
    FormLayout formLayout;
    TableEditor nameEditor;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor leftEditor;
    TableEditor rightEditor;
    TableEditor topEditor;
    TableEditor bottomEditor;
    CCombo combo;
    Text nameText;
    Text widthText;
    Text heightText;
    Button leftAttach;
    Button rightAttach;
    Button topAttach;
    Button bottomAttach;
    final int NAME_COL = 0;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int LEFT_COL = 4;
    final int RIGHT_COL = 5;
    final int TOP_COL = 6;
    final int BOTTOM_COL = 7;
    final int MODIFY_COLS = 4;
    final int TOTAL_COLS = 8;

    FormLayoutTab(LayoutExample instance) {
        super(instance);
    }

    int alignmentConstant(String align) {
        if (align.equals("LEFT")) {
            return 16384;
        }
        if (align.equals("RIGHT")) {
            return 131072;
        }
        if (align.equals("TOP")) {
            return 128;
        }
        if (align.equals("BOTTOM")) {
            return 1024;
        }
        if (align.equals("CENTER")) {
            return 0x1000000;
        }
        return -1;
    }

    String alignmentString(int align) {
        switch (align) {
            case 16384: {
                return "LEFT";
            }
            case 131072: {
                return "RIGHT";
            }
            case 128: {
                return "TOP";
            }
            case 1024: {
                return "BOTTOM";
            }
            case 0x1000000: {
                return "CENTER";
            }
        }
        return "DEFAULT";
    }

    String checkAttachment(String oldAttach, FormAttachment newAttach) {
        String controlClass = newAttach.control.getClass().toString();
        String controlType = controlClass.substring(controlClass.lastIndexOf(46) + 1);
        int i = 0;
        while (i < oldAttach.length() && !Character.isDigit(oldAttach.charAt(i))) {
            ++i;
        }
        String index = oldAttach.substring(i, oldAttach.indexOf(44));
        return String.valueOf(controlType) + index + "," + newAttach.offset + ":" + this.alignmentString(newAttach.alignment);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.table.getColumn(4).setWidth(90);
        this.table.getColumn(5).setWidth(90);
        this.table.getColumn(6).setWidth(90);
        this.table.getColumn(7).setWidth(90);
        this.nameEditor = new TableEditor(this.table);
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.leftEditor = new TableEditor(this.table);
        this.rightEditor = new TableEditor(this.table);
        this.topEditor = new TableEditor(this.table);
        this.bottomEditor = new TableEditor(this.table);
        this.table.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            this.resetEditors();
            this.index = this.table.getSelectionIndex();
            Point pt = new Point(e.x, e.y);
            this.newItem = this.table.getItem(pt);
            if (this.newItem == null) {
                return;
            }
            TableItem oldItem = this.comboEditor.getItem();
            if (this.newItem == oldItem || this.newItem != this.lastSelected) {
                this.lastSelected = this.newItem;
                return;
            }
            this.table.showSelection();
            this.combo = new CCombo((Composite)this.table, 8);
            this.createComboEditor(this.combo, this.comboEditor);
            this.nameText = new Text((Composite)this.table, 4);
            this.nameText.setText(((String[])this.data.get(this.index))[0]);
            this.createTextEditor(this.nameText, this.nameEditor, 0);
            this.widthText = new Text((Composite)this.table, 4);
            this.widthText.setText(((String[])this.data.get(this.index))[2]);
            this.createTextEditor(this.widthText, this.widthEditor, 2);
            this.heightText = new Text((Composite)this.table, 4);
            this.heightText.setText(((String[])this.data.get(this.index))[3]);
            this.createTextEditor(this.heightText, this.heightEditor, 3);
            this.leftAttach = new Button((Composite)this.table, 8);
            this.leftAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
            this.leftEditor.horizontalAlignment = 16384;
            this.leftEditor.grabHorizontal = true;
            this.leftEditor.minimumWidth = this.leftAttach.computeSize((int)-1, (int)-1).x;
            this.leftEditor.setEditor((Control)this.leftAttach, this.newItem, 4);
            this.leftAttach.addSelectionListener(SelectionListener.widgetSelectedAdapter(e1 -> {
                Shell shell = this.tabFolderPage.getShell();
                AttachDialog dialog = new AttachDialog(shell);
                dialog.setText(LayoutExample.getResourceString("Left_Attachment"));
                dialog.setColumn(4);
                String attach = dialog.open();
                this.newItem.setText(4, attach);
                this.resetEditors();
            }));
            this.rightAttach = new Button((Composite)this.table, 8);
            this.rightAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
            this.rightEditor.horizontalAlignment = 16384;
            this.rightEditor.grabHorizontal = true;
            this.rightEditor.minimumWidth = this.rightAttach.computeSize((int)-1, (int)-1).x;
            this.rightEditor.setEditor((Control)this.rightAttach, this.newItem, 5);
            this.rightAttach.addSelectionListener(SelectionListener.widgetSelectedAdapter(e1 -> {
                Shell shell = this.tabFolderPage.getShell();
                AttachDialog dialog = new AttachDialog(shell);
                dialog.setText(LayoutExample.getResourceString("Right_Attachment"));
                dialog.setColumn(5);
                String attach = dialog.open();
                this.newItem.setText(5, attach);
                if (this.newItem.getText(4).endsWith(")")) {
                    this.newItem.setText(4, "");
                }
                this.resetEditors();
            }));
            this.topAttach = new Button((Composite)this.table, 8);
            this.topAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
            this.topEditor.horizontalAlignment = 16384;
            this.topEditor.grabHorizontal = true;
            this.topEditor.minimumWidth = this.topAttach.computeSize((int)-1, (int)-1).x;
            this.topEditor.setEditor((Control)this.topAttach, this.newItem, 6);
            this.topAttach.addSelectionListener(SelectionListener.widgetSelectedAdapter(e1 -> {
                Shell shell = this.tabFolderPage.getShell();
                AttachDialog dialog = new AttachDialog(shell);
                dialog.setText(LayoutExample.getResourceString("Top_Attachment"));
                dialog.setColumn(6);
                String attach = dialog.open();
                this.newItem.setText(6, attach);
                this.resetEditors();
            }));
            this.bottomAttach = new Button((Composite)this.table, 8);
            this.bottomAttach.setText(LayoutExample.getResourceString("Attach_Edit"));
            this.bottomEditor.horizontalAlignment = 16384;
            this.bottomEditor.grabHorizontal = true;
            this.bottomEditor.minimumWidth = this.bottomAttach.computeSize((int)-1, (int)-1).x;
            this.bottomEditor.setEditor((Control)this.bottomAttach, this.newItem, 7);
            this.bottomAttach.addSelectionListener(SelectionListener.widgetSelectedAdapter(e1 -> {
                Shell shell = this.tabFolderPage.getShell();
                AttachDialog dialog = new AttachDialog(shell);
                dialog.setText(LayoutExample.getResourceString("Bottom_Attachment"));
                dialog.setColumn(7);
                String attach = dialog.open();
                this.newItem.setText(7, attach);
                if (this.newItem.getText(6).endsWith(")")) {
                    this.newItem.setText(6, "");
                }
                this.resetEditors();
            }));
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = this.newItem.getBounds(i);
                if (rect.contains(pt)) {
                    switch (i) {
                        case 0: {
                            this.resetEditors();
                            break;
                        }
                        case 1: {
                            this.combo.setFocus();
                            break;
                        }
                        case 2: {
                            this.widthText.setFocus();
                            break;
                        }
                        case 3: {
                            this.heightText.setFocus();
                            break;
                        }
                    }
                }
                ++i;
            }
        }));
    }

    @Override
    void createControlWidgets() {
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        marginGroup.setLayout((Layout)new GridLayout(2, false));
        marginGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Spinner((Composite)marginGroup, 2048);
        this.marginWidth.setSelection(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Spinner((Composite)marginGroup, 2048);
        this.marginHeight.setSelection(0);
        this.marginHeight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginLeft");
        this.marginLeft = new Spinner((Composite)marginGroup, 2048);
        this.marginLeft.setSelection(0);
        this.marginLeft.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginRight");
        this.marginRight = new Spinner((Composite)marginGroup, 2048);
        this.marginRight.setSelection(0);
        this.marginRight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginTop");
        this.marginTop = new Spinner((Composite)marginGroup, 2048);
        this.marginTop.setSelection(0);
        this.marginTop.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginBottom");
        this.marginBottom = new Spinner((Composite)marginGroup, 2048);
        this.marginBottom.setSelection(0);
        this.marginBottom.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("spacing");
        this.spacing = new Spinner((Composite)marginGroup, 2048);
        this.spacing.setSelection(0);
        this.spacing.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
    }

    @Override
    void createLayout() {
        this.formLayout = new FormLayout();
        this.layoutComposite.setLayout((Layout)this.formLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.nameText.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.leftAttach.dispose();
        this.rightAttach.dispose();
        this.topAttach.dispose();
        this.bottomAttach.dispose();
    }

    @Override
    StringBuilder generateLayoutCode() {
        StringBuilder code = new StringBuilder();
        code.append("\t\tFormLayout formLayout = new FormLayout ();\n");
        if (this.formLayout.marginWidth != 0) {
            code.append("\t\tformLayout.marginWidth = " + this.formLayout.marginWidth + ";\n");
        }
        if (this.formLayout.marginHeight != 0) {
            code.append("\t\tformLayout.marginHeight = " + this.formLayout.marginHeight + ";\n");
        }
        if (this.formLayout.marginLeft != 0) {
            code.append("\t\tformLayout.marginLeft = " + this.formLayout.marginLeft + ";\n");
        }
        if (this.formLayout.marginRight != 0) {
            code.append("\t\tformLayout.marginRight = " + this.formLayout.marginRight + ";\n");
        }
        if (this.formLayout.marginTop != 0) {
            code.append("\t\tformLayout.marginTop = " + this.formLayout.marginTop + ";\n");
        }
        if (this.formLayout.marginBottom != 0) {
            code.append("\t\tformLayout.marginBottom = " + this.formLayout.marginBottom + ";\n");
        }
        if (this.formLayout.spacing != 0) {
            code.append("\t\tformLayout.spacing = " + this.formLayout.spacing + ";\n");
        }
        code.append("\t\tshell.setLayout (formLayout);\n");
        boolean first = true;
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append((CharSequence)this.getChildCode(control, i));
            FormData data = (FormData)control.getLayoutData();
            if (data != null) {
                int index;
                String controlString;
                TableItem item;
                code.append("\t\t");
                if (first) {
                    code.append("FormData ");
                    first = false;
                }
                code.append("data = new FormData ();\n");
                if (data.width != -1) {
                    code.append("\t\tdata.width = " + data.width + ";\n");
                }
                if (data.height != -1) {
                    code.append("\t\tdata.height = " + data.height + ";\n");
                }
                if (data.left != null) {
                    if (data.left.control != null) {
                        item = this.table.getItem(i);
                        controlString = item.getText(4);
                        index = Integer.valueOf(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                        code.append("\t\tdata.left = new FormAttachment (" + this.names[index] + ", " + data.left.offset + ", SWT." + this.alignmentString(data.left.alignment) + ");\n");
                    } else if (data.right != null || data.left.numerator != 0 || data.left.offset != 0) {
                        code.append("\t\tdata.left = new FormAttachment (" + data.left.numerator + ", " + data.left.offset + ");\n");
                    }
                }
                if (data.right != null) {
                    if (data.right.control != null) {
                        item = this.table.getItem(i);
                        controlString = item.getText(5);
                        index = Integer.valueOf(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                        code.append("\t\tdata.right = new FormAttachment (" + this.names[index] + ", " + data.right.offset + ", SWT." + this.alignmentString(data.right.alignment) + ");\n");
                    } else {
                        code.append("\t\tdata.right = new FormAttachment (" + data.right.numerator + ", " + data.right.offset + ");\n");
                    }
                }
                if (data.top != null) {
                    if (data.top.control != null) {
                        item = this.table.getItem(i);
                        controlString = item.getText(6);
                        index = Integer.valueOf(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                        code.append("\t\tdata.top = new FormAttachment (" + this.names[index] + ", " + data.top.offset + ", SWT." + this.alignmentString(data.top.alignment) + ");\n");
                    } else if (data.bottom != null || data.top.numerator != 0 || data.top.offset != 0) {
                        code.append("\t\tdata.top = new FormAttachment (" + data.top.numerator + ", " + data.top.offset + ");\n");
                    }
                }
                if (data.bottom != null) {
                    if (data.bottom.control != null) {
                        item = this.table.getItem(i);
                        controlString = item.getText(7);
                        index = Integer.valueOf(controlString.substring(controlString.indexOf(44) - 1, controlString.indexOf(44)));
                        code.append("\t\tdata.bottom = new FormAttachment (" + this.names[index] + ", " + data.bottom.offset + ", SWT." + this.alignmentString(data.bottom.alignment) + ");\n");
                    } else {
                        code.append("\t\tdata.bottom = new FormAttachment (" + data.bottom.numerator + ", " + data.bottom.offset + ");\n");
                    }
                }
                code.append("\t\t" + this.names[i] + ".setLayoutData (data);\n");
            }
            ++i;
        }
        return code;
    }

    @Override
    String[] getInsertString(String name, String controlType) {
        return new String[]{name, controlType, "-1", "-1", "0,0 (" + LayoutExample.getResourceString("Default") + ")", "", "0,0 (" + LayoutExample.getResourceString("Default") + ")", ""};
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"Control Name", "Control Type", "width", "height", "left", "right", "top", "bottom"};
    }

    @Override
    String getTabText() {
        return "FormLayout";
    }

    @Override
    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new String(this.nameText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nameText.setText(oldItem.getText(0));
            }
            try {
                Integer.parseInt(this.widthText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                Integer.parseInt(this.heightText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(oldItem.getText(3));
            }
            String[] insert = new String[]{this.nameText.getText(), this.combo.getText(), this.widthText.getText(), this.heightText.getText()};
            this.data.set(row, insert);
            int i = 0;
            while (i < 4) {
                oldItem.setText(i, ((String[])this.data.get(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    int[] sashWeights() {
        return new int[]{40, 60};
    }

    FormAttachment setAttachment(String attachment) {
        int offset;
        int position;
        int comma = attachment.indexOf(44);
        char first = attachment.charAt(0);
        if (Character.isLetter(first)) {
            int offset2;
            String control = attachment.substring(0, comma);
            int i = 0;
            while (i < control.length() && !Character.isDigit(control.charAt(i))) {
                ++i;
            }
            String end = control.substring(i);
            int index = Integer.valueOf(end);
            Control attachControl = this.children[index];
            int colon = attachment.indexOf(58);
            try {
                offset2 = Integer.valueOf(attachment.substring(comma + 1, colon));
            }
            catch (NumberFormatException numberFormatException) {
                offset2 = 0;
            }
            String align = attachment.substring(colon + 1);
            return new FormAttachment(attachControl, offset2, this.alignmentConstant(align));
        }
        try {
            position = Integer.valueOf(attachment.substring(0, comma));
        }
        catch (NumberFormatException numberFormatException) {
            position = 0;
        }
        try {
            offset = Integer.valueOf(attachment.substring(comma + 1));
        }
        catch (NumberFormatException numberFormatException) {
            offset = 0;
        }
        return new FormAttachment(position, offset);
    }

    @Override
    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            String bottom;
            String top;
            String right;
            String attachment;
            String left;
            int width = Integer.valueOf(items[i].getText(2));
            int height = Integer.valueOf(items[i].getText(3));
            FormData data = new FormData();
            if (width > 0) {
                data.width = width;
            }
            if (height > 0) {
                data.height = height;
            }
            if ((left = items[i].getText(4)).length() > 0) {
                data.left = this.setAttachment(left);
                if (data.left.control != null) {
                    attachment = this.checkAttachment(left, data.left);
                    items[i].setText(4, attachment);
                }
            }
            if ((right = items[i].getText(5)).length() > 0) {
                data.right = this.setAttachment(right);
                if (data.right.control != null) {
                    attachment = this.checkAttachment(right, data.right);
                    items[i].setText(5, attachment);
                }
            }
            if ((top = items[i].getText(6)).length() > 0) {
                data.top = this.setAttachment(top);
                if (data.top.control != null) {
                    attachment = this.checkAttachment(top, data.top);
                    items[i].setText(6, attachment);
                }
            }
            if ((bottom = items[i].getText(7)).length() > 0) {
                data.bottom = this.setAttachment(bottom);
                if (data.bottom.control != null) {
                    attachment = this.checkAttachment(bottom, data.bottom);
                    items[i].setText(7, attachment);
                }
            }
            children[i].setLayoutData((Object)data);
            ++i;
        }
    }

    @Override
    void setLayoutState() {
        this.formLayout.marginWidth = this.marginWidth.getSelection();
        this.formLayout.marginHeight = this.marginHeight.getSelection();
        this.formLayout.marginLeft = this.marginLeft.getSelection();
        this.formLayout.marginRight = this.marginRight.getSelection();
        this.formLayout.marginTop = this.marginTop.getSelection();
        this.formLayout.marginBottom = this.marginBottom.getSelection();
        this.formLayout.spacing = this.spacing.getSelection();
    }

    public class AttachDialog
    extends Dialog {
        String result;
        String controlInput;
        String positionInput;
        String alignmentInput;
        String offsetInput;
        int col;

        public AttachDialog(Shell parent, int style) {
            super(parent, style);
            this.result = "";
            this.col = 0;
        }

        public AttachDialog(Shell parent) {
            this(parent, 0);
        }

        public void setColumn(int col) {
            this.col = col;
        }

        public String open() {
            Shell parent = this.getParent();
            Shell shell = new Shell(parent, 67680);
            shell.setText(this.getText());
            shell.setLayout((Layout)new GridLayout(3, true));
            TableItem newItem = FormLayoutTab.this.leftEditor.getItem();
            String oldAttach = this.result = newItem.getText(this.col);
            String oldPos = "0";
            String oldControl = "";
            String oldAlign = "DEFAULT";
            String oldOffset = "0";
            boolean isControl = false;
            if (oldAttach.length() != 0) {
                char first = oldAttach.charAt(0);
                if (Character.isLetter(first)) {
                    isControl = true;
                    oldControl = oldAttach.substring(0, oldAttach.indexOf(44));
                    oldAlign = oldAttach.substring(oldAttach.indexOf(58) + 1);
                    oldOffset = oldAttach.substring(oldAttach.indexOf(44) + 1, oldAttach.indexOf(58));
                } else {
                    oldPos = oldAttach.substring(0, oldAttach.indexOf(44));
                    oldOffset = oldAttach.substring(oldAttach.indexOf(44) + 1);
                    if (oldOffset.endsWith(")")) {
                        oldOffset = oldOffset.substring(0, oldOffset.indexOf(32));
                    }
                }
            }
            Button posButton = new Button((Composite)shell, 16);
            posButton.setText(LayoutExample.getResourceString("Position"));
            posButton.setSelection(!isControl);
            Combo position = new Combo((Composite)shell, 0);
            position.setItems(new String[]{"0", "25", "33", "50", "67", "75", "100"});
            position.setVisibleItemCount(7);
            position.setText(oldPos);
            position.setEnabled(!isControl);
            position.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Button contButton = new Button((Composite)shell, 16);
            contButton.setText(LayoutExample.getResourceString("Control"));
            contButton.setSelection(isControl);
            Combo control = new Combo((Composite)shell, 8);
            TableItem[] items = FormLayoutTab.this.table.getItems();
            TableItem currentItem = FormLayoutTab.this.leftEditor.getItem();
            int i = 0;
            while (i < FormLayoutTab.this.table.getItemCount()) {
                if (items[i].getText(0).length() > 0 && items[i] != currentItem) {
                    control.add(String.valueOf(items[i].getText(1)) + i);
                }
                ++i;
            }
            if (oldControl.length() != 0) {
                control.setText(oldControl);
            } else {
                control.select(0);
            }
            control.setEnabled(isControl);
            control.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            new Label((Composite)shell, 0).setText(LayoutExample.getResourceString("Alignment"));
            Combo alignment = new Combo((Composite)shell, 0);
            String[] alignmentValues = this.col == 4 || this.col == 5 ? new String[]{"SWT.LEFT", "SWT.RIGHT", "SWT.CENTER", "SWT.DEFAULT"} : new String[]{"SWT.TOP", "SWT.BOTTOM", "SWT.CENTER", "SWT.DEFAULT"};
            alignment.setItems(alignmentValues);
            alignment.setText("SWT." + oldAlign);
            alignment.setEnabled(isControl);
            alignment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            new Label((Composite)shell, 0).setText(LayoutExample.getResourceString("Offset"));
            Text offset = new Text((Composite)shell, 2052);
            offset.setText(oldOffset);
            offset.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            posButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                position.setEnabled(true);
                control.setEnabled(false);
                alignment.setEnabled(false);
            }));
            contButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                position.setEnabled(false);
                control.setEnabled(true);
                alignment.setEnabled(true);
            }));
            Button clear = new Button((Composite)shell, 8);
            clear.setText(LayoutExample.getResourceString("Clear"));
            clear.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            clear.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                this.result = "";
                shell.close();
            }));
            Button ok = new Button((Composite)shell, 8);
            ok.setText(LayoutExample.getResourceString("OK"));
            ok.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            ok.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                this.controlInput = control.getText();
                this.alignmentInput = alignment.getText().substring(4);
                this.positionInput = position.getText();
                if (this.positionInput.length() == 0) {
                    this.positionInput = "0";
                }
                try {
                    Integer.parseInt(this.positionInput);
                }
                catch (NumberFormatException numberFormatException) {
                    this.positionInput = "0";
                }
                this.offsetInput = offset.getText();
                if (this.offsetInput.length() == 0) {
                    this.offsetInput = "0";
                }
                try {
                    Integer.parseInt(this.offsetInput);
                }
                catch (NumberFormatException numberFormatException) {
                    this.offsetInput = "0";
                }
                this.result = posButton.getSelection() || this.controlInput.length() == 0 ? String.valueOf(this.positionInput) + "," + this.offsetInput : String.valueOf(this.controlInput) + "," + this.offsetInput + ":" + this.alignmentInput;
                shell.close();
            }));
            Button cancel = new Button((Composite)shell, 8);
            cancel.setText(LayoutExample.getResourceString("Cancel"));
            cancel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> shell.close()));
            shell.setDefaultButton(ok);
            shell.pack();
            Point center = parent.getLocation();
            center.x = center.x + parent.getBounds().width / 2 - shell.getBounds().width / 2;
            center.y = center.y + parent.getBounds().height / 2 - shell.getBounds().height / 2;
            shell.setLocation(center);
            shell.open();
            while (!shell.isDisposed()) {
                if (!FormLayoutTab.this.display.readAndDispatch()) continue;
                FormLayoutTab.this.display.sleep();
            }
            return this.result;
        }
    }
}

