/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.layoutexample;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.examples.layoutexample.LayoutExample;
import org.eclipse.swt.examples.layoutexample.Tab;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class RowLayoutTab
extends Tab {
    Button horizontal;
    Button vertical;
    Button wrap;
    Button pack;
    Button fill;
    Button justify;
    Button center;
    Spinner marginWidth;
    Spinner marginHeight;
    Spinner marginLeft;
    Spinner marginRight;
    Spinner marginTop;
    Spinner marginBottom;
    Spinner spacing;
    RowLayout rowLayout;
    TableEditor comboEditor;
    TableEditor widthEditor;
    TableEditor heightEditor;
    TableEditor nameEditor;
    TableEditor excludeEditor;
    CCombo combo;
    CCombo exclude;
    Text nameText;
    Text widthText;
    Text heightText;
    final int NAME_COL = 0;
    final int COMBO_COL = 1;
    final int WIDTH_COL = 2;
    final int HEIGHT_COL = 3;
    final int EXCLUDE_COL = 4;
    final int TOTAL_COLS = 5;

    RowLayoutTab(LayoutExample instance) {
        super(instance);
    }

    @Override
    void createChildWidgets() {
        super.createChildWidgets();
        this.nameEditor = new TableEditor(this.table);
        this.comboEditor = new TableEditor(this.table);
        this.widthEditor = new TableEditor(this.table);
        this.heightEditor = new TableEditor(this.table);
        this.excludeEditor = new TableEditor(this.table);
        this.table.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            this.resetEditors();
            this.index = this.table.getSelectionIndex();
            Point pt = new Point(e.x, e.y);
            this.newItem = this.table.getItem(pt);
            if (this.newItem == null) {
                return;
            }
            TableItem oldItem = this.comboEditor.getItem();
            if (this.newItem == oldItem || this.newItem != this.lastSelected) {
                this.lastSelected = this.newItem;
                return;
            }
            this.table.showSelection();
            this.combo = new CCombo((Composite)this.table, 8);
            this.createComboEditor(this.combo, this.comboEditor);
            this.nameText = new Text((Composite)this.table, 4);
            this.nameText.setText(((String[])this.data.get(this.index))[0]);
            this.createTextEditor(this.nameText, this.nameEditor, 0);
            this.widthText = new Text((Composite)this.table, 4);
            this.widthText.setText(((String[])this.data.get(this.index))[2]);
            this.createTextEditor(this.widthText, this.widthEditor, 2);
            this.heightText = new Text((Composite)this.table, 4);
            this.heightText.setText(((String[])this.data.get(this.index))[3]);
            this.createTextEditor(this.heightText, this.heightEditor, 3);
            String[] boolValues = new String[]{"false", "true"};
            this.exclude = new CCombo((Composite)this.table, 0);
            this.exclude.setItems(boolValues);
            this.exclude.setText(this.newItem.getText(4));
            this.excludeEditor.horizontalAlignment = 16384;
            this.excludeEditor.grabHorizontal = true;
            this.excludeEditor.minimumWidth = 50;
            this.excludeEditor.setEditor((Control)this.exclude, this.newItem, 4);
            this.exclude.addTraverseListener(this.traverseListener);
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = this.newItem.getBounds(i);
                if (rect.contains(pt)) {
                    switch (i) {
                        case 0: {
                            this.nameText.setFocus();
                        }
                        case 1: {
                            this.combo.setFocus();
                            break;
                        }
                        case 2: {
                            this.widthText.setFocus();
                            break;
                        }
                        case 3: {
                            this.heightText.setFocus();
                            break;
                        }
                        case 4: {
                            this.exclude.setFocus();
                            break;
                        }
                        default: {
                            this.resetEditors();
                        }
                    }
                }
                ++i;
            }
        }));
    }

    @Override
    void createControlWidgets() {
        Group typeGroup = new Group((Composite)this.controlGroup, 0);
        typeGroup.setText(LayoutExample.getResourceString("Type"));
        typeGroup.setLayout((Layout)new GridLayout());
        typeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.horizontal = new Button((Composite)typeGroup, 16);
        this.horizontal.setText("SWT.HORIZONTAL");
        this.horizontal.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.horizontal.setSelection(true);
        this.horizontal.addSelectionListener(this.selectionListener);
        this.vertical = new Button((Composite)typeGroup, 16);
        this.vertical.setText("SWT.VERTICAL");
        this.vertical.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.vertical.addSelectionListener(this.selectionListener);
        Group marginGroup = new Group((Composite)this.controlGroup, 0);
        marginGroup.setText(LayoutExample.getResourceString("Margins_Spacing"));
        marginGroup.setLayout((Layout)new GridLayout(2, false));
        marginGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        this.marginWidth = new Spinner((Composite)marginGroup, 2048);
        this.marginWidth.setSelection(0);
        this.marginWidth.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        this.marginHeight = new Spinner((Composite)marginGroup, 2048);
        this.marginHeight.setSelection(0);
        this.marginHeight.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.marginHeight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginLeft");
        this.marginLeft = new Spinner((Composite)marginGroup, 2048);
        this.marginLeft.setSelection(3);
        this.marginLeft.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginRight");
        this.marginRight = new Spinner((Composite)marginGroup, 2048);
        this.marginRight.setSelection(3);
        this.marginRight.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginTop");
        this.marginTop = new Spinner((Composite)marginGroup, 2048);
        this.marginTop.setSelection(3);
        this.marginTop.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("marginBottom");
        this.marginBottom = new Spinner((Composite)marginGroup, 2048);
        this.marginBottom.setSelection(3);
        this.marginBottom.addSelectionListener(this.selectionListener);
        new Label((Composite)marginGroup, 0).setText("spacing");
        this.spacing = new Spinner((Composite)marginGroup, 2048);
        this.spacing.setSelection(3);
        this.spacing.addSelectionListener(this.selectionListener);
        Group specGroup = new Group((Composite)this.controlGroup, 0);
        specGroup.setText(LayoutExample.getResourceString("Properties"));
        specGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        specGroup.setLayout((Layout)new GridLayout());
        this.wrap = new Button((Composite)specGroup, 32);
        this.wrap.setText("Wrap");
        this.wrap.setSelection(true);
        this.wrap.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.wrap.addSelectionListener(this.selectionListener);
        this.pack = new Button((Composite)specGroup, 32);
        this.pack.setText("Pack");
        this.pack.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pack.setSelection(true);
        this.pack.addSelectionListener(this.selectionListener);
        this.fill = new Button((Composite)specGroup, 32);
        this.fill.setText("Fill");
        this.fill.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fill.addSelectionListener(this.selectionListener);
        this.justify = new Button((Composite)specGroup, 32);
        this.justify.setText("Justify");
        this.justify.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.justify.addSelectionListener(this.selectionListener);
        this.center = new Button((Composite)specGroup, 32);
        this.center.setText("Center");
        this.center.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.center.addSelectionListener(this.selectionListener);
        super.createControlWidgets();
    }

    @Override
    void createLayout() {
        this.rowLayout = new RowLayout();
        this.layoutComposite.setLayout((Layout)this.rowLayout);
    }

    @Override
    void disposeEditors() {
        this.comboEditor.setEditor(null, null, -1);
        this.combo.dispose();
        this.widthText.dispose();
        this.heightText.dispose();
        this.nameText.dispose();
        this.exclude.dispose();
    }

    @Override
    StringBuilder generateLayoutCode() {
        StringBuilder code = new StringBuilder();
        code.append("\t\tRowLayout rowLayout = new RowLayout ();\n");
        if (this.rowLayout.type == 512) {
            code.append("\t\trowLayout.type = SWT.VERTICAL;\n");
        }
        if (!this.rowLayout.wrap) {
            code.append("\t\trowLayout.wrap = false;\n");
        }
        if (!this.rowLayout.pack) {
            code.append("\t\trowLayout.pack = false;\n");
        }
        if (this.rowLayout.fill) {
            code.append("\t\trowLayout.fill = true;\n");
        }
        if (this.rowLayout.justify) {
            code.append("\t\trowLayout.justify = true;\n");
        }
        if (this.rowLayout.center) {
            code.append("\t\trowLayout.center = true;\n");
        }
        if (this.rowLayout.marginWidth != 0) {
            code.append("\t\trowLayout.marginWidth = " + this.rowLayout.marginWidth + ";\n");
        }
        if (this.rowLayout.marginHeight != 0) {
            code.append("\t\trowLayout.marginHeight = " + this.rowLayout.marginHeight + ";\n");
        }
        if (this.rowLayout.marginLeft != 3) {
            code.append("\t\trowLayout.marginLeft = " + this.rowLayout.marginLeft + ";\n");
        }
        if (this.rowLayout.marginRight != 3) {
            code.append("\t\trowLayout.marginRight = " + this.rowLayout.marginRight + ";\n");
        }
        if (this.rowLayout.marginTop != 3) {
            code.append("\t\trowLayout.marginTop = " + this.rowLayout.marginTop + ";\n");
        }
        if (this.rowLayout.marginBottom != 3) {
            code.append("\t\trowLayout.marginBottom = " + this.rowLayout.marginBottom + ";\n");
        }
        if (this.rowLayout.spacing != 3) {
            code.append("\t\trowLayout.spacing = " + this.rowLayout.spacing + ";\n");
        }
        code.append("\t\tshell.setLayout (rowLayout);\n");
        boolean first = true;
        int i = 0;
        while (i < this.children.length) {
            Control control = this.children[i];
            code.append((CharSequence)this.getChildCode(control, i));
            RowData rowData = (RowData)control.getLayoutData();
            if (rowData != null && (rowData.width != -1 || rowData.height != -1 || rowData.exclude)) {
                code.append("\t\t");
                if (first) {
                    code.append("RowData ");
                    first = false;
                }
                if (rowData.width == -1 && rowData.height == -1) {
                    code.append("rowData = new RowData ();\n");
                } else if (rowData.width == -1) {
                    code.append("rowData = new RowData (SWT.DEFAULT, " + rowData.height + ");\n");
                } else if (rowData.height == -1) {
                    code.append("rowData = new RowData (" + rowData.width + ", SWT.DEFAULT);\n");
                } else {
                    code.append("rowData = new RowData (" + rowData.width + ", " + rowData.height + ");\n");
                }
                if (rowData.exclude) {
                    code.append("\t\trowData.exclude = true;\n");
                }
                code.append("\t\t" + this.names[i] + ".setLayoutData (rowData);\n");
            }
            ++i;
        }
        return code;
    }

    @Override
    String[] getInsertString(String name, String controlType) {
        return new String[]{name, controlType, "-1", "-1", "false"};
    }

    @Override
    String[] getLayoutDataFieldNames() {
        return new String[]{"Control Name", "Control Type", "width", "height", "exclude"};
    }

    @Override
    String getTabText() {
        return "RowLayout";
    }

    @Override
    void resetEditors(boolean tab) {
        TableItem oldItem = this.comboEditor.getItem();
        if (oldItem != null) {
            int row = this.table.indexOf(oldItem);
            try {
                new String(this.nameText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.nameText.setText(oldItem.getText(0));
            }
            try {
                Integer.parseInt(this.widthText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.widthText.setText(oldItem.getText(2));
            }
            try {
                Integer.parseInt(this.heightText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.heightText.setText(oldItem.getText(3));
            }
            String[] insert = new String[]{this.nameText.getText(), this.combo.getText(), this.widthText.getText(), this.heightText.getText(), this.exclude.getText()};
            this.data.set(row, insert);
            int i = 0;
            while (i < 5) {
                oldItem.setText(i, ((String[])this.data.get(row))[i]);
                ++i;
            }
            if (!tab) {
                this.disposeEditors();
            }
        }
        this.setLayoutState();
        this.refreshLayoutComposite();
        this.setLayoutData();
        this.layoutComposite.layout(true);
        this.layoutGroup.layout(true);
    }

    @Override
    void setLayoutData() {
        Control[] children = this.layoutComposite.getChildren();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            int width = Integer.valueOf(items[i].getText(2));
            int height = Integer.valueOf(items[i].getText(3));
            RowData data = new RowData(width, height);
            String exclude = items[i].getText(4);
            data.exclude = exclude.equals("true");
            children[i].setLayoutData((Object)data);
            ++i;
        }
    }

    @Override
    void setLayoutState() {
        this.rowLayout.type = this.vertical.getSelection() ? 512 : 256;
        this.rowLayout.marginWidth = this.marginWidth.getSelection();
        this.rowLayout.marginHeight = this.marginHeight.getSelection();
        this.rowLayout.marginLeft = this.marginLeft.getSelection();
        this.rowLayout.marginRight = this.marginRight.getSelection();
        this.rowLayout.marginTop = this.marginTop.getSelection();
        this.rowLayout.marginBottom = this.marginBottom.getSelection();
        this.rowLayout.spacing = this.spacing.getSelection();
        this.rowLayout.wrap = this.wrap.getSelection();
        this.rowLayout.pack = this.pack.getSelection();
        this.rowLayout.fill = this.fill.getSelection();
        this.rowLayout.justify = this.justify.getSelection();
        this.rowLayout.center = this.center.getSelection();
    }
}

