/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.examples.paint.BasicPaintSession;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.graphics.Point;

public abstract class SegmentedPaintSession
extends BasicPaintSession {
    private List<Point> controlPoints = new ArrayList<Point>();
    private Figure previousFigure = null;
    private Figure currentFigure = null;

    protected SegmentedPaintSession(PaintSurface paintSurface) {
        super(paintSurface);
    }

    @Override
    public void beginSession() {
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.anchorMode"));
        this.previousFigure = null;
        this.currentFigure = null;
        this.controlPoints.clear();
    }

    @Override
    public void endSession() {
        this.getPaintSurface().clearRubberbandSelection();
        if (this.previousFigure != null) {
            this.getPaintSurface().drawFigure(this.previousFigure);
        }
    }

    @Override
    public void resetSession() {
        this.getPaintSurface().clearRubberbandSelection();
        if (this.previousFigure != null) {
            this.getPaintSurface().drawFigure(this.previousFigure);
        }
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.anchorMode"));
        this.previousFigure = null;
        this.currentFigure = null;
        this.controlPoints.clear();
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        this.getPaintSurface().setStatusMessage(PaintExample.getResourceString("session.SegmentedInteractivePaint.message.interactiveMode"));
        this.previousFigure = this.currentFigure;
        if (this.controlPoints.size() > 0) {
            Point lastPoint = this.controlPoints.get(this.controlPoints.size() - 1);
            if (lastPoint.x == event.x || lastPoint.y == event.y) {
                return;
            }
        }
        this.controlPoints.add(new Point(event.x, event.y));
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.controlPoints.size() >= 2) {
            this.getPaintSurface().clearRubberbandSelection();
            this.previousFigure = this.createFigure(this.controlPoints.toArray(new Point[this.controlPoints.size()]), this.controlPoints.size(), true);
        }
        this.resetSession();
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            this.resetSession();
            return;
        }
    }

    public void mouseMove(MouseEvent event) {
        PaintSurface ps = this.getPaintSurface();
        if (this.controlPoints.size() == 0) {
            ps.setStatusCoord(ps.getCurrentPosition());
            return;
        }
        ps.setStatusCoordRange(this.controlPoints.get(this.controlPoints.size() - 1), ps.getCurrentPosition());
        ps.clearRubberbandSelection();
        Point[] points = this.controlPoints.toArray(new Point[this.controlPoints.size() + 1]);
        points[this.controlPoints.size()] = ps.getCurrentPosition();
        this.currentFigure = this.createFigure(points, points.length, false);
        ps.addRubberbandSelection(this.currentFigure);
    }

    protected abstract Figure createFigure(Point[] var1, int var2, boolean var3);
}

