/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.junit.Assert;

public class SwtTestUtil {
    public static boolean fCheckBogusTestCases = false;
    public static boolean fCheckVisibility = false;
    public static boolean fCheckSWTPolicy = false;
    public static boolean fTestDialogOpen = false;
    public static boolean fTestConsistency = false;
    public static boolean verbose = false;
    public static String[] imageFormats = new String[]{"bmp", "jpg", "gif", "png"};
    public static String[] imageFilenames = new String[]{"folder", "folderOpen", "target"};
    public static String[] invalidImageFilenames = new String[]{"corrupt", "corruptBadBitDepth.png"};
    public static String[] transparentImageFilenames = new String[]{"transparent.png"};
    public static String[] reparentablePlatforms = new String[]{"win32", "gtk", "cocoa"};
    public static final String testFontName;
    public static final boolean isWindows;
    public static final boolean isCocoa;
    public static final boolean isGTK;
    public static final boolean isWindowsOS;
    public static final boolean isLinux;
    public static final boolean isAIX;
    public static final boolean isRunningOnContinousIntegration;
    public static final boolean isX11;

    static {
        isWindows = SWT.getPlatform().startsWith("win32");
        isCocoa = SWT.getPlatform().startsWith("cocoa");
        isGTK = SWT.getPlatform().equals("gtk");
        isWindowsOS = System.getProperty("os.name").startsWith("Windows");
        isLinux = System.getProperty("os.name").equals("Linux");
        isAIX = System.getProperty("os.name").equals("AIX");
        isRunningOnContinousIntegration = isGTK && "genie.platform".equalsIgnoreCase(System.getProperty("user.name"));
        isX11 = isGTK && "x11".equals(System.getProperty("org.eclipse.swt.internal.gdk.backend"));
        testFontName = "Helvetica";
    }

    public static void assertSWTProblem(String message, int expectedCode, Throwable actualThrowable) {
        if (actualThrowable instanceof SWTError) {
            SWTError error = (SWTError)actualThrowable;
            Assert.assertEquals((String)message, (long)expectedCode, (long)error.code);
        } else if (actualThrowable instanceof SWTException) {
            SWTException exception = (SWTException)actualThrowable;
            Assert.assertEquals((String)message, (long)expectedCode, (long)exception.code);
        } else {
            try {
                SWT.error((int)expectedCode);
            }
            catch (Throwable expectedThrowable) {
                if (actualThrowable.getMessage().length() > expectedThrowable.getMessage().length()) {
                    Assert.assertTrue((String)message, (boolean)actualThrowable.getMessage().startsWith(expectedThrowable.getMessage()));
                }
                Assert.assertEquals((String)message, (Object)expectedThrowable.getMessage(), (Object)actualThrowable.getMessage());
            }
        }
    }

    protected static boolean isReparentablePlatform() {
        String platform = SWT.getPlatform();
        int i = 0;
        while (i < reparentablePlatforms.length) {
            if (reparentablePlatforms[i].equals(platform)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isGTK3() {
        String gtkVersion = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (gtkVersion != null) {
            return Integer.parseInt(gtkVersion.substring(0, 1)) == 3;
        }
        if (isGTK && gtkVersion == null) {
            throw new IllegalStateException("OS.java has not yet been initialized");
        }
        return false;
    }

    public static boolean isBidi() {
        return true;
    }
}

