/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_CTabFolder
extends Test_org_eclipse_swt_widgets_Composite {
    protected CTabFolder ctabFolder;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.makeCleanEnvironment();
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
    }

    @Override
    @Test
    public void test_getClientArea() {
    }

    @Override
    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
    }

    private void makeCleanEnvironment() {
        this.ctabFolder = new CTabFolder((Composite)this.shell, 0);
        this.setWidget((Widget)this.ctabFolder);
    }

    private void createTabFolder(List<String> events) {
        this.makeCleanEnvironment();
        int i = 0;
        while (i < 3) {
            CTabItem item = new CTabItem(this.ctabFolder, 0);
            item.setText("CTabItem &" + i);
            item.setToolTipText("CTabItem ToolTip" + i);
            Text itemText = new Text((Composite)this.ctabFolder, 2050);
            itemText.setText("\nText for CTabItem " + i + "\n\n\n");
            item.setControl((Control)itemText);
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            this.hookExpectedEvents((Widget)itemText, this.getTestName(), events);
            ++i;
        }
        this.ctabFolder.setSelection(this.ctabFolder.getItem(0));
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 0x1000004, 0, 0, 10, events, false);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(this.ctabFolder.getSize().x / 2, 5, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_PgdwnSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 262144, 0, 0x1000006, 20, events, false);
    }

    @Test
    public void test_consistency_PgupSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(2);
        this.consistencyEvent(0, 262144, 0, 0x1000005, 20, events, false);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 70, 10, 50, events);
    }

    @Test
    public void test_setHighlightEnabled() {
        Assert.assertTrue((String)"By default, highlighting should be enabled", (boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(false);
        Assert.assertFalse((boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(true);
        Assert.assertTrue((boolean)this.ctabFolder.getHighlightEnabled());
    }

    @Ignore(value="Currently failing due to Bug 507611. E.g: Height is 50 instead of being at least 59")
    @Test
    public void test_checkSize() {
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Text text2 = new Text((Composite)this.shell, 18436);
        text2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text2.setText("This control takes the initial focus.");
        Color red = this.shell.getDisplay().getSystemColor(3);
        Image systemImage = this.shell.getDisplay().getSystemImage(2);
        CTabFolder folder = new CTabFolder((Composite)this.shell, 2048);
        folder.setLayoutData((Object)new GridData(4, 1, true, false));
        folder.setSelectionBackground(red);
        int i = 0;
        while (i < 3) {
            CTabItem item = new CTabItem(folder, 64);
            item.setText("Item " + i);
            Text text = new Text((Composite)folder, 2);
            text.setText("Content for Item " + i);
            item.setImage(systemImage);
            item.setControl((Control)text);
            ++i;
        }
        folder.setSelection(0);
        this.shell.pack();
        this.shell.open();
        int folderY = folder.getSize().y;
        int expectedminHeight = systemImage.getImageData().height + text2.getFont().getFontData()[0].getHeight();
        Assert.assertTrue((String)("\nBug 507611 - CTabFolder is too thin for its actual content. \nCtabFolder height:" + folderY + "\nExpected min:" + expectedminHeight), (folderY > expectedminHeight ? 1 : 0) != 0);
    }

    @Test
    public void test_nestedTabHighlighting() {
        CTabFolder partStackTabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem consoleViewTab = new CTabItem(partStackTabFolder, 0);
        consoleViewTab.setText("Console View");
        SashForm anotherView = new SashForm((Composite)partStackTabFolder, 0);
        CTabItem anotherViewTab = new CTabItem(partStackTabFolder, 0);
        anotherViewTab.setText("Other View");
        anotherViewTab.setControl((Control)anotherView);
        CTabFolder anotherViewNestedTabFolder = new CTabFolder((Composite)anotherView, 0);
        CTabItem anotherViewNestedTab = new CTabItem(anotherViewNestedTabFolder, 0);
        anotherViewNestedTab.setText("nested tab");
        this.shell.pack();
        this.shell.open();
        this.processEvents();
        boolean shouldHighlightConsoleViewTab = Test_org_eclipse_swt_custom_CTabFolder.reflection_shouldHighlight(partStackTabFolder);
        Assert.assertFalse((String)"expected CTabFolder to not need highlighting without any selection", (boolean)shouldHighlightConsoleViewTab);
        partStackTabFolder.notifyListeners(26, new Event());
        partStackTabFolder.setSelection(consoleViewTab);
        partStackTabFolder.setSelection(anotherViewTab);
        anotherViewNestedTabFolder.notifyListeners(26, new Event());
        anotherViewNestedTabFolder.setSelection(anotherViewNestedTab);
        partStackTabFolder.setSelection(consoleViewTab);
        anotherViewNestedTabFolder.notifyListeners(27, new Event());
        this.processEvents();
        shouldHighlightConsoleViewTab = Test_org_eclipse_swt_custom_CTabFolder.reflection_shouldHighlight(partStackTabFolder);
        Assert.assertTrue((String)"Bug 528251 - View tab not highlighted due to another view with a CTabFolder", (boolean)shouldHighlightConsoleViewTab);
    }

    private void processEvents() {
        Display display = this.shell.getDisplay();
        while (display.readAndDispatch()) {
        }
    }

    private static boolean reflection_shouldHighlight(CTabFolder partStackTabs) {
        String shouldHighlightMethodName = "shouldHighlight";
        Class<CTabFolder> cTabFolderClass = CTabFolder.class;
        boolean shouldHighlightConsoleViewTab = false;
        try {
            Method method = cTabFolderClass.getDeclaredMethod(shouldHighlightMethodName, new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)partStackTabs, new Object[0]);
            Boolean shouldHighlight = (Boolean)result;
            shouldHighlightConsoleViewTab = shouldHighlight;
        }
        catch (Throwable t) {
            String message = "reflection call to " + cTabFolderClass.getName() + "." + shouldHighlightMethodName + "() failed";
            throw new AssertionError(message, t);
        }
        return shouldHighlightConsoleViewTab;
    }
}

