/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_ExtendedModifyListener {
    Shell shell;
    StyledText styledText;
    int verify = -1;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
        this.shell.open();
    }

    @Test
    public void test_modifyTextLorg_eclipse_swt_custom_ExtendedModifyEvent() {
        ExtendedModifyListener listener = event -> {
            switch (this.verify) {
                case 1: {
                    Assert.assertTrue((String)":1a:", (event.start == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":1b:", (event.length == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":1c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 2: {
                    Assert.assertTrue((String)":2a:", (event.start == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":2b:", (event.length == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":2c:", (boolean)event.replacedText.equals("\n\n"));
                    break;
                }
                case 3: {
                    Assert.assertTrue((String)":3a:", (event.start == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":3b:", (event.length == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":3c:", (boolean)event.replacedText.equals("a"));
                    break;
                }
                case 4: {
                    Assert.assertTrue((String)":4:", (boolean)false);
                    break;
                }
                case 5: {
                    Assert.assertTrue((String)":5a:", (event.start == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":5b:", (event.length == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":5c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 6: {
                    Assert.assertTrue((String)":6a:", (event.start == 21 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":6b:", (event.length == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":6c:", (boolean)event.replacedText.equals("\nline 4"));
                    break;
                }
                case 7: {
                    Assert.assertTrue((String)":7a:", (event.start == 5 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":7b:", (event.length == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":7c:", (boolean)event.replacedText.equals("is a test"));
                    break;
                }
                case 8: {
                    Assert.assertTrue((String)":8a:", (event.start == 7 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":8b:", (event.length == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":8c:", (boolean)event.replacedText.equals("\r\n"));
                    break;
                }
                case 9: {
                    Assert.assertTrue((String)":9a:", (event.start == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":9b:", (event.length == 4 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":9c:", (boolean)event.replacedText.equals("\r\n"));
                    break;
                }
                case 10: {
                    Assert.assertTrue((String)":10:", (boolean)false);
                    break;
                }
                case 11: {
                    Assert.assertTrue((String)":11:", (boolean)false);
                    break;
                }
                case 12: {
                    Assert.assertTrue((String)":12a:", (event.start == 3 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":12b:", (event.length == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":12c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 13: {
                    Assert.assertTrue((String)":13a:", (event.start == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":13b:", (event.length == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":13c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 14: {
                    Assert.assertTrue((String)":14:", (boolean)false);
                    break;
                }
                case 15: {
                    Assert.assertTrue((String)":15a:", (event.start == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":15b:", (event.length == 6 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":15c:", (boolean)event.replacedText.equals("\r\n"));
                    break;
                }
                case 16: {
                    Assert.assertTrue((String)":16:", (boolean)false);
                    break;
                }
                case 17: {
                    Assert.assertTrue((String)":17:", (boolean)false);
                    break;
                }
                case 18: {
                    Assert.assertTrue((String)":18a:", (event.start == 3 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":18b:", (event.length == 7 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":18c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 19: {
                    Assert.assertTrue((String)":19a:", (event.start == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":19b:", (event.length == 7 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":19c:", (boolean)event.replacedText.isEmpty());
                    break;
                }
                case 20: {
                    Assert.assertTrue((String)":20:", (boolean)false);
                    break;
                }
                case 21: {
                    Assert.assertTrue((String)":21a:", (event.start == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":21b:", (event.length == 16 ? 1 : 0) != 0);
                    Assert.assertTrue((String)":21c:", (boolean)event.replacedText.equals("L1\r\nL2\r\nL3\r\nL4\r\n"));
                }
            }
        };
        this.styledText.addExtendedModifyListener(listener);
        boolean exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("testing");
        this.verify = 1;
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 0;
        this.styledText.setText("\n\n");
        this.verify = 2;
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 0;
        this.styledText.setText("a");
        this.verify = 3;
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 4;
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":4: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("Line 1\r\nLine 2");
        this.verify = 5;
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 0;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.verify = 6;
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 0;
        this.styledText.setText("This\nis a test\r");
        this.verify = 7;
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 0;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.verify = 8;
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 9;
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 10;
        try {
            this.styledText.replaceTextRange(3, 1, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":10: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 11;
        try {
            this.styledText.replaceTextRange(1, 2, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":11: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 12;
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 13;
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 14;
        try {
            this.styledText.replaceTextRange(3, 0, "test");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":14: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 15;
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 16;
        try {
            this.styledText.replaceTextRange(3, 1, "test\r\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":16: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 17;
        try {
            this.styledText.replaceTextRange(1, 2, "test\n\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":17: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 18;
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 19;
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 20;
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":20: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 21;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.styledText.removeExtendedModifyListener(listener);
    }
}

