/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.tests.junit.ConsistencyUtility;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_TableTree
extends Test_org_eclipse_swt_widgets_Composite {
    private TableTree tableTree;
    private int style;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.style = 2;
        this.tableTree = new TableTree((Composite)this.shell, 2);
        this.setWidget((Widget)this.tableTree);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Test
    public void test_getSelection() {
        int number = 8;
        TableTreeItem[] items = new TableTreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        Assert.assertArrayEquals((String)"MULTI: After adding items, but before selecting any", (Object[])new TableTreeItem[0], (Object[])this.tableTree.getSelection());
    }

    @Test
    public void test_getSelectionCount() {
        int number = 8;
        TableTreeItem[] items = new TableTreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        Assert.assertEquals((String)"MULTI: After adding items, but before selecting any", (long)0L, (long)this.tableTree.getSelectionCount());
    }

    @Override
    @Test
    public void test_getChildren() {
    }

    @Test
    public void test_selectAll() {
        this.selectAll_helper("Empty table tree", new TableTreeItem[0]);
        int number = 8;
        TableTreeItem[] items = new TableTreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        this.selectAll_helper("selectAll()", items);
        this.singleSelect();
        this.selectAll_helper("Empty table tree", new TableTreeItem[0]);
        items = new TableTreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        this.selectAll_helper("selectAll()", new TableTreeItem[0]);
    }

    @Test
    public void test_setSelection$Lorg_eclipse_swt_custom_TableTreeItem() {
        this.setSelection_helper("Select no items in empty table tree", new TableTreeItem[0], new TableTreeItem[0]);
        try {
            this.tableTree.setSelection(null);
            Assert.fail((String)"MULTI: No exception thrown for selecting null in empty table tree");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int number = 8;
        TableTreeItem[] items = new TableTreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        this.setSelection_helper("Select no items in table tree with items", new TableTreeItem[0], new TableTreeItem[0]);
        try {
            this.tableTree.setSelection(null);
            Assert.fail((String)"MULTI: No exception thrown for selecting null in table tree with items");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        i = 0;
        while (i < number) {
            this.setSelection_helper("Select item " + i, new TableTreeItem[]{items[i]}, new TableTreeItem[]{items[i]});
            ++i;
        }
        this.setSelection_helper("Select items", items, items);
        this.setSelection_helper("Select tableTree.getItems()", this.tableTree.getItems(), this.tableTree.getItems());
        this.setSelection_helper("Select 2 contiguous items", new TableTreeItem[]{items[0], items[1]}, new TableTreeItem[]{items[0], items[1]});
        this.setSelection_helper("Select 2 non-contiguous items", new TableTreeItem[]{items[3], items[6]}, new TableTreeItem[]{items[3], items[6]});
        this.setSelection_helper("Select 3 contiguous items", new TableTreeItem[]{items[2], items[3], items[4]}, new TableTreeItem[]{items[2], items[3], items[4]});
        this.setSelection_helper("Select 3 non-contiguous items", new TableTreeItem[]{items[2], items[5], items[7]}, new TableTreeItem[]{items[2], items[5], items[7]});
        this.setSelection_helper("Select 3 unordered contiguous items", new TableTreeItem[]{items[4], items[2], items[3]}, new TableTreeItem[]{items[2], items[3], items[4]});
        this.setSelection_helper("Select 3 unordered non-contiguous items", new TableTreeItem[]{items[5], items[2], items[7]}, new TableTreeItem[]{items[2], items[5], items[7]});
        this.setSelection_helper("Select 3 reverse-order contiguous items", new TableTreeItem[]{items[4], items[3], items[2]}, new TableTreeItem[]{items[2], items[3], items[4]});
        this.setSelection_helper("Select 3 reverse-order non-contiguous items", new TableTreeItem[]{items[7], items[5], items[2]}, new TableTreeItem[]{items[2], items[5], items[7]});
        this.setSelection_helper("Select same item twice", new TableTreeItem[]{items[0], items[4], items[0]}, new TableTreeItem[]{items[0], items[4]});
        this.setSelection_helper("Select same item multiple times", new TableTreeItem[]{items[4], items[4], items[4], items[4], items[4], items[4]}, new TableTreeItem[]{items[4]});
        this.setSelection_helper("Select multiple items multiple times", new TableTreeItem[]{items[4], items[0], items[2], items[4], items[4], items[0], items[4], items[2]}, new TableTreeItem[]{items[0], items[2], items[4]});
        this.singleSelect();
        this.setSelection_helper("Select no items in empty table tree", new TableTreeItem[0], new TableTreeItem[0]);
        try {
            this.tableTree.setSelection(null);
            Assert.fail((String)"SINGLE: No exception thrown for selecting null in empty table tree");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        items = new TableTreeItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableTreeItem(this.tableTree, 0);
            ++i;
        }
        this.setSelection_helper("Select no items in table tree with items", new TableTreeItem[0], new TableTreeItem[0]);
        try {
            this.tableTree.setSelection(null);
            Assert.fail((String)"SINGLE: No exception thrown for selecting null in table tree with items");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        i = 0;
        while (i < number) {
            this.setSelection_helper("Select item " + i, new TableTreeItem[]{items[i]}, new TableTreeItem[]{items[i]});
            ++i;
        }
        this.setSelection_helper("Select items", items, new TableTreeItem[0]);
        this.setSelection_helper("Select tableTree.getItems()", this.tableTree.getItems(), new TableTreeItem[0]);
        this.setSelection_helper("Select 2 contiguous items", new TableTreeItem[]{items[0], items[1]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 2 non-contiguous items", new TableTreeItem[]{items[3], items[6]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 contiguous items", new TableTreeItem[]{items[2], items[3], items[4]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 non-contiguous items", new TableTreeItem[]{items[2], items[5], items[7]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 unordered contiguous items", new TableTreeItem[]{items[4], items[2], items[3]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 unordered non-contiguous items", new TableTreeItem[]{items[5], items[2], items[7]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 reverse-order contiguous items", new TableTreeItem[]{items[4], items[3], items[2]}, new TableTreeItem[0]);
        this.setSelection_helper("Select 3 reverse-order non-contiguous items", new TableTreeItem[]{items[7], items[5], items[2]}, new TableTreeItem[0]);
        this.setSelection_helper("Select same item twice", new TableTreeItem[]{items[0], items[4], items[0]}, new TableTreeItem[0]);
        this.setSelection_helper("Select same item multiple times", new TableTreeItem[]{items[4], items[4], items[4], items[4], items[4], items[4]}, new TableTreeItem[0]);
        this.setSelection_helper("Select multiple items multiple times", new TableTreeItem[]{items[4], items[0], items[2], items[4], items[4], items[0], items[4], items[2]}, new TableTreeItem[0]);
    }

    private void singleSelect() {
        this.tableTree.dispose();
        this.style = 4;
        this.tableTree = new TableTree((Composite)this.shell, 4);
        this.setWidget((Widget)this.tableTree);
    }

    private void selectAll_helper(String message, TableTreeItem[] expectedSelection) {
        this.tableTree.selectAll();
        message = String.valueOf(this.style == 2 ? "MULTI" : "SINGLE") + ": " + message;
        Assert.assertEquals((String)message, (long)expectedSelection.length, (long)this.tableTree.getSelectionCount());
        Assert.assertArrayEquals((String)message, (Object[])expectedSelection, (Object[])this.tableTree.getSelection());
    }

    private void setSelection_helper(String message, TableTreeItem[] itemsToSelect, TableTreeItem[] expectedSelection) {
        this.tableTree.setSelection(itemsToSelect);
        message = String.valueOf(this.style == 2 ? "MULTI" : "SINGLE") + ": " + message;
        Assert.assertEquals((String)message, (long)expectedSelection.length, (long)this.tableTree.getSelectionCount());
        Assert.assertArrayEquals((String)message, (Object[])expectedSelection, (Object[])this.tableTree.getSelection());
    }

    private void createTableTree(List<String> events, boolean traverse) {
        String test = this.getTestName();
        this.tableTree = new TableTree((Composite)this.shell, 2052);
        int col = 0;
        while (col < 3) {
            TableColumn column = new TableColumn(this.tableTree.getTable(), 0);
            column.setText("Col " + col);
            column.setWidth(70);
            this.hookExpectedEvents((Widget)column, test, events);
            ++col;
        }
        int node = 0;
        while (node < 4) {
            TableTreeItem item = new TableTreeItem(this.tableTree, 0);
            int col2 = 0;
            while (col2 < 3) {
                item.setText(col2, "TTItem" + node + col2);
                ++col2;
            }
            this.hookExpectedEvents((Widget)item, test, events);
            TableTreeItem subitem = new TableTreeItem(item, 0);
            int col3 = 0;
            while (col3 < 3) {
                subitem.setText(col3, "TTSub" + node + col3);
                ++col3;
            }
            this.hookExpectedEvents((Widget)subitem, test, events);
            ++node;
        }
        String[] types = ConsistencyUtility.eventOrdering.get("TableTreeTable");
        if (!traverse) {
            String[] temp = new String[types.length - 1];
            System.arraycopy(types, 0, temp, 0, types.length - 1);
            types = temp;
        }
        this.hookExpectedEvents((Widget)this.tableTree.getTable(), types, events);
        this.setWidget((Widget)this.tableTree);
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(0, 0x1000002, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(30, 30, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_MouseExpand() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(11, 10, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_KeyExpand() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.tableTree.setSelection(new TableTreeItem[]{this.tableTree.getItems()[0]});
        int code = 0x1000004;
        if (SwtTestUtil.isGTK) {
            code = 16777259;
        }
        this.consistencyEvent(0, code, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_DoubleClick() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyPrePackShell();
        this.consistencyEvent(20, this.tableTree.getItemHeight() * 2, 1, 0, 40, events);
    }

    @Test
    public void test_consistency_EnterSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, false);
        this.consistencyEvent(13, 10, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_SpaceSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(32, 32, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(50, 25, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTableTree(events, true);
        this.consistencyEvent(30, 20, 50, 30, 50, events);
    }
}

