/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.Locale;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_FontData {
    @Test
    public void test_Constructor() {
        new FontData();
    }

    @Test
    public void test_ConstructorLjava_lang_String() {
        FontData fd = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData reconstructedFontData = new FontData(fd.toString());
        Assert.assertEquals((Object)fd, (Object)reconstructedFontData);
    }

    @Test
    public void test_ConstructorLjava_lang_StringII() {
        new FontData("", 10, 0);
        new FontData("bad-font", 10, 0);
        new FontData(SwtTestUtil.testFontName, 0, 0);
        new FontData(SwtTestUtil.testFontName, 10, 0);
        new FontData(SwtTestUtil.testFontName, 10, 1);
        new FontData(SwtTestUtil.testFontName, 10, 2);
        new FontData(SwtTestUtil.testFontName, 10, 3);
        try {
            new FontData(null, 10, 0);
            Assert.fail((String)"No exception thrown for name == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new FontData(SwtTestUtil.testFontName, -10, 0);
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        FontData fd1 = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData fd2 = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assert.assertEquals((Object)fd1, (Object)fd1);
        Assert.assertEquals((Object)fd1, (Object)fd2);
    }

    @Test
    public void test_hashCode() {
        FontData fd1 = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData fd2 = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assert.assertEquals((Object)fd1, (Object)fd2);
        Assert.assertEquals((long)fd1.hashCode(), (long)fd2.hashCode());
        FontData fd3 = new FontData(SwtTestUtil.testFontName, 10, 1);
        Assert.assertFalse((fd1.hashCode() == fd3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void test_setHeightI() {
        FontData fontData = new FontData(SwtTestUtil.testFontName, 10, 0);
        int height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assert.assertEquals((String)"Wrong height", (long)fontData.getHeight(), (long)height);
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 1);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assert.assertEquals((String)"Wrong height", (long)fontData.getHeight(), (long)height);
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 2);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assert.assertEquals((String)"Wrong height", (long)fontData.getHeight(), (long)height);
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 3);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assert.assertEquals((String)"Wrong height", (long)fontData.getHeight(), (long)height);
            ++height;
        }
    }

    @Test
    public void test_setLocaleLjava_lang_String() {
        FontData fd = new FontData(SwtTestUtil.testFontName, 10, 0);
        Locale locale = Locale.ENGLISH;
        fd.setLocale(locale.toString());
        Assert.assertEquals((Object)Locale.ENGLISH.toString(), (Object)fd.getLocale());
    }

    @Test
    public void test_setNameLjava_lang_String() {
        FontData fontData = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assert.assertEquals((String)"Wrong name", (Object)fontData.getName(), (Object)SwtTestUtil.testFontName);
        fontData.setName("bad-font");
        Assert.assertEquals((String)"Wrong name", (Object)fontData.getName(), (Object)"bad-font");
        if (SwtTestUtil.isWindows) {
            fontData.setName("");
            Assert.assertEquals((String)"Wrong name", (Object)fontData.getName(), (Object)"");
        }
        fontData.setName(SwtTestUtil.testFontName);
        Assert.assertEquals((String)"Wrong name", (Object)fontData.getName(), (Object)SwtTestUtil.testFontName);
        try {
            fontData.setName(null);
            Assert.fail((String)"No exception thrown for name == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setStyleI() {
        int height = 0;
        while (height < 1000) {
            FontData fontData = new FontData(SwtTestUtil.testFontName, height, 0);
            Assert.assertEquals((String)"Wrong style", (long)fontData.getStyle(), (long)0L);
            fontData.setStyle(1);
            Assert.assertEquals((String)"Wrong style", (long)fontData.getStyle(), (long)1L);
            fontData.setStyle(2);
            Assert.assertEquals((String)"Wrong style", (long)fontData.getStyle(), (long)2L);
            fontData.setStyle(3);
            Assert.assertEquals((String)"Wrong style", (long)fontData.getStyle(), (long)3L);
            fontData.setStyle(0);
            Assert.assertEquals((String)"Wrong style", (long)fontData.getStyle(), (long)0L);
            ++height;
        }
    }

    @Test
    public void test_toString() {
        FontData data = new FontData();
        Assert.assertNotNull((Object)data.toString());
        Assert.assertTrue((data.toString().length() > 0 ? 1 : 0) != 0);
    }
}

