/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_GC {
    Display display;
    Shell shell;
    Image image;
    GC gc;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.shell.setBounds(0, 30, 240, 290);
        this.image = new Image((Device)this.display, 200, 200);
        this.gc = new GC((Drawable)this.image);
    }

    @After
    public void tearDown() {
        this.gc.dispose();
        this.image.dispose();
        this.shell.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Drawable() {
        try {
            GC gc = new GC(null);
            gc.dispose();
            Assert.fail((String)"No exception thrown for drawable == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for drawable == null", 4, e);
        }
        Image image = null;
        GC gc1 = null;
        GC gc2 = null;
        try {
            try {
                image = new Image((Device)this.display, 10, 10);
                gc1 = new GC((Drawable)image);
                gc2 = new GC((Drawable)image);
                Assert.fail((String)"No exception thrown for more than one GC on one image");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for more than one GC on one image", 5, e);
                if (image != null) {
                    image.dispose();
                }
                if (gc1 != null) {
                    gc1.dispose();
                }
                if (gc2 != null) {
                    gc2.dispose();
                }
            }
        }
        finally {
            if (image != null) {
                image.dispose();
            }
            if (gc1 != null) {
                gc1.dispose();
            }
            if (gc2 != null) {
                gc2.dispose();
            }
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DrawableI() {
        block16: {
            try {
                GC gc = new GC(null, 0x2000000);
                gc.dispose();
                Assert.fail((String)"No exception thrown for drawable == null");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for drawable == null", 4, e);
            }
            Image image = null;
            GC gc1 = null;
            GC gc2 = null;
            try {
                try {
                    image = new Image((Device)this.display, 10, 10);
                    gc1 = new GC((Drawable)image, 0x4000000);
                    gc2 = new GC((Drawable)image, 0x2000000);
                    Assert.fail((String)"No exception thrown for more than one GC on one image");
                }
                catch (IllegalArgumentException e) {
                    SwtTestUtil.assertSWTProblem("Incorrect exception thrown for more than one GC on one image", 5, e);
                    if (image != null) {
                        image.dispose();
                    }
                    if (gc1 != null) {
                        gc1.dispose();
                    }
                    if (gc2 != null) {
                        gc2.dispose();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (image != null) {
                    image.dispose();
                }
                if (gc1 != null) {
                    gc1.dispose();
                }
                if (gc2 != null) {
                    gc2.dispose();
                }
                throw throwable;
            }
            if (image != null) {
                image.dispose();
            }
            if (gc1 != null) {
                gc1.dispose();
            }
            if (gc2 != null) {
                gc2.dispose();
            }
        }
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas, 0x4000000);
        testGC.dispose();
        testGC = new GC((Drawable)canvas, 0x2000000);
        testGC.dispose();
        canvas.dispose();
    }

    @Test
    public void test_copyAreaIIIIII() {
        Color white = this.display.getSystemColor(1);
        Color blue = this.display.getSystemColor(9);
        RGB whiteRGB = this.getRealRGB(white);
        RGB blueRGB = this.getRealRGB(blue);
        int width = 20;
        int height = 20;
        int destX = 10;
        int destY = 50;
        this.gc.setBackground(white);
        this.gc.fillRectangle(this.image.getBounds());
        this.gc.setBackground(blue);
        this.gc.fillRectangle(5, 0, 6, 1);
        this.gc.copyArea(0, 0, width, height, destX, destY);
        ImageData imageData = this.image.getImageData();
        PaletteData palette = imageData.palette;
        if (DPIUtil.getDeviceZoom() != 100) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copyAreaIIIIII(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_GC)");
            }
            return;
        }
        int pixel = imageData.getPixel(destX + 4, destY);
        Assert.assertEquals((String)":a:", (Object)whiteRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 6, destY);
        Assert.assertEquals((String)":b:", (Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 10, destY);
        Assert.assertEquals((String)":c:", (Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 12, destY);
        Assert.assertEquals((String)":d:", (Object)whiteRGB, (Object)palette.getRGB(pixel));
    }

    @Test
    public void test_copyAreaLorg_eclipse_swt_graphics_ImageII() {
        Color white = this.display.getSystemColor(1);
        Color blue = this.display.getSystemColor(9);
        RGB whiteRGB = this.getRealRGB(white);
        RGB blueRGB = this.getRealRGB(blue);
        this.gc.setBackground(white);
        this.gc.fillRectangle(this.image.getBounds());
        this.gc.setBackground(blue);
        this.gc.fillRectangle(5, 0, 6, 1);
        Image image = new Image((Device)this.display, 12, 12);
        this.gc.copyArea(image, 0, 0);
        ImageData imageData = image.getImageData();
        PaletteData palette = imageData.palette;
        if (DPIUtil.getDeviceZoom() != 100) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copyAreaLorg_eclipse_swt_graphics_ImageII(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_GC)");
            }
            image.dispose();
            return;
        }
        int pixel = imageData.getPixel(4, 0);
        Assert.assertEquals((String)":a:", (Object)whiteRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(5, 0);
        Assert.assertEquals((String)":b:", (Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(10, 0);
        Assert.assertEquals((String)":c:", (Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(11, 0);
        Assert.assertEquals((String)":d:", (Object)whiteRGB, (Object)palette.getRGB(pixel));
        image.dispose();
    }

    @Test
    public void test_dispose() {
        this.gc.dispose();
    }

    @Test
    public void test_drawArcIIIIII() {
        this.gc.drawArc(10, 20, 50, 25, 90, 90);
    }

    @Test
    public void test_drawFocusIIII() {
        this.gc.drawFocus(1, 1, 50, 25);
    }

    @Test
    public void test_drawImageLorg_eclipse_swt_graphics_ImageII() {
        Color c1 = new Color((Device)this.display, 255, 0, 0);
        Color c2 = new Color((Device)this.display, 0, 0, 0);
        Color c3 = new Color((Device)this.display, 255, 255, 0);
        PaletteData paletteData = new PaletteData(new RGB[]{c1.getRGB(), c2.getRGB(), c3.getRGB()});
        ImageData data = new ImageData(30, 30, 8, paletteData);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (x > y) {
                    data.setPixel(x, y, paletteData.getPixel(c1.getRGB()));
                } else if (x < y) {
                    data.setPixel(x, y, paletteData.getPixel(c2.getRGB()));
                } else {
                    data.setPixel(x, y, paletteData.getPixel(c3.getRGB()));
                }
                ++x;
            }
            ++y;
        }
        Image image = new Image((Device)this.display, data);
        data = image.getImageData();
        data.transparentPixel = paletteData.getPixel(c1.getRGB());
        Image imageTransparent = new Image((Device)this.display, data);
        data.transparentPixel = -1;
        int y2 = 0;
        while (y2 < data.height) {
            int x = 0;
            while (x < data.width) {
                data.setAlpha(x, y2, 127);
                ++x;
            }
            ++y2;
        }
        Image imageAlpha = new Image((Device)this.display, data);
        this.gc.drawImage(image, 100, 100);
        this.gc.drawImage(imageTransparent, 130, 100);
        this.gc.drawImage(imageAlpha, 160, 100);
        try {
            this.gc.drawImage(null, 100, 100);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        image.dispose();
        imageTransparent.dispose();
        imageAlpha.dispose();
        c1.dispose();
        c2.dispose();
        c3.dispose();
    }

    @Test
    public void test_drawImageLorg_eclipse_swt_graphics_ImageIIIIIIII() {
        Color c1 = new Color((Device)this.display, 255, 0, 0);
        Color c2 = new Color((Device)this.display, 0, 0, 0);
        Color c3 = new Color((Device)this.display, 255, 255, 0);
        PaletteData paletteData = new PaletteData(new RGB[]{c1.getRGB(), c2.getRGB(), c3.getRGB()});
        ImageData data = new ImageData(30, 30, 8, paletteData);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (x > y) {
                    data.setPixel(x, y, paletteData.getPixel(c1.getRGB()));
                } else if (x < y) {
                    data.setPixel(x, y, paletteData.getPixel(c2.getRGB()));
                } else {
                    data.setPixel(x, y, paletteData.getPixel(c3.getRGB()));
                }
                ++x;
            }
            ++y;
        }
        Image image = new Image((Device)this.display, data);
        data = image.getImageData();
        data.transparentPixel = paletteData.getPixel(c1.getRGB());
        Image imageTransparent = new Image((Device)this.display, data);
        data.transparentPixel = -1;
        int y2 = 0;
        while (y2 < data.height) {
            int x = 0;
            while (x < data.width) {
                data.setAlpha(x, y2, 127);
                ++x;
            }
            ++y2;
        }
        Image imageAlpha = new Image((Device)this.display, data);
        this.gc.drawImage(image, 10, 5, 20, 15, 100, 120, 50, 60);
        this.gc.drawImage(imageTransparent, 10, 5, 20, 15, 100, 120, 10, 10);
        this.gc.drawImage(imageAlpha, 10, 5, 20, 15, 100, 120, 20, 15);
        try {
            this.gc.drawImage(null, 10, 5, 20, 15, 100, 120, 50, 60);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        image.dispose();
        imageAlpha.dispose();
        imageTransparent.dispose();
        c1.dispose();
        c2.dispose();
        c3.dispose();
    }

    @Test
    public void test_drawLineIIII() {
        this.gc.drawLine(0, 0, 0, 20);
    }

    @Test
    public void test_drawOvalIIII() {
        this.gc.drawOval(10, 0, 20, 30);
    }

    @Test
    public void test_drawPointII() {
        this.gc.drawPoint(10, 10);
    }

    @Test
    public void test_drawPolygon$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.drawPolygon(nArray);
        this.gc.drawPolygon(new int[2]);
    }

    @Test
    public void test_drawPolyline$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.drawPolyline(nArray);
        this.gc.drawPolyline(new int[2]);
    }

    @Test
    public void test_drawRectangleIIII() {
        this.gc.drawRectangle(10, 0, 20, 30);
        this.gc.drawRectangle(0, 0, 0, 0);
    }

    @Test
    public void test_drawRectangleLorg_eclipse_swt_graphics_Rectangle() {
        this.gc.drawRectangle(new Rectangle(10, 0, 20, 30));
        this.gc.drawRectangle(new Rectangle(0, 0, 0, 0));
    }

    @Test
    public void test_drawRoundRectangleIIIIII() {
        this.gc.drawRoundRectangle(10, 0, 20, 30, 3, 3);
        this.gc.drawRoundRectangle(0, 0, 0, 0, 0, 0);
    }

    @Test
    public void test_drawStringLjava_lang_StringII() {
        this.gc.drawString("test", 5, 5);
    }

    @Test
    public void test_drawStringLjava_lang_StringIIZ() {
        this.gc.drawString("test", 5, 5, true);
        this.gc.drawString("test", 5, 5, false);
    }

    @Test
    public void test_drawTextLjava_lang_StringII() {
        this.gc.drawText("test", 5, 5);
        this.gc.drawText("", 0, 0);
    }

    @Test
    public void test_drawTextLjava_lang_StringIII() {
        this.gc.drawText("abc", 5, 5, 0);
        this.gc.drawText("abc", 5, 5, 1);
        this.gc.drawText("abc", 5, 5, 2);
        this.gc.drawText("abc", 5, 5, 8);
        this.gc.drawText("abc", 5, 5, 4);
        this.gc.drawText("", 0, 0, 0);
        this.gc.drawText("", 0, 0, 1);
        this.gc.drawText("", 0, 0, 2);
        this.gc.drawText("", 0, 0, 8);
        this.gc.drawText("", 0, 0, 4);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 0);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 1);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 2);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 8);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 4);
        this.gc.drawText("\r", 5, 5, 2);
        this.gc.drawText("\n", 5, 5, 2);
        this.gc.drawText("&", 5, 5, 8);
        this.gc.drawText("\t", 5, 5, 4);
    }

    @Test
    public void test_drawTextLjava_lang_StringIIZ() {
        this.gc.drawText("abc", 5, 5, true);
        this.gc.drawText("abc", 5, 5, false);
        this.gc.drawText("", 0, 0, true);
        this.gc.drawText("", 0, 0, false);
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Assert.assertTrue((boolean)this.gc.equals((Object)this.gc));
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas);
        Assert.assertFalse((boolean)testGC.equals((Object)this.gc));
        testGC.dispose();
    }

    @Test
    public void test_fillArcIIIIII() {
        this.gc.fillArc(10, 20, 50, 25, 90, 90);
        this.gc.fillArc(10, 20, 50, 25, -10, -10);
    }

    @Test
    public void test_fillGradientRectangleIIIIZ() {
        this.gc.fillGradientRectangle(10, 0, 20, 30, true);
        this.gc.fillGradientRectangle(0, 0, 0, 0, true);
        this.gc.fillGradientRectangle(10, 0, 20, 30, false);
        this.gc.fillGradientRectangle(0, 0, 0, 0, false);
    }

    @Test
    public void test_fillOvalIIII() {
        this.gc.fillOval(10, 0, 20, 30);
        this.gc.fillOval(-1, -1, -1, -1);
    }

    @Test
    public void test_fillPolygon$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.fillPolygon(nArray);
        this.gc.fillPolygon(new int[2]);
        this.gc.fillPolygon(new int[]{-1, -1});
    }

    @Test
    public void test_fillRectangleIIII() {
        this.gc.fillRectangle(new Rectangle(10, 0, 20, 30));
        this.gc.fillRectangle(new Rectangle(0, 0, 0, 0));
        this.gc.fillRectangle(new Rectangle(-1, -1, -1, -1));
    }

    @Test
    public void test_fillRectangleLorg_eclipse_swt_graphics_Rectangle() {
        this.gc.fillRectangle(10, 0, 20, 30);
        this.gc.fillRectangle(0, 0, 0, 0);
    }

    @Test
    public void test_fillRoundRectangleIIIIII() {
        this.gc.fillRoundRectangle(10, 0, 20, 30, 3, 3);
        this.gc.fillRoundRectangle(0, 0, 0, 0, 0, 0);
        this.gc.fillRoundRectangle(10, 0, 20, 30, -10, -10);
    }

    @Test
    public void test_getAdvanceWidthC() {
        int w = this.gc.getAdvanceWidth('a');
        Assert.assertTrue((w > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getCharWidthC() {
        int w = this.gc.getCharWidth('a');
        Assert.assertTrue((w > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getFontMetrics() {
        FontMetrics fm = this.gc.getFontMetrics();
        Assert.assertTrue((fm.getHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getStyle() {
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas, 0x2000000);
        int style = testGC.getStyle();
        Assert.assertTrue(((style & 0x2000000) != 0 ? 1 : 0) != 0);
        testGC.dispose();
        testGC = new GC((Drawable)canvas);
        style = testGC.getStyle();
        Assert.assertTrue(((style & 0x2000000) != 0 ? 1 : 0) != 0);
        testGC.dispose();
        testGC = new GC((Drawable)canvas, 0x4000000);
        style = testGC.getStyle();
        Assert.assertTrue(((style & 0x4000000) != 0 ? 1 : 0) != 0);
        testGC.dispose();
    }

    @Test
    public void test_hashCode() {
        Assert.assertTrue((this.gc.hashCode() == this.gc.hashCode() ? 1 : 0) != 0);
        GC gc2 = new GC((Drawable)this.shell);
        Assert.assertFalse((this.gc.hashCode() == gc2.hashCode() ? 1 : 0) != 0);
        gc2.dispose();
    }

    @Test
    public void test_isClipped() {
        Assert.assertFalse((boolean)this.gc.isClipped());
        this.gc.setClipping(5, 10, 15, 20);
        Assert.assertTrue((boolean)this.gc.isClipped());
    }

    @Test
    public void test_isDisposed() {
        Assert.assertFalse((boolean)this.gc.isDisposed());
        this.gc.dispose();
        Assert.assertTrue((boolean)this.gc.isDisposed());
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.shell.getDisplay(), 255, 0, 0);
        this.gc.setBackground(color);
        Assert.assertEquals((Object)color, (Object)this.gc.getBackground());
        try {
            this.gc.setBackground(null);
            Assert.fail((String)"No exception thrown for null color");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)this.gc.getBackground(), (Object)this.gc.getBackground());
        color.dispose();
        try {
            this.gc.setBackground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setClippingIIII() {
    }

    @Test
    public void test_setClippingLorg_eclipse_swt_graphics_Rectangle() {
    }

    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        this.gc.setFont(this.shell.getDisplay().getSystemFont());
        Font font = this.gc.getFont();
        Assert.assertTrue((boolean)font.equals((Object)this.shell.getDisplay().getSystemFont()));
    }

    @Test
    public void test_setForegroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.shell.getDisplay(), 255, 0, 0);
        this.gc.setForeground(color);
        Assert.assertEquals((Object)color, (Object)this.gc.getForeground());
        try {
            this.gc.setForeground(null);
            Assert.fail((String)"No exception thrown for null color");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)this.gc.getForeground(), (Object)this.gc.getForeground());
        color.dispose();
        try {
            this.gc.setForeground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setLineStyleI() {
        this.gc.setLineStyle(1);
        Assert.assertTrue((this.gc.getLineStyle() == 1 ? 1 : 0) != 0);
        this.gc.setLineStyle(2);
        Assert.assertTrue((this.gc.getLineStyle() == 2 ? 1 : 0) != 0);
        this.gc.setLineStyle(3);
        Assert.assertTrue((this.gc.getLineStyle() == 3 ? 1 : 0) != 0);
        this.gc.setLineStyle(4);
        Assert.assertTrue((this.gc.getLineStyle() == 4 ? 1 : 0) != 0);
        this.gc.setLineStyle(5);
        Assert.assertTrue((this.gc.getLineStyle() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void test_setLineWidthI() {
        this.gc.setLineWidth(10);
        Assert.assertTrue((this.gc.getLineWidth() == 10 ? 1 : 0) != 0);
        this.gc.setLineWidth(0);
        Assert.assertTrue((this.gc.getLineWidth() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_setXORModeZ() {
        this.gc.setXORMode(true);
        Assert.assertTrue((boolean)this.gc.getXORMode());
        this.gc.setXORMode(false);
        Assert.assertFalse((boolean)this.gc.getXORMode());
    }

    @Test
    public void test_stringExtentLjava_lang_String() {
        Point pt = this.gc.stringExtent("abc");
        Assert.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_textExtentLjava_lang_String() {
        Point pt = this.gc.textExtent("abc");
        Assert.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_textExtentLjava_lang_StringI() {
        Point pt = this.gc.textExtent("abc", 0);
        Assert.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_toString() {
        String s = this.gc.toString();
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((s.length() > 0 ? 1 : 0) != 0);
    }

    RGB getRealRGB(Color color) {
        Image colorImage = new Image((Device)this.display, 10, 10);
        GC imageGc = new GC((Drawable)colorImage);
        imageGc.setBackground(color);
        imageGc.setForeground(color);
        imageGc.fillRectangle(0, 0, 10, 10);
        ImageData imageData = colorImage.getImageData();
        PaletteData palette = imageData.palette;
        imageGc.dispose();
        colorImage.dispose();
        int pixel = imageData.getPixel(0, 0);
        return palette.getRGB(pixel);
    }
}

