/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Image {
    ImageFileNameProvider imageFileNameProvider = zoom -> {
        String fileName;
        switch (zoom) {
            case 100: {
                fileName = "collapseall.png";
                break;
            }
            case 150: {
                fileName = "collapseall@1.5x.png";
                break;
            }
            case 200: {
                fileName = "collapseall@2x.png";
                break;
            }
            default: {
                return null;
            }
        }
        return this.getPath(fileName);
    };
    ImageDataProvider imageDataProvider = zoom -> {
        String fileName;
        switch (zoom) {
            case 100: {
                fileName = "collapseall.png";
                break;
            }
            case 150: {
                fileName = "collapseall@1.5x.png";
                break;
            }
            case 200: {
                fileName = "collapseall@2x.png";
                break;
            }
            default: {
                return null;
            }
        }
        return new ImageData(this.getPath(fileName));
    };
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceII() {
        Image image;
        try {
            image = new Image((Device)this.display, -1, 10);
            image.dispose();
            Assert.fail((String)"No exception thrown for width <= 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width <= 0", 5, e);
        }
        try {
            image = new Image((Device)this.display, 0, 10);
            image.dispose();
            Assert.fail((String)"No exception thrown for width <= 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width <= 0", 5, e);
        }
        try {
            image = new Image((Device)this.display, 10, -20);
            image.dispose();
            Assert.fail((String)"No exception thrown for height <= 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height <= 0", 5, e);
        }
        try {
            image = new Image((Device)this.display, 10, 0);
            image.dispose();
            Assert.fail((String)"No exception thrown for height <= 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height <= 0", 5, e);
        }
        image = new Image(null, 10, 10);
        image.dispose();
        image = new Image((Device)this.display, 10, 10);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_Rectangle() {
        Image image;
        Rectangle bounds = null;
        try {
            image = new Image((Device)this.display, bounds);
            image.dispose();
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        }
        bounds = new Rectangle(0, 0, -1, 10);
        try {
            image = new Image((Device)this.display, bounds);
            image.dispose();
            Assert.fail((String)"No exception thrown for width < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width < 0", 5, e);
        }
        bounds = new Rectangle(0, 0, 0, 10);
        try {
            image = new Image((Device)this.display, bounds);
            image.dispose();
            Assert.fail((String)"No exception thrown for width == 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width == 0", 5, e);
        }
        bounds = new Rectangle(0, 0, 10, -1);
        try {
            image = new Image((Device)this.display, bounds);
            image.dispose();
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height < 0", 5, e);
        }
        bounds = new Rectangle(0, 0, 10, 0);
        try {
            image = new Image((Device)this.display, bounds);
            image.dispose();
            Assert.fail((String)"No exception thrown for height == 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height == 0", 5, e);
        }
        bounds = new Rectangle(-1, -10, 10, 10);
        image = new Image((Device)this.display, bounds);
        image.dispose();
        bounds = new Rectangle(0, 0, 10, 10);
        image = new Image(null, bounds);
        image.dispose();
        image = new Image((Device)this.display, bounds);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_ImageData() {
        ImageData data = null;
        Image image = null;
        try {
            image = new Image((Device)this.display, data);
            image.dispose();
            Assert.fail((String)"No exception thrown for ImageData == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData == null", 4, e);
        }
        data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image(null, data);
        image.dispose();
        data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, data);
        image.dispose();
        data = new ImageData(10, 10, 8, new PaletteData(48, 12, 3));
        data.setPixel(9, 9, 48);
        image = new Image((Device)this.display, data);
        Image gcImage = new Image((Device)this.display, 10, 10);
        GC gc = new GC((Drawable)gcImage);
        gc.drawImage(image, 0, 0);
        ImageData gcImageData = gcImage.getImageData();
        int redPixel = gcImageData.getPixel(9, 9);
        Assert.assertEquals((String)":a:", (Object)this.getRealRGB(this.display.getSystemColor(3)), (Object)gcImageData.palette.getRGB(redPixel));
        gc.dispose();
        gcImage.dispose();
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_ImageDataLorg_eclipse_swt_graphics_ImageData() {
        ImageData data = null;
        ImageData data1 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        Image image = null;
        try {
            image = new Image((Device)this.display, data, data1);
            image.dispose();
            Assert.fail((String)"No exception thrown for ImageData source == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source == null", 4, e);
        }
        data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        data1 = null;
        try {
            image = new Image((Device)this.display, data, data1);
            image.dispose();
            Assert.fail((String)"No exception thrown for ImageData mask == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData mask == null", 4, e);
        }
        data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        data1 = new ImageData(1, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        try {
            image = new Image((Device)this.display, data, data1);
            image.dispose();
            Assert.fail((String)"No exception thrown for ImageData source width != ImageData mask width");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source width != ImageData mask width", 5, e);
        }
        data = new ImageData(10, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        data1 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        try {
            image = new Image((Device)this.display, data, data1);
            image.dispose();
            Assert.fail((String)"No exception thrown for ImageData source height != ImageData mask height");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source height != ImageData mask height", 5, e);
        }
        data = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        data1 = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, data, data1);
        image.dispose();
        data = new ImageData(10, 10, 8, new PaletteData(48, 12, 3));
        data.setPixel(9, 9, 48);
        data1 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        data1.setPixel(9, 9, 1);
        image = new Image((Device)this.display, data, data1);
        Image gcImage = new Image((Device)this.display, 10, 10);
        GC gc = new GC((Drawable)gcImage);
        Color backgroundColor = this.display.getSystemColor(9);
        gc.setBackground(backgroundColor);
        gc.fillRectangle(0, 0, 10, 10);
        gc.drawImage(image, 0, 0);
        ImageData gcImageData = gcImage.getImageData();
        int redPixel = gcImageData.getPixel(9, 9);
        Assert.assertEquals((String)":a:", (Object)this.getRealRGB(this.display.getSystemColor(3)), (Object)gcImageData.palette.getRGB(redPixel));
        int bluePixel = gcImageData.getPixel(0, 0);
        Assert.assertEquals((String)":b:", (Object)this.getRealRGB(backgroundColor), (Object)gcImageData.palette.getRGB(bluePixel));
        gc.dispose();
        gcImage.dispose();
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_io_InputStream() {
        InputStream stream = null;
        Image image = null;
        try {
            try {
                image = new Image((Device)this.display, stream);
                image.dispose();
                Assert.fail((String)"No exception thrown for InputStream == null");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for InputStream == null", 4, e);
            }
            stream = SwtTestUtil.class.getResourceAsStream("empty.txt");
            try {
                image = new Image((Device)this.display, stream);
                image.dispose();
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                Assert.fail((String)"No exception thrown for invalid InputStream");
            }
            catch (SWTException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid InputStream", 42, e);
            }
            int numFormats = SwtTestUtil.imageFormats.length;
            String fileName = SwtTestUtil.invalidImageFilenames[0];
            Display[] displayArray = new Display[2];
            displayArray[0] = this.display;
            Display[] displays = displayArray;
            int j = 0;
            while (j < displays.length) {
                int i = 0;
                while (i < numFormats) {
                    String format = SwtTestUtil.imageFormats[i];
                    stream = SwtTestUtil.class.getResourceAsStream(String.valueOf(fileName) + "." + format);
                    try {
                        image = new Image((Device)this.display, stream);
                        image.dispose();
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        Assert.fail((String)"No exception thrown for invalid InputStream");
                    }
                    catch (SWTException sWTException) {}
                    ++i;
                }
                ++j;
            }
            stream = SwtTestUtil.class.getResourceAsStream(SwtTestUtil.invalidImageFilenames[1]);
            try {
                image = new Image((Device)this.display, stream);
                image.dispose();
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                Assert.fail((String)"No exception thrown for invalid InputStream");
            }
            catch (SWTException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image InputStream", 40, e);
            }
            j = 0;
            while (j < displays.length) {
                Display tempDisplay = displays[j];
                int numFileNames = SwtTestUtil.imageFilenames.length;
                int k = 0;
                while (k < numFileNames) {
                    fileName = SwtTestUtil.imageFilenames[k];
                    int i = 0;
                    while (i < numFormats) {
                        String format = SwtTestUtil.imageFormats[i];
                        stream = SwtTestUtil.class.getResourceAsStream(String.valueOf(fileName) + "." + format);
                        image = new Image((Device)tempDisplay, stream);
                        image.dispose();
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        ++i;
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_lang_String() {
        Image image;
        String pathName;
        String fileName = null;
        try {
            Image image2 = new Image((Device)this.display, fileName);
            image2.dispose();
            Assert.fail((String)"No exception thrown for file name == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for file name == null", 4, e);
        }
        try {
            pathName = "nonexistent.txt";
            image = new Image((Device)this.display, pathName);
            image.dispose();
            Assert.fail((String)"No exception thrown for non-existent file name");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for non-existent file name", 39, e);
        }
        try {
            pathName = this.getPath("empty.txt");
            image = new Image((Device)this.display, pathName);
            image.dispose();
            Assert.fail((String)"No exception thrown for invalid file name");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid file name", 42, e);
        }
        int numFormats = SwtTestUtil.imageFormats.length;
        fileName = SwtTestUtil.invalidImageFilenames[0];
        Display[] displayArray = new Display[2];
        displayArray[0] = this.display;
        Display[] displays = displayArray;
        int j = 0;
        while (j < displays.length) {
            int i = 0;
            while (i < numFormats) {
                String format = SwtTestUtil.imageFormats[i];
                try {
                    String pathName2 = this.getPath(String.valueOf(fileName) + "." + format);
                    Image image3 = new Image((Device)this.display, pathName2);
                    image3.dispose();
                    Assert.fail((String)"No exception thrown for invalid file name");
                }
                catch (SWTException sWTException) {}
                ++i;
            }
            ++j;
        }
        try {
            String pathName3 = this.getPath(SwtTestUtil.invalidImageFilenames[1]);
            Image image4 = new Image((Device)this.display, pathName3);
            image4.dispose();
            Assert.fail((String)"No exception thrown for invalid file name");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image file name", 40, e);
        }
        j = 0;
        while (j < displays.length) {
            int numFileNames = SwtTestUtil.imageFilenames.length;
            int k = 0;
            while (k < numFileNames) {
                fileName = SwtTestUtil.imageFilenames[k];
                int i = 0;
                while (i < numFormats) {
                    String format = SwtTestUtil.imageFormats[i];
                    String pathName4 = this.getPath(String.valueOf(fileName) + "." + format);
                    Image image5 = new Image((Device)this.display, pathName4);
                    image5.dispose();
                    ++i;
                }
                ++k;
            }
            ++j;
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageFileNameProvider() {
        Image image;
        ImageFileNameProvider provider = null;
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for file name == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 4, e);
        }
        provider = zoom -> null;
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for non-existent file name");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 5, e);
        }
        image = new Image((Device)this.display, this.imageFileNameProvider);
        image.dispose();
        provider = zoom -> {
            String fileName;
            switch (zoom) {
                case 100: {
                    fileName = "corrupt.png";
                    break;
                }
                case 150: {
                    fileName = "corrupt.png";
                    break;
                }
                case 200: {
                    fileName = "corrupt.png";
                    break;
                }
                default: {
                    return null;
                }
            }
            return this.getPath(fileName);
        };
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for corrupt image file.");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
        }
        provider = zoom -> {
            String fileName;
            switch (zoom) {
                case 100: {
                    fileName = "collapseall.png";
                    break;
                }
                default: {
                    return null;
                }
            }
            return this.getPath(fileName);
        };
        image = new Image((Device)this.display, provider);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageDataProvider() {
        Image image;
        ImageDataProvider provider = null;
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for file name == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 4, e);
        }
        provider = zoom -> null;
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for non-existent file name");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 5, e);
        }
        image = new Image((Device)this.display, this.imageDataProvider);
        image.dispose();
        provider = zoom -> {
            String fileName;
            switch (zoom) {
                case 100: {
                    fileName = "corrupt.png";
                    break;
                }
                case 150: {
                    fileName = "corrupt.png";
                    break;
                }
                case 200: {
                    fileName = "corrupt.png";
                    break;
                }
                default: {
                    return null;
                }
            }
            return new ImageData(this.getPath(fileName));
        };
        try {
            image = new Image((Device)this.display, provider);
            image.dispose();
            Assert.fail((String)"No exception thrown for corrupt image file.");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
        }
        provider = zoom -> {
            String fileName;
            switch (zoom) {
                case 100: {
                    fileName = "collapseall.png";
                    break;
                }
                default: {
                    return null;
                }
            }
            return new ImageData(this.getPath(fileName));
        };
        image = new Image((Device)this.display, provider);
        image.dispose();
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Image image = null;
        Image image1 = null;
        try {
            image1 = image = new Image((Device)this.display, 10, 10);
            Assert.assertFalse((String)":a:", (boolean)image.equals(null));
            Assert.assertTrue((String)":b:", (boolean)image.equals((Object)image1));
            ImageData imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            image.dispose();
            image = new Image((Device)this.display, imageData);
            image1 = new Image((Device)this.display, imageData);
            Assert.assertFalse((String)":c:", (boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertFalse((String)":d:", (boolean)image.equals(null));
            Assert.assertTrue((String)":e:", (boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertTrue((String)":f:", (boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertFalse((String)":d:", (boolean)image.equals(null));
            Assert.assertTrue((String)":e:", (boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertTrue((String)":f:", (boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertFalse((String)":g:", (boolean)image.equals(null));
            Assert.assertTrue((String)":h:", (boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertTrue((String)":i:", (boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
    }

    @Test
    public void test_getBackground() {
        Image image = new Image((Device)this.display, 10, 10);
        image.dispose();
        try {
            image.getBackground();
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        }
    }

    @Test
    public void test_getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        image.dispose();
        try {
            image.getBounds();
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        }
        image = new Image((Device)this.display, bounds.width, bounds.height);
        Rectangle bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":a:", (Object)bounds, (Object)bounds1);
        image = new Image((Device)this.display, bounds);
        bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":b:", (Object)bounds, (Object)bounds1);
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c:", (Object)bounds, (Object)bounds1);
    }

    @Test
    public void test_getBoundsInPixels() {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        image.dispose();
        try {
            image.getBoundsInPixels();
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        }
        image = new Image((Device)this.display, bounds.width, bounds.height);
        Rectangle boundsInPixels = image.getBoundsInPixels();
        image.dispose();
        Assert.assertEquals((String)":a: Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)boundsInPixels, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        boundsInPixels = image.getBoundsInPixels();
        image.dispose();
        Assert.assertEquals((String)":b: Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)boundsInPixels, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        image = new Image((Device)this.display, this.imageFileNameProvider);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c: Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)boundsInPixels, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        image = new Image((Device)this.display, this.imageDataProvider);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)boundsInPixels, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
    }

    @Test
    public void test_getImageDataCurrentZoom() {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        image.dispose();
        try {
            image.getImageDataAtCurrentZoom();
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        }
        image = new Image((Device)this.display, bounds.width, bounds.height);
        ImageData imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        image.dispose();
        Rectangle boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        image.dispose();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        Assert.assertEquals((String)":b: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        image = new Image((Device)this.display, this.imageFileNameProvider);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
        image = new Image((Device)this.display, this.imageDataProvider);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)DPIUtil.autoScaleUp((Rectangle)bounds));
    }

    @Test
    public void test_getImageData() {
        this.getImageData1();
        this.getImageData2(24, new PaletteData(0xFF0000, 65280, 255));
        this.getImageData2(32, new PaletteData(0xFF0000, 65280, 255));
    }

    @Test
    public void test_getImageData_100() {
        this.getImageData_int(100);
    }

    @Test
    public void test_getImageData_200() {
        this.getImageData_int(200);
    }

    void getImageData_int(int zoom) {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        image.dispose();
        try {
            image.getImageData(zoom);
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        }
        image = new Image((Device)this.display, bounds.width, bounds.height);
        ImageData imageDataAtZoom = image.getImageData(zoom);
        image.dispose();
        Rectangle boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        imageDataAtZoom = image.getImageData(zoom);
        image.dispose();
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        Assert.assertEquals((String)":b: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, this.imageFileNameProvider);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, this.imageDataProvider);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
    }

    public static Rectangle scaleBounds(Rectangle rect, int targetZoom, int currentZoom) {
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        Rectangle returnRect = new Rectangle(0, 0, 0, 0);
        returnRect.x = Math.round((float)rect.x * scaleFactor);
        returnRect.y = Math.round((float)rect.y * scaleFactor);
        returnRect.width = Math.round((float)rect.width * scaleFactor);
        returnRect.height = Math.round((float)rect.height * scaleFactor);
        return returnRect;
    }

    @Test
    public void test_hashCode() {
        Image image = null;
        Image image1 = null;
        try {
            image1 = image = new Image((Device)this.display, 10, 10);
            Assert.assertEquals((String)":a:", (long)image1.hashCode(), (long)image.hashCode());
            ImageData imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            image.dispose();
            image = new Image((Device)this.display, imageData);
            image1 = new Image((Device)this.display, imageData);
            boolean equals = image1.hashCode() == image.hashCode();
            Assert.assertFalse((String)":b:", (boolean)equals);
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image = new Image((Device)this.display, this.imageFileNameProvider);
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertEquals((String)":c:", (long)image1.hashCode(), (long)image.hashCode());
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image = new Image((Device)this.display, this.imageDataProvider);
            image1 = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertEquals((String)":d:", (long)image1.hashCode(), (long)image.hashCode());
        }
        finally {
            image.dispose();
            image1.dispose();
        }
    }

    @Test
    public void test_isDisposed() {
        Image image = new Image((Device)this.display, 10, 10);
        Assert.assertFalse((String)":a:", (boolean)image.isDisposed());
        image.dispose();
        Assert.assertTrue((String)":b:", (boolean)image.isDisposed());
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color color;
        Image image;
        block19: {
            block17: {
                block15: {
                    if (SwtTestUtil.isGTK) {
                        if (SwtTestUtil.verbose) {
                            System.out.println("Excluded test_setBackgroundLorg_eclipse_swt_graphics_Color(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_Image)");
                        }
                        return;
                    }
                    image = new Image((Device)this.display, 10, 10);
                    try {
                        try {
                            image.setBackground(null);
                            Assert.fail((String)"No exception thrown for color == null");
                        }
                        catch (IllegalArgumentException e) {
                            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for color == null", 4, e);
                            image.dispose();
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        image.dispose();
                        throw throwable;
                    }
                    image.dispose();
                }
                image = new Image((Device)this.display, 10, 10);
                color = new Color((Device)this.display, 255, 255, 255);
                color.dispose();
                try {
                    try {
                        image.setBackground(color);
                        Assert.fail((String)"No exception thrown for disposed color");
                    }
                    catch (IllegalArgumentException e) {
                        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed color", 5, e);
                        image.dispose();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    image.dispose();
                    throw throwable;
                }
                image.dispose();
            }
            image = new Image((Device)this.display, 10, 10);
            image.dispose();
            color = new Color((Device)this.display, 255, 255, 255);
            try {
                try {
                    image.setBackground(color);
                    Assert.fail((String)"No exception thrown for disposed image");
                }
                catch (SWTException e) {
                    SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
                    color.dispose();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                color.dispose();
                throw throwable;
            }
            color.dispose();
        }
        image = new Image((Device)this.display, 10, 10);
        image.setBackground(this.display.getSystemColor(5));
        color = image.getBackground();
        Assert.assertNull((String)"background color should be null for non-transparent image", (Object)color);
        image.dispose();
        ImageData imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)}));
        imageData.transparentPixel = 0;
        image = new Image((Device)this.display, imageData);
        image.setBackground(this.display.getSystemColor(5));
        color = image.getBackground();
        Assert.assertEquals((String)"background color should have been set to green", (Object)this.display.getSystemColor(5), (Object)color);
        image.dispose();
    }

    @Test
    public void test_toString() {
        Image image = new Image((Device)this.display, 10, 10);
        try {
            Assert.assertNotNull((Object)image.toString());
            Assert.assertTrue((image.toString().length() > 0 ? 1 : 0) != 0);
        }
        finally {
            image.dispose();
        }
    }

    void getImageData1() {
        int numFormats = SwtTestUtil.imageFormats.length;
        String fileName = SwtTestUtil.imageFilenames[0];
        int i = 0;
        while (i < numFormats) {
            String format = SwtTestUtil.imageFormats[i];
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream stream = SwtTestUtil.class.getResourceAsStream(String.valueOf(fileName) + "." + format);){
                    ImageData data1 = new ImageData(stream);
                    Image image = new Image((Device)this.display, data1);
                    ImageData data2 = image.getImageData();
                    image.dispose();
                    Assert.assertEquals((String)"Image width should be the same", (long)data1.width, (long)data2.width);
                    Assert.assertEquals((String)"Image height should be the same", (long)data1.height, (long)data2.height);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    void getImageData2(int depth, PaletteData palette) {
        int width = 10;
        int height = 10;
        Color color = new Color((Device)this.display, 0, 255, 0);
        RGB colorRGB = color.getRGB();
        ImageData imageData = new ImageData(width, height, depth, palette);
        Image image = new Image((Device)this.display, imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(color);
        gc.fillRectangle(0, 0, 10, 10);
        ImageData newData = image.getImageData();
        PaletteData newPalette = newData.palette;
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int pixel = newData.getPixel(i, j);
                RGB rgb = newPalette.getRGB(pixel);
                Assert.assertTrue((String)"rgb.equals(colorRGB)", (boolean)rgb.equals((Object)colorRGB));
                ++j;
            }
            ++i;
        }
        color.dispose();
        gc.dispose();
        image.dispose();
    }

    String getPath(String fileName) {
        String urlPath;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (pluginPath == null) {
            URL url = this.getClass().getClassLoader().getResource(fileName);
            if (url == null) {
                Assert.fail((String)("URL == null for file " + fileName));
            }
            urlPath = url.getFile();
        } else {
            urlPath = String.valueOf(pluginPath) + "/data/" + fileName;
        }
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace('/', File.separatorChar);
        }
        if (SwtTestUtil.isWindows && urlPath.indexOf(File.separatorChar) == 0) {
            urlPath = urlPath.substring(1);
        }
        urlPath = urlPath.replaceAll("%20", " ");
        return urlPath;
    }

    RGB getRealRGB(Color color) {
        Image colorImage = new Image((Device)this.display, 10, 10);
        GC imageGc = new GC((Drawable)colorImage);
        imageGc.setBackground(color);
        imageGc.setForeground(color);
        imageGc.fillRectangle(0, 0, 10, 10);
        ImageData imageData = colorImage.getImageData();
        PaletteData palette = imageData.palette;
        imageGc.dispose();
        colorImage.dispose();
        int pixel = imageData.getPixel(0, 0);
        return palette.getRGB(pixel);
    }
}

