/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_ImageData {
    ImageData imageData;
    final int IMAGE_DIMENSION = 10;

    @Before
    public void setUp() {
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
    }

    @Test
    public void test_ConstructorIIILorg_eclipse_swt_graphics_PaletteData() {
        try {
            new ImageData(-1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            Assert.fail((String)"No exception thrown for width < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, -1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            byte[] byArray = new byte[4];
            byArray[1] = 79;
            byArray[2] = 79;
            new ImageData(1, 1, 1, null, 0, byArray);
            Assert.fail((String)"No exception thrown for paletteData == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 3, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            Assert.fail((String)"No exception thrown for unsupported depth");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] validDepths = new int[]{1, 2, 4, 8, 16, 24, 32};
        int i = 0;
        while (i < validDepths.length) {
            new ImageData(1, 1, validDepths[i], new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            ++i;
        }
    }

    @Test
    public void test_ConstructorIIILorg_eclipse_swt_graphics_PaletteDataI$B() {
        byte[] byArray = new byte[4];
        byArray[1] = 79;
        byArray[2] = 79;
        byte[] validData = byArray;
        try {
            new ImageData(-1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
            Assert.fail((String)"No exception thrown for width < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, -1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 1, null, 0, validData);
            Assert.fail((String)"No exception thrown for paletteData == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, null);
            Assert.fail((String)"No exception thrown for data == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[0]);
            Assert.fail((String)"No exception thrown for data array too small");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 16, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79});
            Assert.fail((String)"No exception thrown for data array too small");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 32, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79, 79});
            Assert.fail((String)"No exception thrown for data array too small");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(2, 2, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79, 79, 79});
            Assert.fail((String)"No exception thrown for data array too small");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new ImageData(1, 1, 3, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
            Assert.fail((String)"No exception thrown for unsupported depth");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] validDepths = new int[]{1, 2, 4, 8, 16, 24, 32};
        int i = 0;
        while (i < validDepths.length) {
            new ImageData(1, 1, validDepths[i], new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
            ++i;
        }
        try {
            new ImageData(1, 1, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 0, validData);
            Assert.fail((String)"No exception thrown for scanlinePad == 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLjava_io_InputStream() {
        InputStream stream;
        Object var2_5;
        Throwable throwable;
        try {
            throwable = null;
            var2_5 = null;
            try {
                stream = null;
                try {
                    new ImageData(stream);
                    Assert.fail((String)"No exception thrown for InputStream == null");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException exception) {}
        try {
            throwable = null;
            var2_5 = null;
            try {
                stream = SwtTestUtil.class.getResourceAsStream("empty.txt");
                try {
                    new ImageData(stream);
                    Assert.fail((String)"No exception thrown for invalid InputStream");
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | SWTException throwable4) {}
        int numFormats = SwtTestUtil.imageFormats.length;
        String fileName = SwtTestUtil.imageFilenames[0];
        int i = 0;
        while (i < numFormats) {
            String format = SwtTestUtil.imageFormats[i];
            try {
                Throwable throwable5 = null;
                Object var6_13 = null;
                try (InputStream stream2 = SwtTestUtil.class.getResourceAsStream(String.valueOf(fileName) + "." + format);){
                    new ImageData(stream2);
                }
                catch (Throwable throwable6) {
                    if (throwable5 == null) {
                        throwable5 = throwable6;
                    } else if (throwable5 != throwable6) {
                        throwable5.addSuppressed(throwable6);
                    }
                    throw throwable5;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    @Test
    public void test_ConstructorLjava_lang_String() {
        String filename = null;
        try {
            new ImageData(filename);
            Assert.fail((String)"No exception thrown for filename == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_clone() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream stream = SwtTestUtil.class.getResourceAsStream(String.valueOf(SwtTestUtil.imageFilenames[0]) + "." + SwtTestUtil.imageFormats[0]);){
                ImageData data1 = new ImageData(stream);
                ImageData data2 = (ImageData)data1.clone();
                Assert.assertEquals((String)":a:", (long)data1.alpha, (long)data2.alpha);
                Assert.assertArrayEquals((String)":b:", (byte[])data1.alphaData, (byte[])data2.alphaData);
                Assert.assertEquals((String)":c:", (long)data1.bytesPerLine, (long)data2.bytesPerLine);
                Assert.assertArrayEquals((String)":d:", (byte[])data1.data, (byte[])data2.data);
                Assert.assertEquals((String)":e:", (long)data1.delayTime, (long)data2.delayTime);
                Assert.assertEquals((String)":f:", (long)data1.depth, (long)data2.depth);
                Assert.assertEquals((String)":g:", (long)data1.disposalMethod, (long)data2.disposalMethod);
                Assert.assertEquals((String)":h:", (long)data1.height, (long)data2.height);
                Assert.assertArrayEquals((String)":i:", (byte[])data1.maskData, (byte[])data2.maskData);
                Assert.assertEquals((String)":j:", (long)data1.maskPad, (long)data2.maskPad);
                Assert.assertEquals((String)":k:", (Object)data1.palette, (Object)data2.palette);
                Assert.assertEquals((String)":l:", (long)data1.scanlinePad, (long)data2.scanlinePad);
                Assert.assertEquals((String)":m:", (long)data1.transparentPixel, (long)data2.transparentPixel);
                Assert.assertEquals((String)":n:", (long)data1.type, (long)data2.type);
                Assert.assertEquals((String)":o:", (long)data1.width, (long)data2.width);
                Assert.assertEquals((String)":p:", (long)data1.x, (long)data2.x);
                Assert.assertEquals((String)":q:", (long)data1.y, (long)data2.y);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    @Test
    public void test_getAlphaII() {
        Assert.assertEquals((String)":a:", (long)255L, (long)this.imageData.getAlpha(0, 0));
        int value = 170;
        this.imageData.setAlpha(0, 0, value);
        Assert.assertEquals((String)":b:", (long)value, (long)this.imageData.getAlpha(0, 0));
        try {
            this.imageData.getAlpha(-1, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getAlpha(10, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getAlpha(0, -1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getAlpha(0, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
    }

    @Test
    public void test_getAlphasIII$BI() {
        byte[] alphaData = new byte[20];
        this.imageData.getAlphas(0, 1, 10, alphaData, 10);
        int i = 0;
        while (i < alphaData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":a:", (long)0L, (long)alphaData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)-1L, (long)alphaData[i]);
            }
            ++i;
        }
        byte value = -86;
        byte[] values = new byte[]{value, (byte)(value + 1), (byte)(value + 2), (byte)(value + 3), (byte)(value + 4)};
        this.imageData.setAlphas(0, 1, values.length, values, 0);
        this.imageData.getAlphas(0, 1, 10, alphaData, 10);
        int i2 = 0;
        while (i2 < alphaData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":c:", (long)0L, (long)alphaData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":d:", (long)values[i2 - 10], (long)alphaData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":e:", (long)0L, (long)alphaData[i2]);
            }
            ++i2;
        }
        try {
            this.imageData.getAlphas(0, 1, 100, alphaData, 10);
            Assert.fail((String)"No exception thrown for getWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.getAlphas(0, 1, 10, null, 10);
            Assert.fail((String)"No exception thrown for alphas == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for alphas == null", 4, e);
        }
        try {
            this.imageData.getAlphas(-1, 1, 10, alphaData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getAlphas(10, 1, 10, alphaData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getAlphas(0, -1, 10, alphaData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getAlphas(0, 10, 10, alphaData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getAlphas(0, 1, -1, alphaData, 10);
            Assert.fail((String)"No exception thrown for getWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, e);
        }
    }

    @Test
    public void test_getPixelII() {
        Assert.assertEquals((String)":a:", (long)0L, (long)this.imageData.getPixel(0, 0));
        int value = 170;
        this.imageData.setPixel(0, 0, value);
        Assert.assertEquals((String)":b:", (long)value, (long)this.imageData.getPixel(0, 0));
        try {
            this.imageData.getPixel(-1, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixel(10, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixel(0, -1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getPixel(0, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        int width = 3;
        int height = 3;
        int depth = 4;
        int pixelValue = 1;
        byte[] data = new byte[]{(byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4), (byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4), (byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4)};
        this.imageData = new ImageData(width, height, depth, new PaletteData(new RGB[]{new RGB(0, 0, 255), new RGB(111, 111, 111)}), 1, data);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = this.imageData.getPixel(x, y);
                Assert.assertEquals((String)"Bad pixel data", (long)pixelValue, (long)pixel);
                ++x;
            }
            ++y;
        }
    }

    @Test
    public void test_getPixelsIII$BI() {
        byte[] pixelData = new byte[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i = 0;
        while (i < pixelData.length) {
            Assert.assertEquals((String)":a:", (long)0L, (long)pixelData[i]);
            ++i;
        }
        byte[] values = new byte[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":c:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":e:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new byte[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":g:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":i:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new byte[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":k:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":m:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new byte[]{1, 2, 3, 15, -1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":o:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":p:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        try {
            this.imageData.getPixels(0, 1, 100, pixelData, 10);
            Assert.fail((String)"No exception thrown for getWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.getPixels(0, 1, 10, null, 10);
            Assert.fail((String)"No exception thrown for pixels == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, e);
        }
        try {
            this.imageData.getPixels(-1, 1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(10, 1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, -1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, 10, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, 1, -1, pixelData, 10);
            Assert.fail((String)"No exception thrown for getWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, e);
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
        try {
            this.imageData.getPixels(0, 1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for invalid depth");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid depth", 38, e);
        }
    }

    @Test
    public void test_getPixelsIII$II() {
        int[] pixelData = new int[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i = 0;
        while (i < pixelData.length) {
            Assert.assertEquals((String)":a:", (long)0L, (long)pixelData[i]);
            ++i;
        }
        int[] values = new int[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":c:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":e:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new int[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":g:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":i:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new int[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":k:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":m:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        values = new int[]{1, 2, 3, 15, 255};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":o:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":p:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 16, new PaletteData(63488, 2016, 31));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":q:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 15;
        nArray[3] = 255;
        nArray[4] = 65450;
        values = nArray;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":r:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":s:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":t:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 24, new PaletteData(0xFF0000, 65280, 255));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":u:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        int[] nArray2 = new int[4];
        nArray2[1] = 255;
        nArray2[2] = 65450;
        nArray2[3] = 0xFF00AA;
        values = nArray2;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":v:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":w:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":x:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(-16777216, 65280, 255));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            Assert.assertEquals((String)":y:", (long)0L, (long)pixelData[i2]);
            ++i2;
        }
        int[] nArray3 = new int[4];
        nArray3[1] = 255;
        nArray3[2] = 65450;
        nArray3[3] = -16733696;
        values = nArray3;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i2 = 0;
        while (i2 < pixelData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":z:", (long)0L, (long)pixelData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":aa:", (long)values[i2 - 10], (long)pixelData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":ab:", (long)0L, (long)pixelData[i2]);
            }
            ++i2;
        }
        try {
            this.imageData.getPixels(0, 1, 100, pixelData, 10);
            Assert.fail((String)"No exception thrown for getWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.getPixels(0, 1, 10, null, 10);
            Assert.fail((String)"No exception thrown for pixels == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, e);
        }
        try {
            this.imageData.getPixels(-1, 1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(10, 1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, -1, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, 10, 10, pixelData, 10);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.getPixels(0, 1, -1, pixelData, 10);
            Assert.fail((String)"No exception thrown for getWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, e);
        }
    }

    @Test
    public void test_getRGBs() {
        Assert.assertNull((String)":a:", (Object)this.imageData.getRGBs());
        Object[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        this.imageData = new ImageData(10, 10, 8, new PaletteData((RGB[])rgbs));
        Assert.assertArrayEquals((String)":b:", (Object[])rgbs, (Object[])this.imageData.getRGBs());
    }

    @Test
    public void test_getTransparencyMask() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream stream = this.getClass().getResourceAsStream(SwtTestUtil.transparentImageFilenames[0]);){
                Image image = new Image((Device)Display.getDefault(), stream);
                this.imageData = image.getImageData();
                ImageData maskData = this.imageData.getTransparencyMask();
                Assert.assertNotNull((String)":b:", (Object)maskData);
                image.dispose();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    @Test
    public void test_getTransparencyType() {
        Image image;
        InputStream stream;
        Object var2_4;
        Throwable throwable;
        Assert.assertEquals((String)":a:", (long)0L, (long)this.imageData.getTransparencyType());
        try {
            throwable = null;
            var2_4 = null;
            try {
                stream = this.getClass().getResourceAsStream(SwtTestUtil.transparentImageFilenames[0]);
                try {
                    image = new Image((Device)Display.getDefault(), stream);
                    this.imageData = image.getImageData();
                    Assert.assertFalse((String)":b:", (this.imageData.getTransparencyType() == 0 ? 1 : 0) != 0);
                    image.dispose();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        try {
            throwable = null;
            var2_4 = null;
            try {
                stream = this.getClass().getResourceAsStream(String.valueOf(SwtTestUtil.imageFilenames[0]) + '.' + SwtTestUtil.imageFormats[SwtTestUtil.imageFormats.length - 1]);
                try {
                    image = new Image((Device)Display.getDefault(), stream);
                    this.imageData = image.getImageData();
                    Assert.assertEquals((String)":c:", (long)0L, (long)this.imageData.getTransparencyType());
                    image.dispose();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    @Test
    public void test_scaledToII() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        byte[] pixelData = new byte[8];
        pixelData[0] = 79;
        this.imageData = new ImageData(8, 8, 1, new PaletteData(rgbs), 1, pixelData);
        ImageData scaledImageData = this.imageData.scaledTo(-8, -8);
        byte[] scaledPixelData = new byte[8];
        scaledImageData.getPixels(0, 7, scaledPixelData.length, scaledPixelData, 0);
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[6] = 1;
        byte[] expectedPixelData = byArray;
        Assert.assertArrayEquals((String)":a:", (byte[])expectedPixelData, (byte[])scaledPixelData);
        scaledImageData = this.imageData.scaledTo(80, 8);
        scaledPixelData = new byte[80];
        scaledImageData.getPixels(0, 0, scaledPixelData.length, scaledPixelData, 0);
        Assert.assertEquals((String)":b:", (long)0L, (long)scaledPixelData[0]);
        Assert.assertEquals((String)":c:", (long)0L, (long)scaledPixelData[1]);
        scaledImageData = this.imageData.scaledTo(8, 80);
        scaledPixelData = new byte[8];
        scaledImageData.getPixels(0, 0, scaledPixelData.length, scaledPixelData, 0);
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArray2[6] = 1;
        byArray2[7] = 1;
        expectedPixelData = byArray2;
        Assert.assertArrayEquals((String)":d:", (byte[])expectedPixelData, (byte[])scaledPixelData);
    }

    @Test
    public void test_setAlphaIII() {
        int value = 170;
        this.imageData.setAlpha(0, 0, value);
        Assert.assertEquals((String)":a:", (long)value, (long)this.imageData.getAlpha(0, 0));
        try {
            this.imageData.setAlpha(-1, 1, value);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setAlpha(10, 1, value);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setAlpha(0, -1, value);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setAlpha(0, 10, value);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
    }

    @Test
    public void test_setAlphasIII$BI() {
        byte[] alphaData = new byte[20];
        byte value = -86;
        byte[] values = new byte[]{value, (byte)(value + 1), (byte)(value + 2), (byte)(value + 3), (byte)(value + 4)};
        this.imageData.setAlphas(0, 1, values.length - 1, values, 1);
        this.imageData.getAlphas(0, 1, 10, alphaData, 0);
        int i = 0;
        while (i < alphaData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)alphaData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)alphaData[i]);
            }
            ++i;
        }
        try {
            this.imageData.setAlphas(0, 1, 100, alphaData, 1);
            Assert.fail((String)"No exception thrown for putWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.setAlphas(0, 1, 10, null, 1);
            Assert.fail((String)"No exception thrown for alphas == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for alphas == null", 4, e);
        }
        try {
            this.imageData.setAlphas(-1, 1, 10, alphaData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setAlphas(10, 1, 10, alphaData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setAlphas(0, -1, 10, alphaData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setAlphas(0, 10, 10, alphaData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setAlphas(0, 1, -1, alphaData, 1);
            Assert.fail((String)"No exception thrown for putWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, e);
        }
    }

    @Test
    public void test_setPixelIII() {
        int value = 170;
        this.imageData.setPixel(0, 0, value);
        Assert.assertEquals((String)":a:", (long)value, (long)this.imageData.getPixel(0, 0));
        try {
            this.imageData.setPixel(-1, 1, value);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixel(10, 1, value);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixel(0, -1, value);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setPixel(0, 10, value);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
    }

    @Test
    public void test_setPixelsIII$BI() {
        byte[] pixelData = new byte[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        byte[] values = new byte[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        int i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":c:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":e:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 15, -1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":g:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        try {
            this.imageData.setPixels(0, 1, 100, pixelData, 1);
            Assert.fail((String)"No exception thrown for putWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.setPixels(0, 1, 10, null, 1);
            Assert.fail((String)"No exception thrown for pixels == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, e);
        }
        try {
            this.imageData.setPixels(-1, 1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(10, 1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, -1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, 10, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, 1, -1, pixelData, 1);
            Assert.fail((String)"No exception thrown for putWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, e);
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
        try {
            this.imageData.setPixels(0, 1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for invalid depth");
        }
        catch (SWTException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid depth", 38, e);
        }
    }

    @Test
    public void test_setPixelsIII$II() {
        int[] pixelData = new int[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        int[] values = new int[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        int i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":c:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":e:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 15, 255};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":g:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 16, new PaletteData(63488, 2016, 31));
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 15;
        nArray[3] = 255;
        nArray[4] = 65450;
        values = nArray;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":i:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 24, new PaletteData(0xFF0000, 65280, 255));
        int[] nArray2 = new int[4];
        nArray2[1] = 255;
        nArray2[2] = 65450;
        nArray2[3] = 0xFF00AA;
        values = nArray2;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":k:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(-16777216, 65280, 255));
        int[] nArray3 = new int[4];
        nArray3[1] = 255;
        nArray3[2] = 65450;
        nArray3[3] = -16733696;
        values = nArray3;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":m:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        try {
            this.imageData.setPixels(0, 1, 100, pixelData, 1);
            Assert.fail((String)"No exception thrown for putWidth out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            this.imageData.setPixels(0, 1, 10, null, 1);
            Assert.fail((String)"No exception thrown for pixels == null");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, e);
        }
        try {
            this.imageData.setPixels(-1, 1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(10, 1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for x out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, -1, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, 10, 10, pixelData, 1);
            Assert.fail((String)"No exception thrown for y out of bounds");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, e);
        }
        try {
            this.imageData.setPixels(0, 1, -1, pixelData, 1);
            Assert.fail((String)"No exception thrown for putWidth < 0");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, e);
        }
    }
}

