/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_PaletteData {
    @Test
    public void test_Constructor$Lorg_eclipse_swt_graphics_RGB() {
        try {
            new PaletteData(null);
            Assert.fail((String)"No exception thrown for rgb == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        PaletteData data = new PaletteData(new RGB[0]);
        Assert.assertFalse((String)":a:", (boolean)data.isDirect);
        new PaletteData(new RGB[2]);
        Assert.assertFalse((String)":b:", (boolean)data.isDirect);
        new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        Assert.assertFalse((String)":c:", (boolean)data.isDirect);
    }

    @Test
    public void test_ConstructorIII() {
        PaletteData data = new PaletteData(0, 0, 0);
        Assert.assertTrue((String)":a:", (boolean)data.isDirect);
        data = new PaletteData(-1, -1, -1);
        Assert.assertTrue((String)":b:", (boolean)data.isDirect);
        data = new PaletteData(0xFF0000, 65280, 255);
        Assert.assertTrue((String)":c:", (boolean)data.isDirect);
    }

    @Test
    public void test_getPixelLorg_eclipse_swt_graphics_RGB() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)};
        PaletteData data = new PaletteData(rgbs);
        try {
            data.getPixel(null);
            Assert.fail((String)"No exception thrown for indexed palette with rgb == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            data.getPixel(new RGB(0, 0, 1));
            Assert.fail((String)"No exception thrown for rgb not found");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((String)":a:", (long)(rgbs.length - 1), (long)data.getPixel(rgbs[rgbs.length - 1]));
        RGB rgb = new RGB(50, 100, 150);
        data = new PaletteData(0xFF0000, 65280, 255);
        try {
            data.getPixel(null);
            Assert.fail((String)"No exception thrown for direct palette with rgb == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((String)":b:", (long)3302550L, (long)data.getPixel(rgb));
    }

    @Test
    public void test_getRGBI() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)};
        PaletteData data = new PaletteData(rgbs);
        try {
            data.getRGB(rgbs.length);
            Assert.fail((String)"No exception thrown for nonexistent pixel");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((String)":a:", (Object)rgbs[rgbs.length - 1], (Object)data.getRGB(rgbs.length - 1));
        RGB rgb = new RGB(50, 100, 150);
        data = new PaletteData(0xFF0000, 65280, 255);
        Assert.assertEquals((String)":b:", (Object)rgb, (Object)data.getRGB(3302550));
    }

    @Test
    public void test_getRGBs() {
        Object[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        PaletteData data = new PaletteData((RGB[])rgbs);
        Assert.assertArrayEquals((String)":a:", (Object[])rgbs, (Object[])data.getRGBs());
        data = new PaletteData(0xFF0000, 65280, 255);
        Assert.assertNull((String)":b:", (Object)data.getRGBs());
    }
}

