/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_printing_Printer {
    @Test
    public void test_Constructor() {
        boolean exceptionThrown = false;
        String detail = "";
        if (Printer.getDefaultPrinterData() == null) {
            block6: {
                try {
                    Printer printer = new Printer();
                    printer.dispose();
                }
                catch (SWTError ex) {
                    if (ex.code != 2) break block6;
                    exceptionThrown = true;
                }
            }
            Assert.assertTrue((String)"ERROR_NO_HANDLES not thrown", (boolean)exceptionThrown);
        } else {
            try {
                Printer printer = new Printer();
                printer.dispose();
            }
            catch (Throwable ex) {
                exceptionThrown = true;
                detail = ex.getMessage();
            }
            Assert.assertFalse((String)("Exception thrown: " + detail), (boolean)exceptionThrown);
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_printing_PrinterData() {
        boolean exceptionThrown = false;
        String detail = "";
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            block6: {
                try {
                    Printer printer = new Printer(data);
                    printer.dispose();
                }
                catch (SWTError ex) {
                    if (ex.code != 2) break block6;
                    exceptionThrown = true;
                }
            }
            Assert.assertTrue((String)"ERROR_NO_HANDLES not thrown", (boolean)exceptionThrown);
        } else {
            try {
                Printer printer = new Printer(data);
                printer.dispose();
            }
            catch (Throwable ex) {
                exceptionThrown = true;
                detail = ex.getMessage();
            }
            Assert.assertFalse((String)("Exception thrown: " + detail), (boolean)exceptionThrown);
        }
    }

    @Test
    public void test_computeTrimIIII() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        Rectangle trim = printer.computeTrim(0, 0, 10, 10);
        Assert.assertTrue((String)"trim width or height is incorrect", (trim.width >= 10 && trim.height >= 10 ? 1 : 0) != 0);
        printer.dispose();
    }

    @Test
    public void test_getBounds() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        Rectangle bounds = printer.getBounds();
        Assert.assertTrue((String)"bounds width or height is zero", (bounds.width > 0 && bounds.height > 0 ? 1 : 0) != 0);
        printer.dispose();
    }

    @Test
    public void test_getClientArea() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        Rectangle clientArea = printer.getClientArea();
        Assert.assertTrue((String)"clientArea width or height is zero", (clientArea.width > 0 && clientArea.height > 0 ? 1 : 0) != 0);
        printer.dispose();
    }

    @Test
    public void test_getDPI() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        Point dpi = printer.getDPI();
        Assert.assertTrue((String)"dpi x or y is zero", (dpi.x > 0 && dpi.y > 0 ? 1 : 0) != 0);
        printer.dispose();
    }

    @Test
    public void test_getPrinterData() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        Assert.assertTrue((String)"getPrinterData != data used in constructor", (data == printer.getPrinterData() ? 1 : 0) != 0);
        printer.dispose();
    }

    @Test
    public void test_getPrinterList() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            PrinterData[] list = Printer.getPrinterList();
            if (list.length == 1) {
                if (SWT.getPlatform().equals("gtk")) {
                    Assert.assertTrue((boolean)list[0].driver.equals("GtkPrintBackendFile"));
                }
            } else {
                Assert.assertTrue((String)"printer list contains items even though there are no printers", (list.length == 0 ? 1 : 0) != 0);
            }
        } else {
            PrinterData[] list = Printer.getPrinterList();
            Assert.assertTrue((String)"printer list is empty", (list.length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_isAutoScalable() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            return;
        }
        Printer printer = new Printer(data);
        boolean isAutoScalable = printer.isAutoScalable();
        Assert.assertFalse((String)"SWT doesnot auto-scale for Printer devices", (boolean)isAutoScalable);
        printer.dispose();
    }
}

