/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.HashSet;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_program_Program {
    @Before
    public void setUp() {
        Display.getDefault();
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Program program = Program.findProgram((String)extensions[i]);
                if (program != null) {
                    Assert.assertTrue((boolean)program.equals((Object)program));
                }
                ++i;
            }
        }
    }

    @Test
    public void test_executeLjava_lang_String() {
        try {
            Program[] programs = Program.getPrograms();
            if (programs != null && programs.length > 0) {
                programs[0].execute(null);
                Assert.fail((String)"Failed to throw ERROR_NULL_ARGUMENT");
            }
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
        }
    }

    @Test
    public void test_findProgramLjava_lang_String() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Program.findProgram((String)extensions[i]);
                ++i;
            }
        }
        try {
            Program.findProgram(null);
            Assert.fail((String)"Failed to throw ERROR_NULL_ARGUMENT");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
        }
        catch (Exception e) {
            Assert.fail((String)("Invalid Exception thrown of type " + e.getClass()));
        }
        catch (Error e) {
            Assert.fail((String)("Invalid Error thrown of type " + e.getClass()));
        }
    }

    @Test
    public void test_getExtensions() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Assert.assertNotNull((Object)extensions[i]);
                ++i;
            }
        }
    }

    @Test
    public void test_getImageData() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Program program = Program.findProgram((String)extensions[i]);
                if (program != null) {
                    program.getImageData();
                }
                ++i;
            }
        }
    }

    @Test
    public void test_getName() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Program program = Program.findProgram((String)extensions[i]);
                if (program != null) {
                    String name = program.getName();
                    Assert.assertNotNull((String)"Program has null name", (Object)name);
                }
                ++i;
            }
        }
    }

    @Test
    public void test_getPrograms() {
        Program[] programs = Program.getPrograms();
        Assert.assertNotNull((Object)programs);
        HashSet<Program> lookup = new HashSet<Program>();
        Program[] programArray = programs;
        int n = programs.length;
        int n2 = 0;
        while (n2 < n) {
            Program program = programArray[n2];
            Assert.assertNotNull((Object)program);
            if (lookup.contains(program)) {
                Assert.fail((String)("Duplicated list entry for " + program));
            } else {
                lookup.add(program);
            }
            ++n2;
        }
    }

    @Test
    public void test_launchLjava_lang_String() {
        try {
            Program.launch(null);
            Assert.fail((String)"Failed to throw ERROR_NULL_ARGUMENT");
        }
        catch (IllegalArgumentException e) {
            SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
        }
    }

    @Test
    public void test_toString() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                Program program = Program.findProgram((String)extensions[i]);
                if (program != null) {
                    String string = program.toString();
                    Assert.assertNotNull((String)"toString returned null", (Object)string);
                }
                ++i;
            }
        }
    }
}

