/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Combo
extends Test_org_eclipse_swt_widgets_Composite {
    Combo combo;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.combo = new Combo((Composite)this.shell, 0);
        this.setWidget((Widget)this.combo);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            this.combo = new Combo(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] cases = new int[]{4, 64};
        int i = 0;
        while (i < cases.length) {
            this.combo = new Combo((Composite)this.shell, cases[i]);
            Assert.assertTrue((String)(":a:" + String.valueOf(i)), ((this.combo.getStyle() & cases[i]) == cases[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void test_addLjava_lang_String() {
        try {
            this.combo.add(null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.add("");
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{""}, (Object[])this.combo.getItems());
        this.combo.add("");
        Assert.assertArrayEquals((String)":b:", (Object[])new String[]{"", ""}, (Object[])this.combo.getItems());
        this.combo.add("fred");
        Assert.assertArrayEquals((String)":c:", (Object[])new String[]{"", "", "fred"}, (Object[])this.combo.getItems());
    }

    @Test
    public void test_addLjava_lang_StringI() {
        try {
            this.combo.add(null, 0);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.add("string", -1);
            Assert.fail((String)"No exception thrown for index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.add("string0", 0);
        try {
            this.combo.add("string1", 2);
            Assert.fail((String)"No exception thrown for index > size");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.removeAll();
        this.combo.add("fred", 0);
        Assert.assertArrayEquals((String)"fred", (Object[])new String[]{"fred"}, (Object[])this.combo.getItems());
        this.combo.add("fred", 0);
        Assert.assertArrayEquals((String)"fred fred", (Object[])new String[]{"fred", "fred"}, (Object[])this.combo.getItems());
        this.combo.add("fred");
        Assert.assertArrayEquals((String)"fred fred fred", (Object[])new String[]{"fred", "fred", "fred"}, (Object[])this.combo.getItems());
        this.combo.removeAll();
        int number = 3;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.add("fred", number);
        Assert.assertArrayEquals((String)"fred0 fred1 fred2 fred", (Object[])new String[]{"fred0", "fred1", "fred2", "fred"}, (Object[])this.combo.getItems());
        this.combo.removeAll();
        number = 3;
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.add("fred", 1);
        Assert.assertArrayEquals((String)"fred0 fred fred1 fred2", (Object[])new String[]{"fred0", "fred", "fred1", "fred2"}, (Object[])this.combo.getItems());
        this.combo.add("fred", 0);
        Assert.assertArrayEquals((String)"fred fred0 fred fred1 fred2", (Object[])new String[]{"fred", "fred0", "fred", "fred1", "fred2"}, (Object[])this.combo.getItems());
        this.combo.add("fred", 4);
        Assert.assertArrayEquals((String)"fred fred0 fred fred1 fred fred2", (Object[])new String[]{"fred", "fred0", "fred", "fred1", "fred", "fred2"}, (Object[])this.combo.getItems());
    }

    @Test
    public void test_addModifyListenerLorg_eclipse_swt_events_ModifyListener() {
        boolean exceptionThrown = false;
        ModifyListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.combo.addModifyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.combo.addModifyListener(listener);
        this.listenerCalled = false;
        this.combo.setText("new text");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded few test scenarios in test_addModifyListenerLorg_eclipse_swt_events_ModifyListener(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
        } else {
            this.combo.removeAll();
            this.combo.add("one");
            this.combo.select(0);
            this.listenerCalled = false;
            this.combo.remove(0);
            Assert.assertTrue((String)"remove(int index) for last item:", (boolean)this.listenerCalled);
            this.combo.removeAll();
            this.combo.add("one");
            this.combo.add("two");
            this.combo.select(0);
            this.listenerCalled = false;
            this.combo.remove(0, 1);
            Assert.assertTrue((String)"remove(int start, int end) for all items:", (boolean)this.listenerCalled);
        }
        this.listenerCalled = false;
        this.combo.removeModifyListener(listener);
        this.combo.setText("line");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
        try {
            this.combo.removeModifyListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        boolean exceptionThrown = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_widgets_Combo.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        try {
            this.combo.addSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.combo.addSelectionListener(listener);
        this.combo.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.combo.removeSelectionListener(listener);
        try {
            this.combo.removeSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.combo.addSelectionListener(listener);
        this.combo.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.combo.removeSelectionListener(listener);
        this.listenerCalled = false;
        this.combo.select(0);
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_clearSelection() {
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.clearSelection();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getSelection().equals((Object)new Point(0, 0)));
        this.combo.setSelection(new Point(0, 5));
        Assert.assertTrue((String)":b:", (boolean)this.combo.getSelection().equals((Object)new Point(0, 0)));
        this.combo.setText("some text");
        this.combo.setSelection(new Point(0, 5));
        Assert.assertTrue((String)":c:", (boolean)this.combo.getSelection().equals((Object)new Point(0, 5)));
        this.combo.clearSelection();
        Assert.assertTrue((String)":d:", (this.combo.getSelection().x == this.combo.getSelection().y ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_copy() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copy(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
            return;
        }
        this.combo.setText("123456");
        this.combo.setSelection(new Point(1, 3));
        this.combo.copy();
        this.combo.setSelection(new Point(0, 0));
        this.combo.paste();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getText().equals("23123456"));
    }

    @Test
    public void test_cut() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_cut(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
            return;
        }
        this.combo.setText("123456");
        this.combo.setSelection(new Point(1, 3));
        this.combo.cut();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getText().equals("1456"));
    }

    @Test
    public void test_deselectAll() {
        this.combo.add("123");
        this.combo.add("456");
        this.combo.add("789");
        this.combo.select(0);
        this.combo.select(2);
        this.combo.deselectAll();
        Assert.assertTrue((String)":a:", (this.combo.getSelectionIndex() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void test_deselectI() {
        String[] items = new String[]{"item0", "item1", "item2"};
        this.combo.setItems(items);
        this.combo.select(1);
        this.combo.deselect(10);
        Assert.assertEquals((long)1L, (long)this.combo.getSelectionIndex());
        this.combo.removeAll();
        this.combo.deselect(2);
        int number = 10;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.select(i);
            Assert.assertTrue((String)(":a:" + i), (this.combo.getSelectionIndex() == i ? 1 : 0) != 0);
            this.combo.deselect(i);
            Assert.assertTrue((String)(":b:" + i), (this.combo.getSelectionIndex() == -1 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Override
    @Test
    public void test_getChildren() {
    }

    @Test
    public void test_getItemCount() {
        int number = 10;
        int i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.combo.getItemCount() == i ? 1 : 0) != 0);
            this.combo.add("fred" + i);
            ++i;
        }
        Assert.assertTrue((String)":aa:", (this.combo.getItemCount() == number ? 1 : 0) != 0);
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":b:" + i), (this.combo.getItemCount() == number - i ? 1 : 0) != 0);
            this.combo.remove(0);
            ++i;
        }
        this.combo.removeAll();
        Assert.assertTrue((String)":c:", (this.combo.getItemCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getItemHeight() {
        this.combo.getItemHeight();
    }

    @Test
    public void test_getItemI() {
        try {
            this.combo.getItem(0);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int number = 10;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((boolean)this.combo.getItem(i).equals("fred" + i));
            ++i;
        }
    }

    @Test
    public void test_getItems() {
        this.combo.removeAll();
        this.combo.add("1");
        this.combo.add("2");
        this.combo.add("3");
        String[] items = this.combo.getItems();
        Assert.assertTrue((String)":a:", (items.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)":a:", (boolean)items[0].equals("1"));
        Assert.assertTrue((String)":a:", (boolean)items[1].equals("2"));
        Assert.assertTrue((String)":a:", (boolean)items[2].equals("3"));
    }

    @Test
    public void test_getOrientation() {
    }

    @Test
    public void test_getSelection() {
        this.combo.setText("123456");
        this.combo.setSelection(new Point(1, 3));
        this.combo.getSelection();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getSelection().equals((Object)new Point(1, 3)));
    }

    @Test
    public void test_getSelectionIndex() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getSelectionIndex(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo)");
            }
            return;
        }
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.combo.getSelectionIndex());
        i = 0;
        while (i < number) {
            this.combo.select(i);
            Assert.assertEquals((long)i, (long)this.combo.getSelectionIndex());
            ++i;
        }
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.combo.getSelectionIndex());
        i = 0;
        while (i < number) {
            this.combo.select(i);
            this.combo.deselect(i);
            Assert.assertEquals((long)-1L, (long)this.combo.getSelectionIndex());
            ++i;
        }
    }

    @Test
    public void test_getText() {
        String[] cases = new String[]{"", "fred", "fredfred"};
        int i = 0;
        while (i < cases.length) {
            this.combo.setText(cases[i]);
            Assert.assertTrue((String)(":a:" + String.valueOf(i)), (boolean)cases[i].equals(this.combo.getText()));
            ++i;
        }
    }

    @Test
    public void test_getTextHeight() {
        this.combo.getTextHeight();
    }

    @Test
    public void test_getTextLimit() {
        this.combo.setTextLimit(3);
        Assert.assertTrue((String)":a:", (this.combo.getTextLimit() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void test_hasFocus() {
    }

    @Test
    public void test_indexOfLjava_lang_String() {
        this.combo.add("string0");
        try {
            this.combo.indexOf(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)i, (long)this.combo.indexOf("fred" + i));
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)-1L, (long)this.combo.indexOf("fred" + i));
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.remove("fred3");
        i = 0;
        while (i < 3) {
            Assert.assertEquals((long)i, (long)this.combo.indexOf("fred" + i));
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.combo.indexOf("fred3"));
        i = 4;
        while (i < number) {
            Assert.assertEquals((long)(i - 1), (long)this.combo.indexOf("fred" + i));
            ++i;
        }
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.remove(2);
        i = 0;
        while (i < 2) {
            Assert.assertEquals((long)i, (long)this.combo.indexOf("fred" + i));
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.combo.indexOf("fred2"));
        i = 3;
        while (i < number) {
            Assert.assertEquals((long)(i - 1), (long)this.combo.indexOf("fred" + i));
            ++i;
        }
    }

    @Test
    public void test_indexOfLjava_lang_StringI() {
        this.combo.add("string0");
        try {
            this.combo.indexOf(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)-1L, (long)this.combo.indexOf("string0", -1));
        this.combo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.combo.indexOf("fred" + i, 0) == i ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":b:" + i), (this.combo.indexOf("fred" + i, i + 1) == -1 ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Assert.assertTrue((String)(":a:" + i), (this.combo.indexOf("fred" + i, 0) == i ? 1 : 0) != 0);
            ++i;
        }
        i = 3;
        while (i < number) {
            Assert.assertTrue((String)(":b:" + i), (this.combo.indexOf("fred" + i, 3) == i ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":b:" + i), (this.combo.indexOf("fred" + i, i) == i ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void test_paste() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_paste(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
            return;
        }
        this.combo.setText("123456");
        this.combo.setSelection(new Point(1, 3));
        this.combo.cut();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getText().equals("1456"));
        this.combo.paste();
        Assert.assertTrue((String)":a:", (boolean)this.combo.getText().equals("123456"));
    }

    @Test
    public void test_removeAll() {
        this.combo.add("1");
        this.combo.add("2");
        this.combo.removeAll();
        Assert.assertTrue((String)":a:", (this.combo.getItems().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_removeI() {
        try {
            this.combo.remove(0);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.remove(3);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.add("string0");
        try {
            this.combo.remove(-1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)"Wrong number of items", (long)(number - i), (long)this.combo.getItemCount());
            this.combo.remove(0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)"Wrong number of items", (long)(number - i), (long)this.combo.getItemCount());
            this.combo.remove(0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("index " + i), (long)(number - i), (long)this.combo.getItemCount());
            this.combo.select(0);
            Assert.assertEquals((String)("index " + i), (long)0L, (long)this.combo.getSelectionIndex());
            this.combo.remove(0);
            if (SwtTestUtil.isWindows || SwtTestUtil.isGTK) {
                Assert.assertEquals((String)("index " + i), (long)-1L, (long)this.combo.getSelectionIndex());
            } else if (i < number - 1) {
                Assert.assertEquals((String)("index " + i), (long)0L, (long)this.combo.getSelectionIndex());
            } else {
                Assert.assertEquals((String)("index " + i), (long)-1L, (long)this.combo.getSelectionIndex());
            }
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("index " + i), (long)(number - i), (long)this.combo.getItemCount());
            this.combo.remove(number - i - 1);
            ++i;
        }
    }

    @Test
    public void test_removeII() {
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        this.combo.remove(0, 4);
        Assert.assertEquals((long)0L, (long)this.combo.getItemCount());
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        this.combo.remove(0, 2);
        Assert.assertEquals((long)2L, (long)this.combo.getItemCount());
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        this.combo.remove(2, 4);
        Assert.assertEquals((long)2L, (long)this.combo.getItemCount());
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        this.combo.remove(3, 2);
        Assert.assertEquals((long)number, (long)this.combo.getItemCount());
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        try {
            this.combo.remove(2, 100);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.remove(-1, number - 1);
            Assert.fail((String)"No exception thrown for start index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded few test scenarios in test_removeII(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
        } else {
            this.combo.removeAll();
            this.combo.add("one");
            this.combo.select(0);
            this.combo.remove(0);
            Assert.assertEquals((Object)"", (Object)this.combo.getText());
            this.combo.removeAll();
            this.combo.add("one");
            this.combo.add("two");
            this.combo.select(0);
            this.combo.remove(0, 1);
            Assert.assertEquals((Object)"", (Object)this.combo.getText());
        }
    }

    @Test
    public void test_removeLjava_lang_String() {
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)(number - i), (long)this.combo.getItemCount());
            this.combo.remove("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)(number - i), (long)this.combo.getItemCount());
            this.combo.remove("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        try {
            this.combo.remove(null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.removeAll();
        i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        try {
            this.combo.remove("fred");
            Assert.fail((String)"No exception thrown for item not found");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)number, (long)this.combo.getItemCount());
    }

    @Test
    public void test_selectI() {
        this.combo.add("123");
        this.combo.add("456");
        this.combo.add("789");
        this.combo.select(1);
        Assert.assertTrue((String)":a:", (this.combo.getSelectionIndex() == 1 ? 1 : 0) != 0);
        this.combo.select(10);
        Assert.assertEquals((long)1L, (long)this.combo.getSelectionIndex());
    }

    @Test
    public void test_setBackgroundDropDownCombo() {
        Combo dropDown = new Combo((Composite)this.shell, 4);
        Color color = new Color((Device)dropDown.getDisplay(), 255, 0, 0);
        dropDown.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground for SWT.DROP_DOWN Combo", (Object)color, (Object)dropDown.getBackground());
        dropDown.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) for SWT.DROP_DOWN Combo", (!dropDown.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)dropDown.getDisplay(), 255, 0, 0, 0);
        dropDown.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground with 0 alpha for SWT.DROP_DOWN Combo", (Object)color, (Object)dropDown.getBackground());
        dropDown.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) with 0 alpha for SWT.DROP_DOWN Combo", (!dropDown.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)dropDown.getDisplay(), 0, 255, 0);
            dropDown.setBackground(color);
            dropDown.setForeground(fg);
            Assert.assertEquals((String)"Setting a foreground disrupted the background color for SWT.DROP_DOWN Combo", (Object)color, (Object)dropDown.getBackground());
            Assert.assertEquals((String)"Setting a foreground onto an SWT.DROP_DOWN Combo with a background failed", (Object)fg, (Object)dropDown.getForeground());
            fg.dispose();
        }
        color.dispose();
        dropDown.dispose();
    }

    @Test
    public void test_setBackgroundAlphaDropDownCombo() {
        Combo dropDown = new Combo((Composite)this.shell, 4);
        Color color = new Color((Device)dropDown.getDisplay(), 255, 0, 0, 0);
        dropDown.setBackground(color);
        Assert.assertEquals((Object)color, (Object)dropDown.getBackground());
        Color fg = new Color((Device)dropDown.getDisplay(), 0, 255, 0, 0);
        dropDown.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)dropDown.getBackground());
        color.dispose();
        fg.dispose();
        dropDown.dispose();
    }

    @Test
    public void test_setBackgroundSimpleCombo() {
        Combo simple = new Combo((Composite)this.shell, 64);
        Color color = new Color((Device)simple.getDisplay(), 255, 0, 0);
        simple.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground for SWT.SIMPLE Combo", (Object)color, (Object)simple.getBackground());
        simple.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) for SWT.SIMPLE Combo", (!simple.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)simple.getDisplay(), 255, 0, 0, 0);
        simple.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground with 0 alpha for SWT.SIMPLE Combo", (Object)color, (Object)simple.getBackground());
        simple.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) with 0 alpha for SWT.SIMPLE Combo", (!simple.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)simple.getDisplay(), 0, 255, 0);
            simple.setBackground(color);
            simple.setForeground(fg);
            Assert.assertEquals((String)"Setting a foreground disrupted the background color for SWT.SIMPLE Combo", (Object)color, (Object)simple.getBackground());
            Assert.assertEquals((String)"Setting a foreground onto an SWT.SIMPLE Combo with a background failed", (Object)fg, (Object)simple.getForeground());
            fg.dispose();
        }
        color.dispose();
        simple.dispose();
    }

    @Test
    public void test_setBackgroundAlphaSimpleCombo() {
        Combo simple = new Combo((Composite)this.shell, 64);
        Color color = new Color((Device)simple.getDisplay(), 255, 0, 0, 0);
        simple.setBackground(color);
        Assert.assertEquals((Object)color, (Object)simple.getBackground());
        Color fg = new Color((Device)simple.getDisplay(), 0, 255, 0, 0);
        simple.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)simple.getBackground());
        color.dispose();
        fg.dispose();
        simple.dispose();
    }

    @Test
    public void test_setForegroundDropDownCombo() {
        Combo dropDown = new Combo((Composite)this.shell, 4);
        Color color = new Color((Device)dropDown.getDisplay(), 255, 0, 0);
        dropDown.setForeground(color);
        Assert.assertEquals((Object)color, (Object)dropDown.getForeground());
        dropDown.setForeground(null);
        Assert.assertFalse((boolean)dropDown.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)dropDown.getDisplay(), 0, 255, 0);
            dropDown.setForeground(color);
            dropDown.setBackground(bg);
            Assert.assertEquals((String)"Setting a background disrupted the foreground color for SWT.DROP_DOWN Combo", (Object)color, (Object)dropDown.getForeground());
            Assert.assertEquals((String)"Setting a background onto an SWT.DROP_DOWN Combo with a foreground failed", (Object)bg, (Object)dropDown.getBackground());
            bg.dispose();
        }
        color.dispose();
        dropDown.dispose();
    }

    @Test
    public void test_setForegroundAlphaDropDownCombo() {
        Combo dropDown = new Combo((Composite)this.shell, 4);
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)dropDown.getDisplay(), 255, 0, 0, 0);
        dropDown.setForeground(color);
        Assert.assertEquals((Object)color, (Object)dropDown.getForeground());
        Color bg = new Color((Device)dropDown.getDisplay(), 0, 255, 0, 0);
        dropDown.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)dropDown.getForeground());
        color.dispose();
        bg.dispose();
        dropDown.dispose();
    }

    @Test
    public void test_setForegroundSimpleCombo() {
        Combo simple = new Combo((Composite)this.shell, 64);
        Color color = new Color((Device)simple.getDisplay(), 255, 0, 0);
        simple.setForeground(color);
        Assert.assertEquals((Object)color, (Object)simple.getForeground());
        simple.setForeground(null);
        Assert.assertFalse((boolean)simple.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)simple.getDisplay(), 0, 255, 0);
            simple.setForeground(color);
            simple.setBackground(bg);
            Assert.assertEquals((String)"Setting a background disrupted the foreground color for SWT.SIMPLE Combo", (Object)color, (Object)simple.getForeground());
            Assert.assertEquals((String)"Setting a background onto an SWT.SIMPLE Combo with a foreground failed", (Object)bg, (Object)simple.getBackground());
            bg.dispose();
        }
        color.dispose();
        simple.dispose();
    }

    @Test
    public void test_setForegroundAlphaSimpleCombo() {
        Combo simple = new Combo((Composite)this.shell, 64);
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)simple.getDisplay(), 255, 0, 0, 0);
        simple.setForeground(color);
        Assert.assertEquals((Object)color, (Object)simple.getForeground());
        Color bg = new Color((Device)simple.getDisplay(), 0, 255, 0, 0);
        simple.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)simple.getForeground());
        color.dispose();
        bg.dispose();
        simple.dispose();
    }

    @Test
    public void test_setItemILjava_lang_String() {
        try {
            this.combo.setItem(0, null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.setItem(3, null);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.setItem(0, "fred");
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.add("string0");
        try {
            this.combo.setItem(0, null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.combo.setItem(-1, "new value");
            Assert.fail((String)"No exception thrown for index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.add("joe");
        this.combo.setItem(0, "fred");
        Assert.assertTrue((String)"fred", (boolean)this.combo.getItem(0).equals("fred"));
        try {
            this.combo.setItem(4, "fred");
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            this.combo.setItem(i, "fred" + i);
            ++i;
        }
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{"fred0", "fred1", "fred2", "fred3", "fred4"}, (Object[])this.combo.getItems());
    }

    @Test
    public void test_setItems$Ljava_lang_String() {
        try {
            this.combo.setItems(null);
            Assert.fail((String)"No exception thrown for items == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String[][] items = new String[][]{new String[0], {""}, {"", ""}, {"fred"}, {"fred0", "fred0"}, {"fred", "fred"}};
        int i = 0;
        while (i < items.length) {
            this.combo.setItems(items[i]);
            Assert.assertArrayEquals((String)(":a:" + i), (Object[])items[i], (Object[])this.combo.getItems());
            ++i;
        }
    }

    @Test
    public void test_setOrientationI() {
        this.combo.setOrientation(0x4000000);
        if ((this.combo.getStyle() & 0x8000000) != 0) {
            Assert.assertTrue((String)":a:", (this.combo.getOrientation() == 0x4000000 ? 1 : 0) != 0);
        }
        this.combo.setOrientation(0x2000000);
        Assert.assertTrue((String)":b:", (this.combo.getOrientation() == 0x2000000 ? 1 : 0) != 0);
    }

    @Test
    public void test_setSelectionLorg_eclipse_swt_graphics_Point() {
        try {
            this.combo.setSelection(null);
            Assert.fail((String)"No exception thrown for point == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int number = 5;
        int i = 0;
        while (i < number) {
            this.combo.add("fred" + i);
            ++i;
        }
        this.combo.setSelection(new Point(0, 5));
        Assert.assertTrue((String)":a:", (boolean)this.combo.getSelection().equals((Object)new Point(0, 0)));
        this.combo.setText("some text");
        this.combo.setSelection(new Point(0, 5));
        Assert.assertTrue((String)":b:", (boolean)this.combo.getSelection().equals((Object)new Point(0, 5)));
    }

    @Test
    public void test_setTextLimitI() {
        try {
            this.combo.setTextLimit(0);
            Assert.fail((String)"No exception thrown for limit == 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.setTextLimit(3);
        Assert.assertTrue((String)":a:", (this.combo.getTextLimit() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void test_setTextLjava_lang_String() {
        try {
            this.combo.setText(null);
            Assert.fail((String)"No exception thrown for text == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String[] cases = new String[]{"", "fred", "fred0"};
        int i = 0;
        while (i < cases.length) {
            this.combo.setText(cases[i]);
            Assert.assertTrue((String)(":a:" + i), (boolean)this.combo.getText().equals(cases[i]));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.combo.add("fred");
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            this.combo.setText(cases[i]);
            Assert.assertTrue((String)(":b:" + i), (boolean)this.combo.getText().equals(cases[i]));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.combo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            this.combo.setText(cases[i]);
            Assert.assertTrue((String)(":c:" + i), (boolean)this.combo.getText().equals(cases[i]));
            ++i;
        }
    }

    @Override
    @Test
    public void test_setBoundsIIII() {
        this.combo.setBounds(10, 20, 30, 40);
        Assert.assertTrue((this.combo.getBounds().x == 10 ? 1 : 0) != 0);
        Assert.assertTrue((this.combo.getBounds().y == 20 ? 1 : 0) != 0);
        Assert.assertTrue((this.combo.getBounds().width == 30 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setBoundsLorg_eclipse_swt_graphics_Rectangle() {
        this.combo.setBounds(new Rectangle(10, 20, 30, 40));
        Assert.assertTrue((this.combo.getBounds().x == 10 ? 1 : 0) != 0);
        Assert.assertTrue((this.combo.getBounds().y == 20 ? 1 : 0) != 0);
        Assert.assertTrue((this.combo.getBounds().width == 30 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setSizeII() {
        this.combo.setSize(30, 40);
        Assert.assertTrue((this.combo.getSize().x == 30 ? 1 : 0) != 0);
        this.combo.setSize(32, 43);
        Assert.assertTrue((this.combo.getSize().x == 32 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setSizeLorg_eclipse_swt_graphics_Point() {
        this.combo.setSize(new Point(30, 40));
        Assert.assertTrue((this.combo.getSize().x == 30 ? 1 : 0) != 0);
        this.combo.setBounds(32, 43, 33, 44);
        Assert.assertTrue((this.combo.getSize().x == 33 ? 1 : 0) != 0);
        this.combo.setBounds(32, 43, 30, 40);
        this.combo.setLocation(11, 22);
        this.combo.setSize(new Point(32, 43));
        Assert.assertTrue((this.combo.getSize().x == 32 ? 1 : 0) != 0);
    }

    private void add() {
        this.combo.add("this");
        this.combo.add("is");
        this.combo.add("SWT");
    }

    @Test
    public void test_consistency_MouseSelection() {
        this.add();
        this.consistencyPrePackShell();
        this.consistencyEvent(this.combo.getSize().x - 10, 5, 30, this.combo.getItemHeight() * 2, 60);
    }

    @Test
    public void test_consistency_KeySelection() {
        this.add();
        this.consistencyEvent(0, 0x1000002, 0, 0, 10);
    }

    @Test
    public void test_consistency_EnterSelection() {
        this.add();
        this.consistencyEvent(10, 13, 0, 0, 10);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.add();
        this.consistencyPrePackShell();
        this.consistencyEvent(this.combo.getSize().x - 10, 5, 3, 0, 30);
        this.consistencyEvent(10, 5, 3, 1, 30);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.add();
        this.consistencyEvent(10, 5, 20, 10, 50);
    }

    @Test
    public void test_consistency_Segments() {
        if (!SwtTestUtil.isWindows) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_consistency_Segments(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Combo).");
            }
            return;
        }
        SegmentListener sl1 = event -> {
            if ((event.lineText.length() & 1) == 1) {
                event.segments = new int[]{1, event.lineText.length()};
                event.segmentsChars = null;
            } else {
                int[] nArray = new int[3];
                nArray[2] = event.lineText.length();
                event.segments = nArray;
                event.segmentsChars = new char[]{':', '<', '>'};
            }
            this.listenerCalled = true;
        };
        try {
            this.combo.addSegmentListener(null);
            Assert.fail((String)"No exception thrown for addSegmentListener(null)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.combo.addSegmentListener(sl1);
        this.doSegmentsTest(true);
        this.combo.addSegmentListener(sl1);
        this.doSegmentsTest(true);
        this.combo.removeSegmentListener(sl1);
        this.doSegmentsTest(true);
        this.combo.removeSegmentListener(sl1);
        this.combo.setText(this.combo.getText());
        this.doSegmentsTest(false);
    }

    private void doSegmentsTest(boolean isListening) {
        Object[] items = new String[]{"first", "second", "third"};
        String string = "1234";
        this.combo.setItems((String[])items);
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertArrayEquals((Object[])items, (Object[])this.combo.getItems());
        this.combo.setText(string);
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)string, (Object)this.combo.getText());
        int limit = string.length() - 1;
        this.combo.setTextLimit(limit);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        this.combo.setText(string);
        Assert.assertEquals((Object)string.substring(0, limit), (Object)this.combo.getText());
        this.combo.setTextLimit(Combo.LIMIT);
        this.combo.setText(string);
        Assert.assertEquals((Object)string, (Object)this.combo.getText());
        int count = items.length;
        int i = 0;
        while (i < count) {
            Assert.assertEquals((Object)items[i], (Object)this.combo.getItem(i));
            Assert.assertEquals((long)i, (long)this.combo.indexOf((String)items[i]));
            this.combo.select(i);
            this.listenerCalled = false;
            Assert.assertEquals((long)i, (long)this.combo.getSelectionIndex());
            Assert.assertEquals((Object)items[i], (Object)this.combo.getText());
            Assert.assertFalse((boolean)this.listenerCalled);
            String currentText = this.combo.getText();
            this.combo.deselect(i ^ 1);
            Assert.assertEquals((Object)currentText, (Object)this.combo.getText());
            this.combo.deselect(i);
            Assert.assertEquals((Object)"", (Object)this.combo.getText());
            ++i;
        }
        i = 0;
        while (i < count) {
            this.combo.setText(this.combo.getItem(i));
            Assert.assertEquals((Object)items[i], (Object)this.combo.getText());
            ++i;
        }
        this.listenerCalled = false;
        limit = 2;
        this.combo.setTextLimit(limit);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        this.combo.setText(string);
        Assert.assertEquals((Object)string.substring(0, limit), (Object)this.combo.getText());
        this.combo.select(1);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        this.combo.remove(1);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        Assert.assertTrue((this.combo.getItemCount() == --count ? 1 : 0) != 0);
        this.combo.add((String)items[1], 1);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        Assert.assertTrue((this.combo.getItemCount() == ++count ? 1 : 0) != 0);
        this.combo.deselectAll();
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        this.combo.remove(1, 2);
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        Assert.assertTrue((this.combo.getItemCount() == (count -= 2) ? 1 : 0) != 0);
        this.combo.removeAll();
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        Assert.assertTrue((this.combo.getItemCount() == 0 ? 1 : 0) != 0);
        this.combo.setItems((String[])items);
        count = items.length;
        Assert.assertEquals((long)limit, (long)this.combo.getTextLimit());
        this.combo.setTextLimit(Combo.LIMIT);
        this.combo.setText(string);
        Assert.assertEquals((Object)string, (Object)this.combo.getText());
        String item = "forth";
        this.combo.add(item);
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)item, (Object)this.combo.getItem(count++));
        Assert.assertTrue((this.combo.getItemCount() == count ? 1 : 0) != 0);
        this.combo.select(1);
        this.combo.remove((String)items[1]);
        Assert.assertEquals((long)(--count), (long)this.combo.getItemCount());
        Assert.assertEquals((long)1L, (long)this.combo.indexOf((String)items[2]));
        this.combo.setItem(1, "second");
        Assert.assertEquals((long)count, (long)this.combo.getItemCount());
        Assert.assertEquals((long)1L, (long)this.combo.indexOf((String)items[1]));
        this.combo.setText(string);
        this.listenerCalled = false;
        Point pt = new Point(1, 3);
        this.combo.setSelection(pt);
        Assert.assertEquals((Object)pt, (Object)this.combo.getSelection());
        Assert.assertFalse((boolean)this.listenerCalled);
        this.combo.copy();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        String substr = string.substring(pt.x, pt.y);
        pt.y = 1;
        pt.x = 1;
        this.combo.setSelection(pt);
        this.combo.paste();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)(String.valueOf(string.substring(0, pt.x)) + substr + string.substring(pt.y)), (Object)this.combo.getText());
        pt.x = pt.y = pt.x + substr.length();
        Assert.assertEquals((Object)pt, (Object)this.combo.getSelection());
        pt.x -= 2;
        this.combo.setSelection(pt);
        Assert.assertEquals((Object)substr, (Object)this.combo.getText().substring(pt.x, pt.y));
        this.combo.cut();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)string, (Object)this.combo.getText());
    }
}

