/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.ConsistencyUtility;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Widget;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Control
extends Test_org_eclipse_swt_widgets_Widget {
    Control control;
    boolean eventOccurred;

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Test
    public void test_addControlListenerLorg_eclipse_swt_events_ControlListener() {
        ControlListener listener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void controlResized(ControlEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }
        };
        this.control.addControlListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(10, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(11, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeControlListener(listener);
    }

    @Test
    public void test_addControlListenerControlMovedAdapterLorg_eclipse_swt_events_ControlListener() {
        ControlListener listener = ControlListener.controlMovedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addControlListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(10, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(11, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeControlListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(10, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(11, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addControlListenerControlResizedAdapterLorg_eclipse_swt_events_ControlListener() {
        ControlListener listener = ControlListener.controlResizedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addControlListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(11, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(10, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeControlListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(11, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(10, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addFocusListenerLorg_eclipse_swt_events_FocusListener() {
        FocusListener listener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void focusLost(FocusEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }
        };
        this.control.addFocusListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(15, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(16, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeFocusListener(listener);
    }

    @Test
    public void test_addFocusListenerFocusGainedAdapterLorg_eclipse_swt_events_FocusListener() {
        FocusListener listener = FocusListener.focusGainedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addFocusListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(15, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(16, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeFocusListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(15, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(16, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addFocusListenerFocusLostAdapterLorg_eclipse_swt_events_FocusListener() {
        FocusListener listener = FocusListener.focusLostAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addFocusListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(16, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(15, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeFocusListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(15, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(16, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addHelpListenerLorg_eclipse_swt_events_HelpListener() {
        HelpListener listener = e -> {
            boolean bl = this.eventOccurred = true;
        };
        this.control.addHelpListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(28, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeHelpListener(listener);
    }

    @Test
    public void test_addKeyListenerLorg_eclipse_swt_events_KeyListener() {
        KeyListener listener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void keyReleased(KeyEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }
        };
        this.control.addKeyListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(1, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(2, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeKeyListener(listener);
    }

    @Test
    public void test_addKeyListenerKeyPressedAdapterLorg_eclipse_swt_events_KeyListener() {
        KeyListener listener = KeyListener.keyPressedAdapter(event -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addKeyListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(1, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeKeyListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(1, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addKeyListenerKeyReleasedAdapterLorg_eclipse_swt_events_KeyListener() {
        KeyListener listener = KeyListener.keyReleasedAdapter(event -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addKeyListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(2, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeKeyListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(2, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addMouseListenerLorg_eclipse_swt_events_MouseListener() {
        MouseListener listener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void mouseUp(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void mouseDoubleClick(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }
        };
        this.control.addMouseListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(3, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(4, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(8, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeMouseListener(listener);
    }

    @Test
    public void test_addMouseMoveListenerLorg_eclipse_swt_events_MouseMoveListener() {
        MouseMoveListener listener = e -> {
            boolean bl = this.eventOccurred = true;
        };
        this.control.addMouseMoveListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(5, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeMouseMoveListener(listener);
    }

    @Test
    public void test_addMouseTrackListenerLorg_eclipse_swt_events_MouseTrackListener() {
        MouseTrackListener listener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void mouseExit(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }

            public void mouseHover(MouseEvent e) {
                Test_org_eclipse_swt_widgets_Control.this.eventOccurred = true;
            }
        };
        this.control.addMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(6, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(7, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(32, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeMouseTrackListener(listener);
    }

    @Test
    public void test_addMouseTrackListenerMouseEnterAdapterLorg_eclipse_swt_events_MouseTrackListener() {
        MouseTrackListener listener = MouseTrackListener.mouseEnterAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(6, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(7, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(32, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(6, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(7, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(32, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addMouseTrackListenerMouseExitAdapterLorg_eclipse_swt_events_MouseTrackListener() {
        MouseTrackListener listener = MouseTrackListener.mouseExitAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(7, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(6, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(32, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(7, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(6, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(32, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addMouseTrackListenerMouseHoverAdapterLorg_eclipse_swt_events_MouseTrackListener() {
        MouseTrackListener listener = MouseTrackListener.mouseHoverAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.control.addMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(32, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(6, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.control.notifyListeners(7, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.removeMouseTrackListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(32, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(6, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.control.notifyListeners(7, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addPaintListenerLorg_eclipse_swt_events_PaintListener() {
        PaintListener listener = e -> {
            boolean bl = this.eventOccurred = true;
        };
        this.control.addPaintListener(listener);
        this.eventOccurred = false;
        Event event = new Event();
        GC gc = event.gc = new GC((Drawable)this.control);
        this.control.notifyListeners(9, event);
        gc.dispose();
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removePaintListener(listener);
    }

    @Test
    public void test_addTraverseListenerLorg_eclipse_swt_events_TraverseListener() {
        TraverseListener listener = e -> {
            boolean bl = this.eventOccurred = true;
        };
        this.control.addTraverseListener(listener);
        this.eventOccurred = false;
        this.control.notifyListeners(31, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.control.removeTraverseListener(listener);
    }

    @Test
    public void test_computeSizeII() {
        this.control.computeSize(-1, -1);
        Point size = this.control.getSize();
        this.control.computeSize(size.x, size.y);
        Assert.assertEquals((long)size.x, (long)this.control.getSize().x);
        Assert.assertEquals((long)size.y, (long)this.control.getSize().y);
    }

    @Test
    public void test_computeSizeIIZ() {
        this.control.computeSize(-1, -1, true);
        Point size = this.control.getSize();
        this.control.computeSize(size.x, size.y, false);
        Assert.assertEquals((long)size.x, (long)this.control.getSize().x);
        Assert.assertEquals((long)size.y, (long)this.control.getSize().y);
    }

    @Test
    public void test_getAccessible() {
        Accessible accessible = this.control.getAccessible();
        Assert.assertNotNull((String)":a:", (Object)accessible);
    }

    @Test
    public void test_getBorderWidth() {
        this.control.getBorderWidth();
    }

    @Test
    public void test_getLocation() {
        this.control.setBounds(32, 43, 30, 40);
        Assert.assertTrue((boolean)this.control.getLocation().equals((Object)new Point(32, 43)));
    }

    @Test
    public void test_getMonitor() {
        Monitor monitor = this.control.getMonitor();
        Assert.assertNotNull((Object)monitor);
        Display display = this.control.getDisplay();
        Monitor[] monitors = display.getMonitors();
        int i = 0;
        while (i < monitors.length) {
            if (monitor.equals((Object)monitors[i])) break;
            ++i;
        }
        if (i == monitors.length) {
            Assert.fail((String)"Control.getMonitor does not return a monitor listed in Display.getMonitors");
        }
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.shell, (Object)this.control.getParent());
    }

    @Test
    public void test_getShell() {
        Assert.assertEquals((Object)this.shell, (Object)this.control.getShell());
    }

    @Test
    public void test_isEnabled() {
        this.control.setEnabled(true);
        Assert.assertTrue((boolean)this.control.isEnabled());
        this.control.setEnabled(false);
        Assert.assertFalse((boolean)this.control.isEnabled());
    }

    @Test
    public void test_isFocusControl() {
        Assert.assertFalse((boolean)this.control.isFocusControl());
    }

    @Test
    public void test_isReparentable() {
        Assert.assertEquals((String)"isReparentable", (Object)this.control.isReparentable(), (Object)SwtTestUtil.isReparentablePlatform());
    }

    @Test
    public void test_isVisible() {
        this.control.setVisible(true);
        Assert.assertFalse((boolean)this.control.isVisible());
        this.control.setVisible(false);
        Assert.assertFalse((boolean)this.control.isVisible());
        if (!SwtTestUtil.isAIX) {
            this.control.setVisible(true);
            this.shell.setVisible(true);
            Assert.assertTrue((String)"Window should be visible", (boolean)this.control.isVisible());
            this.shell.setVisible(false);
            Assert.assertFalse((String)"Window should not be visible", (boolean)this.control.isVisible());
        }
    }

    @Test
    public void test_moveAboveLorg_eclipse_swt_widgets_Control() {
        this.control.moveAbove(null);
        this.control.moveAbove(this.control);
        Button b = new Button((Composite)this.shell, 0);
        this.control.moveAbove((Control)b);
        b.dispose();
    }

    @Test
    public void test_moveBelowLorg_eclipse_swt_widgets_Control() {
        this.control.moveBelow(null);
        this.control.moveBelow(this.control);
        Button b = new Button((Composite)this.shell, 0);
        this.control.moveBelow((Control)b);
        b.dispose();
    }

    @Test
    public void test_pack() {
        this.control.pack();
    }

    @Test
    public void test_packZ() {
        this.control.pack(true);
        this.control.pack(false);
    }

    @Test
    public void test_redraw() {
        this.control.redraw();
    }

    @Test
    public void test_redrawIIIIZ() {
        this.control.redraw(0, 0, 0, 0, false);
        this.control.redraw(0, 0, 0, 0, true);
        this.control.redraw(-10, -10, -10, -10, true);
        this.control.redraw(10, 10, 10, 10, true);
        this.control.redraw(10, 10, 10, 10, false);
        this.control.redraw(10000, 10000, 10000, 10000, false);
    }

    @Test
    public void test_requestLayoutL() {
        this.control.requestLayout();
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.control.getDisplay(), 255, 0, 0);
        this.control.setBackground(color);
        Assert.assertEquals((String)("getBackground not equal color after setBackground(color) for " + this.control), (Object)color, (Object)this.control.getBackground());
        this.control.setBackground(null);
        Assert.assertTrue((String)("getBackground unchanged after setBackground(null) for " + this.control), (!this.control.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)this.control.getDisplay(), 255, 0, 0, 0);
        this.control.setBackground(color);
        Assert.assertEquals((String)("getBackground not equal color after setBackground(color) with 0 alpha for " + this.control + " " + this.control.getBackground()), (Object)color, (Object)this.control.getBackground());
        this.control.setBackground(null);
        Assert.assertTrue((String)("getBackground unchanged after setBackground(null) alpha for " + this.control + " " + this.control.getBackground() + " " + this.control), (!this.control.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)this.control.getDisplay(), 0, 255, 0);
            this.control.setBackground(color);
            this.control.setForeground(fg);
            Assert.assertEquals((String)("Setting a foreground disrupted the background color for " + this.control), (Object)color, (Object)this.control.getBackground());
            Assert.assertEquals((String)("Setting a foreground onto a widget with a background failed for " + this.control), (Object)fg, (Object)this.control.getForeground());
        }
        color.dispose();
    }

    @Test
    public void test_setBackgroundAlphaLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.control.getDisplay(), 255, 0, 0, 0);
        this.control.setBackground(color);
        Assert.assertEquals((Object)color, (Object)this.control.getBackground());
        Color fg = new Color((Device)this.control.getDisplay(), 0, 255, 0, 0);
        this.control.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)this.control.getBackground());
        color.dispose();
        fg.dispose();
    }

    @Test
    public void test_setBoundsIIII() {
        this.control.setBounds(10, 20, 30, 40);
        Assert.assertEquals((Object)new Rectangle(10, 20, 30, 40), (Object)this.control.getBounds());
        this.control.setBounds(20, 30, 40, 50);
        Assert.assertFalse((boolean)this.control.getBounds().equals((Object)new Rectangle(10, 20, 30, 40)));
        this.control.setBounds(10, 20, 30, 40);
    }

    @Test
    public void test_setBoundsLorg_eclipse_swt_graphics_Rectangle() {
        this.control.setBounds(new Rectangle(10, 20, 30, 40));
        Assert.assertEquals((Object)new Rectangle(10, 20, 30, 40), (Object)this.control.getBounds());
        this.control.setBounds(new Rectangle(20, 30, 40, 50));
        Assert.assertFalse((boolean)this.control.getBounds().equals((Object)new Rectangle(10, 20, 30, 40)));
        try {
            this.control.setBounds(null);
            Assert.fail((String)"No exception thrown for rectangle == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.control.setBounds(new Rectangle(10, 20, 30, 40));
    }

    @Test
    public void test_setCaptureZ() {
        this.control.setCapture(true);
        this.control.setCapture(false);
    }

    @Test
    public void test_setCursorLorg_eclipse_swt_graphics_Cursor() {
        this.control.setCursor(null);
        Cursor c = new Cursor((Device)this.control.getDisplay(), 0);
        this.control.setCursor(c);
        c.dispose();
    }

    @Test
    public void test_setEnabledZ() {
        this.control.setEnabled(true);
        Assert.assertTrue((boolean)this.control.getEnabled());
        this.control.setEnabled(false);
        Assert.assertFalse((boolean)this.control.getEnabled());
    }

    @Test
    public void test_setTextDirection() {
        if (!SwtTestUtil.isWindows) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setTextDirection(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Control).");
            }
            return;
        }
        int[] orientations = new int[]{0x2000000, 0x4000000};
        int[] directions = new int[]{0x2000000, 0x4000000, 0x6000000};
        int[] nArray = new int[3];
        nArray[0] = 0x2000000;
        nArray[1] = 0x4000000;
        int[] expectedDirections = nArray;
        int i = orientations.length;
        while (i-- > 0) {
            this.control.setOrientation(orientations[i]);
            expectedDirections[2] = this.control.getOrientation();
            int j = directions.length;
            while (j-- > 0) {
                this.control.setTextDirection(directions[j]);
                Assert.assertEquals((String)("orientation: " + orientations[i] + ", text direction: " + directions[j]), (long)this.control.getTextDirection(), (long)expectedDirections[j]);
            }
        }
    }

    @Test
    public void test_setFocus() {
        this.control.setFocus();
    }

    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        Font font = this.control.getFont();
        this.control.setFont(font);
        Assert.assertEquals((Object)font, (Object)this.control.getFont());
        font = new Font((Device)this.control.getDisplay(), SwtTestUtil.testFontName, 10, 0);
        this.control.setFont(font);
        Assert.assertEquals((Object)font, (Object)this.control.getFont());
        this.control.setFont(null);
        font.dispose();
        try {
            this.control.setFont(font);
            this.control.setFont(null);
            Assert.fail((String)"No exception thrown for disposed font");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setForegroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.control.getDisplay(), 255, 0, 0);
        this.control.setForeground(color);
        Assert.assertEquals((Object)color, (Object)this.control.getForeground());
        this.control.setForeground(null);
        Assert.assertFalse((boolean)this.control.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)this.control.getDisplay(), 0, 255, 0);
            this.control.setForeground(color);
            this.control.setBackground(bg);
            Assert.assertEquals((String)("Setting a background disrupted the foreground color for " + this.control), (Object)color, (Object)this.control.getForeground());
            Assert.assertEquals((String)("Setting a background onto a widget with a foreground failed for " + this.control), (Object)bg, (Object)this.control.getBackground());
        }
        color.dispose();
    }

    @Test
    public void test_setForegroundAlphaLorg_eclipse_swt_graphics_Color() {
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)this.control.getDisplay(), 255, 0, 0, 0);
        this.control.setForeground(color);
        Assert.assertEquals((Object)color, (Object)this.control.getForeground());
        Color bg = new Color((Device)this.control.getDisplay(), 0, 255, 0, 0);
        this.control.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)this.control.getForeground());
        color.dispose();
        bg.dispose();
    }

    @Test
    public void test_setLayoutDataLjava_lang_Object() {
        this.control.setLayoutData((Object)this);
        Assert.assertEquals((Object)this, (Object)this.control.getLayoutData());
        this.control.setLayoutData((Object)"asldsahdahcaslcshdac");
        Assert.assertEquals((Object)"asldsahdahcaslcshdac", (Object)this.control.getLayoutData());
        this.control.setLayoutData(this.getClass());
        Assert.assertEquals(this.getClass(), (Object)this.control.getLayoutData());
        this.control.setLayoutData(null);
        Assert.assertNull((Object)this.control.getLayoutData());
    }

    @Test
    public void test_setLocationII() {
        this.control.setBounds(32, 43, 30, 40);
        this.control.setLocation(11, 22);
        this.control.setSize(32, 43);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)new Point(11, 22));
        this.control.setLocation(10, 10);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)new Point(10, 10));
    }

    @Test
    public void test_setLocationLorg_eclipse_swt_graphics_Point() {
        try {
            this.control.setLocation(null);
            Assert.fail((String)"No exception thrown for location == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Point loc = new Point(30, 40);
        this.control.setLocation(loc);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)loc);
        loc = new Point(10, 10);
        this.control.setLocation(loc);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)loc);
        loc = new Point(10000, 10000);
        this.control.setLocation(loc);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)loc);
        loc = new Point(-10, -10);
        this.control.setLocation(loc);
        Assert.assertEquals((Object)this.control.getLocation(), (Object)loc);
    }

    @Test
    public void test_setMenuLorg_eclipse_swt_widgets_Menu() {
        this.control.setMenu(null);
        Menu m = new Menu(this.control);
        this.control.setMenu(m);
        Assert.assertEquals((Object)m, (Object)this.control.getMenu());
    }

    @Test
    public void test_setParentLorg_eclipse_swt_widgets_Composite() {
        if (this.control.isReparentable()) {
            Shell originalParent = new Shell();
            Shell newParent = new Shell();
            Button b = new Button((Composite)originalParent, 8);
            b.setParent((Composite)newParent);
            originalParent.dispose();
            Assert.assertFalse((boolean)b.isDisposed());
            newParent.dispose();
        }
    }

    @Test
    public void test_setRedrawZ() {
        this.control.setRedraw(false);
        this.control.setRedraw(true);
    }

    @Test
    public void test_setSizeII() {
        this.control.setBounds(32, 43, 30, 40);
        Assert.assertEquals((Object)new Point(30, 40), (Object)this.control.getSize());
        this.control.setBounds(32, 43, 30, 40);
        this.control.setLocation(11, 22);
        this.control.setSize(32, 43);
        Assert.assertEquals((Object)new Point(32, 43), (Object)this.control.getSize());
        this.control.setSize(0, 0);
        this.control.setSize(10, 10);
        this.control.setSize(10000, 10000);
        this.control.setSize(-10, -10);
    }

    @Test
    public void test_setSizeLorg_eclipse_swt_graphics_Point() {
        this.control.setSize(new Point(30, 40));
        Assert.assertEquals((Object)new Point(30, 40), (Object)this.control.getSize());
        try {
            this.control.setSize(null);
            Assert.fail((String)"No exception thrown for size == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.control.setSize(new Point(0, 0));
        this.control.setSize(new Point(10, 10));
        this.control.setSize(new Point(10000, 10000));
        this.control.setSize(new Point(-10, -10));
    }

    @Test
    public void test_setToolTipTextLjava_lang_String() {
        this.control.setToolTipText("This is a tip");
        Assert.assertEquals((Object)"This is a tip", (Object)this.control.getToolTipText());
        this.control.setToolTipText(null);
        Assert.assertNull((Object)this.control.getToolTipText());
    }

    @Test
    public void test_setVisibleZ() {
        this.control.setVisible(true);
        Assert.assertTrue((boolean)this.control.getVisible());
        this.control.setVisible(false);
        Assert.assertFalse((boolean)this.control.getVisible());
    }

    @Test
    public void test_toControlII() {
        Point controlCoords = this.control.toControl(0, 0);
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.control.toDisplay(controlCoords.x, controlCoords.y));
    }

    @Test
    public void test_toControlLorg_eclipse_swt_graphics_Point() {
        Point controlCoords = this.control.toControl(new Point(0, 0));
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.control.toDisplay(controlCoords));
        try {
            this.control.toControl(null);
            Assert.fail((String)"No exception thrown for size == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_toDisplayII() {
        Point displayCoords = this.control.toDisplay(0, 0);
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.control.toControl(displayCoords.x, displayCoords.y));
    }

    @Test
    public void test_toDisplayLorg_eclipse_swt_graphics_Point() {
        Point displayCoords = this.control.toDisplay(new Point(0, 0));
        Assert.assertEquals((Object)new Point(0, 0), (Object)this.control.toControl(displayCoords));
        try {
            this.control.toDisplay(null);
            Assert.fail((String)"No exception thrown for size == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_traverseI() {
        this.control.traverse(2);
        this.control.traverse(4);
        this.control.traverse(16);
        this.control.traverse(8);
        this.control.traverse(64);
        this.control.traverse(32);
    }

    @Test
    public void test_update() {
        this.control.update();
    }

    @Override
    protected void setWidget(Widget w) {
        this.control = (Control)w;
        super.setWidget(w);
    }

    protected void consistencyEvent(final int paramA, final int paramB, final int paramC, final int paramD, final int method, List<String> events, boolean focus) {
        if (SwtTestUtil.fTestConsistency) {
            final Display display = this.shell.getDisplay();
            if (events == null) {
                events = new ArrayList<String>();
            }
            final String test = this.getTestName();
            this.shell.setLayout((Layout)new FillLayout());
            this.shell.setText("Parent");
            this.shell.pack();
            this.shell.open();
            if (this.control instanceof Shell) {
                ((Shell)this.control).pack();
                ((Shell)this.control).open();
            }
            final Point[] pt = this.determineLocations(paramA, paramB, paramC, paramD, method);
            if (focus && !this.control.setFocus()) {
                this.control.forceFocus();
            }
            Object[] expectedEvents = this.hookExpectedEvents(test, events);
            new Thread(){

                @Override
                public void run() {
                    display.wake();
                    switch (method) {
                        case 30: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postClick(display, pt[0], paramC));
                            if (paramD != 1) break;
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postClick(display, pt[1], 1));
                            break;
                        }
                        case 40: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postDoubleClick(display, pt[0], paramC));
                            break;
                        }
                        case 10: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postKeyPress(display, paramA, paramB));
                            break;
                        }
                        case 20: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postDoubleKeyPress(display, paramA, paramB, paramC, paramD));
                            break;
                        }
                        case 50: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postDrag(display, pt[0], pt[1]));
                            break;
                        }
                        case 60: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postSelection(display, pt[0], pt[1]));
                            break;
                        }
                        case 1: {
                            Assert.assertTrue((String)test, (boolean)ConsistencyUtility.postShellIconify(display, pt[1], paramA));
                            if (Test_org_eclipse_swt_widgets_Control.this.control instanceof Shell) {
                                display.syncExec((Runnable)new Thread(){

                                    @Override
                                    public void run() {
                                        ((Shell)(this).Test_org_eclipse_swt_widgets_Control.this.control).setMinimized(false);
                                    }
                                });
                                break;
                            }
                            Assert.fail((String)"Iconifying a non shell control");
                        }
                    }
                    display.asyncExec((Runnable)new Thread(){

                        @Override
                        public void run() {
                            (this).Test_org_eclipse_swt_widgets_Control.this.shell.dispose();
                        }
                    });
                }
            }.start();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.setUp();
            Object[] results = new String[events.size()];
            results = events.toArray(results);
            Assert.assertArrayEquals((String)(String.valueOf(test) + " event ordering"), (Object[])expectedEvents, (Object[])results);
        }
    }

    protected void consistencyEvent(int paramA, int paramB, int paramC, int paramD, int method, List<String> events) {
        this.consistencyEvent(paramA, paramB, paramC, paramD, method, events, true);
    }

    protected void consistencyEvent(int paramA, int paramB, int paramC, int paramD, int method) {
        this.consistencyEvent(paramA, paramB, paramC, paramD, method, null, true);
    }

    protected void consistencyPrePackShell() {
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.pack();
    }

    protected void consistencyPrePackShell(Shell shell) {
        this.consistencyPrePackShell();
        shell.pack();
    }

    protected Point[] determineLocations(int paramA, int paramB, int paramC, int paramD, int method) {
        Point[] array = new Point[2];
        if (method >= 30) {
            array[0] = this.control.toDisplay(paramA, paramB);
        }
        if (method >= 50) {
            array[1] = this.control.toDisplay(paramC, paramD);
        }
        if (method == 30 && paramD == 1) {
            array[1] = this.shell.toDisplay(25, -10);
        } else if (method == 1) {
            array[0] = this.control.toDisplay(0, 0);
            array[1] = this.control.toDisplay(this.control.getSize().x - 20, 0);
        }
        return array;
    }

    @Test
    public void test_ExceptionsThrownInDisposeListenerDontPreventDisposal() {
        this.disposedIntentionally = true;
        Consumer oldHandler = Display.getCurrent().getRuntimeExceptionHandler();
        try {
            ArrayList handledExceptions = new ArrayList();
            Display.getCurrent().setRuntimeExceptionHandler(exception -> handledExceptions.add(exception));
            int[] listenerInvocations = new int[1];
            this.control.addDisposeListener(e -> {
                nArray[0] = listenerInvocations[0] + 1;
            });
            this.control.addDisposeListener(e -> {
                throw new RuntimeException("Test exception handling");
            });
            this.control.addDisposeListener(e -> {
                nArray[0] = listenerInvocations[0] + 1;
            });
            try {
                this.control.dispose();
            }
            catch (RuntimeException runtimeException) {
                Assert.fail((String)"The exception in the listener should have been logged, not passed along to the caller");
            }
            Assert.assertTrue((boolean)this.control.isDisposed());
            Assert.assertEquals((long)2L, (long)listenerInvocations[0]);
            Assert.assertEquals((long)1L, (long)handledExceptions.size());
        }
        finally {
            Display.getCurrent().setRuntimeExceptionHandler(oldHandler);
        }
    }
}

