/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Item;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_CoolItem
extends Test_org_eclipse_swt_widgets_Item {
    static final boolean MINIMAL_CONFORMANCE = false;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        this.setWidget((Widget)coolItem);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CoolBarI() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        new CoolItem(coolBar, 0);
        try {
            new CoolItem(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CoolBarII() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0, 0);
        try {
            coolItem = new CoolItem(coolBar, 0, -1);
            Assert.fail((String)"No exception thrown for index == -1");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            coolItem = new CoolItem(coolBar, 0, 2);
            Assert.fail((String)"No exception thrown for index == 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)1L, (long)coolBar.getItemCount());
        coolItem = new CoolItem(coolBar, 0, 1);
        Assert.assertEquals((long)2L, (long)coolBar.getItemCount());
        coolItem = new CoolItem(coolBar, 0, 0);
        Assert.assertEquals((long)3L, (long)coolBar.getItemCount());
        Assert.assertEquals((Object)coolItem, (Object)coolBar.getItem(0));
    }

    @Test
    public void test_computeSizeII() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foo");
        Point size = coolItem.computeSize(-1, -1);
        coolItem.setControl((Control)button);
        Point size2 = coolItem.computeSize(-1, -1);
        Assert.assertTrue((size2.x == size.x ? 1 : 0) != 0);
        size = coolItem.computeSize(50, 25);
        size2 = coolItem.computeSize(100, 25);
        Assert.assertEquals((long)(size.x + 50), (long)size2.x);
        Assert.assertEquals((long)size.y, (long)size2.y);
        size = coolItem.computeSize(1, 1);
        size2 = coolItem.computeSize(26, 26);
        Assert.assertEquals((long)25L, (long)(size2.x - size.x));
    }

    @Test
    public void test_getBounds() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foo");
        coolItem.setControl((Control)button);
        Rectangle rect = coolItem.getBounds();
        Point size = coolItem.getSize();
        Assert.assertEquals((long)size.x, (long)rect.width);
        Assert.assertEquals((long)size.y, (long)rect.height);
        coolItem.setSize(25, 25);
        rect = coolItem.getBounds();
        coolItem.setSize(100, 25);
        Rectangle newRect = coolItem.getBounds();
        Assert.assertEquals((long)(rect.width + 75), (long)newRect.width);
        Assert.assertEquals((long)rect.x, (long)newRect.x);
        Assert.assertEquals((long)rect.y, (long)newRect.y);
    }

    @Test
    public void test_getControl() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Assert.assertNull((Object)coolItem.getControl());
        Button button = new Button((Composite)coolBar, 8);
        coolItem.setControl((Control)button);
        Control control = coolItem.getControl();
        Assert.assertEquals((Object)button, (Object)control);
        button = new Button((Composite)coolBar, 8);
        coolItem.setControl((Control)button);
        control = coolItem.getControl();
        Assert.assertEquals((Object)button, (Object)control);
    }

    @Test
    public void test_getParent() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Assert.assertEquals((Object)coolBar, (Object)coolItem.getParent());
    }

    @Test
    public void test_getPreferredSize() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foobar");
        coolItem.setControl((Control)button);
        Point pref = coolItem.getPreferredSize();
        coolItem.setPreferredSize(pref);
        Assert.assertEquals((Object)pref, (Object)coolItem.getPreferredSize());
    }

    @Test
    public void test_getSize() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foo");
        coolItem.setControl((Control)button);
        Point size = coolItem.getSize();
        Rectangle rect = coolItem.getBounds();
        Assert.assertEquals((long)rect.width, (long)size.x);
        Assert.assertEquals((long)rect.height, (long)size.y);
    }

    @Test
    public void test_setControlLorg_eclipse_swt_widgets_Control() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        coolItem.setControl(null);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foobar");
        Point size = coolItem.getSize();
        coolItem.setControl((Control)button);
        Point size2 = coolItem.getSize();
        Assert.assertTrue((size2.x > size.x ? 1 : 0) != 0);
        size = button.computeSize(-1, -1);
        size2 = coolItem.computeSize(size.x, size.y);
        Assert.assertEquals((Object)size2, (Object)coolItem.getSize());
        button = new Button((Composite)coolBar, 8);
        button.dispose();
        try {
            coolItem.setControl((Control)button);
            Assert.fail((String)"No exception when control.isDisposed()");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        button = new Button((Composite)this.shell, 8);
        try {
            coolItem.setControl((Control)button);
            Assert.fail((String)"No exception thrown when control has wrong parent");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setPreferredSizeII() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foobar");
        coolItem.setControl((Control)button);
        Point size = coolItem.getSize();
        coolItem.setPreferredSize(size);
        Assert.assertEquals((long)size.x, (long)coolItem.getSize().x);
        coolItem.setSize(coolItem.getPreferredSize());
        Assert.assertEquals((Object)size, (Object)coolItem.getSize());
    }

    @Test
    public void test_setPreferredSizeLorg_eclipse_swt_graphics_Point() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foobar");
        coolItem.setControl((Control)button);
        Point size = new Point(50, 30);
        coolItem.setPreferredSize(size);
        Point size2 = coolItem.getPreferredSize();
        coolItem.setPreferredSize(50, 30);
        Assert.assertEquals((Object)size2, (Object)coolItem.getPreferredSize());
    }

    @Test
    public void test_setSizeII() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foo");
        coolItem.setControl((Control)button);
        coolItem.setSize(50, 50);
        Assert.assertEquals((Object)new Point(50, 50), (Object)coolItem.getSize());
        coolItem.setSize(0, 0);
        Point smallest = coolItem.getSize();
        coolItem.setSize(1, 1);
        Assert.assertEquals((Object)smallest, (Object)coolItem.getSize());
        Rectangle rect = coolItem.getBounds();
        Point size = coolItem.getSize();
        coolItem.setSize(rect.width, rect.height);
        Assert.assertEquals((Object)size, (Object)coolItem.getSize());
    }

    @Test
    public void test_setSizeLorg_eclipse_swt_graphics_Point() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Button button = new Button((Composite)coolBar, 8);
        button.setText("foo");
        coolItem.setControl((Control)button);
        Point size = new Point(50, 50);
        coolItem.setSize(size);
        Point size2 = coolItem.getSize();
        coolItem.setSize(50, 50);
        Assert.assertEquals((Object)size2, (Object)coolItem.getSize());
    }
}

