/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Control;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Test_org_eclipse_swt_widgets_DateTime
extends Test_org_eclipse_swt_widgets_Control {
    static final int JAN = 0;
    static final int FEB = 1;
    static final int AUG = 7;
    static final int NOV = 10;
    DateTime datetime;
    int style = 32;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{32}, {128}, {1024}};
        return Arrays.asList(data);
    }

    public Test_org_eclipse_swt_widgets_DateTime(int style) {
        this.style = style;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.datetime = new DateTime((Composite)this.shell, this.style);
        this.setWidget((Widget)this.datetime);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        new DateTime((Composite)this.shell, 0);
        new DateTime((Composite)this.shell, 32);
        new DateTime((Composite)this.shell, 128);
        new DateTime((Composite)this.shell, 1024);
        new DateTime((Composite)this.shell, 0x10000020);
        new DateTime((Composite)this.shell, 0x10000080);
        new DateTime((Composite)this.shell, 0x10000400);
        new DateTime((Composite)this.shell, 65568);
        new DateTime((Composite)this.shell, 65664);
        new DateTime((Composite)this.shell, 66560);
        new DateTime((Composite)this.shell, 32800);
        new DateTime((Composite)this.shell, 32896);
        new DateTime((Composite)this.shell, 33792);
        try {
            new DateTime(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Test_org_eclipse_swt_widgets_DateTime.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        try {
            this.datetime.addSelectionListener(null);
            Assert.fail((String)"No exception thrown for addSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.datetime.addSelectionListener(listener);
        this.datetime.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        try {
            this.datetime.removeSelectionListener(null);
            Assert.fail((String)"No exception thrown for removeSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.listenerCalled = false;
        this.datetime.removeSelectionListener(listener);
        this.datetime.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.datetime.addSelectionListener(listener);
        this.datetime.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.datetime.removeSelectionListener(listener);
        this.datetime.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_setBackgroundCalendarDateTime() {
        DateTime calendar = new DateTime((Composite)this.shell, 1024);
        Color color = new Color((Device)calendar.getDisplay(), 255, 0, 0);
        calendar.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground for SWT.CALENDAR DateTime", (Object)color, (Object)calendar.getBackground());
        calendar.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) for SWT.CALENDAR DateTime", (!calendar.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)calendar.getDisplay(), 255, 0, 0, 0);
        calendar.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground with 0 alpha for SWT.CALENDAR DateTime", (Object)color, (Object)calendar.getBackground());
        calendar.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) with 0 alpha for SWT.CALENDAR DateTime", (!calendar.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)calendar.getDisplay(), 0, 255, 0);
            calendar.setBackground(color);
            calendar.setForeground(fg);
            Assert.assertEquals((String)"Setting a foreground disrupted the background color for SWT.CALENDAR DateTime", (Object)color, (Object)calendar.getBackground());
            Assert.assertEquals((String)"Setting a foreground onto an SWT.CALENDAR DateTime with a background failed", (Object)fg, (Object)calendar.getForeground());
            fg.dispose();
        }
        color.dispose();
        calendar.dispose();
    }

    @Test
    public void test_setBackgroundAlphaCalendarDateTime() {
        DateTime calendar = new DateTime((Composite)this.shell, 1024);
        Color color = new Color((Device)calendar.getDisplay(), 255, 0, 0, 0);
        calendar.setBackground(color);
        Assert.assertEquals((Object)color, (Object)calendar.getBackground());
        Color fg = new Color((Device)calendar.getDisplay(), 0, 255, 0, 0);
        calendar.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)calendar.getBackground());
        color.dispose();
        fg.dispose();
        calendar.dispose();
    }

    @Test
    public void test_setBackgroundTimeDateTime() {
        DateTime time = new DateTime((Composite)this.shell, 128);
        Color color = new Color((Device)time.getDisplay(), 255, 0, 0);
        time.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground for SWT.TIME DateTime", (Object)color, (Object)time.getBackground());
        time.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) for SWT.TIME DateTime", (!time.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)time.getDisplay(), 255, 0, 0, 0);
        time.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground with 0 alpha for SWT.TIME DateTime", (Object)color, (Object)time.getBackground());
        time.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) with 0 alpha for SWT.TIME DateTime", (!time.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)time.getDisplay(), 0, 255, 0);
            time.setBackground(color);
            time.setForeground(fg);
            Assert.assertEquals((String)"Setting a foreground disrupted the background color for SWT.TIME DateTime", (Object)color, (Object)time.getBackground());
            Assert.assertEquals((String)"Setting a foreground onto an SWT.TIME DateTime with a background failed", (Object)fg, (Object)time.getForeground());
            fg.dispose();
        }
        color.dispose();
        time.dispose();
    }

    @Test
    public void test_setBackgroundAlphaTimeDateTime() {
        DateTime time = new DateTime((Composite)this.shell, 128);
        Color color = new Color((Device)time.getDisplay(), 255, 0, 0, 0);
        time.setBackground(color);
        Assert.assertEquals((Object)color, (Object)time.getBackground());
        Color fg = new Color((Device)time.getDisplay(), 0, 255, 0, 0);
        time.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)time.getBackground());
        color.dispose();
        fg.dispose();
        time.dispose();
    }

    @Test
    public void test_setBackgroundDateDateTime() {
        DateTime date = new DateTime((Composite)this.shell, 32);
        Color color = new Color((Device)date.getDisplay(), 255, 0, 0);
        date.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground for SWT.DATE DateTime", (Object)color, (Object)date.getBackground());
        date.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) for SWT.DATE DateTime", (!date.getBackground().equals((Object)color) ? 1 : 0) != 0);
        color.dispose();
        color = new Color((Device)date.getDisplay(), 255, 0, 0, 0);
        date.setBackground(color);
        Assert.assertEquals((String)"getBackground not equal after setBackground with 0 alpha for SWT.DATE DateTime", (Object)color, (Object)date.getBackground());
        date.setBackground(null);
        Assert.assertTrue((String)"getBackground unchanged after setBackground(null) with 0 alpha for SWT.DATE DateTime", (!date.getBackground().equals((Object)color) ? 1 : 0) != 0);
        if ("gtk".equals(SWT.getPlatform())) {
            Color fg = new Color((Device)date.getDisplay(), 0, 255, 0);
            date.setBackground(color);
            date.setForeground(fg);
            Assert.assertEquals((String)"Setting a foreground disrupted the background color for SWT.DATE DateTime", (Object)color, (Object)date.getBackground());
            Assert.assertEquals((String)"Setting a foreground onto an SWT.DATE DateTime with a background failed", (Object)fg, (Object)date.getForeground());
            fg.dispose();
        }
        color.dispose();
        date.dispose();
    }

    @Test
    public void test_setBackgroundAlphaDateDateTime() {
        DateTime date = new DateTime((Composite)this.shell, 32);
        Color color = new Color((Device)date.getDisplay(), 255, 0, 0, 0);
        date.setBackground(color);
        Assert.assertEquals((Object)color, (Object)date.getBackground());
        Color fg = new Color((Device)date.getDisplay(), 0, 255, 0, 0);
        date.setForeground(fg);
        Assert.assertEquals((Object)color, (Object)date.getBackground());
        color.dispose();
        fg.dispose();
        date.dispose();
    }

    @Test
    public void test_setDateIII() {
        this.datetime.setDate(2008, 7, 31);
        Assert.assertEquals((long)31L, (long)this.datetime.getDay());
        Assert.assertEquals((long)7L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 10, 30);
        Assert.assertEquals((long)30L, (long)this.datetime.getDay());
        Assert.assertEquals((long)10L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 1, 29);
        Assert.assertEquals((long)29L, (long)this.datetime.getDay());
        Assert.assertEquals((long)1L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2007, 1, 28);
        Assert.assertEquals((long)28L, (long)this.datetime.getDay());
        Assert.assertEquals((long)1L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2007L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(1752, 10, 30);
        Assert.assertEquals((long)30L, (long)this.datetime.getDay());
        Assert.assertEquals((long)10L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)1752L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 1);
        this.datetime.setDate(9999, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)9999L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 11, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)11L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(1999, 1, 29);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(1999, 10, 31);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(1751, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(10000, 0, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, -1, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 12, 1);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 0);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 0, 99);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
    }

    @Test
    public void test_setDayI() {
        this.datetime.setDate(2008, 7, 1);
        int day = 1;
        while (day <= 31) {
            this.datetime.setDay(day);
            Assert.assertEquals((long)day, (long)this.datetime.getDay());
            ++day;
        }
        day = this.datetime.getDay();
        this.datetime.setDay(32);
        Assert.assertEquals((long)day, (long)this.datetime.getDay());
        this.datetime.setDay(-5);
        Assert.assertEquals((long)day, (long)this.datetime.getDay());
        this.datetime.setDate(2008, 1, 1);
        this.datetime.setDay(30);
        Assert.assertEquals((long)1L, (long)this.datetime.getDay());
        this.datetime.setDate(2007, 1, 5);
        this.datetime.setDay(29);
        Assert.assertEquals((long)5L, (long)this.datetime.getDay());
    }

    @Test
    public void test_setForegroundCalendarDateTime() {
        DateTime calendar = new DateTime((Composite)this.shell, 1024);
        Color color = new Color((Device)calendar.getDisplay(), 255, 0, 0);
        calendar.setForeground(color);
        Assert.assertEquals((Object)color, (Object)calendar.getForeground());
        calendar.setForeground(null);
        Assert.assertFalse((boolean)calendar.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)calendar.getDisplay(), 0, 255, 0);
            calendar.setForeground(color);
            calendar.setBackground(bg);
            Assert.assertEquals((String)"Setting a background disrupted the foreground color for SWT.CALENDAR DateTime", (Object)color, (Object)calendar.getForeground());
            Assert.assertEquals((String)"Setting a background onto an SWT.CALENDAR DateTime with a foreground failed", (Object)bg, (Object)calendar.getBackground());
            bg.dispose();
        }
        color.dispose();
        calendar.dispose();
    }

    @Test
    public void test_setForegroundAlphaCalendarDateTime() {
        DateTime calendar = new DateTime((Composite)this.shell, 1024);
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)calendar.getDisplay(), 255, 0, 0, 0);
        calendar.setForeground(color);
        Assert.assertEquals((Object)color, (Object)calendar.getForeground());
        Color bg = new Color((Device)calendar.getDisplay(), 0, 255, 0, 0);
        calendar.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)calendar.getForeground());
        color.dispose();
        bg.dispose();
        calendar.dispose();
    }

    @Test
    public void test_setForegroundTimeDateTime() {
        DateTime time = new DateTime((Composite)this.shell, 128);
        Color color = new Color((Device)time.getDisplay(), 255, 0, 0);
        time.setForeground(color);
        Assert.assertEquals((Object)color, (Object)time.getForeground());
        time.setForeground(null);
        Assert.assertFalse((boolean)time.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)time.getDisplay(), 0, 255, 0);
            time.setForeground(color);
            time.setBackground(bg);
            Assert.assertEquals((String)"Setting a background disrupted the foreground color for SWT.TIME DateTime", (Object)color, (Object)time.getForeground());
            Assert.assertEquals((String)"Setting a background onto an SWT.TIME DateTime with a foreground failed", (Object)bg, (Object)time.getBackground());
            bg.dispose();
        }
        color.dispose();
        time.dispose();
    }

    @Test
    public void test_setForegroundAlphaTimeDateTime() {
        DateTime time = new DateTime((Composite)this.shell, 128);
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)time.getDisplay(), 255, 0, 0, 0);
        time.setForeground(color);
        Assert.assertEquals((Object)color, (Object)time.getForeground());
        Color bg = new Color((Device)time.getDisplay(), 0, 255, 0, 0);
        time.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)time.getForeground());
        color.dispose();
        bg.dispose();
        time.dispose();
    }

    @Test
    public void test_setForegroundDateDateTime() {
        DateTime date = new DateTime((Composite)this.shell, 32);
        Color color = new Color((Device)date.getDisplay(), 255, 0, 0);
        date.setForeground(color);
        Assert.assertEquals((Object)color, (Object)date.getForeground());
        date.setForeground(null);
        Assert.assertFalse((boolean)date.getForeground().equals((Object)color));
        if ("gtk".equals(SWT.getPlatform())) {
            Color bg = new Color((Device)date.getDisplay(), 0, 255, 0);
            date.setForeground(color);
            date.setBackground(bg);
            Assert.assertEquals((String)"Setting a background disrupted the foreground color for SWT.DATE DateTime", (Object)color, (Object)date.getForeground());
            Assert.assertEquals((String)"Setting a background onto an SWT.DATE DateTime with a foreground failed", (Object)bg, (Object)date.getBackground());
            bg.dispose();
        }
        color.dispose();
        date.dispose();
    }

    @Test
    public void test_setForegroundAlphaDateDateTime() {
        DateTime date = new DateTime((Composite)this.shell, 32);
        Assume.assumeTrue((String)"Alpha support for foreground colors does not exist on GTK2 or Win32", (SwtTestUtil.isCocoa || SwtTestUtil.isGTK3() ? 1 : 0) != 0);
        Color color = new Color((Device)date.getDisplay(), 255, 0, 0, 0);
        date.setForeground(color);
        Assert.assertEquals((Object)color, (Object)date.getForeground());
        Color bg = new Color((Device)date.getDisplay(), 0, 255, 0, 0);
        date.setBackground(bg);
        Assert.assertEquals((Object)color, (Object)date.getForeground());
        color.dispose();
        bg.dispose();
        date.dispose();
    }

    @Test
    public void test_setHoursI() {
        this.datetime.setTime(2, 10, 30);
        this.datetime.setHours(21);
        Assert.assertEquals((long)21L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setHours(24);
        Assert.assertEquals((long)21L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setHours(-1);
        Assert.assertEquals((long)21L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
    }

    @Test
    public void test_setMinutesI() {
        this.datetime.setTime(2, 10, 30);
        this.datetime.setMinutes(22);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)22L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setMinutes(0);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)0L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setMinutes(59);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)59L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setMinutes(-1);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)59L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setMinutes(60);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)59L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
    }

    @Test
    public void test_setMonthI() {
        this.datetime.setDate(2008, 10, 1);
        this.datetime.setMonth(7);
        Assert.assertEquals((long)7L, (long)this.datetime.getMonth());
        this.datetime.setMonth(0);
        Assert.assertEquals((long)0L, (long)this.datetime.getMonth());
        this.datetime.setMonth(1);
        Assert.assertEquals((long)1L, (long)this.datetime.getMonth());
        this.datetime.setMonth(10);
        Assert.assertEquals((long)10L, (long)this.datetime.getMonth());
        this.datetime.setDate(2008, 10, 30);
        this.datetime.setMonth(1);
        Assert.assertEquals((long)10L, (long)this.datetime.getMonth());
        this.datetime.setDate(2008, 7, 31);
        this.datetime.setMonth(10);
        Assert.assertEquals((long)7L, (long)this.datetime.getMonth());
        this.datetime.setDate(2007, 10, 29);
        this.datetime.setMonth(1);
        Assert.assertEquals((long)10L, (long)this.datetime.getMonth());
    }

    @Test
    public void test_setSecondsI() {
        this.datetime.setTime(2, 10, 30);
        this.datetime.setSeconds(52);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)52L, (long)this.datetime.getSeconds());
        this.datetime.setSeconds(0);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)0L, (long)this.datetime.getSeconds());
        this.datetime.setSeconds(59);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
        this.datetime.setSeconds(-1);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
        this.datetime.setSeconds(60);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
    }

    @Test
    public void test_setTimeIII() {
        this.datetime.setTime(2, 10, 30);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setTime(0, 10, 30);
        Assert.assertEquals((long)0L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setTime(23, 10, 30);
        Assert.assertEquals((long)23L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 0, 30);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)0L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 59, 30);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)59L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)30L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 10, 0);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)0L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 10, 59);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
        this.datetime.setTime(29, 10, 30);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 73, 30);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
        this.datetime.setTime(2, 10, 95);
        Assert.assertEquals((long)2L, (long)this.datetime.getHours());
        Assert.assertEquals((long)10L, (long)this.datetime.getMinutes());
        Assert.assertEquals((long)59L, (long)this.datetime.getSeconds());
    }

    @Test
    public void test_setYearI() {
        this.datetime.setDate(2008, 10, 1);
        this.datetime.setYear(1947);
        Assert.assertEquals((long)1947L, (long)this.datetime.getYear());
        this.datetime.setYear(1752);
        Assert.assertEquals((long)1752L, (long)this.datetime.getYear());
        this.datetime.setYear(9999);
        Assert.assertEquals((long)9999L, (long)this.datetime.getYear());
        this.datetime.setYear(2005);
        Assert.assertEquals((long)2005L, (long)this.datetime.getYear());
        this.datetime.setYear(0);
        Assert.assertEquals((long)2005L, (long)this.datetime.getYear());
        this.datetime.setYear(-1947);
        Assert.assertEquals((long)2005L, (long)this.datetime.getYear());
        this.datetime.setDate(2008, 1, 29);
        this.datetime.setYear(2007);
        Assert.assertEquals((long)2008L, (long)this.datetime.getYear());
    }

    @Test
    public void test_removeSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
    }

    protected void setUp(int style) {
        super.setUp();
        this.datetime = new DateTime((Composite)this.shell, style);
        this.setWidget((Widget)this.datetime);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.consistencyEvent(10, 10, 3, 0, 30);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 3, 0, 30);
        this.tearDown();
        this.setUp(128);
        this.consistencyEvent(5, 5, 3, 0, 30);
        this.tearDown();
        this.setUp(1024);
        this.consistencyEvent(5, 5, 3, 0, 30);
    }

    @Test
    public void test_consistency_MouseSelection() {
        this.consistencyEvent(10, 10, 1, 0, 30);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 1, 0, 30);
        this.tearDown();
        this.setUp(128);
        this.consistencyEvent(5, 5, 1, 0, 30);
        this.tearDown();
        this.setUp(1024);
        this.consistencyEvent(5, 5, 1, 0, 30);
    }

    @Test
    public void test_consistency_EnterSelection() {
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(10, 13, 0, 0, 10);
        this.tearDown();
        this.setUp(128);
        this.consistencyEvent(10, 13, 0, 0, 10);
        this.tearDown();
        this.setUp(1024);
        this.consistencyEvent(10, 13, 0, 0, 10);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.consistencyEvent(10, 10, 20, 20, 50);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 15, 15, 50);
        this.tearDown();
        this.setUp(128);
        this.consistencyEvent(5, 5, 15, 15, 50);
        this.tearDown();
        this.setUp(1024);
        this.consistencyEvent(5, 5, 15, 15, 50);
    }
}

