/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Control;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Link
extends Test_org_eclipse_swt_widgets_Control {
    Link link;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.link = new Link((Composite)this.shell, 0);
        this.setWidget((Widget)this.link);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        this.link = new Link((Composite)this.shell, 0);
        this.link.dispose();
        this.link = new Link((Composite)this.shell, 0);
        this.link.dispose();
        this.link = new Link((Composite)this.shell, 2048);
        this.link.dispose();
        try {
            this.link = new Link(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Test_org_eclipse_swt_widgets_Link.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        try {
            this.link.addSelectionListener(null);
            Assert.fail((String)"No exception thrown for addSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.link.addSelectionListener(listener);
        this.link.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        try {
            this.link.removeSelectionListener(null);
            Assert.fail((String)"No exception thrown for removeSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.listenerCalled = false;
        this.link.removeSelectionListener(listener);
        this.link.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.link.addSelectionListener(listener);
        this.link.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.link.removeSelectionListener(listener);
        this.link.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
        this.link.computeSize(0, 0);
        this.link.computeSize(0, 0, false);
        this.link.computeSize(-10, -10);
        this.link.computeSize(-10, -10, false);
        this.link.computeSize(10, 10);
        this.link.computeSize(10, 10, false);
        this.link.computeSize(10000, 10000);
        this.link.computeSize(10000, 10000, false);
    }

    @Test
    public void test_setTextLjava_lang_String() {
        String[] cases = new String[]{"", "a", "aa", "aaaaaaaaaa", "a&", "&", "&a", "&a&", "&a", "&<a>", "<a>", "&a<a>", "<a></a>", "<a></a>&", "<a></a>a&", "<a></a>&a", "&a<a>a</a>&a", "&a<a>&a</a>&a", "Text <a href=\"url.com\">Link</a> text <A color=#212121>Link 2</A> ", "Text<a  \t   xxx=\"yyy  \"        id=\"ids\" href=\"HREF\"     >Link< /a>End", "Te&&xt &text && <a>L&ink</a> h&i <a>fe&&lipe</a> &l &end&&", "Text <a id=\"1\">Link</a> something <a href=\"bla bla2\" >Link2</a> somethingelse <a>Link3 large large</a>. some text to test this wrapping thing <A href=\"last\">this is suppose to be a very long link text the spraws over several lines in the text layout</a>.end", "The SWT component is designed to provide <A>efficient</A>, <A>portable</A> <A>access to the user-interface facilities of the operating systems</A> on which it is implemented.", "some text", "ldkashdoehufweovcnhslvhregojebckreavbkuhxbiufvcyhbifuyewvbiureyd.,cmnesljliewjfchvbwoifivbeworixuieurvbiuvbohflksjeahfcliureafgyciabelitvyrwtlicuyrtliureybcliuyreuceyvbliureybct", "\n \n \b \t ", "\u0000"};
        int i = 0;
        while (i < cases.length) {
            this.link.setText(cases[i]);
            Assert.assertEquals((Object)this.link.getText(), (Object)cases[i]);
            ++i;
        }
        try {
            this.link.setText(null);
            Assert.fail((String)"No exception thrown for text == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setLinkForegroundLorg_eclipse_swt_graphics_Color() {
        Assert.assertNotNull((Object)this.link.getLinkForeground());
        Color color = new Color((Device)this.control.getDisplay(), 12, 34, 56);
        this.link.setLinkForeground(color);
        Assert.assertEquals((Object)color, (Object)this.link.getLinkForeground());
        this.link.setLinkForeground(null);
        Assert.assertFalse((boolean)this.link.getForeground().equals((Object)color));
        color.dispose();
    }
}

