/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Widget;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_ScrollBar
extends Test_org_eclipse_swt_widgets_Widget {
    ScrollBar scrollBar;
    Canvas canvas;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.canvas = new Canvas((Composite)this.shell, 256);
        this.scrollBar = this.canvas.getHorizontalBar();
        this.canvas.setSize(100, 100);
        this.setWidget((Widget)this.scrollBar);
        this.shell.pack();
        this.shell.open();
    }

    protected String valueString(int[] intArray) {
        return " (" + intArray[1] + "," + intArray[2] + "," + intArray[3] + "," + intArray[4] + ")";
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        boolean exceptionThrown = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_widgets_ScrollBar.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        try {
            this.scrollBar.addSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.scrollBar.addSelectionListener(listener);
        this.scrollBar.setSelection(100);
        Assert.assertTrue((String)":a:", (!this.listenerCalled ? 1 : 0) != 0);
        this.scrollBar.removeSelectionListener(listener);
        try {
            this.scrollBar.removeSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.scrollBar.addSelectionListener(listener);
        this.scrollBar.setSelection(100);
        Assert.assertTrue((String)":a:", (!this.listenerCalled ? 1 : 0) != 0);
        this.scrollBar.removeSelectionListener(listener);
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.canvas, (Object)this.scrollBar.getParent());
    }

    @Test
    public void test_getSize() {
        Assert.assertTrue((this.scrollBar.getSize().x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scrollBar.getSize().y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_isEnabled() {
        this.scrollBar.setEnabled(true);
        Assert.assertTrue((boolean)this.scrollBar.isEnabled());
        this.scrollBar.setEnabled(false);
        Assert.assertTrue((!this.scrollBar.isEnabled() ? 1 : 0) != 0);
    }

    @Test
    public void test_isVisible() {
        this.scrollBar.setVisible(true);
        Assert.assertTrue((boolean)this.scrollBar.isVisible());
        this.scrollBar.setVisible(false);
        Assert.assertTrue((!this.scrollBar.isVisible() ? 1 : 0) != 0);
    }

    @Test
    public void test_setEnabledZ() {
        this.scrollBar.setEnabled(true);
        Assert.assertTrue((boolean)this.scrollBar.getEnabled());
        this.scrollBar.setEnabled(false);
        Assert.assertTrue((!this.scrollBar.getEnabled() ? 1 : 0) != 0);
    }

    @Test
    public void test_setIncrementI() {
        int[] cases = new int[]{1, 10, 10000};
        int i = 0;
        while (i < cases.length) {
            this.scrollBar.setIncrement(cases[i]);
            Assert.assertEquals((long)cases[i], (long)this.scrollBar.getIncrement());
            ++i;
        }
        this.scrollBar.setIncrement(25);
        this.scrollBar.setIncrement(0);
        Assert.assertEquals((long)25L, (long)this.scrollBar.getIncrement());
    }

    @Test
    public void test_setMaximumI() {
        int[][] testValues = this.getSetMaximumValues();
        int i = 0;
        while (i < testValues.length) {
            int[] intArray = testValues[i];
            this.setDefaults();
            this.scrollBar.setMaximum(intArray[0]);
            String valueString = this.valueString(intArray);
            this.report("setMax " + intArray[0] + valueString, intArray[0], intArray[1], intArray[2], intArray[3], intArray[4]);
            ++i;
        }
    }

    @Test
    public void test_setMinimumI() {
        int[][] testValues = this.getSetMinimumValues();
        int i = 0;
        while (i < testValues.length) {
            int[] intArray = testValues[i];
            this.setDefaults();
            this.scrollBar.setMinimum(intArray[0]);
            String valueString = this.valueString(intArray);
            this.report("setMin " + intArray[0] + valueString, intArray[0], intArray[1], intArray[2], intArray[3], intArray[4]);
            ++i;
        }
    }

    @Test
    public void test_setPageIncrementI() {
        int[] cases = new int[]{1, 10, 10000};
        int i = 0;
        while (i < cases.length) {
            this.scrollBar.setPageIncrement(cases[i]);
            Assert.assertEquals((long)this.scrollBar.getPageIncrement(), (long)cases[i]);
            ++i;
        }
        this.scrollBar.setPageIncrement(25);
        this.scrollBar.setPageIncrement(0);
        Assert.assertEquals((long)25L, (long)this.scrollBar.getPageIncrement());
    }

    @Test
    public void test_setSelectionI() {
        int[][] testValues = this.getSetSelectionValues();
        int i = 0;
        while (i < testValues.length) {
            int[] intArray = testValues[i];
            this.setDefaults();
            this.scrollBar.setSelection(intArray[0]);
            String valueString = this.valueString(intArray);
            this.report("setSel " + intArray[0] + valueString, intArray[0], intArray[1], intArray[2], intArray[3], intArray[4]);
            ++i;
        }
    }

    @Test
    public void test_setThumbI() {
        int[][] testValues = this.getSetThumbValues();
        int i = 0;
        while (i < testValues.length) {
            int[] intArray = testValues[i];
            this.setDefaults();
            this.scrollBar.setThumb(intArray[0]);
            String valueString = this.valueString(intArray);
            this.report("setThmb " + intArray[0] + valueString, intArray[0], intArray[1], intArray[2], intArray[3], intArray[4]);
            ++i;
        }
    }

    @Test
    public void test_setValuesIIIIII() {
        this.scrollBar.setValues(10, 10, 50, 2, 5, 10);
        Assert.assertTrue((String)":a:", (this.scrollBar.getSelection() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (this.scrollBar.getMinimum() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (this.scrollBar.getMaximum() == 50 ? 1 : 0) != 0);
        Assert.assertTrue((String)":d:", (this.scrollBar.getThumb() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)":e:", (this.scrollBar.getIncrement() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)":f:", (this.scrollBar.getPageIncrement() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_setVisibleZ() {
        this.scrollBar.setVisible(true);
        Assert.assertTrue((boolean)this.scrollBar.getVisible());
        this.scrollBar.setVisible(false);
        Assert.assertTrue((!this.scrollBar.getVisible() ? 1 : 0) != 0);
    }

    private void report(String call, int set, int minExpected, int maxExpected, int selectionExpected, int thumbExpected) {
        this.check(call, minExpected, maxExpected, selectionExpected, thumbExpected);
    }

    private void check(String call, int minExpected, int maxExpected, int selectionExpected, int thumbExpected) {
        Assert.assertEquals((String)(String.valueOf(call) + " max "), (long)maxExpected, (long)this.scrollBar.getMaximum());
        Assert.assertEquals((String)(String.valueOf(call) + " min "), (long)minExpected, (long)this.scrollBar.getMinimum());
        Assert.assertEquals((String)(String.valueOf(call) + " sel "), (long)selectionExpected, (long)this.scrollBar.getSelection());
        Assert.assertEquals((String)(String.valueOf(call) + " thmb "), (long)thumbExpected, (long)this.scrollBar.getThumb());
    }

    private int[][] getSetThumbValues() {
        int[][] nArrayArray = new int[140][];
        nArrayArray[0] = new int[]{-15, 10, 100, 50, 10};
        nArrayArray[1] = new int[]{-14, 10, 100, 50, 10};
        nArrayArray[2] = new int[]{-13, 10, 100, 50, 10};
        nArrayArray[3] = new int[]{-12, 10, 100, 50, 10};
        nArrayArray[4] = new int[]{-11, 10, 100, 50, 10};
        nArrayArray[5] = new int[]{-10, 10, 100, 50, 10};
        nArrayArray[6] = new int[]{-9, 10, 100, 50, 10};
        nArrayArray[7] = new int[]{-8, 10, 100, 50, 10};
        nArrayArray[8] = new int[]{-7, 10, 100, 50, 10};
        nArrayArray[9] = new int[]{-6, 10, 100, 50, 10};
        nArrayArray[10] = new int[]{-5, 10, 100, 50, 10};
        nArrayArray[11] = new int[]{-4, 10, 100, 50, 10};
        nArrayArray[12] = new int[]{-3, 10, 100, 50, 10};
        nArrayArray[13] = new int[]{-2, 10, 100, 50, 10};
        nArrayArray[14] = new int[]{-1, 10, 100, 50, 10};
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 100;
        nArray[3] = 50;
        nArray[4] = 10;
        nArrayArray[15] = nArray;
        nArrayArray[16] = new int[]{1, 10, 100, 50, 1};
        nArrayArray[17] = new int[]{2, 10, 100, 50, 2};
        nArrayArray[18] = new int[]{3, 10, 100, 50, 3};
        nArrayArray[19] = new int[]{4, 10, 100, 50, 4};
        nArrayArray[20] = new int[]{5, 10, 100, 50, 5};
        nArrayArray[21] = new int[]{6, 10, 100, 50, 6};
        nArrayArray[22] = new int[]{7, 10, 100, 50, 7};
        nArrayArray[23] = new int[]{8, 10, 100, 50, 8};
        nArrayArray[24] = new int[]{9, 10, 100, 50, 9};
        nArrayArray[25] = new int[]{10, 10, 100, 50, 10};
        nArrayArray[26] = new int[]{11, 10, 100, 50, 11};
        nArrayArray[27] = new int[]{12, 10, 100, 50, 12};
        nArrayArray[28] = new int[]{13, 10, 100, 50, 13};
        nArrayArray[29] = new int[]{14, 10, 100, 50, 14};
        nArrayArray[30] = new int[]{15, 10, 100, 50, 15};
        nArrayArray[31] = new int[]{16, 10, 100, 50, 16};
        nArrayArray[32] = new int[]{17, 10, 100, 50, 17};
        nArrayArray[33] = new int[]{18, 10, 100, 50, 18};
        nArrayArray[34] = new int[]{19, 10, 100, 50, 19};
        nArrayArray[35] = new int[]{20, 10, 100, 50, 20};
        nArrayArray[36] = new int[]{21, 10, 100, 50, 21};
        nArrayArray[37] = new int[]{22, 10, 100, 50, 22};
        nArrayArray[38] = new int[]{23, 10, 100, 50, 23};
        nArrayArray[39] = new int[]{24, 10, 100, 50, 24};
        nArrayArray[40] = new int[]{25, 10, 100, 50, 25};
        nArrayArray[41] = new int[]{26, 10, 100, 50, 26};
        nArrayArray[42] = new int[]{27, 10, 100, 50, 27};
        nArrayArray[43] = new int[]{28, 10, 100, 50, 28};
        nArrayArray[44] = new int[]{29, 10, 100, 50, 29};
        nArrayArray[45] = new int[]{30, 10, 100, 50, 30};
        nArrayArray[46] = new int[]{31, 10, 100, 50, 31};
        nArrayArray[47] = new int[]{32, 10, 100, 50, 32};
        nArrayArray[48] = new int[]{33, 10, 100, 50, 33};
        nArrayArray[49] = new int[]{34, 10, 100, 50, 34};
        nArrayArray[50] = new int[]{35, 10, 100, 50, 35};
        nArrayArray[51] = new int[]{36, 10, 100, 50, 36};
        nArrayArray[52] = new int[]{37, 10, 100, 50, 37};
        nArrayArray[53] = new int[]{38, 10, 100, 50, 38};
        nArrayArray[54] = new int[]{39, 10, 100, 50, 39};
        nArrayArray[55] = new int[]{40, 10, 100, 50, 40};
        nArrayArray[56] = new int[]{41, 10, 100, 50, 41};
        nArrayArray[57] = new int[]{42, 10, 100, 50, 42};
        nArrayArray[58] = new int[]{43, 10, 100, 50, 43};
        nArrayArray[59] = new int[]{44, 10, 100, 50, 44};
        nArrayArray[60] = new int[]{45, 10, 100, 50, 45};
        nArrayArray[61] = new int[]{46, 10, 100, 50, 46};
        nArrayArray[62] = new int[]{47, 10, 100, 50, 47};
        nArrayArray[63] = new int[]{48, 10, 100, 50, 48};
        nArrayArray[64] = new int[]{49, 10, 100, 50, 49};
        nArrayArray[65] = new int[]{50, 10, 100, 50, 50};
        nArrayArray[66] = new int[]{51, 10, 100, 49, 51};
        nArrayArray[67] = new int[]{52, 10, 100, 48, 52};
        nArrayArray[68] = new int[]{53, 10, 100, 47, 53};
        nArrayArray[69] = new int[]{54, 10, 100, 46, 54};
        nArrayArray[70] = new int[]{55, 10, 100, 45, 55};
        nArrayArray[71] = new int[]{56, 10, 100, 44, 56};
        nArrayArray[72] = new int[]{57, 10, 100, 43, 57};
        nArrayArray[73] = new int[]{58, 10, 100, 42, 58};
        nArrayArray[74] = new int[]{59, 10, 100, 41, 59};
        nArrayArray[75] = new int[]{60, 10, 100, 40, 60};
        nArrayArray[76] = new int[]{61, 10, 100, 39, 61};
        nArrayArray[77] = new int[]{62, 10, 100, 38, 62};
        nArrayArray[78] = new int[]{63, 10, 100, 37, 63};
        nArrayArray[79] = new int[]{64, 10, 100, 36, 64};
        nArrayArray[80] = new int[]{65, 10, 100, 35, 65};
        nArrayArray[81] = new int[]{66, 10, 100, 34, 66};
        nArrayArray[82] = new int[]{67, 10, 100, 33, 67};
        nArrayArray[83] = new int[]{68, 10, 100, 32, 68};
        nArrayArray[84] = new int[]{69, 10, 100, 31, 69};
        nArrayArray[85] = new int[]{70, 10, 100, 30, 70};
        nArrayArray[86] = new int[]{71, 10, 100, 29, 71};
        nArrayArray[87] = new int[]{72, 10, 100, 28, 72};
        nArrayArray[88] = new int[]{73, 10, 100, 27, 73};
        nArrayArray[89] = new int[]{74, 10, 100, 26, 74};
        nArrayArray[90] = new int[]{75, 10, 100, 25, 75};
        nArrayArray[91] = new int[]{76, 10, 100, 24, 76};
        nArrayArray[92] = new int[]{77, 10, 100, 23, 77};
        nArrayArray[93] = new int[]{78, 10, 100, 22, 78};
        nArrayArray[94] = new int[]{79, 10, 100, 21, 79};
        nArrayArray[95] = new int[]{80, 10, 100, 20, 80};
        nArrayArray[96] = new int[]{81, 10, 100, 19, 81};
        nArrayArray[97] = new int[]{82, 10, 100, 18, 82};
        nArrayArray[98] = new int[]{83, 10, 100, 17, 83};
        nArrayArray[99] = new int[]{84, 10, 100, 16, 84};
        nArrayArray[100] = new int[]{85, 10, 100, 15, 85};
        nArrayArray[101] = new int[]{86, 10, 100, 14, 86};
        nArrayArray[102] = new int[]{87, 10, 100, 13, 87};
        nArrayArray[103] = new int[]{88, 10, 100, 12, 88};
        nArrayArray[104] = new int[]{89, 10, 100, 11, 89};
        nArrayArray[105] = new int[]{90, 10, 100, 10, 90};
        nArrayArray[106] = new int[]{91, 10, 100, 10, 90};
        nArrayArray[107] = new int[]{92, 10, 100, 10, 90};
        nArrayArray[108] = new int[]{93, 10, 100, 10, 90};
        nArrayArray[109] = new int[]{94, 10, 100, 10, 90};
        nArrayArray[110] = new int[]{95, 10, 100, 10, 90};
        nArrayArray[111] = new int[]{96, 10, 100, 10, 90};
        nArrayArray[112] = new int[]{97, 10, 100, 10, 90};
        nArrayArray[113] = new int[]{98, 10, 100, 10, 90};
        nArrayArray[114] = new int[]{99, 10, 100, 10, 90};
        nArrayArray[115] = new int[]{100, 10, 100, 10, 90};
        nArrayArray[116] = new int[]{101, 10, 100, 10, 90};
        nArrayArray[117] = new int[]{102, 10, 100, 10, 90};
        nArrayArray[118] = new int[]{103, 10, 100, 10, 90};
        nArrayArray[119] = new int[]{104, 10, 100, 10, 90};
        nArrayArray[120] = new int[]{105, 10, 100, 10, 90};
        nArrayArray[121] = new int[]{106, 10, 100, 10, 90};
        nArrayArray[122] = new int[]{107, 10, 100, 10, 90};
        nArrayArray[123] = new int[]{108, 10, 100, 10, 90};
        nArrayArray[124] = new int[]{109, 10, 100, 10, 90};
        nArrayArray[125] = new int[]{110, 10, 100, 10, 90};
        nArrayArray[126] = new int[]{111, 10, 100, 10, 90};
        nArrayArray[127] = new int[]{112, 10, 100, 10, 90};
        nArrayArray[128] = new int[]{113, 10, 100, 10, 90};
        nArrayArray[129] = new int[]{114, 10, 100, 10, 90};
        nArrayArray[130] = new int[]{115, 10, 100, 10, 90};
        nArrayArray[131] = new int[]{116, 10, 100, 10, 90};
        nArrayArray[132] = new int[]{117, 10, 100, 10, 90};
        nArrayArray[133] = new int[]{118, 10, 100, 10, 90};
        nArrayArray[134] = new int[]{119, 10, 100, 10, 90};
        nArrayArray[135] = new int[]{120, 10, 100, 10, 90};
        nArrayArray[136] = new int[]{121, 10, 100, 10, 90};
        nArrayArray[137] = new int[]{122, 10, 100, 10, 90};
        nArrayArray[138] = new int[]{123, 10, 100, 10, 90};
        nArrayArray[139] = new int[]{124, 10, 100, 10, 90};
        return nArrayArray;
    }

    private int[][] getSetMinimumValues() {
        int[][] nArrayArray = new int[140][];
        nArrayArray[0] = new int[]{-15, 10, 100, 50, 10};
        nArrayArray[1] = new int[]{-14, 10, 100, 50, 10};
        nArrayArray[2] = new int[]{-13, 10, 100, 50, 10};
        nArrayArray[3] = new int[]{-12, 10, 100, 50, 10};
        nArrayArray[4] = new int[]{-11, 10, 100, 50, 10};
        nArrayArray[5] = new int[]{-10, 10, 100, 50, 10};
        nArrayArray[6] = new int[]{-9, 10, 100, 50, 10};
        nArrayArray[7] = new int[]{-8, 10, 100, 50, 10};
        nArrayArray[8] = new int[]{-7, 10, 100, 50, 10};
        nArrayArray[9] = new int[]{-6, 10, 100, 50, 10};
        nArrayArray[10] = new int[]{-5, 10, 100, 50, 10};
        nArrayArray[11] = new int[]{-4, 10, 100, 50, 10};
        nArrayArray[12] = new int[]{-3, 10, 100, 50, 10};
        nArrayArray[13] = new int[]{-2, 10, 100, 50, 10};
        nArrayArray[14] = new int[]{-1, 10, 100, 50, 10};
        int[] nArray = new int[5];
        nArray[2] = 100;
        nArray[3] = 50;
        nArray[4] = 10;
        nArrayArray[15] = nArray;
        nArrayArray[16] = new int[]{1, 1, 100, 50, 10};
        nArrayArray[17] = new int[]{2, 2, 100, 50, 10};
        nArrayArray[18] = new int[]{3, 3, 100, 50, 10};
        nArrayArray[19] = new int[]{4, 4, 100, 50, 10};
        nArrayArray[20] = new int[]{5, 5, 100, 50, 10};
        nArrayArray[21] = new int[]{6, 6, 100, 50, 10};
        nArrayArray[22] = new int[]{7, 7, 100, 50, 10};
        nArrayArray[23] = new int[]{8, 8, 100, 50, 10};
        nArrayArray[24] = new int[]{9, 9, 100, 50, 10};
        nArrayArray[25] = new int[]{10, 10, 100, 50, 10};
        nArrayArray[26] = new int[]{11, 11, 100, 50, 10};
        nArrayArray[27] = new int[]{12, 12, 100, 50, 10};
        nArrayArray[28] = new int[]{13, 13, 100, 50, 10};
        nArrayArray[29] = new int[]{14, 14, 100, 50, 10};
        nArrayArray[30] = new int[]{15, 15, 100, 50, 10};
        nArrayArray[31] = new int[]{16, 16, 100, 50, 10};
        nArrayArray[32] = new int[]{17, 17, 100, 50, 10};
        nArrayArray[33] = new int[]{18, 18, 100, 50, 10};
        nArrayArray[34] = new int[]{19, 19, 100, 50, 10};
        nArrayArray[35] = new int[]{20, 20, 100, 50, 10};
        nArrayArray[36] = new int[]{21, 21, 100, 50, 10};
        nArrayArray[37] = new int[]{22, 22, 100, 50, 10};
        nArrayArray[38] = new int[]{23, 23, 100, 50, 10};
        nArrayArray[39] = new int[]{24, 24, 100, 50, 10};
        nArrayArray[40] = new int[]{25, 25, 100, 50, 10};
        nArrayArray[41] = new int[]{26, 26, 100, 50, 10};
        nArrayArray[42] = new int[]{27, 27, 100, 50, 10};
        nArrayArray[43] = new int[]{28, 28, 100, 50, 10};
        nArrayArray[44] = new int[]{29, 29, 100, 50, 10};
        nArrayArray[45] = new int[]{30, 30, 100, 50, 10};
        nArrayArray[46] = new int[]{31, 31, 100, 50, 10};
        nArrayArray[47] = new int[]{32, 32, 100, 50, 10};
        nArrayArray[48] = new int[]{33, 33, 100, 50, 10};
        nArrayArray[49] = new int[]{34, 34, 100, 50, 10};
        nArrayArray[50] = new int[]{35, 35, 100, 50, 10};
        nArrayArray[51] = new int[]{36, 36, 100, 50, 10};
        nArrayArray[52] = new int[]{37, 37, 100, 50, 10};
        nArrayArray[53] = new int[]{38, 38, 100, 50, 10};
        nArrayArray[54] = new int[]{39, 39, 100, 50, 10};
        nArrayArray[55] = new int[]{40, 40, 100, 50, 10};
        nArrayArray[56] = new int[]{41, 41, 100, 50, 10};
        nArrayArray[57] = new int[]{42, 42, 100, 50, 10};
        nArrayArray[58] = new int[]{43, 43, 100, 50, 10};
        nArrayArray[59] = new int[]{44, 44, 100, 50, 10};
        nArrayArray[60] = new int[]{45, 45, 100, 50, 10};
        nArrayArray[61] = new int[]{46, 46, 100, 50, 10};
        nArrayArray[62] = new int[]{47, 47, 100, 50, 10};
        nArrayArray[63] = new int[]{48, 48, 100, 50, 10};
        nArrayArray[64] = new int[]{49, 49, 100, 50, 10};
        nArrayArray[65] = new int[]{50, 50, 100, 50, 10};
        nArrayArray[66] = new int[]{51, 51, 100, 51, 10};
        nArrayArray[67] = new int[]{52, 52, 100, 52, 10};
        nArrayArray[68] = new int[]{53, 53, 100, 53, 10};
        nArrayArray[69] = new int[]{54, 54, 100, 54, 10};
        nArrayArray[70] = new int[]{55, 55, 100, 55, 10};
        nArrayArray[71] = new int[]{56, 56, 100, 56, 10};
        nArrayArray[72] = new int[]{57, 57, 100, 57, 10};
        nArrayArray[73] = new int[]{58, 58, 100, 58, 10};
        nArrayArray[74] = new int[]{59, 59, 100, 59, 10};
        nArrayArray[75] = new int[]{60, 60, 100, 60, 10};
        nArrayArray[76] = new int[]{61, 61, 100, 61, 10};
        nArrayArray[77] = new int[]{62, 62, 100, 62, 10};
        nArrayArray[78] = new int[]{63, 63, 100, 63, 10};
        nArrayArray[79] = new int[]{64, 64, 100, 64, 10};
        nArrayArray[80] = new int[]{65, 65, 100, 65, 10};
        nArrayArray[81] = new int[]{66, 66, 100, 66, 10};
        nArrayArray[82] = new int[]{67, 67, 100, 67, 10};
        nArrayArray[83] = new int[]{68, 68, 100, 68, 10};
        nArrayArray[84] = new int[]{69, 69, 100, 69, 10};
        nArrayArray[85] = new int[]{70, 70, 100, 70, 10};
        nArrayArray[86] = new int[]{71, 71, 100, 71, 10};
        nArrayArray[87] = new int[]{72, 72, 100, 72, 10};
        nArrayArray[88] = new int[]{73, 73, 100, 73, 10};
        nArrayArray[89] = new int[]{74, 74, 100, 74, 10};
        nArrayArray[90] = new int[]{75, 75, 100, 75, 10};
        nArrayArray[91] = new int[]{76, 76, 100, 76, 10};
        nArrayArray[92] = new int[]{77, 77, 100, 77, 10};
        nArrayArray[93] = new int[]{78, 78, 100, 78, 10};
        nArrayArray[94] = new int[]{79, 79, 100, 79, 10};
        nArrayArray[95] = new int[]{80, 80, 100, 80, 10};
        nArrayArray[96] = new int[]{81, 81, 100, 81, 10};
        nArrayArray[97] = new int[]{82, 82, 100, 82, 10};
        nArrayArray[98] = new int[]{83, 83, 100, 83, 10};
        nArrayArray[99] = new int[]{84, 84, 100, 84, 10};
        nArrayArray[100] = new int[]{85, 85, 100, 85, 10};
        nArrayArray[101] = new int[]{86, 86, 100, 86, 10};
        nArrayArray[102] = new int[]{87, 87, 100, 87, 10};
        nArrayArray[103] = new int[]{88, 88, 100, 88, 10};
        nArrayArray[104] = new int[]{89, 89, 100, 89, 10};
        nArrayArray[105] = new int[]{90, 90, 100, 90, 10};
        nArrayArray[106] = new int[]{91, 91, 100, 91, 9};
        nArrayArray[107] = new int[]{92, 92, 100, 92, 8};
        nArrayArray[108] = new int[]{93, 93, 100, 93, 7};
        nArrayArray[109] = new int[]{94, 94, 100, 94, 6};
        nArrayArray[110] = new int[]{95, 95, 100, 95, 5};
        nArrayArray[111] = new int[]{96, 96, 100, 96, 4};
        nArrayArray[112] = new int[]{97, 97, 100, 97, 3};
        nArrayArray[113] = new int[]{98, 98, 100, 98, 2};
        nArrayArray[114] = new int[]{99, 99, 100, 99, 1};
        nArrayArray[115] = new int[]{100, 10, 100, 50, 10};
        nArrayArray[116] = new int[]{101, 10, 100, 50, 10};
        nArrayArray[117] = new int[]{102, 10, 100, 50, 10};
        nArrayArray[118] = new int[]{103, 10, 100, 50, 10};
        nArrayArray[119] = new int[]{104, 10, 100, 50, 10};
        nArrayArray[120] = new int[]{105, 10, 100, 50, 10};
        nArrayArray[121] = new int[]{106, 10, 100, 50, 10};
        nArrayArray[122] = new int[]{107, 10, 100, 50, 10};
        nArrayArray[123] = new int[]{108, 10, 100, 50, 10};
        nArrayArray[124] = new int[]{109, 10, 100, 50, 10};
        nArrayArray[125] = new int[]{110, 10, 100, 50, 10};
        nArrayArray[126] = new int[]{111, 10, 100, 50, 10};
        nArrayArray[127] = new int[]{112, 10, 100, 50, 10};
        nArrayArray[128] = new int[]{113, 10, 100, 50, 10};
        nArrayArray[129] = new int[]{114, 10, 100, 50, 10};
        nArrayArray[130] = new int[]{115, 10, 100, 50, 10};
        nArrayArray[131] = new int[]{116, 10, 100, 50, 10};
        nArrayArray[132] = new int[]{117, 10, 100, 50, 10};
        nArrayArray[133] = new int[]{118, 10, 100, 50, 10};
        nArrayArray[134] = new int[]{119, 10, 100, 50, 10};
        nArrayArray[135] = new int[]{120, 10, 100, 50, 10};
        nArrayArray[136] = new int[]{121, 10, 100, 50, 10};
        nArrayArray[137] = new int[]{122, 10, 100, 50, 10};
        nArrayArray[138] = new int[]{123, 10, 100, 50, 10};
        nArrayArray[139] = new int[]{124, 10, 100, 50, 10};
        return nArrayArray;
    }

    private int[][] getSetMaximumValues() {
        int[][] nArrayArray = new int[140][];
        nArrayArray[0] = new int[]{-15, 10, 100, 50, 10};
        nArrayArray[1] = new int[]{-14, 10, 100, 50, 10};
        nArrayArray[2] = new int[]{-13, 10, 100, 50, 10};
        nArrayArray[3] = new int[]{-12, 10, 100, 50, 10};
        nArrayArray[4] = new int[]{-11, 10, 100, 50, 10};
        nArrayArray[5] = new int[]{-10, 10, 100, 50, 10};
        nArrayArray[6] = new int[]{-9, 10, 100, 50, 10};
        nArrayArray[7] = new int[]{-8, 10, 100, 50, 10};
        nArrayArray[8] = new int[]{-7, 10, 100, 50, 10};
        nArrayArray[9] = new int[]{-6, 10, 100, 50, 10};
        nArrayArray[10] = new int[]{-5, 10, 100, 50, 10};
        nArrayArray[11] = new int[]{-4, 10, 100, 50, 10};
        nArrayArray[12] = new int[]{-3, 10, 100, 50, 10};
        nArrayArray[13] = new int[]{-2, 10, 100, 50, 10};
        nArrayArray[14] = new int[]{-1, 10, 100, 50, 10};
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 100;
        nArray[3] = 50;
        nArray[4] = 10;
        nArrayArray[15] = nArray;
        nArrayArray[16] = new int[]{1, 10, 100, 50, 10};
        nArrayArray[17] = new int[]{2, 10, 100, 50, 10};
        nArrayArray[18] = new int[]{3, 10, 100, 50, 10};
        nArrayArray[19] = new int[]{4, 10, 100, 50, 10};
        nArrayArray[20] = new int[]{5, 10, 100, 50, 10};
        nArrayArray[21] = new int[]{6, 10, 100, 50, 10};
        nArrayArray[22] = new int[]{7, 10, 100, 50, 10};
        nArrayArray[23] = new int[]{8, 10, 100, 50, 10};
        nArrayArray[24] = new int[]{9, 10, 100, 50, 10};
        nArrayArray[25] = new int[]{10, 10, 100, 50, 10};
        nArrayArray[26] = new int[]{11, 10, 11, 10, 1};
        nArrayArray[27] = new int[]{12, 10, 12, 10, 2};
        nArrayArray[28] = new int[]{13, 10, 13, 10, 3};
        nArrayArray[29] = new int[]{14, 10, 14, 10, 4};
        nArrayArray[30] = new int[]{15, 10, 15, 10, 5};
        nArrayArray[31] = new int[]{16, 10, 16, 10, 6};
        nArrayArray[32] = new int[]{17, 10, 17, 10, 7};
        nArrayArray[33] = new int[]{18, 10, 18, 10, 8};
        nArrayArray[34] = new int[]{19, 10, 19, 10, 9};
        nArrayArray[35] = new int[]{20, 10, 20, 10, 10};
        nArrayArray[36] = new int[]{21, 10, 21, 11, 10};
        nArrayArray[37] = new int[]{22, 10, 22, 12, 10};
        nArrayArray[38] = new int[]{23, 10, 23, 13, 10};
        nArrayArray[39] = new int[]{24, 10, 24, 14, 10};
        nArrayArray[40] = new int[]{25, 10, 25, 15, 10};
        nArrayArray[41] = new int[]{26, 10, 26, 16, 10};
        nArrayArray[42] = new int[]{27, 10, 27, 17, 10};
        nArrayArray[43] = new int[]{28, 10, 28, 18, 10};
        nArrayArray[44] = new int[]{29, 10, 29, 19, 10};
        nArrayArray[45] = new int[]{30, 10, 30, 20, 10};
        nArrayArray[46] = new int[]{31, 10, 31, 21, 10};
        nArrayArray[47] = new int[]{32, 10, 32, 22, 10};
        nArrayArray[48] = new int[]{33, 10, 33, 23, 10};
        nArrayArray[49] = new int[]{34, 10, 34, 24, 10};
        nArrayArray[50] = new int[]{35, 10, 35, 25, 10};
        nArrayArray[51] = new int[]{36, 10, 36, 26, 10};
        nArrayArray[52] = new int[]{37, 10, 37, 27, 10};
        nArrayArray[53] = new int[]{38, 10, 38, 28, 10};
        nArrayArray[54] = new int[]{39, 10, 39, 29, 10};
        nArrayArray[55] = new int[]{40, 10, 40, 30, 10};
        nArrayArray[56] = new int[]{41, 10, 41, 31, 10};
        nArrayArray[57] = new int[]{42, 10, 42, 32, 10};
        nArrayArray[58] = new int[]{43, 10, 43, 33, 10};
        nArrayArray[59] = new int[]{44, 10, 44, 34, 10};
        nArrayArray[60] = new int[]{45, 10, 45, 35, 10};
        nArrayArray[61] = new int[]{46, 10, 46, 36, 10};
        nArrayArray[62] = new int[]{47, 10, 47, 37, 10};
        nArrayArray[63] = new int[]{48, 10, 48, 38, 10};
        nArrayArray[64] = new int[]{49, 10, 49, 39, 10};
        nArrayArray[65] = new int[]{50, 10, 50, 40, 10};
        nArrayArray[66] = new int[]{51, 10, 51, 41, 10};
        nArrayArray[67] = new int[]{52, 10, 52, 42, 10};
        nArrayArray[68] = new int[]{53, 10, 53, 43, 10};
        nArrayArray[69] = new int[]{54, 10, 54, 44, 10};
        nArrayArray[70] = new int[]{55, 10, 55, 45, 10};
        nArrayArray[71] = new int[]{56, 10, 56, 46, 10};
        nArrayArray[72] = new int[]{57, 10, 57, 47, 10};
        nArrayArray[73] = new int[]{58, 10, 58, 48, 10};
        nArrayArray[74] = new int[]{59, 10, 59, 49, 10};
        nArrayArray[75] = new int[]{60, 10, 60, 50, 10};
        nArrayArray[76] = new int[]{61, 10, 61, 50, 10};
        nArrayArray[77] = new int[]{62, 10, 62, 50, 10};
        nArrayArray[78] = new int[]{63, 10, 63, 50, 10};
        nArrayArray[79] = new int[]{64, 10, 64, 50, 10};
        nArrayArray[80] = new int[]{65, 10, 65, 50, 10};
        nArrayArray[81] = new int[]{66, 10, 66, 50, 10};
        nArrayArray[82] = new int[]{67, 10, 67, 50, 10};
        nArrayArray[83] = new int[]{68, 10, 68, 50, 10};
        nArrayArray[84] = new int[]{69, 10, 69, 50, 10};
        nArrayArray[85] = new int[]{70, 10, 70, 50, 10};
        nArrayArray[86] = new int[]{71, 10, 71, 50, 10};
        nArrayArray[87] = new int[]{72, 10, 72, 50, 10};
        nArrayArray[88] = new int[]{73, 10, 73, 50, 10};
        nArrayArray[89] = new int[]{74, 10, 74, 50, 10};
        nArrayArray[90] = new int[]{75, 10, 75, 50, 10};
        nArrayArray[91] = new int[]{76, 10, 76, 50, 10};
        nArrayArray[92] = new int[]{77, 10, 77, 50, 10};
        nArrayArray[93] = new int[]{78, 10, 78, 50, 10};
        nArrayArray[94] = new int[]{79, 10, 79, 50, 10};
        nArrayArray[95] = new int[]{80, 10, 80, 50, 10};
        nArrayArray[96] = new int[]{81, 10, 81, 50, 10};
        nArrayArray[97] = new int[]{82, 10, 82, 50, 10};
        nArrayArray[98] = new int[]{83, 10, 83, 50, 10};
        nArrayArray[99] = new int[]{84, 10, 84, 50, 10};
        nArrayArray[100] = new int[]{85, 10, 85, 50, 10};
        nArrayArray[101] = new int[]{86, 10, 86, 50, 10};
        nArrayArray[102] = new int[]{87, 10, 87, 50, 10};
        nArrayArray[103] = new int[]{88, 10, 88, 50, 10};
        nArrayArray[104] = new int[]{89, 10, 89, 50, 10};
        nArrayArray[105] = new int[]{90, 10, 90, 50, 10};
        nArrayArray[106] = new int[]{91, 10, 91, 50, 10};
        nArrayArray[107] = new int[]{92, 10, 92, 50, 10};
        nArrayArray[108] = new int[]{93, 10, 93, 50, 10};
        nArrayArray[109] = new int[]{94, 10, 94, 50, 10};
        nArrayArray[110] = new int[]{95, 10, 95, 50, 10};
        nArrayArray[111] = new int[]{96, 10, 96, 50, 10};
        nArrayArray[112] = new int[]{97, 10, 97, 50, 10};
        nArrayArray[113] = new int[]{98, 10, 98, 50, 10};
        nArrayArray[114] = new int[]{99, 10, 99, 50, 10};
        nArrayArray[115] = new int[]{100, 10, 100, 50, 10};
        nArrayArray[116] = new int[]{101, 10, 101, 50, 10};
        nArrayArray[117] = new int[]{102, 10, 102, 50, 10};
        nArrayArray[118] = new int[]{103, 10, 103, 50, 10};
        nArrayArray[119] = new int[]{104, 10, 104, 50, 10};
        nArrayArray[120] = new int[]{105, 10, 105, 50, 10};
        nArrayArray[121] = new int[]{106, 10, 106, 50, 10};
        nArrayArray[122] = new int[]{107, 10, 107, 50, 10};
        nArrayArray[123] = new int[]{108, 10, 108, 50, 10};
        nArrayArray[124] = new int[]{109, 10, 109, 50, 10};
        nArrayArray[125] = new int[]{110, 10, 110, 50, 10};
        nArrayArray[126] = new int[]{111, 10, 111, 50, 10};
        nArrayArray[127] = new int[]{112, 10, 112, 50, 10};
        nArrayArray[128] = new int[]{113, 10, 113, 50, 10};
        nArrayArray[129] = new int[]{114, 10, 114, 50, 10};
        nArrayArray[130] = new int[]{115, 10, 115, 50, 10};
        nArrayArray[131] = new int[]{116, 10, 116, 50, 10};
        nArrayArray[132] = new int[]{117, 10, 117, 50, 10};
        nArrayArray[133] = new int[]{118, 10, 118, 50, 10};
        nArrayArray[134] = new int[]{119, 10, 119, 50, 10};
        nArrayArray[135] = new int[]{120, 10, 120, 50, 10};
        nArrayArray[136] = new int[]{121, 10, 121, 50, 10};
        nArrayArray[137] = new int[]{122, 10, 122, 50, 10};
        nArrayArray[138] = new int[]{123, 10, 123, 50, 10};
        nArrayArray[139] = new int[]{124, 10, 124, 50, 10};
        return nArrayArray;
    }

    private void setDefaults() {
        this.scrollBar.setMaximum(100);
        this.scrollBar.setMinimum(10);
        this.scrollBar.setThumb(10);
        this.scrollBar.setSelection(50);
    }

    private int[][] getSetSelectionValues() {
        int[][] nArrayArray = new int[140][];
        nArrayArray[0] = new int[]{-15, 10, 100, 10, 10};
        nArrayArray[1] = new int[]{-14, 10, 100, 10, 10};
        nArrayArray[2] = new int[]{-13, 10, 100, 10, 10};
        nArrayArray[3] = new int[]{-12, 10, 100, 10, 10};
        nArrayArray[4] = new int[]{-11, 10, 100, 10, 10};
        nArrayArray[5] = new int[]{-10, 10, 100, 10, 10};
        nArrayArray[6] = new int[]{-9, 10, 100, 10, 10};
        nArrayArray[7] = new int[]{-8, 10, 100, 10, 10};
        nArrayArray[8] = new int[]{-7, 10, 100, 10, 10};
        nArrayArray[9] = new int[]{-6, 10, 100, 10, 10};
        nArrayArray[10] = new int[]{-5, 10, 100, 10, 10};
        nArrayArray[11] = new int[]{-4, 10, 100, 10, 10};
        nArrayArray[12] = new int[]{-3, 10, 100, 10, 10};
        nArrayArray[13] = new int[]{-2, 10, 100, 10, 10};
        nArrayArray[14] = new int[]{-1, 10, 100, 10, 10};
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 100;
        nArray[3] = 10;
        nArray[4] = 10;
        nArrayArray[15] = nArray;
        nArrayArray[16] = new int[]{1, 10, 100, 10, 10};
        nArrayArray[17] = new int[]{2, 10, 100, 10, 10};
        nArrayArray[18] = new int[]{3, 10, 100, 10, 10};
        nArrayArray[19] = new int[]{4, 10, 100, 10, 10};
        nArrayArray[20] = new int[]{5, 10, 100, 10, 10};
        nArrayArray[21] = new int[]{6, 10, 100, 10, 10};
        nArrayArray[22] = new int[]{7, 10, 100, 10, 10};
        nArrayArray[23] = new int[]{8, 10, 100, 10, 10};
        nArrayArray[24] = new int[]{9, 10, 100, 10, 10};
        nArrayArray[25] = new int[]{10, 10, 100, 10, 10};
        nArrayArray[26] = new int[]{11, 10, 100, 11, 10};
        nArrayArray[27] = new int[]{12, 10, 100, 12, 10};
        nArrayArray[28] = new int[]{13, 10, 100, 13, 10};
        nArrayArray[29] = new int[]{14, 10, 100, 14, 10};
        nArrayArray[30] = new int[]{15, 10, 100, 15, 10};
        nArrayArray[31] = new int[]{16, 10, 100, 16, 10};
        nArrayArray[32] = new int[]{17, 10, 100, 17, 10};
        nArrayArray[33] = new int[]{18, 10, 100, 18, 10};
        nArrayArray[34] = new int[]{19, 10, 100, 19, 10};
        nArrayArray[35] = new int[]{20, 10, 100, 20, 10};
        nArrayArray[36] = new int[]{21, 10, 100, 21, 10};
        nArrayArray[37] = new int[]{22, 10, 100, 22, 10};
        nArrayArray[38] = new int[]{23, 10, 100, 23, 10};
        nArrayArray[39] = new int[]{24, 10, 100, 24, 10};
        nArrayArray[40] = new int[]{25, 10, 100, 25, 10};
        nArrayArray[41] = new int[]{26, 10, 100, 26, 10};
        nArrayArray[42] = new int[]{27, 10, 100, 27, 10};
        nArrayArray[43] = new int[]{28, 10, 100, 28, 10};
        nArrayArray[44] = new int[]{29, 10, 100, 29, 10};
        nArrayArray[45] = new int[]{30, 10, 100, 30, 10};
        nArrayArray[46] = new int[]{31, 10, 100, 31, 10};
        nArrayArray[47] = new int[]{32, 10, 100, 32, 10};
        nArrayArray[48] = new int[]{33, 10, 100, 33, 10};
        nArrayArray[49] = new int[]{34, 10, 100, 34, 10};
        nArrayArray[50] = new int[]{35, 10, 100, 35, 10};
        nArrayArray[51] = new int[]{36, 10, 100, 36, 10};
        nArrayArray[52] = new int[]{37, 10, 100, 37, 10};
        nArrayArray[53] = new int[]{38, 10, 100, 38, 10};
        nArrayArray[54] = new int[]{39, 10, 100, 39, 10};
        nArrayArray[55] = new int[]{40, 10, 100, 40, 10};
        nArrayArray[56] = new int[]{41, 10, 100, 41, 10};
        nArrayArray[57] = new int[]{42, 10, 100, 42, 10};
        nArrayArray[58] = new int[]{43, 10, 100, 43, 10};
        nArrayArray[59] = new int[]{44, 10, 100, 44, 10};
        nArrayArray[60] = new int[]{45, 10, 100, 45, 10};
        nArrayArray[61] = new int[]{46, 10, 100, 46, 10};
        nArrayArray[62] = new int[]{47, 10, 100, 47, 10};
        nArrayArray[63] = new int[]{48, 10, 100, 48, 10};
        nArrayArray[64] = new int[]{49, 10, 100, 49, 10};
        nArrayArray[65] = new int[]{50, 10, 100, 50, 10};
        nArrayArray[66] = new int[]{51, 10, 100, 51, 10};
        nArrayArray[67] = new int[]{52, 10, 100, 52, 10};
        nArrayArray[68] = new int[]{53, 10, 100, 53, 10};
        nArrayArray[69] = new int[]{54, 10, 100, 54, 10};
        nArrayArray[70] = new int[]{55, 10, 100, 55, 10};
        nArrayArray[71] = new int[]{56, 10, 100, 56, 10};
        nArrayArray[72] = new int[]{57, 10, 100, 57, 10};
        nArrayArray[73] = new int[]{58, 10, 100, 58, 10};
        nArrayArray[74] = new int[]{59, 10, 100, 59, 10};
        nArrayArray[75] = new int[]{60, 10, 100, 60, 10};
        nArrayArray[76] = new int[]{61, 10, 100, 61, 10};
        nArrayArray[77] = new int[]{62, 10, 100, 62, 10};
        nArrayArray[78] = new int[]{63, 10, 100, 63, 10};
        nArrayArray[79] = new int[]{64, 10, 100, 64, 10};
        nArrayArray[80] = new int[]{65, 10, 100, 65, 10};
        nArrayArray[81] = new int[]{66, 10, 100, 66, 10};
        nArrayArray[82] = new int[]{67, 10, 100, 67, 10};
        nArrayArray[83] = new int[]{68, 10, 100, 68, 10};
        nArrayArray[84] = new int[]{69, 10, 100, 69, 10};
        nArrayArray[85] = new int[]{70, 10, 100, 70, 10};
        nArrayArray[86] = new int[]{71, 10, 100, 71, 10};
        nArrayArray[87] = new int[]{72, 10, 100, 72, 10};
        nArrayArray[88] = new int[]{73, 10, 100, 73, 10};
        nArrayArray[89] = new int[]{74, 10, 100, 74, 10};
        nArrayArray[90] = new int[]{75, 10, 100, 75, 10};
        nArrayArray[91] = new int[]{76, 10, 100, 76, 10};
        nArrayArray[92] = new int[]{77, 10, 100, 77, 10};
        nArrayArray[93] = new int[]{78, 10, 100, 78, 10};
        nArrayArray[94] = new int[]{79, 10, 100, 79, 10};
        nArrayArray[95] = new int[]{80, 10, 100, 80, 10};
        nArrayArray[96] = new int[]{81, 10, 100, 81, 10};
        nArrayArray[97] = new int[]{82, 10, 100, 82, 10};
        nArrayArray[98] = new int[]{83, 10, 100, 83, 10};
        nArrayArray[99] = new int[]{84, 10, 100, 84, 10};
        nArrayArray[100] = new int[]{85, 10, 100, 85, 10};
        nArrayArray[101] = new int[]{86, 10, 100, 86, 10};
        nArrayArray[102] = new int[]{87, 10, 100, 87, 10};
        nArrayArray[103] = new int[]{88, 10, 100, 88, 10};
        nArrayArray[104] = new int[]{89, 10, 100, 89, 10};
        nArrayArray[105] = new int[]{90, 10, 100, 90, 10};
        nArrayArray[106] = new int[]{91, 10, 100, 90, 10};
        nArrayArray[107] = new int[]{92, 10, 100, 90, 10};
        nArrayArray[108] = new int[]{93, 10, 100, 90, 10};
        nArrayArray[109] = new int[]{94, 10, 100, 90, 10};
        nArrayArray[110] = new int[]{95, 10, 100, 90, 10};
        nArrayArray[111] = new int[]{96, 10, 100, 90, 10};
        nArrayArray[112] = new int[]{97, 10, 100, 90, 10};
        nArrayArray[113] = new int[]{98, 10, 100, 90, 10};
        nArrayArray[114] = new int[]{99, 10, 100, 90, 10};
        nArrayArray[115] = new int[]{100, 10, 100, 90, 10};
        nArrayArray[116] = new int[]{101, 10, 100, 90, 10};
        nArrayArray[117] = new int[]{102, 10, 100, 90, 10};
        nArrayArray[118] = new int[]{103, 10, 100, 90, 10};
        nArrayArray[119] = new int[]{104, 10, 100, 90, 10};
        nArrayArray[120] = new int[]{105, 10, 100, 90, 10};
        nArrayArray[121] = new int[]{106, 10, 100, 90, 10};
        nArrayArray[122] = new int[]{107, 10, 100, 90, 10};
        nArrayArray[123] = new int[]{108, 10, 100, 90, 10};
        nArrayArray[124] = new int[]{109, 10, 100, 90, 10};
        nArrayArray[125] = new int[]{110, 10, 100, 90, 10};
        nArrayArray[126] = new int[]{111, 10, 100, 90, 10};
        nArrayArray[127] = new int[]{112, 10, 100, 90, 10};
        nArrayArray[128] = new int[]{113, 10, 100, 90, 10};
        nArrayArray[129] = new int[]{114, 10, 100, 90, 10};
        nArrayArray[130] = new int[]{115, 10, 100, 90, 10};
        nArrayArray[131] = new int[]{116, 10, 100, 90, 10};
        nArrayArray[132] = new int[]{117, 10, 100, 90, 10};
        nArrayArray[133] = new int[]{118, 10, 100, 90, 10};
        nArrayArray[134] = new int[]{119, 10, 100, 90, 10};
        nArrayArray[135] = new int[]{120, 10, 100, 90, 10};
        nArrayArray[136] = new int[]{121, 10, 100, 90, 10};
        nArrayArray[137] = new int[]{122, 10, 100, 90, 10};
        nArrayArray[138] = new int[]{123, 10, 100, 90, 10};
        nArrayArray[139] = new int[]{124, 10, 100, 90, 10};
        return nArrayArray;
    }
}

