/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_TabFolder
extends Test_org_eclipse_swt_widgets_Composite {
    protected TabFolder tabFolder;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.makeCleanEnvironment();
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            new TabFolder(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
    }

    @Test
    public void test_TabFolder_getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        int i = 0;
        while (i < 6) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText("TabItem " + i);
            Button button = new Button((Composite)this.tabFolder, 8);
            button.setText("Page " + i);
            item.setControl((Control)button);
            children.add(button);
            ++i;
        }
        Label label = new Label((Composite)this.tabFolder, 0);
        label.setText("Unused Child");
        children.add(label);
        Assert.assertArrayEquals((Object[])children.toArray(), (Object[])this.tabFolder.getChildren());
    }

    @Override
    @Test
    public void test_getClientArea() {
    }

    @Test
    public void test_getItemCount() {
        int number = 10;
        int i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.tabFolder.getItemCount() == i ? 1 : 0) != 0);
            new TabItem(this.tabFolder, 0);
            ++i;
        }
    }

    @Test
    public void test_getItemI() {
        int number = 15;
        TabItem[] items = new TabItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + String.valueOf(i)), (boolean)this.tabFolder.getItem(i).equals(items[i]));
            ++i;
        }
        try {
            this.tabFolder.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.tabFolder.getItem(number + 1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.tabFolder.getItem(-1);
            Assert.fail((String)"No exception thrown for index == -1");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItems() {
        int number = 5;
        Object[] items = new TabItem[number];
        Assert.assertEquals((long)0L, (long)this.tabFolder.getItems().length);
        int i = 0;
        while (i < number) {
            items[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])items, (Object[])this.tabFolder.getItems());
        this.tabFolder.getItems()[0].dispose();
        Assert.assertArrayEquals((Object[])new TabItem[]{items[1], items[2], items[3], items[4]}, (Object[])this.tabFolder.getItems());
        this.tabFolder.getItems()[3].dispose();
        Assert.assertArrayEquals((Object[])new TabItem[]{items[1], items[2], items[3]}, (Object[])this.tabFolder.getItems());
        this.tabFolder.getItems()[1].dispose();
        Assert.assertArrayEquals((Object[])new TabItem[]{items[1], items[3]}, (Object[])this.tabFolder.getItems());
    }

    @Test
    public void test_setControl() {
        int number = 5;
        TabItem[] items = new TabItem[number];
        Button setControlButton = new Button((Composite)this.tabFolder, 0);
        setControlButton.setText("test button");
        int i = 0;
        while (i < number) {
            items[i] = new TabItem(this.tabFolder, 0);
            items[i].setControl((Control)setControlButton);
            Assert.assertEquals((Object)items[i].getControl(), (Object)setControlButton);
            Assert.assertTrue((boolean)setControlButton.getVisible());
            ++i;
        }
        items[0].setControl((Control)setControlButton);
        Assert.assertEquals((Object)items[0].getControl(), (Object)setControlButton);
        Assert.assertTrue((boolean)setControlButton.getVisible());
    }

    @Test
    public void test_getSelection() {
        int number = 10;
        TabItem[] tis = new TabItem[number];
        int i = 0;
        while (i < number) {
            tis[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        Assert.assertTrue((String)":a:", (this.tabFolder.getSelection()[0] == tis[0] ? 1 : 0) != 0);
        i = 0;
        while (i < number) {
            this.tabFolder.setSelection(i);
            Assert.assertTrue((String)(":b:" + i), (this.tabFolder.getSelection()[0] == tis[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void test_getSelectionIndex() {
        int number = 15;
        TabItem[] items = new TabItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        Assert.assertTrue((String)":a:", (this.tabFolder.getSelectionIndex() == 0 ? 1 : 0) != 0);
        this.tabFolder.setSelection(new TabItem[]{items[2], items[number - 1], items[10]});
        Assert.assertTrue((String)":b:", (this.tabFolder.getSelectionIndex() == 2 ? 1 : 0) != 0);
        this.tabFolder.setSelection(items);
        Assert.assertTrue((String)":c:", (this.tabFolder.getSelectionIndex() == 0 ? 1 : 0) != 0);
        this.tabFolder.setSelection(items[2]);
        Assert.assertTrue((String)":d:", (this.tabFolder.getSelectionIndex() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void test_indexOfLorg_eclipse_swt_widgets_TabItem() {
        int number = 10;
        TabItem[] tis = new TabItem[number];
        int i = 0;
        while (i < number) {
            tis[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.tabFolder.indexOf(tis[i]) == i ? 1 : 0) != 0);
            ++i;
        }
        this.makeCleanEnvironment();
        i = 0;
        while (i < number) {
            tis[i] = new TabItem(this.tabFolder, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            try {
                this.tabFolder.indexOf(null);
                Assert.fail((String)"No exception thrown for tabItem == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        this.makeCleanEnvironment();
        number = 20;
        TabItem[] items = new TabItem[number];
        int i2 = 0;
        while (i2 < number) {
            items[i2] = new TabItem(this.tabFolder, 0);
            items[i2].setText(String.valueOf(i2));
            ++i2;
        }
        TabFolder tabFolder_2 = new TabFolder((Composite)this.shell, 0);
        TabItem[] items_2 = new TabItem[number];
        int i3 = 0;
        while (i3 < number) {
            items_2[i3] = new TabItem(tabFolder_2, 0);
            items_2[i3].setText(String.valueOf(i3));
            ++i3;
        }
        i3 = 0;
        while (i3 < number) {
            Assert.assertTrue((String)(":a:" + String.valueOf(i3)), (this.tabFolder.indexOf(items_2[i3]) == -1 ? 1 : 0) != 0);
            ++i3;
        }
        TabFolder tabFolder2 = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder2, 0);
        Assert.assertTrue((String)":a:", (this.tabFolder.indexOf(tabItem) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void test_setSelectionEmpty() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setSelectionEmpty(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_TabFolder)");
            }
            return;
        }
        int number = 10;
        int i = 0;
        while (i < number) {
            new TabItem(this.tabFolder, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.tabFolder.setSelection(i);
            Assert.assertEquals((long)i, (long)this.tabFolder.getSelectionIndex());
            ++i;
        }
        this.makeCleanEnvironment();
        this.tabFolder.setSelection(-1);
        Assert.assertEquals((long)0L, (long)this.tabFolder.getSelection().length);
    }

    @Test
    public void test_setSelectionI() {
        block24: {
            int i22;
            TabItem[] items;
            int number;
            block22: {
                block20: {
                    number = 10;
                    int i = 0;
                    while (i < number) {
                        new TabItem(this.tabFolder, 0);
                        ++i;
                    }
                    i = 0;
                    while (i < number) {
                        this.tabFolder.setSelection(i);
                        Assert.assertEquals((long)i, (long)this.tabFolder.getSelectionIndex());
                        ++i;
                    }
                    this.makeCleanEnvironment();
                    i = 0;
                    while (i < number) {
                        new TabItem(this.tabFolder, 0);
                        Assert.assertEquals((String)("i=" + i), (long)0L, (long)this.tabFolder.getSelectionIndex());
                        ++i;
                    }
                    this.makeCleanEnvironment();
                    number = 5;
                    items = new TabItem[number];
                    i22 = 0;
                    while (i22 < number) {
                        items[i22] = new TabItem(this.tabFolder, 0);
                        ++i22;
                    }
                    try {
                        try {
                            this.tabFolder.setSelection(null);
                            Assert.fail((String)"No exception thrown for selection == null");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                            break block20;
                        }
                    }
                    catch (Throwable i22) {
                        Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                        throw i22;
                    }
                    Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                }
                try {
                    try {
                        this.tabFolder.setSelection(null);
                        Assert.fail((String)"No exception thrown for selection == null");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                        break block22;
                    }
                }
                catch (Throwable i22) {
                    Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                    throw i22;
                }
                Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
            }
            this.makeCleanEnvironment();
            items = new TabItem[number];
            i22 = 0;
            while (i22 < number) {
                items[i22] = new TabItem(this.tabFolder, 0);
                ++i22;
            }
            this.tabFolder.setSelection(0);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(4);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[4]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(2);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[2]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(1);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[1]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(number + 1);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[1]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(3);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[3]}, (Object[])this.tabFolder.getSelection());
            this.makeCleanEnvironment();
            i22 = 0;
            while (i22 < number) {
                items[i22] = new TabItem(this.tabFolder, 0);
                ++i22;
            }
            this.tabFolder.setSelection(items[0]);
            Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(new TabItem[]{items[0]});
            Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(new TabItem[]{items[3]});
            Assert.assertArrayEquals((Object[])new TabItem[]{items[3]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(new TabItem[]{items[4]});
            Assert.assertArrayEquals((Object[])new TabItem[]{items[4]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(new TabItem[]{items[2]});
            Assert.assertArrayEquals((Object[])new TabItem[]{items[2]}, (Object[])this.tabFolder.getSelection());
            this.tabFolder.setSelection(new TabItem[]{items[1]});
            Assert.assertArrayEquals((Object[])new TabItem[]{items[1]}, (Object[])this.tabFolder.getSelection());
            this.makeCleanEnvironment();
            i22 = 0;
            while (i22 < number) {
                items[i22] = new TabItem(this.tabFolder, 0);
                ++i22;
            }
            try {
                try {
                    TabItem[] tabItemArray = new TabItem[2];
                    tabItemArray[0] = items[0];
                    this.tabFolder.setSelection(tabItemArray);
                    this.tabFolder.setSelection(new TabItem[1]);
                    Assert.fail((String)"No exception thrown for selection == null");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                    break block24;
                }
            }
            catch (Throwable throwable) {
                Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
                throw throwable;
            }
            Assert.assertArrayEquals((Object[])new TabItem[]{items[0]}, (Object[])this.tabFolder.getSelection());
        }
    }

    private void makeCleanEnvironment() {
        this.tabFolder = new TabFolder((Composite)this.shell, 0);
        this.setWidget((Widget)this.tabFolder);
    }

    private void createTabFolder(List<String> events) {
        this.makeCleanEnvironment();
        int i = 0;
        while (i < 3) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText("TabItem &" + i);
            item.setToolTipText("TabItem ToolTip" + i);
            Text itemText = new Text((Composite)this.tabFolder, 2050);
            itemText.setText("\nText for TabItem " + i + "\n\n\n");
            item.setControl((Control)itemText);
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            ++i;
        }
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 0x1000004, 0, 0, 10, events, false);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(this.tabFolder.getSize().x / 2, 5, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_PgdwnSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 262144, 0, 0x1000006, 20, events, false);
    }

    @Test
    public void test_consistency_PgupSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.tabFolder.setSelection(2);
        this.consistencyEvent(0, 262144, 0, 0x1000005, 20, events, false);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.tabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.tabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 70, 10, 50, events);
    }
}

