/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Item;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_TreeItem
extends Test_org_eclipse_swt_widgets_Item {
    TreeItem treeItem;
    Tree tree;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.makeCleanEnvironment();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeI() {
        try {
            new TreeItem(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int i = 0;
        while (i < 10) {
            new TreeItem(this.tree, 0);
            ++i;
        }
        Assert.assertEquals((long)11L, (long)this.tree.getItemCount());
        new TreeItem(this.tree, 0, 5);
        Assert.assertEquals((long)12L, (long)this.tree.getItemCount());
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeII() {
        try {
            new TreeItem(this.tree, 0, 5);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeItemI() {
        int i = 0;
        while (i < 10) {
            new TreeItem(this.treeItem, 0);
            ++i;
        }
        Assert.assertEquals((long)10L, (long)this.treeItem.getItemCount());
        new TreeItem(this.treeItem, 0, 5);
        Assert.assertEquals((long)1L, (long)this.tree.getItemCount());
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeItemII() {
        try {
            new TreeItem(this.treeItem, 0, 5);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)1L, (long)this.tree.getItemCount());
    }

    @Test
    public void test_getBounds() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getBounds(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_TreeItem)");
            }
            return;
        }
        Image image = this.images[0];
        String string = "hello";
        Rectangle bounds = this.treeItem.getBounds();
        Assert.assertTrue((String)":1a:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        this.treeItem.setText(string);
        GC gc = new GC((Drawable)this.tree);
        Point extent = gc.stringExtent(string);
        gc.dispose();
        bounds = this.treeItem.getBounds();
        Assert.assertTrue((String)":1b:", (bounds.x > 0 && bounds.height > extent.y && bounds.width > extent.x ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        Rectangle rect = image.getBounds();
        this.treeItem.setImage(image);
        bounds = this.treeItem.getBounds();
        Assert.assertTrue((String)":1c:", (bounds.x > 0 && bounds.height >= rect.height ? 1 : 0) != 0);
        Rectangle bounds2 = this.treeItem.getImageBounds(0);
        Assert.assertTrue((String)":1d:", (bounds.x >= bounds2.x + bounds2.width ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        TreeItem subItem = new TreeItem(this.treeItem, 0);
        bounds = subItem.getBounds();
        Assert.assertTrue((String)":1e:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        bounds = subItem.getBounds();
        bounds2 = this.treeItem.getBounds();
        Assert.assertTrue((String)":1f:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > 0 ? 1 : 0) != 0);
        this.treeItem.setExpanded(false);
        bounds = subItem.getBounds();
        Assert.assertTrue((String)":1g:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        subItem.setText(string);
        bounds = subItem.getBounds();
        bounds2 = this.treeItem.getBounds();
        Assert.assertTrue((String)":1h:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > extent.y && bounds.width > extent.x ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        subItem = new TreeItem(this.treeItem, 0);
        this.treeItem.setExpanded(true);
        subItem.setImage(image);
        bounds = subItem.getBounds();
        Assert.assertTrue((String)":1i:", (bounds.x > 0 && bounds.height >= rect.height ? 1 : 0) != 0);
        bounds2 = subItem.getImageBounds(0);
        Assert.assertTrue((String)":1j:", (bounds.x >= bounds2.x + bounds2.width ? 1 : 0) != 0);
    }

    void getBoundsIA() {
        Image image = this.images[0];
        Rectangle imageBounds = image.getBounds();
        String string = "hello";
        GC gc = new GC((Drawable)this.tree);
        Point stringExtent = gc.stringExtent(string);
        gc.dispose();
        this.makeCleanEnvironment();
        Rectangle bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1a:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(-1);
        Assert.assertTrue((String)":1b:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":1c:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        TreeItem subItem = new TreeItem(this.treeItem, 0);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":1d:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":1e:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        this.treeItem.setExpanded(false);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":1f:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        subItem.setText(string);
        bounds = subItem.getBounds(0);
        Rectangle bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1g:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent.y && bounds.width > stringExtent.x ? 1 : 0) != 0);
        this.treeItem.setText(string);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1h:", (bounds.x > 0 && bounds.height > stringExtent.y && bounds.width > stringExtent.x ? 1 : 0) != 0);
        bounds2 = this.treeItem.getBounds();
        this.treeItem.setText("");
        bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1i:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1j:", (bounds2.width < bounds.width ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        this.treeItem.setImage(image);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1k:", (bounds.x > 0 && bounds.height >= imageBounds.height && bounds.width >= imageBounds.width ? 1 : 0) != 0);
        this.treeItem.setImage(null);
        bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1l:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        this.treeItem.setText(string);
        bounds = this.treeItem.getBounds(0);
        this.treeItem.setImage(image);
        bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":1n:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":1o:", (bounds2.width > bounds.width ? 1 : 0) != 0);
        Assert.assertTrue((String)":1p", (bounds2.width >= stringExtent.x + imageBounds.width && bounds2.height >= Math.max(stringExtent.y, imageBounds.height) ? 1 : 0) != 0);
    }

    void getBoundsIB() {
        Image image = this.images[0];
        Rectangle imageBounds = image.getBounds();
        String string = "hello";
        GC gc = new GC((Drawable)this.tree);
        Point stringExtent = gc.stringExtent(string);
        gc.dispose();
        Tree tree2 = new Tree((Composite)this.shell, 32);
        TreeItem treeItem2 = new TreeItem(tree2, 0);
        Rectangle bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2a:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(-1);
        Assert.assertTrue((String)":2b:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":2c:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        TreeItem subItem2 = new TreeItem(treeItem2, 0);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":2d:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        treeItem2.setExpanded(true);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":2e:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        treeItem2.setExpanded(false);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":2f:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        treeItem2.setExpanded(true);
        subItem2.setText(string);
        bounds = subItem2.getBounds(0);
        Rectangle bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2g:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent.y && bounds.width > stringExtent.x ? 1 : 0) != 0);
        treeItem2.setText(string);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2h:", (bounds.x > 0 && bounds.height > stringExtent.y && bounds.width > stringExtent.x ? 1 : 0) != 0);
        bounds2 = treeItem2.getBounds();
        treeItem2.setText("");
        bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2i:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2j:", (bounds2.width < bounds.width ? 1 : 0) != 0);
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2 = new TreeItem(tree2, 0);
        treeItem2.setImage(image);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2k:", (bounds.x > 0 && bounds.height >= imageBounds.height && bounds.width >= imageBounds.width ? 1 : 0) != 0);
        treeItem2.setImage(null);
        bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2l:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2 = new TreeItem(tree2, 0);
        treeItem2.setText(string);
        bounds = treeItem2.getBounds(0);
        treeItem2.setImage(image);
        bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":2n:", (bounds2.x > 0 && bounds2.height > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":2o:", (bounds2.width > bounds.width ? 1 : 0) != 0);
        Assert.assertTrue((String)":1p", (bounds2.width >= stringExtent.x + imageBounds.width && bounds2.height >= Math.max(stringExtent.y, imageBounds.height) ? 1 : 0) != 0);
    }

    void getBoundsIC() {
        Image image = this.images[0];
        Rectangle imageBounds = image.getBounds();
        String string1 = "hello";
        String string2 = "world";
        GC gc = new GC((Drawable)this.tree);
        Point stringExtent1 = gc.stringExtent(string1);
        gc.dispose();
        this.makeCleanEnvironment();
        TreeColumn column0 = new TreeColumn(this.tree, 16384);
        TreeColumn column1 = new TreeColumn(this.tree, 0x1000000);
        Rectangle bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3a:", (bounds.x > 0 && bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3b:", (bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(-1);
        Assert.assertTrue((String)":3c:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        bounds = this.treeItem.getBounds(2);
        Assert.assertTrue((String)":3d:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        TreeItem subItem = new TreeItem(this.treeItem, 0);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":3e:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":3f:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        this.treeItem.setExpanded(false);
        bounds = subItem.getBounds(0);
        Assert.assertTrue((String)":3g:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.treeItem.setExpanded(true);
        subItem.setText(new String[]{string1, string2});
        bounds = subItem.getBounds(0);
        Rectangle bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3h:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent1.y && bounds.width == 0 ? 1 : 0) != 0);
        column0.setWidth(100);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3i:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3j:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = subItem.getBounds(0);
        bounds2 = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3k:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        column1.setWidth(200);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3l:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3m:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 200 ? 1 : 0) != 0);
        this.treeItem.setText(new String[]{string1, string2});
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3n:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3o:", (bounds.x >= 100 && bounds.height > stringExtent1.y && bounds.width == 200 ? 1 : 0) != 0);
        this.treeItem.setText(new String[]{"", ""});
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3p:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3q:", (bounds.x >= 100 && bounds.height > stringExtent1.y && bounds.width == 200 ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        column0 = new TreeColumn(this.tree, 16384);
        column1 = new TreeColumn(this.tree, 0x1000000);
        column0.setWidth(100);
        column1.setWidth(200);
        this.treeItem.setImage(new Image[]{image, image});
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3r:", (bounds.x > 0 && bounds.height >= imageBounds.height && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3s:", (bounds.x >= 100 && bounds.height >= imageBounds.height && bounds.width == 200 ? 1 : 0) != 0);
        this.treeItem.setImage(new Image[2]);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3t:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3u:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 200 ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        column0 = new TreeColumn(this.tree, 16384);
        column1 = new TreeColumn(this.tree, 0x1000000);
        column0.setWidth(100);
        column1.setWidth(200);
        this.treeItem.setText(new String[]{string1, string2});
        this.treeItem.setImage(new Image[]{image, image});
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3v:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.height >= imageBounds.height && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = this.treeItem.getBounds(1);
        Assert.assertTrue((String)":3w:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.height >= imageBounds.height && bounds.width == 200 ? 1 : 0) != 0);
        this.makeCleanEnvironment();
        this.treeItem.setText(string1);
        new TreeColumn(this.tree, 131072);
        bounds = this.treeItem.getBounds(0);
        Assert.assertTrue((String)":3x:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width == 0 ? 1 : 0) != 0);
    }

    void getBoundsID() {
        Image image = this.images[0];
        Rectangle imageBounds = image.getBounds();
        String string1 = "hello";
        String string2 = "world";
        GC gc = new GC((Drawable)this.tree);
        Point stringExtent1 = gc.stringExtent(string1);
        gc.dispose();
        Tree tree2 = new Tree((Composite)this.shell, 32);
        TreeItem treeItem2 = new TreeItem(tree2, 0);
        TreeColumn column0 = new TreeColumn(tree2, 16384);
        TreeColumn column1 = new TreeColumn(tree2, 0x1000000);
        Rectangle bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4a:", (bounds.x > 0 && bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4b:", (bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(-1);
        Assert.assertTrue((String)":4c:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        bounds = treeItem2.getBounds(2);
        Assert.assertTrue((String)":4d:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        TreeItem subItem2 = new TreeItem(treeItem2, 0);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":4e:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        treeItem2.setExpanded(true);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":4f:", (bounds.x > 0 && bounds.height > 0 ? 1 : 0) != 0);
        treeItem2.setExpanded(false);
        bounds = subItem2.getBounds(0);
        Assert.assertTrue((String)":4g:", (boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        treeItem2.setExpanded(true);
        subItem2.setText(new String[]{string1, string2});
        bounds = subItem2.getBounds(0);
        Rectangle bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4h:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent1.y && bounds.width == 0 ? 1 : 0) != 0);
        column0.setWidth(100);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4i:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4j:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 0 ? 1 : 0) != 0);
        bounds = subItem2.getBounds(0);
        bounds2 = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4k:", (bounds.x > bounds2.x && bounds.y >= bounds2.y + bounds2.height && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        column1.setWidth(200);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4l:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4m:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 200 ? 1 : 0) != 0);
        treeItem2.setText(new String[]{string1, string2});
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4n:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4o:", (bounds.x >= 100 && bounds.height > stringExtent1.y && bounds.width == 200 ? 1 : 0) != 0);
        treeItem2.setText(new String[]{"", ""});
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4p:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4q:", (bounds.x >= 100 && bounds.height > stringExtent1.y && bounds.width == 200 ? 1 : 0) != 0);
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2 = new TreeItem(tree2, 0);
        column0 = new TreeColumn(tree2, 16384);
        column1 = new TreeColumn(tree2, 0x1000000);
        column0.setWidth(100);
        column1.setWidth(200);
        treeItem2.setImage(new Image[]{image, image});
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4r:", (bounds.x > 0 && bounds.height >= imageBounds.height && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4s:", (bounds.x >= 100 && bounds.height >= imageBounds.height && bounds.width == 200 ? 1 : 0) != 0);
        treeItem2.setImage(new Image[2]);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4t:", (bounds.x > 0 && bounds.height > 0 && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4u:", (bounds.x >= 100 && bounds.height > 0 && bounds.width == 200 ? 1 : 0) != 0);
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2 = new TreeItem(tree2, 0);
        column0 = new TreeColumn(tree2, 16384);
        column1 = new TreeColumn(tree2, 0x1000000);
        column0.setWidth(100);
        column1.setWidth(200);
        treeItem2.setText(new String[]{string1, string2});
        treeItem2.setImage(new Image[]{image, image});
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4v:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.height >= imageBounds.height && bounds.width > 0 && bounds.width < 100 ? 1 : 0) != 0);
        bounds = treeItem2.getBounds(1);
        Assert.assertTrue((String)":4w:", (bounds.x >= 100 && bounds.height > stringExtent1.y && bounds.height >= imageBounds.height && bounds.width == 200 ? 1 : 0) != 0);
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2 = new TreeItem(tree2, 0);
        treeItem2.setText(string1);
        new TreeColumn(tree2, 131072);
        bounds = treeItem2.getBounds(0);
        Assert.assertTrue((String)":4x:", (bounds.x > 0 && bounds.height > stringExtent1.y && bounds.width == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getBoundsI() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getBoundsI(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_TreeItem)");
            }
            return;
        }
        this.getBoundsIA();
        this.getBoundsIB();
        this.getBoundsIC();
        this.getBoundsID();
    }

    @Test
    public void test_getExpanded() {
        Assert.assertFalse((boolean)this.treeItem.getExpanded());
        new TreeItem(this.treeItem, 0);
        this.treeItem.setExpanded(true);
        Assert.assertTrue((boolean)this.treeItem.getExpanded());
        this.treeItem.setExpanded(false);
        Assert.assertFalse((boolean)this.treeItem.getExpanded());
    }

    @Test
    public void test_getImageBoundsI() {
        Tree tree2 = new Tree((Composite)this.shell, 32);
        TreeItem treeItem2 = new TreeItem(tree2, 0);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)this.treeItem.getImageBounds(-1));
        Rectangle bounds = this.treeItem.getImageBounds(0);
        Assert.assertTrue((String)":b:", (bounds.width == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)this.treeItem.getImageBounds(1));
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)treeItem2.getImageBounds(-1));
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)treeItem2.getImageBounds(1));
        this.makeCleanEnvironment();
        Image image = this.images[0];
        this.treeItem.setImage(0, image);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)this.treeItem.getImageBounds(-1));
        bounds = this.treeItem.getImageBounds(0);
        this.makeCleanEnvironment();
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2.dispose();
        treeItem2 = new TreeItem(tree2, 0);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)treeItem2.getImageBounds(-1));
        bounds = treeItem2.getImageBounds(0);
        this.makeCleanEnvironment();
        tree2.dispose();
        tree2 = new Tree((Composite)this.shell, 32);
        treeItem2.dispose();
        treeItem2 = new TreeItem(tree2, 0);
        image = this.images[1];
        treeItem2.setImage(0, image);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)treeItem2.getImageBounds(-1));
        bounds = treeItem2.getImageBounds(0);
        Assert.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)treeItem2.getImageBounds(1));
    }

    @Test
    public void test_getItemI() {
        int number = 15;
        TreeItem[] items = new TreeItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TreeItem(this.treeItem, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("i=" + i), (Object)items[i], (Object)this.treeItem.getItem(i));
            ++i;
        }
        try {
            this.treeItem.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.treeItem.getItem(number + 1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.treeItem.getItem(-1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItemCount() {
        int i = 0;
        while (i < 10) {
            Assert.assertEquals((long)i, (long)this.treeItem.getItemCount());
            new TreeItem(this.treeItem, 0);
            ++i;
        }
        Assert.assertTrue((String)"b: ", (this.treeItem.getItemCount() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_getItems() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 100;
        int[] cases = nArray;
        TreeItem[][] items = new TreeItem[cases.length][];
        int j = 0;
        while (j < cases.length) {
            items[j] = new TreeItem[cases[j]];
            ++j;
        }
        j = 0;
        while (j < cases.length) {
            int i = 0;
            while (i < cases[j]) {
                TreeItem ti;
                items[j][i] = ti = new TreeItem(this.treeItem, 0);
                ++i;
            }
            Assert.assertArrayEquals((Object[])items[j], (Object[])this.treeItem.getItems());
            i = 0;
            while (i < cases[j]) {
                items[j][i].dispose();
                ++i;
            }
            Assert.assertEquals((long)0L, (long)this.treeItem.getItemCount());
            ++j;
        }
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.tree, (Object)this.treeItem.getParent());
    }

    @Test
    public void test_getParentItem() {
        TreeItem tItem = new TreeItem(this.treeItem, 0);
        Assert.assertEquals((Object)this.treeItem, (Object)tItem.getParentItem());
    }

    @Test
    public void test_setBackgroundILorg_eclipse_swt_graphics_Color() {
        Display display = this.treeItem.getDisplay();
        Color red = display.getSystemColor(3);
        Color blue = display.getSystemColor(9);
        Assert.assertEquals((Object)this.tree.getBackground(), (Object)this.treeItem.getBackground(0));
        Assert.assertEquals((Object)this.treeItem.getBackground(), (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(0, red);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(10, red);
        Assert.assertEquals((Object)this.treeItem.getBackground(), (Object)this.treeItem.getBackground(10));
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        this.treeItem.setBackground(10, red);
        Assert.assertEquals((Object)this.treeItem.getBackground(), (Object)this.treeItem.getBackground(10));
        this.treeItem.setBackground(0, red);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(0, null);
        Assert.assertEquals((Object)this.tree.getBackground(), (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(0, blue);
        this.treeItem.setBackground(red);
        Assert.assertEquals((Object)blue, (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(0, null);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getBackground(0));
        this.treeItem.setBackground(null);
        Assert.assertEquals((Object)this.tree.getBackground(), (Object)this.treeItem.getBackground(0));
        try {
            Color color = new Color((Device)display, 255, 0, 0);
            color.dispose();
            this.treeItem.setBackground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.treeItem.getDisplay(), 255, 0, 0);
        this.treeItem.setBackground(color);
        Assert.assertEquals((Object)color, (Object)this.treeItem.getBackground());
        this.treeItem.setBackground(null);
        Assert.assertEquals((Object)this.tree.getBackground(), (Object)this.treeItem.getBackground());
        color.dispose();
        try {
            this.treeItem.setBackground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setCheckedZ() {
        Assert.assertFalse((boolean)this.treeItem.getChecked());
        this.treeItem.setChecked(true);
        Assert.assertFalse((boolean)this.treeItem.getChecked());
        Tree t = new Tree((Composite)this.shell, 32);
        TreeItem ti = new TreeItem(t, 0);
        ti.setChecked(true);
        Assert.assertTrue((boolean)ti.getChecked());
        ti.setChecked(false);
        Assert.assertFalse((boolean)ti.getChecked());
        t.dispose();
    }

    @Test
    public void test_setExpandedZ() {
        Assert.assertFalse((boolean)this.treeItem.getExpanded());
        this.treeItem.setExpanded(true);
        Assert.assertFalse((boolean)this.treeItem.getExpanded());
        new TreeItem(this.treeItem, 0);
        this.treeItem.setExpanded(true);
        Assert.assertTrue((boolean)this.treeItem.getExpanded());
        this.treeItem.setExpanded(false);
        Assert.assertFalse((boolean)this.treeItem.getExpanded());
        TreeItem ti = new TreeItem(this.treeItem, 0);
        ti.setExpanded(true);
        this.treeItem.setExpanded(false);
        Assert.assertFalse((boolean)ti.getExpanded());
    }

    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        Font font = this.treeItem.getFont();
        this.treeItem.setFont(font);
        Assert.assertTrue((boolean)font.equals((Object)this.treeItem.getFont()));
        font = new Font((Device)this.treeItem.getDisplay(), SwtTestUtil.testFontName, 10, 0);
        this.treeItem.setFont(font);
        Assert.assertTrue((boolean)font.equals((Object)this.treeItem.getFont()));
        this.treeItem.setFont(null);
        Assert.assertTrue((boolean)this.tree.getFont().equals((Object)this.treeItem.getFont()));
        font.dispose();
        try {
            this.treeItem.setFont(font);
            this.treeItem.setFont(null);
            Assert.fail((String)"No exception thrown for disposed font");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setFontILorg_eclipse_swt_graphics_Font() {
        Display display = this.treeItem.getDisplay();
        Font font = new Font((Device)display, SwtTestUtil.testFontName, 10, 0);
        Assert.assertTrue((boolean)this.tree.getFont().equals((Object)this.treeItem.getFont(0)));
        Assert.assertTrue((boolean)this.treeItem.getFont().equals((Object)this.treeItem.getFont(0)));
        this.treeItem.setFont(0, font);
        Assert.assertTrue((boolean)font.equals((Object)this.treeItem.getFont(0)));
        this.treeItem.setFont(10, font);
        Assert.assertTrue((boolean)this.treeItem.getFont().equals((Object)this.treeItem.getFont(10)));
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        this.treeItem.setFont(10, font);
        Assert.assertTrue((boolean)this.treeItem.getFont().equals((Object)this.treeItem.getFont(10)));
        this.treeItem.setFont(0, font);
        Assert.assertTrue((boolean)font.equals((Object)this.treeItem.getFont(0)));
        this.treeItem.setFont(0, null);
        Assert.assertTrue((boolean)this.tree.getFont().equals((Object)this.treeItem.getFont(0)));
        Font font2 = new Font((Device)display, SwtTestUtil.testFontName, 20, 0);
        this.treeItem.setFont(0, font);
        this.treeItem.setFont(font2);
        Assert.assertTrue((boolean)font.equals((Object)this.treeItem.getFont(0)));
        this.treeItem.setFont(0, null);
        Assert.assertTrue((boolean)font2.equals((Object)this.treeItem.getFont(0)));
        this.treeItem.setFont(null);
        Assert.assertTrue((boolean)this.tree.getFont().equals((Object)this.treeItem.getFont(0)));
        font.dispose();
        font2.dispose();
        try {
            this.treeItem.setFont(0, font);
            this.treeItem.setFont(0, null);
            Assert.fail((String)"No exception thrown for disposed font");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setForegroundILorg_eclipse_swt_graphics_Color() {
        Display display = this.treeItem.getDisplay();
        Color red = display.getSystemColor(3);
        Color blue = display.getSystemColor(9);
        Assert.assertEquals((Object)this.tree.getForeground(), (Object)this.treeItem.getForeground(0));
        Assert.assertEquals((Object)this.treeItem.getForeground(), (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(0, red);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(10, red);
        Assert.assertEquals((Object)this.treeItem.getForeground(), (Object)this.treeItem.getForeground(10));
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        this.treeItem.setForeground(10, red);
        Assert.assertEquals((Object)this.treeItem.getForeground(), (Object)this.treeItem.getForeground(10));
        this.treeItem.setForeground(0, red);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(0, null);
        Assert.assertEquals((Object)this.tree.getForeground(), (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(0, blue);
        this.treeItem.setForeground(red);
        Assert.assertEquals((Object)blue, (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(0, null);
        Assert.assertEquals((Object)red, (Object)this.treeItem.getForeground(0));
        this.treeItem.setForeground(null);
        Assert.assertEquals((Object)this.tree.getForeground(), (Object)this.treeItem.getForeground(0));
        try {
            Color color = new Color((Device)display, 255, 0, 0);
            color.dispose();
            this.treeItem.setForeground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setForegroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color((Device)this.treeItem.getDisplay(), 255, 0, 0);
        this.treeItem.setForeground(color);
        Assert.assertEquals((Object)color, (Object)this.treeItem.getForeground());
        this.treeItem.setForeground(null);
        Assert.assertEquals((Object)this.tree.getForeground(), (Object)this.treeItem.getForeground());
        color.dispose();
        try {
            this.treeItem.setForeground(color);
            Assert.fail((String)"No exception thrown for color disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setGrayedZ() {
        Tree newTree = new Tree((Composite)this.shell, 32);
        TreeItem tItem = new TreeItem(newTree, 0);
        Assert.assertFalse((boolean)tItem.getGrayed());
        tItem.setGrayed(true);
        Assert.assertTrue((boolean)tItem.getGrayed());
        tItem.setGrayed(false);
        Assert.assertFalse((boolean)tItem.getGrayed());
        newTree.dispose();
    }

    @Test
    public void test_setImage$Lorg_eclipse_swt_graphics_Image() {
        Assert.assertNull((Object)this.treeItem.getImage(1));
        this.treeItem.setImage(-1, null);
        Assert.assertNull((Object)this.treeItem.getImage(-1));
        this.treeItem.setImage(0, this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.treeItem.getImage(0));
        String[] texts = new String[this.images.length];
        int i = 0;
        while (i < texts.length) {
            texts[i] = String.valueOf(i);
            ++i;
        }
        int columnCount = this.tree.getColumnCount();
        if (columnCount < texts.length) {
            int i2 = columnCount;
            while (i2 < texts.length) {
                new TreeColumn(this.tree, 0);
                ++i2;
            }
        }
        TreeColumn[] columns = this.tree.getColumns();
        int i3 = 0;
        while (i3 < texts.length) {
            columns[i3].setText(texts[i3]);
            ++i3;
        }
        this.treeItem.setImage(1, this.images[1]);
        Assert.assertEquals((Object)this.images[1], (Object)this.treeItem.getImage(1));
        this.treeItem.setImage(this.images);
        i3 = 0;
        while (i3 < this.images.length) {
            Assert.assertEquals((Object)this.images[i3], (Object)this.treeItem.getImage(i3));
            ++i3;
        }
        try {
            this.treeItem.setImage(null);
            Assert.fail((String)"No exception thrown for images == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setImageILorg_eclipse_swt_graphics_Image() {
        Assert.assertEquals(null, (Object)this.treeItem.getImage(0));
        this.treeItem.setImage(0, this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.treeItem.getImage(0));
        this.treeItem.setImage(10, this.images[0]);
        Assert.assertEquals(null, (Object)this.treeItem.getImage(10));
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        this.treeItem.setImage(10, this.images[0]);
        Assert.assertEquals(null, (Object)this.treeItem.getImage(10));
        this.treeItem.setImage(0, this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.treeItem.getImage(0));
        this.treeItem.setImage(0, null);
        Assert.assertEquals(null, (Object)this.treeItem.getImage(0));
        this.treeItem.setImage(0, this.images[0]);
        this.treeItem.setImage(this.images[1]);
        Assert.assertEquals((Object)this.images[1], (Object)this.treeItem.getImage(0));
        this.treeItem.setImage(this.images[1]);
        this.treeItem.setImage(0, this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.treeItem.getImage(0));
        this.images[0].dispose();
        try {
            this.treeItem.setImage(0, this.images[0]);
            this.treeItem.setImage(0, null);
            Assert.fail((String)"No exception thrown for disposed font");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setText$Ljava_lang_String() {
        String[] TestStrings = new String[]{"test", "test1", "test2"};
        try {
            this.treeItem.setText(null);
            Assert.fail((String)"No exception thrown for strings == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(1).length());
        this.treeItem.setText(TestStrings);
        Assert.assertEquals((Object)TestStrings[0], (Object)this.treeItem.getText(0));
        int i = 1;
        while (i < TestStrings.length) {
            Assert.assertEquals((long)0L, (long)this.treeItem.getText(i).length());
            ++i;
        }
        int columnCount = this.tree.getColumnCount();
        if (columnCount < this.images.length) {
            int i2 = columnCount;
            while (i2 < this.images.length) {
                new TreeColumn(this.tree, 0);
                ++i2;
            }
        }
        TreeColumn[] columns = this.tree.getColumns();
        int i3 = 0;
        while (i3 < TestStrings.length) {
            columns[i3].setText(TestStrings[i3]);
            ++i3;
        }
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(1).length());
    }

    @Test
    public void test_setTextILjava_lang_String() {
        String[] TestStrings = new String[]{"test", "test1", "test2"};
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(1).length());
        this.treeItem.setText(1, "test");
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(1).length());
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(0).length());
        this.treeItem.setText(0, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(0));
        this.treeItem.setText(-1, TestStrings[1]);
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(-1).length());
        this.makeCleanEnvironment();
        int columnCount = this.tree.getColumnCount();
        if (columnCount < this.images.length) {
            int i = columnCount;
            while (i < this.images.length) {
                new TreeColumn(this.tree, 0);
                ++i;
            }
        }
        TreeColumn[] columns = this.tree.getColumns();
        int i = 0;
        while (i < TestStrings.length) {
            columns[i].setText(TestStrings[i]);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(1).length());
        this.treeItem.setText(1, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(1));
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(0).length());
        this.treeItem.setText(0, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(0));
        this.treeItem.setText(-1, TestStrings[1]);
        Assert.assertEquals((long)0L, (long)this.treeItem.getText(-1).length());
        try {
            this.treeItem.setText(-1, null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.treeItem.setText(0, null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.makeCleanEnvironment();
        new TreeColumn(this.tree, 0);
        this.treeItem = new TreeItem(this.tree, 0);
        this.treeItem.setText(0, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(0));
        new TreeColumn(this.tree, 0);
        this.treeItem.setText(1, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(1));
        new TreeColumn(this.tree, 0);
        this.treeItem.setText(2, "test");
        Assert.assertEquals((Object)"test", (Object)this.treeItem.getText(2));
    }

    private void makeCleanEnvironment() {
        if (this.treeItem != null) {
            this.treeItem.dispose();
        }
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.tree = new Tree((Composite)this.shell, 0);
        this.treeItem = new TreeItem(this.tree, 0);
        this.setWidget((Widget)this.treeItem);
    }
}

