/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.performance;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.swt.SWT;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class SwtPerformanceTestCase
extends TestCase {
    public static boolean verbose = false;
    public static final boolean isGTK = SWT.getPlatform().equals("gtk");
    public static final boolean isWindows = SWT.getPlatform().startsWith("win32");
    public static String[] imageFormats = new String[]{"bmp", "jpg", "gif", "png"};
    public static String[] imageFilenames = new String[]{"folder", "folderOpen", "target"};
    public static String[] transparentImageFilenames = new String[]{"transparent.png"};

    public SwtPerformanceTestCase(String name) {
        super(name);
    }

    protected PerformanceMeter createMeter(String id) {
        Performance performance = Performance.getDefault();
        String scenarioId = "org.eclipse.swt.test." + id;
        PerformanceMeter meter = performance.createPerformanceMeter(scenarioId);
        performance.tagAsSummary(meter, id, Dimension.ELAPSED_PROCESS);
        return meter;
    }

    protected PerformanceMeter createMeterWithoutSummary(String id) {
        Performance performance = Performance.getDefault();
        String scenarioId = "org.eclipse.swt.test." + id;
        PerformanceMeter meter = performance.createPerformanceMeter(scenarioId);
        return meter;
    }

    protected void disposeMeter(PerformanceMeter meter) {
        try {
            meter.commit();
            Performance.getDefault().assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    protected String getPath(String fileName) {
        String urlPath;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        if (pluginPath == null) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName);
            if (url == null) {
                SwtPerformanceTestCase.fail((String)("URL == null for file " + fileName));
            }
            urlPath = url.getFile();
        } else {
            urlPath = String.valueOf(pluginPath) + "/data/" + fileName;
        }
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace('/', File.separatorChar);
        }
        if (isWindows && urlPath.indexOf(File.separatorChar) == 0) {
            urlPath = urlPath.substring(1);
        }
        urlPath = urlPath.replaceAll("%20", " ");
        if (verbose) {
            System.out.println("Resolved file name for " + fileName + " = " + urlPath);
        }
        return urlPath;
    }
}

