/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Sleak {
    List list;
    Canvas canvas;
    Button start;
    Button stop;
    Button check;
    Text text;
    Label label;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];

    public static void main(String[] args) {
        DeviceData data = new DeviceData();
        data.tracking = true;
        Display display = new Display(data);
        Sleak sleak = new Sleak();
        Shell shell = new Shell(display);
        shell.setText("S-Leak");
        Point size = shell.getSize();
        shell.setSize(size.x / 2, size.y / 2);
        sleak.create((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void create(Composite parent) {
        this.list = new List(parent, 2560);
        this.list.addListener(13, event -> this.refreshObject());
        this.text = new Text(parent, 2816);
        this.canvas = new Canvas(parent, 2048);
        this.canvas.addListener(9, event -> this.paintCanvas(event));
        this.check = new Button(parent, 32);
        this.check.setText("Stack");
        this.check.addListener(13, e -> this.toggleStackTrace());
        this.start = new Button(parent, 8);
        this.start.setText("Snap");
        this.start.addListener(13, event -> this.refreshAll());
        this.stop = new Button(parent, 8);
        this.stop.setText("Diff");
        this.stop.addListener(13, event -> this.refreshDifference());
        this.label = new Label(parent, 2048);
        this.label.setText("0 object(s)");
        parent.addListener(11, e -> this.layout());
        this.check.setSelection(false);
        this.text.setVisible(false);
        this.layout();
    }

    void refreshLabel() {
        int colors = 0;
        int cursors = 0;
        int fonts = 0;
        int gcs = 0;
        int images = 0;
        int paths = 0;
        int patterns = 0;
        int regions = 0;
        int textLayouts = 0;
        int transforms = 0;
        int i = 0;
        while (i < this.objects.length) {
            Object object = this.objects[i];
            if (object instanceof Color) {
                ++colors;
            }
            if (object instanceof Cursor) {
                ++cursors;
            }
            if (object instanceof Font) {
                ++fonts;
            }
            if (object instanceof GC) {
                ++gcs;
            }
            if (object instanceof Image) {
                ++images;
            }
            if (object instanceof Path) {
                ++paths;
            }
            if (object instanceof Pattern) {
                ++patterns;
            }
            if (object instanceof Region) {
                ++regions;
            }
            if (object instanceof TextLayout) {
                ++textLayouts;
            }
            if (object instanceof Transform) {
                ++transforms;
            }
            ++i;
        }
        String string = "";
        if (colors != 0) {
            string = String.valueOf(string) + colors + " Color(s)\n";
        }
        if (cursors != 0) {
            string = String.valueOf(string) + cursors + " Cursor(s)\n";
        }
        if (fonts != 0) {
            string = String.valueOf(string) + fonts + " Font(s)\n";
        }
        if (gcs != 0) {
            string = String.valueOf(string) + gcs + " GC(s)\n";
        }
        if (images != 0) {
            string = String.valueOf(string) + images + " Image(s)\n";
        }
        if (paths != 0) {
            string = String.valueOf(string) + paths + " Paths(s)\n";
        }
        if (patterns != 0) {
            string = String.valueOf(string) + patterns + " Pattern(s)\n";
        }
        if (regions != 0) {
            string = String.valueOf(string) + regions + " Region(s)\n";
        }
        if (textLayouts != 0) {
            string = String.valueOf(string) + textLayouts + " TextLayout(s)\n";
        }
        if (transforms != 0) {
            string = String.valueOf(string) + transforms + " Transform(s)\n";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        this.label.setText(string);
    }

    void refreshDifference() {
        Display display = this.canvas.getDisplay();
        DeviceData info = display.getDeviceData();
        if (!info.tracking) {
            Shell shell = this.canvas.getShell();
            MessageBox dialog = new MessageBox(shell, 40);
            dialog.setText(shell.getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation");
            dialog.open();
        }
        Object[] newObjects = info.objects;
        Error[] newErrors = info.errors;
        Object[] diffObjects = new Object[newObjects.length];
        Error[] diffErrors = new Error[newErrors.length];
        int count = 0;
        int i = 0;
        while (i < newObjects.length) {
            int index = 0;
            while (index < this.oldObjects.length) {
                if (newObjects[i] == this.oldObjects[index]) break;
                ++index;
            }
            if (index == this.oldObjects.length) {
                diffObjects[count] = newObjects[i];
                diffErrors[count] = newErrors[i];
                ++count;
            }
            ++i;
        }
        this.objects = new Object[count];
        this.errors = new Error[count];
        System.arraycopy(diffObjects, 0, this.objects, 0, count);
        System.arraycopy(diffErrors, 0, this.errors, 0, count);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        i = 0;
        while (i < this.objects.length) {
            this.list.add(this.objects[i].toString());
            ++i;
        }
        this.refreshLabel();
        this.layout();
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.layout();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        GC gc = event.gc;
        Object object = this.objects[index];
        if (object instanceof Color) {
            if (((Color)object).isDisposed()) {
                return;
            }
            gc.setBackground((Color)object);
            gc.fillRectangle(this.canvas.getClientArea());
            return;
        }
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gc.setFont((Font)object);
            FontData[] array = gc.getFont().getFontData();
            String string = "";
            String lf = this.text.getLineDelimiter();
            int i = 0;
            while (i < array.length) {
                FontData data = array[i];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = String.valueOf(style) + "ITALIC";
                    }
                }
                string = String.valueOf(string) + data.getName() + " " + data.getHeight() + " " + style + lf;
                ++i;
            }
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                return;
            }
            gc.drawImage((Image)object, 0, 0);
            return;
        }
        if (object instanceof Path) {
            if (((Path)object).isDisposed()) {
                return;
            }
            gc.drawPath((Path)object);
            return;
        }
        if (object instanceof Pattern) {
            if (((Pattern)object).isDisposed()) {
                return;
            }
            gc.setBackgroundPattern((Pattern)object);
            gc.fillRectangle(this.canvas.getClientArea());
            gc.setBackgroundPattern(null);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof TextLayout) {
            if (((TextLayout)object).isDisposed()) {
                return;
            }
            ((TextLayout)object).draw(gc, 0, 0);
            return;
        }
        if (object instanceof Transform) {
            if (((Transform)object).isDisposed()) {
                return;
            }
            String string = ((Transform)object).toString();
            gc.drawString(string, 0, 0);
            return;
        }
    }

    void refreshObject() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.check.getSelection()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PrintStream s = new PrintStream(stream);
            this.errors[index].printStackTrace(s);
            this.text.setText(stream.toString());
            this.text.setVisible(true);
            this.canvas.setVisible(false);
        } else {
            this.canvas.setVisible(true);
            this.text.setVisible(false);
            this.canvas.redraw();
        }
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.refreshDifference();
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    void layout() {
        Composite parent = this.canvas.getParent();
        Rectangle rect = parent.getClientArea();
        int width = 0;
        String[] items = this.list.getItems();
        GC gc = new GC((Drawable)this.list);
        int i = 0;
        while (i < this.objects.length) {
            width = Math.max(width, gc.stringExtent((String)items[i]).x);
            ++i;
        }
        gc.dispose();
        Point size1 = this.start.computeSize(-1, -1);
        Point size2 = this.stop.computeSize(-1, -1);
        Point size3 = this.check.computeSize(-1, -1);
        Point size4 = this.label.computeSize(-1, -1);
        width = Math.max(size1.x, Math.max(size2.x, Math.max(size3.x, width)));
        width = Math.max(64, Math.max(size4.x, this.list.computeSize((int)width, (int)-1).x));
        this.start.setBounds(0, 0, width, size1.y);
        this.stop.setBounds(0, size1.y, width, size2.y);
        this.check.setBounds(0, size1.y + size2.y, width, size3.y);
        this.label.setBounds(0, rect.height - size4.y, width, size4.y);
        int height = size1.y + size2.y + size3.y;
        this.list.setBounds(0, height, width, rect.height - height - size4.y);
        this.text.setBounds(width, 0, rect.width - width, rect.height);
        this.canvas.setBounds(width, 0, rect.width - width, rect.height);
    }
}

