/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;

public abstract class CleanupClass
extends JNIGenerator {
    String classSourcePath;
    String[] sourcePath;
    String classSource;
    Map<File, String> files;
    int usedCount;
    int unusedCount;

    String[] getArgNames(JNIMethod method) {
        int parantesesStart;
        int n_args = method.getParameters().length;
        if (n_args == 0) {
            return new String[0];
        }
        String name = method.getName();
        String params = "";
        int index = 0;
        while (true) {
            if (!Character.isWhitespace(this.classSource.charAt((index = this.classSource.indexOf(name, index + 1)) - 1))) {
                continue;
            }
            if (index == -1) {
                return null;
            }
            parantesesStart = this.classSource.indexOf("(", index);
            if (this.classSource.substring(index + name.length(), parantesesStart).trim().length() == 0) break;
        }
        int parantesesEnd = this.classSource.indexOf(")", parantesesStart);
        params = this.classSource.substring(parantesesStart + 1, parantesesEnd);
        String[] names = new String[n_args];
        StringTokenizer tk = new StringTokenizer(params, ",");
        int i = 0;
        while (i < names.length) {
            String s = tk.nextToken().trim();
            StringTokenizer tk1 = new StringTokenizer(s, " ");
            String s1 = null;
            while (tk1.hasMoreTokens()) {
                s1 = tk1.nextToken();
            }
            names[i] = s1.trim();
            ++i;
        }
        return names;
    }

    void loadClassSource() {
        if (this.classSourcePath == null) {
            return;
        }
        File f = new File(this.classSourcePath);
        this.classSource = this.loadFile(f);
    }

    void loadFiles() {
        if (this.sourcePath == null) {
            return;
        }
        this.files = new HashMap<File, String>();
        int i = 0;
        while (i < this.sourcePath.length) {
            File file = new File(this.sourcePath[i]);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    if (file.getAbsolutePath().endsWith(".java")) {
                        this.files.put(file, this.loadFile(file));
                    }
                } else {
                    this.loadDirectory(file);
                }
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    String loadFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                String string;
                BufferedReader br;
                FileReader fr;
                block19: {
                    block18: {
                        int read;
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        StringBuilder str = new StringBuilder();
                        char[] buffer = new char[1024];
                        while ((read = br.read(buffer)) != -1) {
                            str.append(buffer, 0, read);
                        }
                        fr.close();
                        string = str.toString();
                        if (br == null) break block18;
                        br.close();
                    }
                    if (fr == null) break block19;
                    fr.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (br != null) {
                                br.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fr != null) {
                                fr.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    void loadDirectory(File file) {
        String[] entries = file.list();
        if (entries == null) {
            entries = new String[]{};
        }
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            File f = new File(file, entry);
            if (!f.isDirectory()) {
                if (f.getAbsolutePath().endsWith(".java")) {
                    this.files.put(f, this.loadFile(f));
                }
            } else {
                this.loadDirectory(f);
            }
            ++i;
        }
    }

    @Override
    public void generate(JNIClass clazz) {
        this.loadFiles();
        this.loadClassSource();
    }

    public void setSourcePath(String[] sourcePath) {
        this.sourcePath = sourcePath;
        this.files = null;
    }

    public void setClassSourcePath(String classSourcePath) {
        this.classSourcePath = classSourcePath;
    }
}

