/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Modifier;
import org.eclipse.swt.tools.internal.CleanupClass;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.ReflectClass;

public class CleanupConstants
extends CleanupClass {
    String getFieldValue(JNIField field) {
        int equalsIndex;
        String name = field.getName();
        int index = 0;
        do {
            if ((index = this.classSource.indexOf(name, index + 1)) == -1) {
                return null;
            }
            equalsIndex = this.classSource.indexOf("=", index);
        } while (this.classSource.substring(index + name.length(), equalsIndex).trim().length() != 0);
        int semiIndex = this.classSource.indexOf(";", equalsIndex);
        return this.classSource.substring(equalsIndex + 1, semiIndex).trim();
    }

    @Override
    public void generate(JNIClass clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        JNIField[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(JNIField[] fields) {
        CleanupConstants.sort(fields);
        int i = 0;
        while (i < fields.length) {
            JNIField field = fields[i];
            if ((field.getModifiers() & 0x10) != 0) {
                this.generate(field);
            }
            ++i;
        }
    }

    public void generate(JNIField field) {
        String name = field.getName();
        for (String str : this.files.values()) {
            if (str.indexOf(name) == -1) continue;
            int modifiers = field.getModifiers();
            String modifiersStr = Modifier.toString(modifiers);
            this.output("\t");
            this.output(modifiersStr);
            if (modifiersStr.length() > 0) {
                this.output(" ");
            }
            this.output(field.getType().getTypeSignature3(false));
            this.output(" ");
            this.output(field.getName());
            this.output(" = ");
            this.output(this.getFieldValue(field));
            this.outputln(";");
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java CleanupConstants <OS className> <class source> <src path1> <src path2>");
            return;
        }
        try {
            CleanupConstants gen = new CleanupConstants();
            String clazzName = args[0];
            String classSource = args[1];
            String[] sourcePath = new String[args.length - 2];
            System.arraycopy(args, 2, sourcePath, 0, sourcePath.length);
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(new ReflectClass(clazz));
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

