/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.swt.tools.internal.CleanupClass;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.ReflectClass;

public class CleanupNatives
extends CleanupClass {
    @Override
    public void generate(JNIClass clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        JNIMethod[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(JNIMethod[] methods) {
        CleanupNatives.sort(methods);
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(JNIMethod method) {
        String name = method.getName();
        for (String str : this.files.values()) {
            if (str.indexOf(name) == -1) continue;
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
        this.output("NOT USED=" + method.toString() + "\n");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java CleanupNatives <OS className> <OS class source> <src path0> <src path1>");
            return;
        }
        try {
            CleanupNatives gen = new CleanupNatives();
            String clazzName = args[0];
            String classSource = args[1];
            String[] sourcePath = new String[args.length - 2];
            System.arraycopy(args, 2, sourcePath, 0, sourcePath.length);
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(new ReflectClass(clazz));
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

