/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.swt.tools.internal.AbstractItem;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIItem;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;

public class MetaDataGenerator
extends JNIGenerator {
    @Override
    public void generateCopyright() {
        this.generateMetaData("swt_properties_copyright");
    }

    @Override
    public void generate(JNIClass clazz) {
        this.output(MetaDataGenerator.toC(clazz.getName()));
        this.output("=");
        this.output(((AbstractItem)((Object)clazz)).flatten());
        this.outputln();
        JNIField[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        JNIMethod[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.outputln();
    }

    public void generate(JNIField[] fields) {
        int i = 0;
        while (i < fields.length) {
            JNIField field = fields[i];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                this.generate(field);
                this.outputln();
            }
            ++i;
        }
    }

    public void generate(JNIField field) {
        this.output(field.getDeclaringClass().getSimpleName());
        this.output("_");
        this.output(field.getName());
        this.output("=");
        this.output(((AbstractItem)((Object)field)).flatten());
    }

    public void generate(JNIMethod[] methods) {
        MetaDataGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
                this.outputln();
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++i;
        }
    }

    public void generate(JNIMethod method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getSimpleName());
        buffer.append("_");
        if (method.isNativeUnique()) {
            buffer.append(method.getName());
        } else {
            buffer.append(MetaDataGenerator.getFunctionName(method));
        }
        String key = buffer.toString();
        this.output(key);
        this.output("=");
        this.output(((AbstractItem)((Object)method)).flatten());
        this.outputln();
        JNIParameter[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            this.output(key);
            this.output("_");
            this.output(String.valueOf(i) + "=");
            this.output(((AbstractItem)((Object)params[i])).flatten());
            this.outputln();
            ++i;
        }
    }

    @Override
    public String getExtension() {
        return ".properties";
    }

    @Override
    protected boolean getGenerate(JNIItem item) {
        return true;
    }

    @Override
    public String getOutputName() {
        return this.getMainClass().getName();
    }

    protected boolean getGenerate() {
        return true;
    }
}

