/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class NativeStats {
    Map<String, NativeFunction[]> snapshot = this.snapshot();
    static final String[] classes = new String[]{"OS", "ATK", "GTK", "XPCOM", "COM", "AGL", "Gdip", "GLX", "Cairo", "WGL"};

    public Map<String, NativeFunction[]> diff() {
        Map<String, NativeFunction[]> newSnapshot = this.snapshot();
        for (Map.Entry<String, NativeFunction[]> entry : newSnapshot.entrySet()) {
            String className = entry.getKey();
            NativeFunction[] newFuncs = entry.getValue();
            NativeFunction[] funcs = this.snapshot.get(className);
            if (funcs == null) continue;
            int i = 0;
            while (i < newFuncs.length) {
                newFuncs[i].subtract(funcs[i]);
                ++i;
            }
        }
        return newSnapshot;
    }

    public void dumpDiff(PrintStream ps) {
        this.dump(this.diff(), ps);
    }

    public void dumpSnapshot(PrintStream ps) {
        this.dump(this.snapshot(), ps);
    }

    public void dumpSnapshot(String className, PrintStream ps) {
        HashMap<String, NativeFunction[]> snapshot = new HashMap<String, NativeFunction[]>();
        this.snapshot(className, snapshot);
        this.dump(className, (NativeFunction[])snapshot.get(className), ps);
    }

    public void dump(Map<String, NativeFunction[]> snapshot, PrintStream ps) {
        for (Map.Entry<String, NativeFunction[]> entry : snapshot.entrySet()) {
            String className = entry.getKey();
            this.dump(className, entry.getValue(), ps);
        }
    }

    void dump(String className, NativeFunction[] funcs, PrintStream ps) {
        NativeFunction func;
        if (funcs == null) {
            return;
        }
        Arrays.sort(funcs);
        int total = 0;
        int i = 0;
        while (i < funcs.length) {
            func = funcs[i];
            total += func.getCallCount();
            ++i;
        }
        ps.print(className);
        ps.print("=");
        ps.print(total);
        ps.println();
        i = 0;
        while (i < funcs.length) {
            func = funcs[i];
            if (func.getCallCount() > 0) {
                ps.print("\t");
                ps.print(func.getName());
                ps.print("=");
                ps.print(func.getCallCount());
                ps.println();
            }
            ++i;
        }
    }

    public void reset() {
        this.snapshot = this.snapshot();
    }

    public Map<String, NativeFunction[]> snapshot() {
        HashMap<String, NativeFunction[]> snapshot = new HashMap<String, NativeFunction[]>();
        int i = 0;
        while (i < classes.length) {
            String className = classes[i];
            this.snapshot(className, snapshot);
            ++i;
        }
        return snapshot;
    }

    public Map<String, NativeFunction[]> snapshot(String className, Map<String, NativeFunction[]> snapshot) {
        try {
            Class<?> clazz = this.getClass();
            Method functionCount = clazz.getMethod(String.valueOf(className) + "_GetFunctionCount", new Class[0]);
            Method functionCallCount = clazz.getMethod(String.valueOf(className) + "_GetFunctionCallCount", Integer.TYPE);
            Method functionName = clazz.getMethod(String.valueOf(className) + "_GetFunctionName", Integer.TYPE);
            int count = (Integer)functionCount.invoke(clazz, new Object[0]);
            NativeFunction[] funcs = new NativeFunction[count];
            Object[] index = new Object[1];
            int i = 0;
            while (i < count) {
                index[0] = i;
                int callCount = (Integer)functionCallCount.invoke(clazz, index);
                String name = (String)functionName.invoke(clazz, index);
                funcs[i] = new NativeFunction(name, callCount);
                ++i;
            }
            snapshot.put(className, funcs);
        }
        catch (Throwable throwable) {}
        return snapshot;
    }

    public static final native int OS_GetFunctionCount();

    public static final native String OS_GetFunctionName(int var0);

    public static final native int OS_GetFunctionCallCount(int var0);

    public static final native int ATK_GetFunctionCount();

    public static final native String ATK_GetFunctionName(int var0);

    public static final native int ATK_GetFunctionCallCount(int var0);

    public static final native int AGL_GetFunctionCount();

    public static final native String AGL_GetFunctionName(int var0);

    public static final native int AGL_GetFunctionCallCount(int var0);

    public static final native int Gdip_GetFunctionCount();

    public static final native String Gdip_GetFunctionName(int var0);

    public static final native int Gdip_GetFunctionCallCount(int var0);

    public static final native int GLX_GetFunctionCount();

    public static final native String GLX_GetFunctionName(int var0);

    public static final native int GLX_GetFunctionCallCount(int var0);

    public static final native int GTK_GetFunctionCount();

    public static final native String GTK_GetFunctionName(int var0);

    public static final native int GTK_GetFunctionCallCount(int var0);

    public static final native int XPCOM_GetFunctionCount();

    public static final native String XPCOM_GetFunctionName(int var0);

    public static final native int XPCOM_GetFunctionCallCount(int var0);

    public static final native int COM_GetFunctionCount();

    public static final native String COM_GetFunctionName(int var0);

    public static final native int COM_GetFunctionCallCount(int var0);

    public static final native int WGL_GetFunctionCount();

    public static final native String WGL_GetFunctionName(int var0);

    public static final native int WGL_GetFunctionCallCount(int var0);

    public static final native int Cairo_GetFunctionCount();

    public static final native String Cairo_GetFunctionName(int var0);

    public static final native int Cairo_GetFunctionCallCount(int var0);

    public static class NativeFunction
    implements Comparable<Object> {
        String name;
        int callCount;

        public NativeFunction(String name, int callCount) {
            this.name = name;
            this.callCount = callCount;
        }

        void subtract(NativeFunction func) {
            this.callCount -= func.callCount;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Object func) {
            return ((NativeFunction)func).callCount - this.callCount;
        }
    }
}

