/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.HashSet;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;

public class NativesGenerator
extends JNIGenerator {
    boolean enterExitMacro = true;

    @Override
    public void generateCopyright() {
        this.outputln(this.fixDelimiter(this.getMetaData().getCopyright()));
    }

    @Override
    public void generateIncludes() {
        String outputName = this.getOutputName();
        this.outputln("#include \"swt.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_structs.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_stats.h\"");
        this.outputln();
    }

    public void generate(JNIClass clazz, String methodName) {
        JNIMethod[] methods = clazz.getDeclaredMethods();
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith(methodName)) {
                ++count;
            }
            ++i;
        }
        JNIMethod[] result = new JNIMethod[count];
        count = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2].getName().startsWith(methodName)) {
                result[count++] = methods[i2];
            }
            ++i2;
        }
        this.generate(result);
    }

    @Override
    public void generate(JNIClass clazz) {
        JNIMethod[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) break;
            ++i;
        }
        if (i == methods.length) {
            return;
        }
        NativesGenerator.sort(methods);
        this.generateNativeMacro(clazz);
        this.generateExcludes(methods);
        this.generate(methods);
    }

    public void generate(JNIMethod[] methods) {
        NativesGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++i;
        }
    }

    boolean isStruct(String flagsStr) {
        String[] flags = NativesGenerator.split(flagsStr, " ");
        int i = 0;
        while (i < flags.length) {
            if (flags[i].equals("struct")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isFloatingPoint(String type) {
        return type.equals("float") || type.equals("double");
    }

    void generateCallback(JNIMethod method, String function) {
        this.output("static jintLong ");
        this.output(function);
        this.outputln(";");
        this.output("static ");
        String[] types = NativesGenerator.split((String)method.getParam("callback_types"), ";");
        String[] flags = NativesGenerator.split((String)method.getParam("callback_flags"), ";");
        this.output(types[0]);
        this.output(" ");
        this.output("proc_");
        this.output(function);
        this.output("(");
        boolean first = true;
        int i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            this.output(types[i]);
            this.output(" ");
            this.output("arg");
            this.output(String.valueOf(i - 1));
            first = false;
            ++i;
        }
        this.outputln(") {");
        this.output("\t");
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output(types[0]);
            this.output("* lprc = ");
        } else if (!types[0].equals("void")) {
            this.output("return ");
        }
        this.output("((");
        this.output(types[0]);
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output("*");
        }
        this.output(" (*)(");
        first = true;
        i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            this.output(types[i]);
            if (this.isStruct(flags[i]) || this.isFloatingPoint(types[i])) {
                this.output("*");
            }
            ++i;
        }
        this.output("))");
        this.output(function);
        this.output(")(");
        first = true;
        i = 1;
        while (i < types.length) {
            if (!first) {
                this.output(", ");
            }
            first = false;
            if (this.isStruct(flags[i]) || this.isFloatingPoint(types[i])) {
                this.output("&");
            }
            this.output("arg");
            this.output(String.valueOf(i - 1));
            ++i;
        }
        this.outputln(");");
        if (this.isStruct(flags[0]) || this.isFloatingPoint(types[0])) {
            this.output("\t");
            this.output(types[0]);
            this.outputln(" rc;");
            this.outputln("\tif (lprc) {");
            this.outputln("\t\trc = *lprc;");
            this.outputln("\t\tfree(lprc);");
            this.outputln("\t} else {");
            this.output("\t\tmemset(&rc, 0, sizeof(");
            this.output(types[0]);
            this.outputln("));");
            this.outputln("\t}");
            this.outputln("\treturn rc;");
        }
        this.outputln("}");
        this.output("static jintLong ");
        this.output(method.getName());
        this.outputln("(jintLong func) {");
        this.output("\t");
        this.output(function);
        this.outputln(" = func;");
        this.output("\treturn (jintLong)proc_");
        this.output(function);
        this.outputln(";");
        this.outputln("}");
    }

    public void generate(JNIMethod method) {
        boolean isCPP;
        if (method.getFlag("no_gen")) {
            return;
        }
        JNIType returnType = method.getReturnType();
        JNIType returnType64 = method.getReturnType64();
        if (!(returnType.isType("void") || returnType.isPrimitive() || this.isSystemClass(returnType) || returnType.isType("java.lang.String"))) {
            this.output("Warning: bad return type. :");
            this.outputln(method.toString());
            return;
        }
        JNIParameter[] params = method.getParameters();
        String function = NativesGenerator.getFunctionName(method);
        String function64 = NativesGenerator.getFunctionName(method, method.getParameterTypes64());
        this.generateSourceStart(function, function64);
        boolean sameFunction = function.equals(function64);
        if (!sameFunction) {
            this.output("#ifndef ");
            this.output("JNI64");
            this.outputln();
        }
        if (isCPP = this.getCPP()) {
            this.output("extern \"C\" ");
            this.generateFunctionPrototype(method, function, params, returnType, returnType64, true);
            this.outputln(";");
        }
        if (function.startsWith("CALLBACK_")) {
            this.generateCallback(method, function);
        }
        this.generateFunctionPrototype(method, function, params, returnType, returnType64, !sameFunction);
        if (!function.equals(function64)) {
            this.outputln();
            this.outputln("#else");
            if (isCPP) {
                this.output("extern \"C\" ");
                this.generateFunctionPrototype(method, function64, params, returnType, returnType64, true);
                this.outputln(";");
            }
            this.generateFunctionPrototype(method, function64, params, returnType, returnType64, !sameFunction);
            this.outputln();
            this.outputln("#endif");
        }
        this.generateFunctionBody(method, function, function64, params, returnType, returnType64);
        this.generateSourceEnd();
        this.outputln();
    }

    public void setEnterExitMacro(boolean enterExitMacro) {
        this.enterExitMacro = enterExitMacro;
    }

    void generateExcludes(JNIMethod[] methods) {
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < methods.length) {
            String exclude;
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0 && (exclude = method.getExclude()).length() != 0) {
                excludes.add(exclude);
            }
            ++i;
        }
        for (String exclude : excludes) {
            this.outputln(exclude);
            int i2 = 0;
            while (i2 < methods.length) {
                String methodExclude;
                JNIMethod method = methods[i2];
                if ((method.getModifiers() & 0x100) != 0 && exclude.equals(methodExclude = method.getExclude())) {
                    this.output("#define NO_");
                    this.outputln(NativesGenerator.getFunctionName(method));
                }
                ++i2;
            }
            this.outputln("#endif");
            this.outputln();
        }
    }

    void generateNativeMacro(JNIClass clazz) {
        this.output("#ifndef ");
        this.output(clazz.getSimpleName());
        this.outputln("_NATIVE");
        this.output("#define ");
        this.output(clazz.getSimpleName());
        this.output("_NATIVE(func) Java_");
        this.output(NativesGenerator.toC(clazz.getName()));
        this.outputln("_##func");
        this.outputln("#endif");
        this.outputln();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateGetParameter(JNIMethod method, JNIParameter param, boolean critical, int indent) {
        JNIType paramType = param.getType();
        JNIType paramType64 = param.getType64();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return false;
        }
        String iStr = String.valueOf(param.getParameter());
        int j = 0;
        while (j < indent) {
            this.output("\t");
            ++j;
        }
        if ("memmove".equals(method.getName()) && param.getFlag("no_in")) {
            this.output("if (!arg");
            this.output(iStr);
            this.output(") goto fail;\n");
            j = 0;
            while (j < indent) {
                this.output("\t");
                ++j;
            }
            this.output("if ((lparg");
        } else {
            this.output("if (arg");
            this.output(iStr);
            this.output(") if ((lparg");
        }
        this.output(iStr);
        this.output(" = ");
        boolean isCPP = this.getCPP();
        if (paramType.isArray()) {
            JNIType componentType = paramType.getComponentType();
            if (!componentType.isPrimitive()) throw new Error("not done");
            if (critical) {
                if (isCPP) {
                    this.output("(");
                    this.output(componentType.getTypeSignature2(!paramType.equals(paramType64)));
                    this.output("*)");
                    this.output("env->GetPrimitiveArrayCritical(arg");
                } else {
                    this.output("(*env)->GetPrimitiveArrayCritical(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (isCPP) {
                    this.output("env->Get");
                } else {
                    this.output("(*env)->Get");
                }
                this.output(componentType.getTypeSignature1(!paramType.equals(paramType64)));
                if (isCPP) {
                    this.output("ArrayElements(arg");
                } else {
                    this.output("ArrayElements(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else if (paramType.isType("java.lang.String")) {
            if (param.getFlag("unicode")) {
                if (isCPP) {
                    this.output("env->GetStringChars(arg");
                } else {
                    this.output("(*env)->GetStringChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (isCPP) {
                    this.output("env->GetStringUTFChars(arg");
                } else {
                    this.output("(*env)->GetStringUTFChars(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else if (param.getFlag("no_in")) {
            this.output("&_arg");
            this.output(iStr);
        } else {
            this.output("get");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", &_arg");
            this.output(iStr);
            this.output(")");
        }
        this.outputln(") == NULL) goto fail;");
        return true;
    }

    void generateSetParameter(JNIParameter param, boolean critical) {
        JNIType paramType = param.getType();
        JNIType paramType64 = param.getType64();
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return;
        }
        String iStr = String.valueOf(param.getParameter());
        boolean isCPP = this.getCPP();
        if (paramType.isArray()) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            JNIType componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if (critical) {
                    if (isCPP) {
                        this.output("env->ReleasePrimitiveArrayCritical(arg");
                    } else {
                        this.output("(*env)->ReleasePrimitiveArrayCritical(env, arg");
                    }
                    this.output(iStr);
                } else {
                    if (isCPP) {
                        this.output("env->Release");
                    } else {
                        this.output("(*env)->Release");
                    }
                    this.output(componentType.getTypeSignature1(!paramType.equals(paramType64)));
                    if (isCPP) {
                        this.output("ArrayElements(arg");
                    } else {
                        this.output("ArrayElements(env, arg");
                    }
                    this.output(iStr);
                }
                this.output(", lparg");
                this.output(iStr);
                this.output(", ");
                if (param.getFlag("no_out")) {
                    this.output("JNI_ABORT");
                } else {
                    this.output("0");
                }
            } else {
                throw new Error("not done");
            }
            this.output(");");
            this.outputln();
        } else if (paramType.isType("java.lang.String")) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            if (param.getFlag("unicode")) {
                if (isCPP) {
                    this.output("env->ReleaseStringChars(arg");
                } else {
                    this.output("(*env)->ReleaseStringChars(env, arg");
                }
            } else if (isCPP) {
                this.output("env->ReleaseStringUTFChars(arg");
            } else {
                this.output("(*env)->ReleaseStringUTFChars(env, arg");
            }
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        } else if (!param.getFlag("no_out")) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            this.output("set");
            this.output(paramType.getSimpleName());
            this.output("Fields(env, arg");
            this.output(iStr);
            this.output(", lparg");
            this.output(iStr);
            this.outputln(");");
        }
    }

    void generateEnterExitMacro(JNIMethod method, String function, String function64, boolean enter) {
        if (!this.enterExitMacro) {
            return;
        }
        boolean tryCatch = method.getFlag("trycatch");
        if (!function.equals(function64)) {
            this.output("#ifndef ");
            this.output("JNI64");
            this.outputln();
        }
        this.output("\t");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE_");
        this.output(enter ? "ENTER" : "EXIT");
        if (tryCatch) {
            this.output(enter ? "_TRY" : "_CATCH");
        }
        this.output("(env, that, ");
        this.output(function);
        this.outputln("_FUNC);");
        if (!function.equals(function64)) {
            this.outputln("#else");
            this.output("\t");
            this.output(method.getDeclaringClass().getSimpleName());
            this.output("_NATIVE_");
            this.output(enter ? "ENTER" : "EXIT");
            if (tryCatch) {
                this.output(enter ? "_TRY" : "_CATCH");
            }
            this.output("(env, that, ");
            this.output(function64);
            this.outputln("_FUNC);");
            this.outputln("#endif");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateLocalVars(JNIParameter[] params, JNIType returnType, JNIType returnType64) {
        boolean needsReturn = this.enterExitMacro;
        int i = 0;
        while (i < params.length) {
            JNIParameter param = params[i];
            JNIType paramType = param.getType();
            JNIType paramType64 = param.getType64();
            if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                this.output("\t");
                if (paramType.isArray()) {
                    JNIType componentType = paramType.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output(componentType.getTypeSignature2(!paramType.equals(paramType64)));
                    this.output(" *lparg" + i);
                    this.output("=NULL;");
                } else if (paramType.isType("java.lang.String")) {
                    if (param.getFlag("unicode")) {
                        this.output("const jchar *lparg" + i);
                    } else {
                        this.output("const char *lparg" + i);
                    }
                    this.output("= NULL;");
                } else {
                    if (param.getTypeClass().getFlag("struct")) {
                        this.output("struct ");
                    }
                    this.output(paramType.getSimpleName());
                    this.output(" _arg" + i);
                    if (param.getFlag("init")) {
                        this.output("={0}");
                    }
                    this.output(", *lparg" + i);
                    this.output("=NULL;");
                }
                this.outputln();
                needsReturn = true;
            }
            ++i;
        }
        if (!needsReturn || returnType.isType("void")) return needsReturn;
        this.output("\t");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.outputln(" rc = 0;");
        return needsReturn;
    }

    boolean generateGetters(JNIMethod method, JNIParameter[] params) {
        JNIParameter param;
        boolean genFailTag = false;
        int criticalCount = 0;
        int i = 0;
        while (i < params.length) {
            param = params[i];
            if (!this.isCritical(param)) {
                genFailTag |= this.generateGetParameter(method, param, false, 1);
            } else {
                ++criticalCount;
            }
            ++i;
        }
        if (criticalCount != 0) {
            i = 0;
            while (i < params.length) {
                param = params[i];
                if (this.isCritical(param)) {
                    genFailTag |= this.generateGetParameter(method, param, true, 2);
                }
                ++i;
            }
        }
        return genFailTag;
    }

    void generateSetters(JNIParameter[] params) {
        JNIParameter param;
        int criticalCount = 0;
        int i = params.length - 1;
        while (i >= 0) {
            param = params[i];
            if (this.isCritical(param)) {
                ++criticalCount;
            }
            --i;
        }
        if (criticalCount != 0) {
            i = params.length - 1;
            while (i >= 0) {
                param = params[i];
                if (this.isCritical(param)) {
                    this.output("\t");
                    this.generateSetParameter(param, true);
                }
                --i;
            }
        }
        i = params.length - 1;
        while (i >= 0) {
            param = params[i];
            if (!this.isCritical(param)) {
                this.generateSetParameter(param, false);
            }
            --i;
        }
    }

    void generateDynamicFunctionCall(JNIMethod method, JNIParameter[] params, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        this.outputln("/*");
        this.generateFunctionCall(method, params, returnType, returnType64, needsReturn);
        this.outputln("*/");
        this.outputln("\t{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        this.output("\t\t");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_LOAD_FUNCTION(fp, ");
        this.output(name);
        this.outputln(")");
        this.outputln("\t\tif (fp) {");
        this.output("\t\t");
        this.generateFunctionCallLeftSide(method, returnType, returnType64, needsReturn);
        this.output("((");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.output(" (CALLING_CONVENTION*)(");
        int i = 0;
        while (i < params.length) {
            if (i != 0) {
                this.output(", ");
            }
            JNIParameter param = params[i];
            String cast = param.getCast();
            boolean isStruct = param.getFlag("struct");
            if (cast.length() > 2) {
                int index;
                cast = cast.substring(1, cast.length() - 1);
                if (isStruct && (index = cast.lastIndexOf(42)) != -1) {
                    cast = cast.substring(0, index).trim();
                }
                this.output(cast);
            } else {
                JNIType paramType64;
                JNIType paramType;
                this.output(paramType.getTypeSignature4(!(paramType = param.getType()).equals(paramType64 = param.getType64()), isStruct));
            }
            ++i;
        }
        this.output("))");
        this.output("fp");
        this.output(")");
        this.generateFunctionCallRightSide(method, params, 0);
        this.output(";");
        this.outputln();
        this.outputln("\t\t}");
        this.outputln("\t}");
    }

    void generateFunctionCallLeftSide(JNIMethod method, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        this.output("\t");
        if (!returnType.isType("void")) {
            if (needsReturn) {
                this.output("rc = ");
            } else {
                this.output("return ");
            }
            this.output("(");
            this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
            this.output(")");
        }
        if (method.getFlag("address")) {
            this.output("&");
        }
        if (method.getFlag("jni")) {
            boolean isCPP = this.getCPP();
            this.output(isCPP ? "env->" : "(*env)->");
        }
    }

    void generateFunctionCallRightSide(JNIMethod method, JNIParameter[] params, int paramStart) {
        if (!method.getFlag("const")) {
            boolean isCPP;
            this.output("(");
            if (method.getFlag("jni") && !(isCPP = this.getCPP())) {
                this.output("env, ");
            }
            int i = paramStart;
            while (i < params.length) {
                JNIParameter param = params[i];
                if (i != paramStart) {
                    this.output(", ");
                }
                if (param.getFlag("struct")) {
                    this.output("*");
                }
                this.output(param.getCast());
                if (param.getFlag("object")) {
                    this.output("TO_OBJECT(");
                }
                if (i == params.length - 1 && param.getFlag("sentinel")) {
                    this.output("NULL");
                } else {
                    JNIType paramType = param.getType();
                    if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                        this.output("lp");
                    }
                    this.output("arg" + i);
                }
                if (param.getFlag("object")) {
                    this.output(")");
                }
                ++i;
            }
            this.output(")");
        }
    }

    void generateFunctionCall(JNIMethod method, JNIParameter[] params, JNIType returnType, JNIType returnType64, boolean needsReturn) {
        boolean makeCopy;
        String name = method.getName();
        String copy = (String)method.getParam("copy");
        boolean isCPP = this.getCPP();
        boolean bl = makeCopy = copy.length() != 0 && isCPP && !returnType.isType("void");
        if (makeCopy) {
            this.output("\t");
            this.output(copy);
            this.output(" temp = ");
        } else {
            this.generateFunctionCallLeftSide(method, returnType, returnType64, needsReturn);
        }
        int paramStart = 0;
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean objc_struct = false;
        if (name.equals("objc_msgSend_stret") || name.equals("objc_msgSendSuper_stret")) {
            objc_struct = true;
        }
        if (objc_struct) {
            this.outputln("if (STRUCT_SIZE_LIMIT == 0) {");
            this.output("\t\t");
        }
        if (name.equalsIgnoreCase("call") || name.startsWith("callFunc")) {
            this.output("(");
            String cast = params[0].getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                this.output(cast);
            } else {
                this.output("(");
                this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
                this.output(" (");
                this.output((String)method.getParam("convention"));
                this.output("*)())");
            }
            this.output("arg0)");
            paramStart = 1;
        } else if (name.startsWith("VtblCall") || name.startsWith("_VtblCall")) {
            this.output("((");
            this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
            this.output(" (STDMETHODCALLTYPE *)(");
            int i = 1;
            while (i < params.length) {
                JNIType paramType64;
                JNIParameter param;
                JNIType paramType;
                if (i != 1) {
                    this.output(", ");
                }
                this.output(paramType.getTypeSignature4(!(paramType = (param = params[i]).getType()).equals(paramType64 = param.getType64()), param.getFlag("struct")));
                ++i;
            }
            this.output("))(*(");
            JNIType paramType = params[1].getType();
            JNIType paramType64 = params[1].getType64();
            this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), false));
            this.output(" **)arg1)[arg0])");
            paramStart = 1;
        } else if (method.getFlag("cpp") || method.getFlag("setter") || method.getFlag("getter") || method.getFlag("adder")) {
            String cast;
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            this.output("(");
            JNIParameter param = params[0];
            if (param.getFlag("struct")) {
                this.output("*");
            }
            if ((cast = param.getCast()).length() != 0 && !cast.equals("()")) {
                this.output(cast);
            }
            if (param.getFlag("object")) {
                this.output("TO_OBJECT(");
            }
            this.output("arg0");
            if (param.getFlag("object")) {
                this.output(")");
            }
            this.output(")->");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1, name.length()));
                } else {
                    this.output(name);
                }
            }
            paramStart = 1;
        } else if (method.getFlag("gcnew")) {
            this.output("TO_HANDLE(gcnew ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1));
                } else {
                    this.output(name);
                }
            }
        } else if (method.getFlag("new")) {
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            this.output("new ");
            String accessor = method.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(0, index));
                } else {
                    this.output(name);
                }
            }
        } else {
            String accessor;
            if (method.getFlag("delete")) {
                this.output("delete ");
                JNIParameter param = params[0];
                String cast = param.getCast();
                if (cast.length() != 0 && !cast.equals("()")) {
                    this.output(cast);
                } else {
                    this.output("(");
                    this.output(name.substring(0, name.indexOf("_")));
                    this.output(" *)");
                }
                this.outputln("arg0;");
                return;
            }
            if (method.getFlag("object")) {
                this.output("TO_HANDLE(");
            }
            if (method.getFlag("cast")) {
                this.output("((");
                String returnCast = returnType.getTypeSignature2(!returnType.equals(returnType64));
                if (name.equals("objc_msgSend_bool") && returnCast.equals("jboolean")) {
                    returnCast = "BOOL";
                }
                this.output(returnCast);
                this.output(" (*)(");
                int i = 0;
                while (i < params.length) {
                    JNIParameter param;
                    String cast;
                    if (i != 0) {
                        this.output(", ");
                    }
                    if ((cast = (param = params[i]).getCast()) != null && cast.length() != 0) {
                        if (cast.startsWith("(")) {
                            cast = cast.substring(1);
                        }
                        if (cast.endsWith(")")) {
                            cast = cast.substring(0, cast.length() - 1);
                        }
                        this.output(cast);
                    } else {
                        JNIType paramType = param.getType();
                        JNIType paramType64 = param.getType64();
                        if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag("struct")) {
                            this.output("struct ");
                        }
                        this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), param.getFlag("struct")));
                    }
                    ++i;
                }
                this.output("))");
            }
            if ((accessor = method.getAccessor()).length() != 0) {
                this.output(accessor);
            } else {
                this.output(name);
            }
            if (method.getFlag("cast")) {
                this.output(")");
            }
        }
        if (method.getFlag("setter") && params.length == 3 || method.getFlag("getter") && params.length == 2) {
            this.output("[arg1]");
            ++paramStart;
        }
        if (method.getFlag("setter")) {
            this.output(" = ");
        }
        if (method.getFlag("adder")) {
            this.output(" += ");
        }
        if (!method.getFlag("getter")) {
            this.generateFunctionCallRightSide(method, params, paramStart);
        }
        if (method.getFlag("gcnew") || method.getFlag("object")) {
            this.output(")");
        }
        this.output(";");
        this.outputln();
        if (makeCopy) {
            this.outputln("\t{");
            this.output("\t\t");
            this.output(copy);
            this.output("* copy = new ");
            this.output(copy);
            this.outputln("();");
            this.outputln("\t\t*copy = temp;");
            this.output("\t\trc = ");
            this.output("(");
            this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
            this.output(")");
            this.outputln("copy;");
            this.outputln("\t}");
        }
        if (objc_struct) {
            this.outputln("\t} else if (sizeof(_arg0) > STRUCT_SIZE_LIMIT) {");
            this.generate_objc_msgSend_stret(params, name);
            this.generateFunctionCallRightSide(method, params, 1);
            this.outputln(";");
            this.outputln("\t} else {");
            this.generate_objc_msgSend_stret(params, name.substring(0, name.length() - "_stret".length()));
            this.generateFunctionCallRightSide(method, params, 1);
            this.outputln(";");
            this.outputln("\t}");
        }
    }

    void generate_objc_msgSend_stret(JNIParameter[] params, String func) {
        this.output("\t\t*lparg0 = (*(");
        JNIType paramType = params[0].getType();
        JNIType paramType64 = params[0].getType64();
        this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), true));
        this.output(" (*)(");
        int i = 1;
        while (i < params.length) {
            JNIParameter param;
            String cast;
            if (i != 1) {
                this.output(", ");
            }
            if ((cast = (param = params[i]).getCast()) != null && cast.length() != 0) {
                if (cast.startsWith("(")) {
                    cast = cast.substring(1);
                }
                if (cast.endsWith(")")) {
                    cast = cast.substring(0, cast.length() - 1);
                }
                this.output(cast);
            } else {
                paramType = param.getType();
                paramType64 = param.getType64();
                if (!paramType.isPrimitive() && !paramType.isArray() && param.getTypeClass().getFlag("struct")) {
                    this.output("struct ");
                }
                this.output(paramType.getTypeSignature4(!paramType.equals(paramType64), param.getFlag("struct")));
            }
            ++i;
        }
        this.output("))");
        this.output(func);
        this.output(")");
    }

    void generateReturn(JNIType returnType, boolean needsReturn) {
        if (needsReturn && !returnType.isType("void")) {
            this.outputln("\treturn rc;");
        }
    }

    void generateMemmove(JNIMethod method, String function, String function64, JNIParameter[] params) {
        this.generateEnterExitMacro(method, function, function64, true);
        this.output("\t");
        boolean get = params[0].getType().isPrimitive();
        String className = params[get ? 1 : 0].getType().getSimpleName();
        this.output(get ? "if (arg1) get" : "if (arg0) set");
        this.output(className);
        this.output(get ? "Fields(env, arg1, (" : "Fields(env, arg0, (");
        this.output(className);
        this.output(get ? " *)arg0)" : " *)arg1)");
        this.outputln(";");
        this.generateEnterExitMacro(method, function, function64, false);
    }

    void generateFunctionBody(JNIMethod method, String function, String function64, JNIParameter[] params, JNIType returnType, JNIType returnType64) {
        boolean isMemove;
        this.outputln("{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean bl = isMemove = (name.equals("memmove") || name.equals("MoveMemory")) && params.length == 2 && returnType.isType("void");
        if (isMemove) {
            this.generateMemmove(method, function, function64, params);
        } else {
            boolean needsReturn = this.generateLocalVars(params, returnType, returnType64);
            this.generateEnterExitMacro(method, function, function64, true);
            boolean genFailTag = this.generateGetters(method, params);
            if (method.getFlag("dynamic")) {
                this.generateDynamicFunctionCall(method, params, returnType, returnType64, needsReturn);
            } else {
                this.generateFunctionCall(method, params, returnType, returnType64, needsReturn);
            }
            if (genFailTag) {
                this.outputln("fail:");
            }
            this.generateSetters(params);
            this.generateEnterExitMacro(method, function, function64, false);
            this.generateReturn(returnType, needsReturn);
        }
        this.outputln("}");
    }

    void generateFunctionPrototype(JNIMethod method, String function, JNIParameter[] params, JNIType returnType, JNIType returnType64, boolean singleLine) {
        this.output("JNIEXPORT ");
        this.output(returnType.getTypeSignature2(!returnType.equals(returnType64)));
        this.output(" JNICALL ");
        this.output(method.getDeclaringClass().getSimpleName());
        this.output("_NATIVE(");
        this.output(function);
        if (singleLine) {
            this.output(")");
            this.output("(JNIEnv *env, ");
        } else {
            this.outputln(")");
            this.output("\t(JNIEnv *env, ");
        }
        if ((method.getModifiers() & 8) != 0) {
            this.output("jclass");
        } else {
            this.output("jobject");
        }
        this.output(" that");
        int i = 0;
        while (i < params.length) {
            this.output(", ");
            JNIType paramType = params[i].getType();
            JNIType paramType64 = params[i].getType64();
            this.output(paramType.getTypeSignature2(!paramType.equals(paramType64)));
            this.output(" arg" + i);
            ++i;
        }
        this.output(")");
        if (!singleLine) {
            this.outputln();
        }
    }

    void generateSourceStart(String function, String function64) {
        if (function.equals(function64)) {
            this.output("#ifndef NO_");
            this.outputln(function);
        } else {
            this.output("#if (!defined(NO_");
            this.output(function);
            this.output(") && !defined(");
            this.output("JNI64");
            this.output(")) || (!defined(NO_");
            this.output(function64);
            this.output(") && defined(");
            this.output("JNI64");
            this.outputln("))");
        }
    }

    void generateSourceEnd() {
        this.outputln("#endif");
    }

    boolean isCritical(JNIParameter param) {
        JNIType paramType = param.getType();
        return paramType.isArray() && paramType.getComponentType().isPrimitive() && param.getFlag("critical");
    }

    boolean isSystemClass(JNIType type) {
        return type.isType("java.lang.Object") || type.isType("java.lang.Class");
    }
}

