/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;

public class ConsoleListeners
implements IConsoleListener {
    private static ConsoleListeners instance = new ConsoleListeners();
    private Set listeners = new HashSet();

    public static ConsoleListeners getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IConsoleListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IConsoleListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConsoleListener[] getListeners() {
        Set set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new IConsoleListener[this.listeners.size()]);
        }
    }

    @Override
    public void commandInvoked(final Session session, final String line) {
        if (this.listeners.isEmpty()) {
            return;
        }
        IConsoleListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IConsoleListener listener = listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.commandInvoked(session, line);
                }
            });
            ++i;
        }
    }

    @Override
    public void messageLineReceived(final Session session, final String line, final IStatus status) {
        if (this.listeners.isEmpty()) {
            return;
        }
        IConsoleListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IConsoleListener listener = listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.messageLineReceived(session, line, status);
                }
            });
            ++i;
        }
    }

    @Override
    public void errorLineReceived(final Session session, final String line, final IStatus status) {
        if (this.listeners.isEmpty()) {
            return;
        }
        IConsoleListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IConsoleListener listener = listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.errorLineReceived(session, line, status);
                }
            });
            ++i;
        }
    }

    @Override
    public void commandCompleted(final Session session, final IStatus status, final Exception exception) {
        if (this.listeners.isEmpty()) {
            return;
        }
        IConsoleListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IConsoleListener listener = listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception2) {
                }

                public void run() throws Exception {
                    listener.commandCompleted(session, status, exception);
                }
            });
            ++i;
        }
    }
}

