/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.examples.model.PluginManifestChangeTracker;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FileSystemPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.team.examples.filesystem";
    public static final String PROVIDER_ID = "org.eclipse.team.examples.filesystem.FileSystemProvider";
    private static FileSystemPlugin plugin;
    private PessimisticFilesystemProviderPlugin pessPlugin;
    private PluginManifestChangeTracker tracker;

    public FileSystemPlugin() {
        plugin = this;
        this.pessPlugin = new PessimisticFilesystemProviderPlugin();
    }

    public static FileSystemPlugin getPlugin() {
        return plugin;
    }

    public static TeamException wrapException(CoreException e) {
        return new TeamException(e.getStatus());
    }

    public static TeamException wrapException(IOException e) {
        return new TeamException((IStatus)new Status(4, ID, -4, e.getMessage(), (Throwable)e));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.pessPlugin.start(context);
        this.tracker = new PluginManifestChangeTracker();
        this.tracker.start();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.pessPlugin != null) {
                this.pessPlugin.stop(context);
            }
        }
        finally {
            super.stop(context);
        }
        this.tracker.dispose();
        this.tracker = null;
    }

    public static void log(CoreException e) {
        FileSystemPlugin.log((IStatus)new Status(e.getStatus().getSeverity(), ID, 0, e.getMessage(), (Throwable)e));
    }
}

