/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.subscriber;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeStatus;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;

public class FileSystemMergeContext
extends SubscriberMergeContext {
    public FileSystemMergeContext(ISynchronizationScopeManager manager) {
        super((Subscriber)FileSystemSubscriber.getInstance(), manager);
        this.initialize();
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        FileSystemSubscriber.getInstance().makeInSync(resource);
    }

    public void markAsMerged(IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        FileSystemSubscriber.getInstance().markAsMerged(resource, monitor);
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, false, monitor);
    }

    public ISchedulingRule getMergeRule(IDiff node) {
        return ResourceDiffTree.getResourceFor((IDiff)node).getProject();
    }

    public IStatus merge(IDiff diff, boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        if (!ignoreLocalChanges) {
            IThreeWayDiff twd;
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (diff instanceof IThreeWayDiff && resource instanceof IFile && (twd = (IThreeWayDiff)diff).getDirection() == 768) {
                return new MergeStatus("org.eclipse.team.examples.filesystem", "Cannot merge conflicting files", new IFile[]{(IFile)resource});
            }
        }
        return super.merge(diff, ignoreLocalChanges, monitor);
    }
}

