/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.subscriber;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;

public class FileSystemResourceVariant
extends CachedResourceVariant {
    private File ioFile;
    private byte[] bytes;

    public FileSystemResourceVariant(File file) {
        this.ioFile = file;
    }

    public FileSystemResourceVariant(File file, byte[] bytes) {
        this.ioFile = file;
        this.bytes = bytes;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        this.setContents(this.getContents(), monitor);
    }

    protected String getCachePath() {
        return String.valueOf(this.getFilePath()) + " " + this.ioFile.lastModified();
    }

    private String getFilePath() {
        try {
            return this.ioFile.getCanonicalPath();
        }
        catch (IOException e) {
            FileSystemPlugin.log((IStatus)new Status(4, "org.eclipse.team.examples.filesystem", 0, "Failed to obtain canonical path for " + this.ioFile.getAbsolutePath(), (Throwable)e));
            return this.ioFile.getAbsolutePath();
        }
    }

    protected String getCacheId() {
        return "org.eclipse.team.examples.filesystem";
    }

    public String getName() {
        return this.ioFile.getName();
    }

    public boolean isContainer() {
        return this.ioFile.isDirectory();
    }

    public String getContentIdentifier() {
        return new Date(this.ioFile.lastModified()).toString();
    }

    public byte[] asBytes() {
        if (this.bytes == null) {
            this.bytes = Long.toString(this.ioFile.lastModified()).getBytes();
        }
        return this.bytes;
    }

    public FileSystemResourceVariant[] members() {
        if (this.isContainer()) {
            File[] members = this.ioFile.listFiles();
            if (members == null) {
                members = new File[]{};
            }
            FileSystemResourceVariant[] result = new FileSystemResourceVariant[members.length];
            int i = 0;
            while (i < members.length) {
                result[i] = new FileSystemResourceVariant(members[i]);
                ++i;
            }
            return result;
        }
        return new FileSystemResourceVariant[0];
    }

    public InputStream getContents() throws TeamException {
        try {
            return new BufferedInputStream(new FileInputStream(this.ioFile));
        }
        catch (FileNotFoundException e) {
            throw new TeamException("Failed to fetch contents for " + this.getFilePath(), (Throwable)e);
        }
    }

    public File getFile() {
        return this.ioFile;
    }
}

