/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.history.FileSystemHistory;
import org.eclipse.team.examples.filesystem.ui.FileSystemTableProvider;
import org.eclipse.team.examples.filesystem.ui.OpenFileSystemRevisionAction;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class FileSystemHistoryPage
extends HistoryPage {
    IFile file;
    FileSystemHistory fileSystemHistory;
    IFileRevision[] entries;
    IFileRevision currentSelection;
    private FileSystemTableProvider fileSystemTableProvider;
    TableViewer tableViewer;
    private Composite localComposite;
    OpenFileSystemRevisionAction openAction;
    boolean shutdown = false;
    private RefreshFileHistory refreshFileHistoryJob;

    public boolean inputSet() {
        IFile tempFile;
        this.file = tempFile = this.getFile();
        if (tempFile == null) {
            return false;
        }
        this.tableViewer.setInput(null);
        this.fileSystemHistory = new FileSystemHistory(this.file);
        this.refreshHistory();
        return true;
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    private IFile getFile() {
        Object obj = this.getInput();
        if (obj instanceof IFile) {
            return (IFile)obj;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.localComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.localComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.localComposite.setLayoutData((Object)data);
        this.tableViewer = this.createTable(this.localComposite);
        this.contributeActions();
    }

    private void contributeActions() {
        this.openAction = new OpenFileSystemRevisionAction("Open");
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSystemHistoryPage.this.openAction.selectionChanged(FileSystemHistoryPage.this.tableViewer.getStructuredSelection());
            }
        });
        this.openAction.setPage(this);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(menuMgr1 -> {
            menuMgr1.add((IContributionItem)new Separator("group.file"));
            menuMgr1.add((IAction)this.openAction);
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
    }

    private TableViewer createTable(Composite parent) {
        this.fileSystemTableProvider = new FileSystemTableProvider();
        TableViewer viewer = this.fileSystemTableProvider.createTable(parent);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (FileSystemHistoryPage.this.entries != null) {
                    return FileSystemHistoryPage.this.entries;
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                FileSystemHistoryPage.this.entries = fileHistory.getFileRevisions();
                return FileSystemHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                FileSystemHistoryPage.this.entries = null;
            }
        });
        return viewer;
    }

    public Control getControl() {
        return this.localComposite;
    }

    public void setFocus() {
        this.localComposite.setFocus();
    }

    public String getDescription() {
        if (this.file != null) {
            return this.file.getFullPath().toString();
        }
        return null;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public boolean isValidInput(Object object) {
        RepositoryProvider provider;
        return object instanceof IResource && ((IResource)object).getType() == 1 && (provider = RepositoryProvider.getProvider((IProject)((IFile)object).getProject())) != null && provider instanceof FileSystemProvider;
    }

    public void refresh() {
        this.refreshHistory();
    }

    private void refreshHistory() {
        if (this.refreshFileHistoryJob == null) {
            this.refreshFileHistoryJob = new RefreshFileHistory();
        }
        if (this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
        this.refreshFileHistoryJob.setFileHistory(this.fileSystemHistory);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        Utils.schedule((Job)this.refreshFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    private class RefreshFileHistory
    extends Job {
        FileSystemHistory fileHistory;

        public RefreshFileHistory() {
            super("Fetching FileSystem revisions...");
        }

        public void setFileHistory(FileSystemHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.fileHistory != null && !FileSystemHistoryPage.this.shutdown) {
                this.fileHistory.refresh(monitor);
                Utils.asyncExec(() -> FileSystemHistoryPage.this.tableViewer.setInput((Object)this.fileHistory), (StructuredViewer)FileSystemHistoryPage.this.tableViewer);
            }
            return status;
        }
    }
}

