/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.examples.filesystem.ui.CompoundResourceTraversal;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class FileSystemOperation
extends ModelOperation {
    public static SubscriberScopeManager createScopeManager(String name, ResourceMapping[] inputMappings) {
        return new SubscriberScopeManager(name, inputMappings, (Subscriber)FileSystemSubscriber.getInstance(), true);
    }

    protected FileSystemOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, (ISynchronizationScopeManager)manager);
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                Map providerToTraversals = this.getProviderToTraversalsMap();
                monitor.beginTask(this.getTaskName(), providerToTraversals.size() * 100);
                monitor.setTaskName(this.getTaskName());
                for (FileSystemProvider provider : providerToTraversals.keySet()) {
                    ResourceTraversal[] traversals = this.getTraversals(providerToTraversals, provider);
                    this.execute(provider, traversals, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private Map getProviderToTraversalsMap() {
        HashMap result = new HashMap();
        ISynchronizationScope scope = this.getScope();
        ResourceMapping[] mappings = scope.getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = scope.getTraversals(mapping);
            int j = 0;
            while (j < traversals.length) {
                ResourceTraversal traversal = traversals[j];
                IResource[] resources = traversal.getResources();
                int k = 0;
                while (k < resources.length) {
                    IResource resource = resources[k];
                    this.recordResourceAndDepth(result, resource, traversal.getDepth());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected FileSystemProvider getProviderFor(IProject project) {
        return (FileSystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
    }

    private void recordResourceAndDepth(HashMap providerToTraversals, IResource resource, int depth) {
        FileSystemProvider provider = this.getProviderFor(resource.getProject());
        if (provider != null) {
            CompoundResourceTraversal traversal = (CompoundResourceTraversal)providerToTraversals.get((Object)provider);
            if (traversal == null) {
                traversal = new CompoundResourceTraversal();
                providerToTraversals.put(provider, traversal);
            }
            traversal.addResource(resource, depth);
        }
    }

    private ResourceTraversal[] getTraversals(Map providerToTraversals, FileSystemProvider provider) {
        CompoundResourceTraversal traversal = (CompoundResourceTraversal)providerToTraversals.get((Object)provider);
        return traversal.asTraversals();
    }

    protected abstract void execute(FileSystemProvider var1, ResourceTraversal[] var2, IProgressMonitor var3) throws CoreException;

    protected abstract String getTaskName();

    protected boolean canRunAsJob() {
        return true;
    }
}

