/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.examples.filesystem.history.FileSystemFileRevision;

public class FileSystemTableProvider {
    private static final int COL_TYPE = 0;
    private static final int COL_DATE = 1;

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistorySorter sorter = new HistorySorter(1);
        sorter.setReversed(true);
        viewer.setSorter((ViewerSorter)sorter);
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        SelectionListener headerListener = this.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText("Revision");
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText("Date");
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }

    protected IFileRevision adaptToFileRevision(Object element) {
        IFileRevision entry = null;
        if (element instanceof IFileRevision) {
            entry = (IFileRevision)element;
        } else if (element instanceof IAdaptable) {
            entry = (IFileRevision)((IAdaptable)element).getAdapter(IFileRevision.class);
        }
        return entry;
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                HistorySorter oldSorter = (HistorySorter)tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setSorter((ViewerSorter)new HistorySorter(column));
                }
            }
        };
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFileRevision entry = FileSystemTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    if (entry instanceof FileSystemFileRevision) {
                        return "FileSystem revision";
                    }
                    return "Local history revision";
                }
                case 1: {
                    long date = entry.getTimestamp();
                    Date dateFromLong = new Date(date);
                    return DateFormat.getInstance().format(dateFromLong);
                }
            }
            return "";
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    class HistorySorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistorySorter(int columnNumber) {
            int[][] nArrayArray = new int[2][];
            int[] nArray = new int[2];
            nArray[0] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            nArrayArray[1] = nArray2;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            IFileRevision e1 = FileSystemTableProvider.this.adaptToFileRevision(o1);
            IFileRevision e2 = FileSystemTableProvider.this.adaptToFileRevision(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(compareViewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, IFileRevision e1, IFileRevision e2) {
            switch (columnNumber) {
                case 0: {
                    long date1 = e1.getTimestamp();
                    long date2 = e2.getTimestamp();
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? -1 : 1;
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

