/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.team.examples.filesystem.ui.FileSystemOperation;
import org.eclipse.ui.IWorkbenchPart;

public class PutOperation
extends FileSystemOperation {
    private boolean overwriteIncoming;

    protected PutOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, manager);
    }

    @Override
    protected void execute(FileSystemProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        provider.getOperations().checkin(traversals, this.isOverwriteIncoming(), monitor);
        if (!this.isOverwriteIncoming() && this.hasOutgoingChanges(traversals)) {
            throw new TeamException("Could not put all changes due to conflicts.");
        }
    }

    private boolean hasOutgoingChanges(ResourceTraversal[] traversals) throws CoreException {
        final RuntimeException found = new RuntimeException();
        try {
            FileSystemSubscriber.getInstance().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    IThreeWayDiff twd;
                    if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 256 || twd.getDirection() == 768)) {
                        throw found;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("PutAction.working");
    }

    public boolean isOverwriteIncoming() {
        return this.overwriteIncoming;
    }

    public void setOverwriteIncoming(boolean overwriteIncoming) {
        this.overwriteIncoming = overwriteIncoming;
    }
}

