/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelFile;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectElementFile;

public class ModelObjectDefinitionFile
extends ModelFile {
    public static final String MODEL_OBJECT_DEFINITION_FILE_EXTENSION = "mod";

    public static boolean isModFile(IResource resource) {
        String fileExtension;
        if (resource instanceof IFile && (fileExtension = resource.getFileExtension()) != null) {
            return fileExtension.equals(MODEL_OBJECT_DEFINITION_FILE_EXTENSION);
        }
        return false;
    }

    public static IResource[] getReferencedResources(String projectName, IStorage storage) throws CoreException {
        if (storage == null) {
            return new IResource[0];
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        String[] filePaths = ModelObjectDefinitionFile.readLines(storage);
        int i = 0;
        while (i < filePaths.length) {
            String path = filePaths[i];
            IFile file = ModelObjectDefinitionFile.getFile(projectName, path);
            if (file != null && file.getFileExtension() != null && file.getFileExtension().equals("moe")) {
                result.add(file);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ModelObjectDefinitionFile(IFile file) {
        super(file);
    }

    @Override
    public ModelObject[] getChildren() throws CoreException {
        return this.getModelObjectElementFiles();
    }

    public ModelObjectElementFile[] getModelObjectElementFiles() throws CoreException {
        ArrayList<ModelObjectElementFile> result = new ArrayList<ModelObjectElementFile>();
        String[] filePaths = ModelObjectDefinitionFile.readLines((IStorage)((IFile)this.getResource()));
        int i = 0;
        while (i < filePaths.length) {
            ModelObjectElementFile moeFile;
            String path = filePaths[i];
            IFile file = ModelObjectDefinitionFile.getFile(this.getResource().getProject().getName(), path);
            if (file != null && (moeFile = this.getMoeFile(file)) != null) {
                result.add(moeFile);
            }
            ++i;
        }
        return result.toArray(new ModelObjectElementFile[result.size()]);
    }

    private static String[] readLines(IStorage file) throws CoreException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));
        String line = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            try {
                while ((line = reader.readLine()) != null) {
                    result.add(line.trim());
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.examples.filesystem", 0, NLS.bind((String)"Error reading from file {0}", (Object)file.getFullPath()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return result.toArray(new String[result.size()]);
    }

    private void writeLines(String[] strings) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            buffer.append(string);
            buffer.append("\n");
            ++i;
        }
        ((IFile)this.getResource()).setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), false, true, null);
    }

    private ModelObjectElementFile getMoeFile(IFile file) {
        if (ModelObjectElementFile.isMoeFile((IResource)file)) {
            return new ModelObjectElementFile(this, file);
        }
        return null;
    }

    private static IFile getFile(String projectName, String path) {
        if (path.length() == 0) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validatePath("/" + projectName + "/" + path, 1);
        if (status.isOK()) {
            IProject project = workspace.getRoot().getProject(projectName);
            return project.getFile((IPath)new Path(path));
        }
        FileSystemPlugin.log(status);
        return null;
    }

    public void addMoe(IFile file) throws CoreException {
        ((IFile)this.getResource()).appendContents((InputStream)new ByteArrayInputStream(("\n" + file.getProjectRelativePath()).getBytes()), false, true, null);
    }

    public void remove(ModelObjectElementFile file) throws CoreException {
        ModelObjectElementFile[] files = this.getModelObjectElementFiles();
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            ModelObjectElementFile child = files[i];
            if (!child.equals((Object)file)) {
                paths.add(child.getResource().getProjectRelativePath().toString());
            }
            ++i;
        }
        this.writeLines(paths.toArray(new String[paths.size()]));
    }

    @Override
    public void delete() throws CoreException {
        ModelObjectElementFile[] files = this.getModelObjectElementFiles();
        super.delete();
        int i = 0;
        while (i < files.length) {
            ModelObjectElementFile file = files[i];
            file.getResource().delete(false, null);
            ++i;
        }
    }

    public void setElements(IResource[] resources) throws CoreException {
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            paths.add(resource.getProjectRelativePath().toString());
            ++i;
        }
        this.writeLines(paths.toArray(new String[paths.size()]));
    }

    public boolean hasMoe(IFile file) throws CoreException {
        ModelObjectElementFile[] files = this.getModelObjectElementFiles();
        int i = 0;
        while (i < files.length) {
            ModelObjectElementFile child = files[i];
            if (child.getResource().equals((Object)file)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

