/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelProject;

public abstract class ModelResource
extends ModelObject {
    private final IResource resource;

    protected ModelResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.getResource().getName();
    }

    @Override
    public String getPath() {
        return this.getResource().getFullPath().makeRelative().toString();
    }

    @Override
    public ModelObject getParent() {
        return ModelObject.create((IResource)this.getResource().getParent());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)obj);
            return this.getResource().equals((Object)mr.getResource());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    @Override
    public void delete() throws CoreException {
        this.getResource().delete(false, null);
    }

    @Override
    public ModelProject getProject() {
        return (ModelProject)ModelObject.create((IResource)this.getResource().getProject());
    }
}

