/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.mapping.ChangeTracker;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;

public class PluginManifestChangeTracker
extends ChangeTracker {
    Set manifestFilePaths = new HashSet();

    public PluginManifestChangeTracker() {
        this.manifestFilePaths.add(new Path(null, "plugin.xml"));
        this.manifestFilePaths.add(new Path(null, "plugin.properties"));
        this.manifestFilePaths.add(new Path(null, "build.properties"));
        this.manifestFilePaths.add(new Path(null, "META-INF/MANIFEST.MF"));
    }

    protected boolean isProjectOfInterest(IProject project) {
        return super.isProjectOfInterest(project) && this.hasPDENature(project);
    }

    private boolean hasPDENature(IProject project) {
        try {
            return project.getDescription().hasNature("org.eclipse.pde.PluginNature");
        }
        catch (CoreException e) {
            FileSystemPlugin.log((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.team.examples.filesystem", 0, NLS.bind((String)"Could not obtain project description for {0}", (Object)project.getName()), (Throwable)e));
            return false;
        }
    }

    protected void handleChanges(IProject project, IResource[] resources) {
        this.handleProjectChange(project);
    }

    protected void handleProjectChange(IProject project) {
        ArrayList<IFile> changes = new ArrayList<IFile>();
        for (IPath path : this.manifestFilePaths) {
            IFile file = project.getFile(path);
            try {
                if (!this.isModified(file)) continue;
                changes.add(file);
            }
            catch (CoreException e) {
                FileSystemPlugin.log((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.team.examples.filesystem", 0, NLS.bind((String)"Could not obtain diff for {0}", (Object)file.getFullPath().toString()), (Throwable)e));
            }
        }
        if (changes.size() > 1) {
            this.groupInSet(project, changes.toArray(new IFile[changes.size()]));
        }
    }

    private void groupInSet(IProject project, IFile[] files) {
        String name = this.getSetName(project);
        try {
            this.ensureGrouped(project, name, files);
        }
        catch (CoreException e) {
            FileSystemPlugin.log((IStatus)new Status(e.getStatus().getSeverity(), "org.eclipse.team.examples.filesystem", 0, NLS.bind((String)"Could not create change set {0}", (Object)name), (Throwable)e));
        }
    }

    private String getSetName(IProject project) {
        return "Plugin manifest files for " + project.getName();
    }

    protected boolean isResourceOfInterest(IResource resource) {
        return this.manifestFilePaths.contains(resource.getProjectRelativePath());
    }
}

