/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.mapping;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelProject;

public class ExampleModelProvider
extends ModelProvider {
    public static final String ID = "org.eclipse.team.examples.filesystem.modelProvider";

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        final ArrayList problems = new ArrayList();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    ModelStatus status;
                    IResource resource = delta.getResource();
                    if (ModelObjectElementFile.isMoeFile(resource) && delta.getKind() == 2) {
                        status = new ModelStatus(4, "org.eclipse.team.examples.filesystem", ExampleModelProvider.this.getDescriptor().getId(), NLS.bind((String)"Deleting file {0} may corrupt any model definition that references it.", (Object)resource.getFullPath()));
                        problems.add(status);
                    }
                    if (ModelObjectDefinitionFile.isModFile(resource)) {
                        if (delta.getKind() == 2) {
                            status = new ModelStatus(2, "org.eclipse.team.examples.filesystem", ExampleModelProvider.this.getDescriptor().getId(), NLS.bind((String)"Deleting file {0} may result in unreferenced element files.", (Object)resource.getFullPath()));
                            problems.add(status);
                        }
                        if (delta.getKind() == 1 && (delta.getFlags() & 0x800) > 0) {
                            status = new ModelStatus(4, "org.eclipse.team.examples.filesystem", ExampleModelProvider.this.getDescriptor().getId(), NLS.bind((String)"Copying file {0} may corrupt the model defintion.", (Object)delta.getMovedFromPath()));
                            problems.add(status);
                        }
                    }
                    return delta.getResource().getType() == 8 || ModelProject.isModProject(delta.getResource().getProject());
                }
            });
        }
        catch (CoreException e) {
            FileSystemPlugin.log(e);
        }
        if (problems.size() == 1) {
            return (IStatus)problems.get(0);
        }
        if (problems.size() > 1) {
            return new MultiStatus("org.eclipse.team.examples.filesystem", 0, problems.toArray(new IStatus[problems.size()]), "Multiple potential side effects have been found.", null);
        }
        return super.validateChange(delta, monitor);
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ModelObject object;
        if (ModelProject.isModProject(resource.getProject()) && (object = ModelObject.create(resource)) != null) {
            return new ResourceMapping[]{(ResourceMapping)object.getAdapter(ResourceMapping.class)};
        }
        return super.getMappings(resource, context, monitor);
    }
}

