/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.mapping.ExampleModelProvider;

public class ModelMerger
extends ResourceMappingMerger {
    private final ExampleModelProvider provider;

    public ModelMerger(ExampleModelProvider provider) {
        this.provider = provider;
    }

    protected ModelProvider getModelProvider() {
        return this.provider;
    }

    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        try {
            IStatus status;
            if (mergeContext.getType() == 3) {
                monitor.beginTask("Merging model elements", 100);
                status = this.mergeModelElements(mergeContext, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                try {
                    Job.getJobManager().join((Object)mergeContext, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                }
                catch (InterruptedException interruptedException) {}
                status = super.merge(mergeContext, monitor);
            } else {
                status = super.merge(mergeContext, monitor);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus mergeModelElements(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        try {
            IDiff[] modeDiffs = this.getModDiffs(mergeContext);
            ArrayList<IDiff> failures = new ArrayList<IDiff>();
            monitor.beginTask(null, 100 * modeDiffs.length);
            int i = 0;
            while (i < modeDiffs.length) {
                IDiff diff = modeDiffs[i];
                if (!this.mergeModelElement(mergeContext, diff, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100))) {
                    failures.add(diff);
                }
                ++i;
            }
            if (failures.size() > 0) {
                MergeStatus mergeStatus = new MergeStatus("org.eclipse.team.examples.filesystem", "Several objects could not be merged", this.getMappings(failures));
                return mergeStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private ResourceMapping[] getMappings(List failures) {
        ArrayList<Object> mappings = new ArrayList<Object>();
        for (IDiff diff : failures) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            ModelObjectDefinitionFile file = (ModelObjectDefinitionFile)ModelObject.create(resource);
            mappings.add(file.getAdapter(ResourceMapping.class));
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    private IDiff[] getModDiffs(IMergeContext mergeContext) {
        final ArrayList result = new ArrayList();
        mergeContext.getDiffTree().accept(this.getModelProjectTraversals(mergeContext), new IDiffVisitor(){

            public boolean visit(IDiff diff) {
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (ModelObjectDefinitionFile.isModFile(resource)) {
                    result.add(diff);
                }
                return true;
            }
        });
        return result.toArray(new IDiff[result.size()]);
    }

    private ResourceTraversal[] getModelProjectTraversals(IMergeContext mergeContext) {
        IProject[] scopeProjects = mergeContext.getScope().getProjects();
        ArrayList<IProject> modelProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < scopeProjects.length) {
            IProject project = scopeProjects[i];
            try {
                if (ModelProject.isModProject(project)) {
                    modelProjects.add(project);
                }
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
            ++i;
        }
        if (modelProjects.isEmpty()) {
            return new ResourceTraversal[0];
        }
        return new ResourceTraversal[]{new ResourceTraversal(modelProjects.toArray(new IResource[modelProjects.size()]), 2, 0)};
    }

    private boolean mergeModelElement(IMergeContext mergeContext, IDiff diff, IProgressMonitor monitor) throws CoreException {
        IThreeWayDiff twd;
        if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 512 || twd.getDirection() == 768)) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (twd.getDirection() == 768) {
                if (!resource.exists()) {
                    return false;
                }
                if (((IResourceDiff)twd.getRemoteChange()).getAfterState() == null) {
                    return false;
                }
            }
            IResourceDiff remoteChange = (IResourceDiff)twd.getRemoteChange();
            IResource[] localElements = this.getReferencedResources(resource);
            IResource[] baseElements = this.getReferencedResources(resource.getProject().getName(), remoteChange.getBeforeState(), monitor);
            IResource[] remoteElements = this.getReferencedResources(resource.getProject().getName(), remoteChange.getAfterState(), monitor);
            IResource[] addedElements = this.getAddedElements(baseElements, remoteElements);
            IResource[] removedElements = this.getAddedElements(remoteElements, baseElements);
            if (this.hasOutgoingChanges(mergeContext, removedElements)) {
                return false;
            }
            HashSet<IResource> elementFiles = new HashSet<IResource>();
            elementFiles.addAll(Arrays.asList(baseElements));
            elementFiles.addAll(Arrays.asList(localElements));
            elementFiles.addAll(Arrays.asList(remoteElements));
            if (!this.mergeElementFiles(mergeContext, elementFiles.toArray(new IResource[elementFiles.size()]), monitor)) {
                return false;
            }
            if (!resource.exists()) {
                IStatus status = mergeContext.merge(diff, false, monitor);
                if (!status.isOK()) {
                    return false;
                }
            } else {
                ModelObjectDefinitionFile file = (ModelObjectDefinitionFile)ModelObject.create(resource);
                elementFiles = new HashSet();
                elementFiles.addAll(Arrays.asList(localElements));
                elementFiles.addAll(Arrays.asList(addedElements));
                elementFiles.removeAll(Arrays.asList(removedElements));
                file.setElements(elementFiles.toArray(new IResource[elementFiles.size()]));
                mergeContext.markAsMerged(diff, false, monitor);
            }
        }
        return true;
    }

    private boolean mergeElementFiles(IMergeContext mergeContext, IResource[] resources, IProgressMonitor monitor) throws CoreException {
        IDiff[] diffs = this.getDiffs(mergeContext, resources);
        IStatus status = mergeContext.merge(diffs, false, monitor);
        return status.isOK();
    }

    private IDiff[] getDiffs(IMergeContext mergeContext, IResource[] resources) {
        HashSet<IDiff> diffSet = new HashSet<IDiff>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            IDiff[] diffs = mergeContext.getDiffTree().getDiffs(resource, 0);
            diffSet.addAll(Arrays.asList(diffs));
            ++i;
        }
        return diffSet.toArray(new IDiff[diffSet.size()]);
    }

    private boolean hasOutgoingChanges(IMergeContext mergeContext, IResource[] removedElements) {
        FastDiffFilter fastDiffFilter = new FastDiffFilter(){

            public boolean select(IDiff diff) {
                if (diff instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)diff;
                    return twd.getDirection() == 256 || twd.getDirection() == 768;
                }
                return false;
            }
        };
        int i = 0;
        while (i < removedElements.length) {
            IResource resource = removedElements[i];
            if (mergeContext.getDiffTree().hasMatchingDiffs(resource.getFullPath(), fastDiffFilter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IResource[] getAddedElements(IResource[] baseElements, IResource[] remoteElements) {
        IResource resource;
        ArrayList<IResource> result = new ArrayList<IResource>();
        HashSet<IResource> base = new HashSet<IResource>();
        int i = 0;
        while (i < baseElements.length) {
            resource = baseElements[i];
            base.add(resource);
            ++i;
        }
        i = 0;
        while (i < remoteElements.length) {
            resource = remoteElements[i];
            if (!base.contains(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private IResource[] getReferencedResources(IResource resource) throws CoreException {
        if (resource instanceof IFile && resource.exists()) {
            return ModelObjectDefinitionFile.getReferencedResources(resource.getProject().getName(), (IStorage)((IFile)resource));
        }
        return new IResource[0];
    }

    private IResource[] getReferencedResources(String projectName, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        if (revision != null) {
            return ModelObjectDefinitionFile.getReferencedResources(projectName, revision.getStorage(monitor));
        }
        return new IResource[0];
    }
}

