/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.examples.model.ModelContainer;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ui.ModelSaveablesProvider;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.SaveablesProvider;

public class ModelNavigatorActionProvider
extends CommonActionProvider {
    private Action newModAction;
    private Action newFolderAction;
    private Action newMoeAction;
    private Action deleteAction;
    private Action makeDirty;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.createActions();
    }

    private void createActions() {
        this.deleteAction = new Action("Delete"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ModelNavigatorActionProvider.this.getContext().getSelection();
                try {
                    for (Object element : selection) {
                        if (!(element instanceof ModelObject)) continue;
                        ModelObject mo = (ModelObject)((Object)element);
                        mo.delete();
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)ModelNavigatorActionProvider.this.getShell(), null, null, (IStatus)e.getStatus());
                }
            }
        };
        this.newFolderAction = new Action("Create Folder"){

            public void run() {
                IContainer container = ModelNavigatorActionProvider.this.getSelectedContainer();
                if (container != null) {
                    String name = this.promptForName();
                    if (name == null) {
                        return;
                    }
                    IFolder folder = container.getFolder((IPath)new Path(name));
                    try {
                        folder.create(false, true, null);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)ModelNavigatorActionProvider.this.getShell(), null, null, (IStatus)e.getStatus());
                    }
                }
            }

            private String promptForName() {
                InputDialog dialog = new InputDialog(ModelNavigatorActionProvider.this.getShell(), "Enter Name", "Enter the name of the new folder", "New Folder", null);
                int result = dialog.open();
                if (result == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        };
        this.newModAction = new Action("Create MOD File"){

            public void run() {
                IContainer container = ModelNavigatorActionProvider.this.getSelectedContainer();
                if (container != null) {
                    String name = this.promptForName();
                    if (name == null) {
                        return;
                    }
                    if (!name.endsWith(".mod")) {
                        name = String.valueOf(name) + ".mod";
                    }
                    IFile file = container.getFile((IPath)new Path(name));
                    try {
                        file.create((InputStream)new ByteArrayInputStream("".getBytes()), false, null);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)ModelNavigatorActionProvider.this.getShell(), null, null, (IStatus)e.getStatus());
                    }
                }
            }

            private String promptForName() {
                InputDialog dialog = new InputDialog(ModelNavigatorActionProvider.this.getShell(), "Enter Name", "Enter the name of the new model object", "New Object", null);
                int result = dialog.open();
                if (result == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        };
        this.newMoeAction = new Action("Create MOE File"){

            public void run() {
                ModelObjectDefinitionFile modFile = ModelNavigatorActionProvider.this.getSelectedModFile();
                if (modFile != null) {
                    String path = this.promptForPath((ModelContainer)modFile.getParent());
                    if (path == null) {
                        return;
                    }
                    if (!path.endsWith(".moe")) {
                        path = String.valueOf(path) + ".moe";
                    }
                    ModelContainer parent = (ModelContainer)modFile.getParent();
                    IFile file = ((IContainer)parent.getResource()).getFile((IPath)new Path(path));
                    try {
                        file.create((InputStream)new ByteArrayInputStream("".getBytes()), false, null);
                        modFile.addMoe(file);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)ModelNavigatorActionProvider.this.getShell(), null, null, (IStatus)e.getStatus());
                    }
                }
            }

            private String promptForPath(ModelContainer parent) {
                InputDialog dialog = new InputDialog(ModelNavigatorActionProvider.this.getShell(), "Enter Path", "Enter the path of the new model element relative to " + parent.getPath(), "New Element", null);
                int result = dialog.open();
                if (result == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        };
        this.makeDirty = new Action("Make Dirty"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ModelNavigatorActionProvider.this.getContext().getSelection();
                for (Object element : selection) {
                    if (!(element instanceof ModelObjectDefinitionFile)) continue;
                    ModelObjectDefinitionFile mo = (ModelObjectDefinitionFile)((Object)element);
                    ModelSaveablesProvider provider = this.getSaveablesProvider();
                    provider.makeDirty(mo);
                }
            }

            private ModelSaveablesProvider getSaveablesProvider() {
                ITreeContentProvider provider = ModelNavigatorActionProvider.this.getActionSite().getContentService().getContentExtensionById("org.eclipse.team.examples.model.navigator").getContentProvider();
                return (ModelSaveablesProvider)((Object)Adapters.adapt((Object)provider, SaveablesProvider.class));
            }
        };
    }

    protected Shell getShell() {
        return this.getActionSite().getViewSite().getShell();
    }

    public void fillContextMenu(IMenuManager menu) {
        ModelObjectDefinitionFile modFile;
        super.fillContextMenu(menu);
        menu.add((IAction)this.deleteAction);
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            menu.add((IAction)this.newFolderAction);
            menu.add((IAction)this.newModAction);
        }
        if ((modFile = this.getSelectedModFile()) != null) {
            menu.add((IAction)this.newMoeAction);
            menu.add((IAction)this.makeDirty);
        }
    }

    IContainer getSelectedContainer() {
        Object o;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && (o = selection.getFirstElement()) instanceof ModelContainer) {
            ModelContainer mc = (ModelContainer)((Object)o);
            return (IContainer)mc.getResource();
        }
        return null;
    }

    ModelObjectDefinitionFile getSelectedModFile() {
        Object o;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && (o = selection.getFirstElement()) instanceof ModelObjectDefinitionFile) {
            return (ModelObjectDefinitionFile)((Object)o);
        }
        return null;
    }
}

