/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelFolder;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.ModelWorkspace;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.osgi.framework.Bundle;

public class ModelWorkbenchAdapter
implements IWorkbenchAdapter {
    private static final String ICON_PATH = "$nl$/icons/full/";

    public Object[] getChildren(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            try {
                return mo.getChildren();
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof ModelProject) {
            return ModelWorkbenchAdapter.createImageDescriptor("obj/prj_obj.gif");
        }
        if (object instanceof ModelWorkspace) {
            return ModelWorkbenchAdapter.createImageDescriptor("obj/root_obj.gif");
        }
        if (object instanceof ModelFolder) {
            return ModelWorkbenchAdapter.createImageDescriptor("obj/fldr_obj.gif");
        }
        if (object instanceof ModelObjectDefinitionFile) {
            return ModelWorkbenchAdapter.createImageDescriptor("obj/mod_obj.gif");
        }
        if (object instanceof ModelObjectElementFile) {
            return ModelWorkbenchAdapter.createImageDescriptor("obj/moe_obj.gif");
        }
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            return mo.getName();
        }
        return null;
    }

    public Object getParent(Object o) {
        if (o instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)o);
            return mo.getParent();
        }
        return null;
    }

    public static ImageDescriptor createImageDescriptor(String id) {
        URL url = FileLocator.find((Bundle)FileSystemPlugin.getPlugin().getBundle(), (IPath)new Path(ICON_PATH + id), null);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

