/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;

public class NewModelProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage mainPage;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle(ResourceMessages.NewProject_title);
        this.mainPage.setDescription(ResourceMessages.NewProject_description);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        description.setNatureIds(new String[]{"org.eclipse.team.examples.filesystem.modelNature"});
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewModelProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((CoreException)t).getStatus());
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error occurred", (String)t.getMessage());
            }
            return false;
        }
        return true;
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1000));
        }
        finally {
            monitor.done();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

