/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ResourceSetContentProvider;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class PessimisticModificationValidator
extends FileModificationValidator {
    private PessimisticFilesystemProvider fProvider;

    public PessimisticModificationValidator(PessimisticFilesystemProvider provider) {
        this.fProvider = provider;
    }

    public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
        if (files.length == 0) {
            return new Status(0, this.getUid(), 0, "OK", null);
        }
        HashSet<IFile> checkOut = new HashSet<IFile>();
        int reloadCount = 0;
        int checkoutFailCount = 0;
        HashMap validateEditStatusMap = new HashMap(files.length);
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (this.fProvider.isControlled((IResource)file)) {
                if (this.fProvider.isCheckedout((IResource)file)) {
                    PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
                } else {
                    checkOut.add(file);
                }
            } else {
                PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
            }
            ++i;
        }
        if (!checkOut.isEmpty()) {
            if (context != null) {
                boolean shouldFail = this.shouldFailValidateEdit();
                int statusCode = this.checkout(checkOut, "org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited", shouldFail, context);
                if (shouldFail) {
                    return new Status(4, this.getUid(), 4, "Fail Validate Edit Preference true", null);
                }
                if (statusCode == 8) {
                    return new Status(8, this.getUid(), 4, "Checkout canceled by user", null);
                }
            } else if (this.isAutomaticCheckout()) {
                if (this.shouldFailValidateEdit()) {
                    return new Status(4, this.getUid(), 4, "Fail Validate Edit Preference true", null);
                }
                this.checkout(checkOut);
            }
            for (IFile file : checkOut) {
                if (this.fProvider.isCheckedout((IResource)file)) {
                    if (!this.fProvider.hasContentChanged((IResource)file)) {
                        PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 1);
                        continue;
                    }
                    ++reloadCount;
                    PessimisticModificationValidator.setValidateEditStatus(validateEditStatusMap, file, 2);
                    continue;
                }
                ++checkoutFailCount;
            }
        }
        if (reloadCount + checkoutFailCount == 0) {
            return new Status(0, this.getUid(), 0, "OK", null);
        }
        if (checkoutFailCount == files.length) {
            return new Status(4, this.getUid(), 4, "No files were checked out.", null);
        }
        Status[] children = new Status[files.length];
        int mask = 3;
        int i2 = 0;
        while (i2 < files.length) {
            int result = PessimisticModificationValidator.getValidateEditStatus(validateEditStatusMap, files[i2]);
            children[i2] = (result & mask) != 0 ? new Status(0, this.getUid(), 0, "OK", null) : new Status(4, this.getUid(), 4, "File " + files[i2].getName() + " could not be checked out.", null);
            ++i2;
        }
        return new MultiStatus(this.getUid(), 0, (IStatus[])children, "Some files were not successfully checked out", null);
    }

    public IStatus validateSave(IFile file) {
        int checkedInFilesSaved = this.getPreferences().getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved");
        if (checkedInFilesSaved == 4) {
            return new Status(0, this.getUid(), 0, "", null);
        }
        Status status = new Status(0, this.getUid(), 0, "File is writable", null);
        if (!this.fProvider.isControlled((IResource)file)) {
            return status;
        }
        if (this.fProvider.isIgnored((IResource)file)) {
            return status;
        }
        if (this.fProvider.isCheckedout((IResource)file)) {
            return status;
        }
        HashSet<IFile> files = new HashSet<IFile>(1);
        files.add(file);
        this.checkout(files, "org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved", false, null);
        if (this.fProvider.isCheckedout((IResource)file)) {
            return status;
        }
        return new Status(4, this.getUid(), 4, file.getProjectRelativePath() + " could not be checked out", null);
    }

    private String getUid() {
        return "org.eclipse.team.examples.pessimistic";
    }

    private boolean shouldFailValidateEdit() {
        return this.getPreferences().getBoolean("org.eclipse.team.examples.pessimistic.FailValidateEdit");
    }

    private boolean isAutomaticCheckout() {
        return this.getPreferences().getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt") == 2;
    }

    private int promptAndCheckout(Set resources, boolean beQuiet, boolean shouldFail, Object context) {
        if (resources.isEmpty()) {
            return 0;
        }
        HashSet<IFile> temp = new HashSet<IFile>(resources.size());
        for (IFile resource : resources) {
            if (!this.fProvider.isControlled((IResource)resource) || this.fProvider.isCheckedout((IResource)resource)) continue;
            temp.add(resource);
        }
        resources = temp;
        final int[] statusCode = new int[1];
        if (!beQuiet && !resources.isEmpty()) {
            final Shell shell = this.getShell(context);
            if (shell != null && !shell.isDisposed()) {
                Display display = shell.getDisplay();
                final Set[] result = new Set[]{resources};
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                        Object[] resourceArray = result[0].toArray();
                        ResourceSetContentProvider contentProvider = new ResourceSetContentProvider(result[0]);
                        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                        dialog.setMessage("Select resources to be checked out.");
                        dialog.setTitle("Check out resources");
                        dialog.setContainerMode(true);
                        dialog.setBlockOnOpen(true);
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        dialog.setExpandedElements(resourceArray);
                        dialog.setInitialSelections(resourceArray);
                        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                        int status = dialog.open();
                        result[0] = null;
                        if (status == 0) {
                            Object[] results = dialog.getResult();
                            result[0] = new HashSet(results.length);
                            int i = 0;
                            while (i < results.length) {
                                result[0].add(results[i]);
                                ++i;
                            }
                        } else if (status == 1) {
                            statusCode[0] = 8;
                        }
                    }
                });
                resources = result[0];
            } else {
                resources = null;
                PessimisticFilesystemProviderPlugin.getInstance().logError(new RuntimeException(), "Context is invalid: " + context);
            }
        }
        if (resources != null && !resources.isEmpty() && !shouldFail) {
            this.checkout(resources);
        }
        return statusCode[0];
    }

    private void checkout(Set resources) {
        if (resources.isEmpty()) {
            return;
        }
        IFile[] checkOut = new IFile[resources.size()];
        resources.toArray(checkOut);
        this.fProvider.checkout((IResource[])checkOut, null);
    }

    private IPreferenceStore getPreferences() {
        return PessimisticFilesystemProviderPlugin.getInstance().getPreferenceStore();
    }

    private int checkout(Set resources, String itemId, boolean shouldFail, Object context) {
        if (resources.isEmpty()) {
            return 0;
        }
        int preference = this.getPreferences().getInt(itemId);
        if (preference == 4) {
            return 0;
        }
        boolean beQuiet = false;
        if (preference == 2) {
            beQuiet = true;
        }
        return this.promptAndCheckout(resources, beQuiet, shouldFail, context);
    }

    private static void setValidateEditStatus(Map map, IFile resource, int status) {
        map.put(resource, status);
    }

    private static int getValidateEditStatus(Map map, IFile resource) {
        Integer i = (Integer)map.get(resource);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private Shell getShell(Object context) {
        if (context instanceof FileModificationValidationContext) {
            FileModificationValidationContext fmvc = (FileModificationValidationContext)context;
            return (Shell)fmvc.getShell();
        }
        if (context instanceof Shell) {
            return (Shell)context;
        }
        if (context instanceof Control) {
            Control control = (Control)context;
            return control.getShell();
        }
        if (context instanceof Widget) {
            Widget widget = (Widget)context;
            return widget.getDisplay().getActiveShell();
        }
        return null;
    }
}

